/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.LocaleInfo;
import com.iizix.Utilities;
import com.iizix.Value;
import com.iizix.value.IValueObject;
import com.iizix.value.a;
import java.text.Format;
import java.text.ParseException;
import org.w3c.dom.Element;

public class BinaryValue
implements IValueObject<byte[]> {
    private static final byte[] a = new byte[0];

    @Override
    public final Value.Type getValueType() {
        return Value.Type.Binary;
    }

    @Override
    public Class<byte[]> getValueClass() {
        return byte[].class;
    }

    @Override
    public String getDescription() {
        return "Binary data as a byte array, can be represented in Base64, Binary or Hexadecimal";
    }

    @Override
    public byte[] createDefault() {
        return a;
    }

    @Override
    public byte[] parse(String string) throws ParseException {
        byte[] byArray = Utilities.fromHex(string.trim());
        if (byArray != null) {
            return byArray;
        }
        throw new ParseException("Illegal hexadecimal string: " + string, 0);
    }

    @Override
    public byte[] parse(String string, String string2, LocaleInfo localeInfo) throws ParseException, IllegalArgumentException {
        Format format;
        if (string2 != null && (format = this.getFormatter(string2, localeInfo)) != null) {
            return (byte[])format.parseObject(string);
        }
        return this.parse(string);
    }

    @Override
    public Format getFormatter(String string, LocaleInfo localeInfo) throws IllegalArgumentException {
        if (string == null) {
            return null;
        }
        return new a(this, switch (string.toLowerCase()) {
            case "hex" -> 0;
            case "base64" -> 1;
            case "binary" -> 2;
            default -> throw new IllegalArgumentException("Unknown pattern: only base64, binary and hex is allowed");
        });
    }

    @Override
    public String toString(byte[] byArray) {
        return Utilities.toHex(byArray);
    }

    @Override
    public String toString(byte[] byArray, String string, LocaleInfo localeInfo) throws IllegalArgumentException {
        Format format;
        if (string != null && (format = this.getFormatter(string, localeInfo)) != null) {
            return format.format(byArray);
        }
        return Utilities.toHex(byArray);
    }

    @Override
    public String toStringForced(Object object) {
        try {
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                return Utilities.toHex(byArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.valueOf(object);
    }

    @Override
    public byte[] load(String string, Element element) throws Exception {
        byte[] byArray = Utilities.fromHex(string);
        if (byArray != null) {
            return byArray;
        }
        throw new Exception("Failed to parse Hex value: " + string);
    }

    @Override
    public String save(byte[] byArray, Element element) throws Exception {
        return Utilities.toHex(byArray);
    }

    @Override
    public byte[] convert(Object object, Value.Type type, LocaleInfo localeInfo) throws Exception {
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return byArray;
        }
        long l2 = Long.MIN_VALUE;
        if (object instanceof Number) {
            Number number = (Number)object;
            l2 = number.longValue();
        } else if (type != null) {
            l2 = type.valueObject.asLongCast(object, localeInfo);
        }
        if (l2 != Long.MIN_VALUE) {
            byte[] byArray = new byte[4];
            int n2 = 0;
            while (n2 < 4 && l2 != 0L) {
                byArray[n2++] = (byte)(l2 & 0xFFL);
                l2 >>>= 8;
            }
            if (n2 == 0) {
                n2 = 1;
            }
            if (n2 == 4) {
                return byArray;
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        String string = type != null ? type.valueObject.toStringForced(object) : String.valueOf(object);
        byte[] byArray = Utilities.fromHex(string.trim());
        if (byArray != null) {
            return byArray;
        }
        throw new Exception("Failed to parse Hex value: " + string);
    }

    @Override
    public long asLong(byte[] byArray, LocaleInfo localeInfo) {
        if (byArray.length > 4) {
            return Long.MIN_VALUE;
        }
        long l2 = 0L;
        byte[] byArray2 = byArray;
        int n2 = byArray.length;
        int n3 = 0;
        while (n3 < n2) {
            byte by = byArray2[n3];
            l2 = l2 << 8 | (long)(by & 0xFF);
            ++n3;
        }
        return l2;
    }
}

