/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.txp.impl;

import com.iizix.timeout.ITimeoutListener;
import com.iizix.timeout.ITimeoutTask;
import com.iizix.timeout.engine.TimerEngine;
import com.iizix.txp.ITXPNode;
import com.iizix.txp.ITXPid;
import com.iizix.txp.ITXProcess;
import com.iizix.txp.impl.ITXPNodeLogger;
import com.iizix.txp.impl.TXPNodeLogger;

public abstract class AbstractTXPNode
implements ITimeoutListener,
ITXPNode {
    protected ITXPid pid;
    protected ITXProcess process;
    protected ITXPNodeLogger txplog;
    protected ITXPNode.State state = ITXPNode.State.NONE;
    protected long timeout = -1L;
    protected ITimeoutTask timeoutTask;
    protected volatile boolean hasTimedOutWaiting = false;
    protected volatile boolean hasTimedOut = false;
    protected volatile boolean hasProcessTimedOut = false;

    public ITXPid getPid() {
        return this.pid;
    }

    public boolean isIdempotent() {
        return false;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long l2) {
        this.timeout = l2;
        this.log().settingTimeout(this.timeout);
    }

    public ITXPNode.State retry(ITXProcess iTXProcess) {
        return this.log().returnedState(ITXPNode.State.UNABLE);
    }

    public ITXPNode.State undo(ITXProcess iTXProcess) {
        return this.log().returnedState(ITXPNode.State.UNABLE);
    }

    public ITXPNode.State recover(ITXProcess iTXProcess) {
        return this.log().returnedState(ITXPNode.State.UNABLE);
    }

    public ITXPNode.State getState() {
        return this.state;
    }

    public void timeout(ITXProcess iTXProcess) {
        this.hasTimedOut = true;
        this.log().timedOut(iTXProcess);
    }

    public void processTimeout(ITXProcess iTXProcess) {
        this.hasProcessTimedOut = true;
        this.log().processTimedOut(iTXProcess);
    }

    @Override
    public void onTimeout() {
        this.hasTimedOutWaiting = true;
        this.log().timedOut();
        this.process.timeout((ITXPNode)this);
    }

    public boolean hasTimedOut() {
        return this.hasTimedOut;
    }

    public boolean hasProcessTimedOut() {
        return this.hasProcessTimedOut;
    }

    protected ITXProcess getProcess() {
        return this.process;
    }

    protected void ready() {
        this.getProcess().ready((ITXPNode)this, this.getState());
        if (this.getState() == ITXPNode.State.OK && this.timeout != -1L) {
            this.timeoutTask = TimerEngine.getSystemInstance().registerTimeout(this.timeout, null, this);
        }
        this.log().ready();
    }

    protected boolean hasTimedOutWaiting() {
        return this.hasTimedOutWaiting;
    }

    protected void cancelTimeout() {
        ITimeoutTask iTimeoutTask = this.timeoutTask;
        if (iTimeoutTask != null) {
            this.timeoutTask = null;
            if (!iTimeoutTask.hasTimedOut()) {
                iTimeoutTask.cancel();
            }
        }
    }

    protected void createLogger() {
        this.txplog = new TXPNodeLogger();
    }

    protected ITXPNodeLogger log() {
        return this.txplog;
    }
}

