/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.translate.microsoft;

import com.iizix.ILog;
import com.iizix.text.KString;
import com.iizix.translate.ITranslator;
import com.iizix.translate.RequestException;
import com.iizix.translate.Translation;
import com.iizix.translate.TranslationEngine;
import com.iizix.translate.TranslationException;
import com.iizix.translate.google.Language;
import com.iizix.translate.microsoft.AzureAuthToken;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class AzureCognitiveServices
implements ITranslator {
    protected static boolean USE_v3 = true;
    private AzureAuthToken a;
    private String a;
    private final HashMap<String, String> a = new HashMap();
    private HashMap<String, String> b;

    public void setSubscriptionKey(String string) throws IllegalArgumentException {
        this.a = new AzureAuthToken(string);
        this.a = null;
    }

    @Override
    public void updateSupportedLanguages() {
        try {
            CharSequence[] charSequenceArray = this.getLanguages();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            CharSequence[] charSequenceArray2 = charSequenceArray;
            int n2 = charSequenceArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string = charSequenceArray2[n3];
                hashMap.put(string.toLowerCase(), string);
                ++n3;
            }
            this.b = hashMap;
            ILog.INFO(this.getClass(), "Azure Cognitive Services supported languages: " + String.join((CharSequence)", ", charSequenceArray));
        }
        catch (Exception exception) {
            ILog.WARNING(this.getClass(), "Failed retrieving the Azure Cognitive Services supported languages: " + exception.getMessage());
        }
    }

    @Override
    public String getLanguageCode(String string) {
        Object object;
        HashMap<String, String> hashMap = this.b;
        if (hashMap != null && (object = hashMap.get(string.toLowerCase())) != null) {
            return object;
        }
        object = Language.get(string);
        return object != null ? object.langID : null;
    }

    @Override
    public void deconfigure() {
        this.a = "Missing subscription key, please configure Azure Cognitive Services";
        this.a = null;
    }

    @Override
    public String getReadyState() {
        return this.a;
    }

    @Override
    public String getName() {
        return "Azure Cognitive Services";
    }

    @Override
    public boolean isLanguageHandled(String string) {
        HashMap<String, String> hashMap = this.b;
        if (hashMap != null) {
            return hashMap.containsKey(string.toLowerCase());
        }
        return Language.get(string) != null;
    }

    @Override
    public String getLanguageDescription(String string) {
        if (string == null) {
            return "<auto-detect>";
        }
        Language language = Language.get(string);
        if (language != null) {
            return language.toString();
        }
        HashMap<String, String> hashMap = this.b;
        if (hashMap != null && hashMap.containsKey(string.toLowerCase())) {
            return "Language " + string + " has no description";
        }
        return "<unsupported language code " + string + ">";
    }

    @Override
    public boolean canTranslate(String string, String string2) {
        HashMap<String, String> hashMap = this.b;
        return (string == null || Language.get(string) != null || hashMap != null && hashMap.containsKey(string.toLowerCase())) && (Language.get(string2) != null || hashMap != null && hashMap.containsKey(string2.toLowerCase()));
    }

    private void a() throws RequestException, TranslationException {
        AzureAuthToken azureAuthToken = this.a;
        if (azureAuthToken == null) {
            throw new TranslationException("Azure Cognitive Services is not configured with a subscription key");
        }
        try {
            String string = azureAuthToken.getAccessToken();
            ((HashMap)((Object)this.a)).put("Authorization", "Bearer " + string);
        }
        catch (Exception exception) {
            throw new RequestException("Token Access request failed: " + exception.getMessage(), exception);
        }
    }

    @Override
    public Translation translate(KString kString, String string, String string2) throws TranslationException, RequestException {
        this.a();
        String string3 = kString.getRawString();
        String string4 = this.getLanguageCode(string2);
        if (string4 != null) {
            string2 = string4;
        }
        if (string != null && (string4 = this.getLanguageCode(string)) != null) {
            string = string4;
        }
        try {
            if (USE_v3) {
                HashMap<String, String> hashMap = new HashMap<String, String>((Map<String, String>)((Object)this.a));
                hashMap.put("Content-Type", "application/json;charset=UTF-8");
                StringBuilder stringBuilder = new StringBuilder("https://api.cognitive.microsofttranslator.com/translate?api-version=3.0").append("&to=").append(string2).append("&textType=").append(kString.isHTML() ? "html" : "plain");
                if (string != null) {
                    stringBuilder.append("&from=").append(string);
                }
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("Text", (Object)string3);
                JSONArray jSONArray = new JSONArray();
                jSONArray.put((Object)jSONObject);
                String string5 = TranslationEngine.DEBUG ? jSONArray.toString(2) : jSONArray.toString();
                String string6 = TranslationEngine.getInstance().postRequestJSON(stringBuilder.toString(), hashMap, string5);
                jSONArray = new JSONArray(string6);
                jSONObject = jSONArray.getJSONObject(0);
                if (string == null) {
                    string = jSONObject.getJSONObject("detectedLanguage").getString("language");
                }
                jSONObject = jSONObject.getJSONArray("translations").getJSONObject(0);
                string6 = jSONObject.getString("text");
                return new Translation((ITranslator)this, kString, string3, string, string6, string2);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("text", string3);
            hashMap.put("to", string2);
            hashMap.put("contentType", kString.isHTML() ? "text/html" : "text/plain");
            if (string != null) {
                hashMap.put("from", string);
            }
            String string7 = TranslationEngine.getInstance().requestString("https://api.microsofttranslator.com/V2/Ajax.svc/Translate", hashMap, (Map<String, String>)((Object)this.a), 1, 10000);
            JSONTokener jSONTokener = new JSONTokener(string7);
            string7 = jSONTokener.nextString(jSONTokener.next());
            return new Translation((ITranslator)this, kString, string3, string, string7, string2);
        }
        catch (IOException | JSONException throwable) {
            throw new RequestException("Translate request failed: " + throwable.getMessage(), throwable);
        }
    }

    public String[] getLanguages() throws TranslationException, RequestException {
        this.a();
        try {
            if (USE_v3) {
                String string = TranslationEngine.getInstance().requestString("https://api.cognitive.microsofttranslator.com/languages?api-version=3.0&scope=translation", (String)null, (Map<String, String>)((Object)this.a), 1, 10000);
                JSONObject jSONObject = new JSONObject(string);
                jSONObject = jSONObject.getJSONObject("translation");
                int n2 = jSONObject.length();
                int n3 = 0;
                Object[] objectArray = new String[n2];
                for (String string2 : jSONObject.keySet()) {
                    objectArray[n3++] = string2;
                }
                if (TranslationEngine.DEBUG) {
                    System.err.println("Languages-v3 = " + Arrays.toString(objectArray));
                }
                return objectArray;
            }
            String string = TranslationEngine.getInstance().requestString("https://api.microsofttranslator.com/V2/Ajax.svc/GetLanguagesForTranslate", (String)null, (Map<String, String>)((Object)this.a), 1, 10000);
            JSONArray jSONArray = new JSONArray(string);
            int n4 = jSONArray.length();
            Object[] objectArray = new String[n4];
            while (--n4 >= 0) {
                objectArray[n4] = jSONArray.getString(n4);
            }
            if (TranslationEngine.DEBUG) {
                System.err.println("Languages-v2 = " + Arrays.toString(objectArray));
            }
            return objectArray;
        }
        catch (IOException | JSONException throwable) {
            throw new RequestException("Language codes request failed: " + throwable.getMessage(), throwable);
        }
    }

    public String detectLanguage(String string) throws TranslationException, RequestException {
        this.a();
        try {
            if (USE_v3) {
                HashMap<String, String> hashMap = new HashMap<String, String>((Map<String, String>)((Object)this.a));
                hashMap.put("Content-Type", "application/json;charset=UTF-8");
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("Text", (Object)string);
                JSONArray jSONArray = new JSONArray();
                jSONArray.put((Object)jSONObject);
                String string2 = TranslationEngine.DEBUG ? jSONArray.toString(2) : jSONArray.toString();
                String string3 = TranslationEngine.getInstance().postRequestJSON("https://api.cognitive.microsofttranslator.com/detect?api-version=3.0", hashMap, string2);
                jSONArray = new JSONArray(string3);
                jSONObject = jSONArray.getJSONObject(0);
                string3 = jSONObject.getString("language");
                if (TranslationEngine.DEBUG) {
                    System.err.println("Detected language = " + string3 + " in " + string);
                }
                return string3;
            }
            String string4 = "https://api.microsofttranslator.com/V2/Ajax.svc/Detect?text=" + URLEncoder.encode(string, TranslationEngine.ENCODING);
            String string5 = TranslationEngine.getInstance().requestString(string4, (String)null, (Map<String, String>)((Object)this.a), 1, 10000);
            JSONTokener jSONTokener = new JSONTokener(string5);
            string5 = jSONTokener.nextString(jSONTokener.next());
            if (TranslationEngine.DEBUG) {
                System.err.println("Detected language = " + string5 + " in " + string);
            }
            return string5;
        }
        catch (IOException | JSONException throwable) {
            throw new RequestException("Language codes request failed: " + throwable.getMessage(), throwable);
        }
    }
}

