/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.push.vapid;

import com.iizix.push.vapid.Encoding;
import com.iizix.push.vapid.Utils;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class HttpEce {
    public static final int KEY_LENGTH = 16;
    public static final int SHA_256_LENGTH = 32;
    public static final int TAG_SIZE = 16;
    public static final int TWO_BYTE_MAX = 65536;
    public static final String WEB_PUSH_INFO = "WebPush: info\u0000";
    private Map<String, KeyPair> a;
    private Map<String, String> b;

    public HttpEce() {
        this(new HashMap<String, KeyPair>(), new HashMap<String, String>());
    }

    public HttpEce(Map<String, KeyPair> map, Map<String, String> map2) {
        this.a = map;
        this.b = map2;
    }

    public byte[] encrypt(byte[] byArray, byte[] byArray2, byte[] byArray3, String string, ECPublicKey eCPublicKey, byte[] byArray4, Encoding encoding) throws GeneralSecurityException {
        HttpEce.a("encrypt", byArray);
        byte[][] byArray5 = this.deriveKeyAndNonce(byArray2, byArray3, string, eCPublicKey, byArray4, encoding, 1);
        byte[] byArray6 = byArray5[0];
        byte[] byArray7 = byArray5[1];
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding", "BC");
        GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(128, byArray7);
        cipher.init(1, (Key)new SecretKeySpec(byArray6, "AES"), gCMParameterSpec);
        if (encoding == Encoding.AES128GCM) {
            byte[] byArray8 = this.a(byArray2, string);
            HttpEce.a("header", byArray8);
            byte[] byArray9 = new byte[]{2};
            HttpEce.a("padding", byArray9);
            byte[][] byArrayArray = new byte[][]{cipher.update(byArray), cipher.update(byArray9), cipher.doFinal()};
            HttpEce.a("encrypted", Utils.concat(byArrayArray));
            return HttpEce.a("ciphertext", Utils.concat(byArray8, Utils.concat(byArrayArray)));
        }
        return Utils.concat(cipher.update(new byte[2]), cipher.doFinal(byArray));
    }

    public byte[] decrypt(byte[] byArray, byte[] byArray2, byte[] byArray3, String string, Encoding encoding) throws InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, InvalidAlgorithmParameterException, BadPaddingException, NoSuchProviderException, NoSuchPaddingException {
        byte[] byArray4;
        byte[][] byArray5;
        if (encoding == Encoding.AES128GCM) {
            byArray5 = this.parseHeader(byArray);
            byArray2 = byArray5[0];
            string = new String(byArray5[2]);
            byArray4 = byArray5[3];
        } else {
            byArray4 = byArray;
        }
        byArray5 = this.deriveKeyAndNonce(byArray2, byArray3, string, null, null, encoding, 2);
        return this.decryptRecord(byArray4, byArray5[0], byArray5[1], encoding);
    }

    public byte[][] parseHeader(byte[] byArray) {
        byte[] byArray2 = Arrays.copyOfRange(byArray, 0, 16);
        byte[] byArray3 = Arrays.copyOfRange(byArray, 16, 20);
        byte by = Arrays.copyOfRange(byArray, 20, 21)[0];
        byte[] byArray4 = Arrays.copyOfRange(byArray, 21, 21 + by);
        byte[] byArray5 = Arrays.copyOfRange(byArray, 21 + by, byArray.length);
        return new byte[][]{byArray2, byArray3, byArray4, byArray5};
    }

    public byte[] decryptRecord(byte[] byArray, byte[] byArray2, byte[] byArray3, Encoding encoding) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding", "BC");
        GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(128, byArray3);
        cipher.init(2, (Key)new SecretKeySpec(byArray2, "AES"), gCMParameterSpec);
        byte[] byArray4 = cipher.doFinal(byArray);
        if (encoding == Encoding.AES128GCM) {
            return Arrays.copyOfRange(byArray4, 0, byArray4.length - 1);
        }
        return Arrays.copyOfRange(byArray4, 2, byArray4.length);
    }

    private byte[] a(byte[] byArray, String string) {
        byte[] byArray2 = string == null ? new byte[]{} : Utils.encode(this.a(string));
        if (byArray2.length > 255) {
            throw new IllegalArgumentException("They keyid is too large.");
        }
        byte[] byArray3 = Utils.toByteArray(4096, 4);
        byte[] byArray4 = new byte[]{(byte)byArray2.length};
        return Utils.concat(byArray, byArray3, byArray4, byArray2);
    }

    protected static byte[] buildInfo(String string, byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(19 + string.length() + byArray.length);
        byteBuffer.put("Content-Encoding: ".getBytes(StandardCharsets.UTF_8), 0, 18);
        byteBuffer.put(string.getBytes(StandardCharsets.UTF_8), 0, string.length());
        byteBuffer.put(new byte[1], 0, 1);
        byteBuffer.put(byArray, 0, byArray.length);
        return byteBuffer.array();
    }

    protected static byte[] hkdfExpand(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) {
        HttpEce.a("salt", byArray2);
        HttpEce.a("ikm", byArray);
        HttpEce.a("info", byArray3);
        HKDFBytesGenerator hKDFBytesGenerator = new HKDFBytesGenerator((Digest)new SHA256Digest());
        hKDFBytesGenerator.init((DerivationParameters)new HKDFParameters(byArray, byArray2, byArray3));
        byte[] byArray4 = new byte[n2];
        hKDFBytesGenerator.generateBytes(byArray4, 0, n2);
        HttpEce.a("expand", byArray4);
        return byArray4;
    }

    public byte[][] extractSecretAndContext(byte[] byArray, String string, ECPublicKey eCPublicKey, byte[] byArray2) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        if (byArray != null) {
            byArray3 = byArray;
            if (byArray3.length != 16) {
                throw new IllegalStateException("An explicit key must be 16 bytes.");
            }
        } else if (eCPublicKey != null) {
            byte[][] byArray5 = this.a(string, eCPublicKey);
            byArray3 = byArray5[0];
            byArray4 = byArray5[1];
        } else if (string != null) {
            byArray3 = this.a.get(string).getPublic().getEncoded();
        }
        if (byArray3 == null) {
            throw new IllegalStateException("Unable to determine key.");
        }
        if (byArray2 != null) {
            byArray3 = HttpEce.hkdfExpand(byArray3, byArray2, HttpEce.buildInfo("auth", new byte[0]), 32);
        }
        return new byte[][]{byArray3, byArray4};
    }

    public byte[][] deriveKeyAndNonce(byte[] byArray, byte[] byArray2, String string, ECPublicKey eCPublicKey, byte[] byArray3, Encoding encoding, int n2) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] byArray4;
        byte[] byArray5;
        byte[] byArray6;
        Object object;
        if (encoding == Encoding.AESGCM) {
            object = this.extractSecretAndContext(byArray2, string, eCPublicKey, byArray3);
            byArray6 = object[0];
            byArray5 = HttpEce.buildInfo("aesgcm", object[1]);
            byArray4 = HttpEce.buildInfo("nonce", object[1]);
        } else if (encoding == Encoding.AES128GCM) {
            byArray5 = "Content-Encoding: aes128gcm\u0000".getBytes();
            byArray4 = "Content-Encoding: nonce\u0000".getBytes();
            byArray6 = this.a(byArray2, string, eCPublicKey, byArray3, n2);
        } else {
            throw new IllegalStateException("Unknown version: " + String.valueOf((Object)encoding));
        }
        object = HttpEce.hkdfExpand(byArray6, byArray, byArray5, 16);
        byte[] byArray7 = HttpEce.hkdfExpand(byArray6, byArray, byArray4, 12);
        HttpEce.a("key", (byte[])object);
        HttpEce.a("nonce", byArray7);
        return new byte[][]{(byte[])object, byArray7};
    }

    private byte[] a(byte[] byArray, String string, ECPublicKey eCPublicKey, byte[] byArray2, int n2) throws InvalidKeyException, NoSuchAlgorithmException {
        if (byArray != null) {
            if (byArray.length != 16) {
                throw new IllegalArgumentException("An explicit key must be 16 bytes.");
            }
            return byArray;
        }
        if (eCPublicKey == null) {
            KeyPair keyPair = this.a.get(string);
            if (keyPair == null) {
                throw new IllegalArgumentException("No saved key for keyid '" + string + "'.");
            }
            return Utils.encode((ECPublicKey)keyPair.getPublic());
        }
        return this.webpushSecret(string, eCPublicKey, byArray2, n2);
    }

    public byte[] webpushSecret(String string, ECPublicKey eCPublicKey, byte[] byArray, int n2) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] byArray2;
        ECPublicKey eCPublicKey2;
        ECPublicKey eCPublicKey3;
        ECPublicKey eCPublicKey4;
        if (n2 == 1) {
            eCPublicKey4 = this.a(string);
            eCPublicKey3 = eCPublicKey;
            eCPublicKey2 = eCPublicKey;
        } else if (n2 == 2) {
            eCPublicKey4 = eCPublicKey3 = this.a(string);
            eCPublicKey2 = eCPublicKey;
        } else {
            throw new IllegalArgumentException("Unsupported mode: " + n2);
        }
        HttpEce.a("remote pubkey", Utils.encode(eCPublicKey3));
        HttpEce.a("sender pubkey", Utils.encode(eCPublicKey4));
        HttpEce.a("receiver pubkey", Utils.encode(eCPublicKey2));
        KeyAgreement keyAgreement = KeyAgreement.getInstance("ECDH");
        keyAgreement.init((Key)this.a(string));
        keyAgreement.doPhase((Key)eCPublicKey3, true);
        byte[] byArray3 = byArray2 = keyAgreement.generateSecret();
        byte[] byArray4 = byArray;
        byte[] byArray5 = Utils.concat(WEB_PUSH_INFO.getBytes(), Utils.encode(eCPublicKey2), Utils.encode(eCPublicKey4));
        return HttpEce.hkdfExpand(byArray3, byArray4, byArray5, 32);
    }

    private byte[][] a(String string, ECPublicKey eCPublicKey) throws NoSuchAlgorithmException, InvalidKeyException {
        ECPublicKey eCPublicKey2 = this.a(string);
        KeyAgreement keyAgreement = KeyAgreement.getInstance("ECDH");
        keyAgreement.init((Key)this.a(string));
        keyAgreement.doPhase((Key)eCPublicKey, true);
        byte[] byArray = keyAgreement.generateSecret();
        byte[] byArray2 = Utils.concat(this.b.get(string).getBytes(StandardCharsets.UTF_8), new byte[1], HttpEce.a(eCPublicKey), HttpEce.a(eCPublicKey2));
        return new byte[][]{byArray, byArray2};
    }

    private ECPublicKey a(String string) {
        return (ECPublicKey)this.a.get(string).getPublic();
    }

    private ECPrivateKey a(String string) {
        return (ECPrivateKey)this.a.get(string).getPrivate();
    }

    private static byte[] a(ECPublicKey eCPublicKey) {
        byte[] byArray = Utils.encode(eCPublicKey);
        return Utils.concat(HttpEce.a(byArray.length), byArray);
    }

    private static byte[] a(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Cannot convert a negative number, " + n2 + " given.");
        }
        if (n2 >= 65536) {
            throw new IllegalArgumentException("Cannot convert an integer larger than 65535 to two bytes.");
        }
        byte[] byArray = new byte[2];
        byArray[1] = (byte)(n2 & 0xFF);
        byArray[0] = (byte)(n2 >> 8);
        return byArray;
    }

    private static byte[] a(String string, byte[] byArray) {
        if ("1".equals(System.getenv("ECE_KEYLOG"))) {
            System.out.println(string + " [" + byArray.length + "]: " + Base64.getUrlEncoder().withoutPadding().encodeToString(byArray));
        }
        return byArray;
    }
}

