/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.ui.value;

import com.iizix.ILog;
import com.iizix.NotFoundException;
import com.iizix.prop.Atom;
import com.iizix.prop.NumberProp;
import com.iizix.prop.PropException;
import com.iizix.prop.ui.value.IUIValueComponent;

public interface IUIDoubleValueComponent
extends IUIValueComponent {
    default public NumberProp createValueProp() {
        return new NumberProp(Atom.VALUE);
    }

    default public boolean setValue(double d2) throws IllegalArgumentException {
        NumberProp numberProp = this.getProp(Atom.VALUE, NumberProp.class);
        try {
            if (numberProp != null) {
                return numberProp.setPropValue(d2);
            }
            numberProp = this.createValueProp();
            numberProp.setPropValue(d2);
            return this.setProp(numberProp);
        }
        catch (PropException propException) {
            ILog.SEVERE(this.getClass(), "Failed setting value: " + d2, propException);
            return false;
        }
    }

    default public double getValue() throws NotFoundException {
        NumberProp numberProp = this.getProp(Atom.VALUE, NumberProp.class);
        if (numberProp == null) {
            throw new NotFoundException("value is undefined");
        }
        double d2 = numberProp.getDouble(Double.NaN);
        if (Double.isNaN(d2)) {
            throw new NotFoundException("value is undefined");
        }
        return d2;
    }

    default public double getValueOrDefault() {
        try {
            return this.getValue();
        }
        catch (NotFoundException notFoundException) {
            return this.getDefaultValue();
        }
    }

    public double getDefaultValue();
}

