/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.ui;

import com.iizix.prop.Atom;
import com.iizix.prop.IComplexOperation;
import com.iizix.prop.IPropCnr;
import com.iizix.prop.IntProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropValidateException;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.ui.UIComp;

public interface ILayoutDataAlignY
extends IPropCnr {
    public static final String ALIGN_Y_NAME = "alignY";
    public static final int ALIGN_Y_TOP = 1;
    public static final int ALIGN_Y_MIDDLE = 2;
    public static final int ALIGN_Y_BOTTOM = 3;
    public static final int ALIGN_Y_FILL = 4;

    default public IntProp getAlignPropY() {
        return this.getProp(ALIGN_Y_NAME, IntProp.class);
    }

    default public int setAlignY(int n2) {
        return this.setAlignY(n2, null);
    }

    default public int setAlignY(int n2, IComplexOperation iComplexOperation) {
        UIComp uIComp = (UIComp)this.getParent();
        if (uIComp == null) {
            return -1;
        }
        if (uIComp.hasImplicitAlignFillY()) {
            return 4;
        }
        if (n2 <= 0 || n2 > 4) {
            n2 = this.getDefaultAlignY();
        } else {
            IntProp intProp = this.getProp(ALIGN_Y_NAME, IntProp.class);
            if (intProp != null) {
                if ((Integer)intProp.getPropValue() != n2) {
                    IComplexOperation.setPropValue(iComplexOperation, intProp, n2);
                }
            } else if (n2 != this.getDefaultAlignY()) {
                try {
                    intProp = new IntProp(Atom.get(ALIGN_Y_NAME), n2);
                }
                catch (PropValidateException propValidateException) {
                    throw new InternalError("Shouldn't be", propValidateException);
                }
                IComplexOperation.addProp(iComplexOperation, (PropCnr)((Object)this), intProp);
            }
        }
        return n2;
    }

    default public int getDefaultAlignY() {
        return 1;
    }

    default public int getAlignY() {
        UIComp uIComp = (UIComp)this.getParent();
        if (uIComp != null && uIComp.hasImplicitAlignFillY()) {
            return 4;
        }
        int n2 = this.getDefaultAlignY();
        IntProp intProp = this.getAlignPropY();
        return intProp != null ? intProp.getInt(n2) : n2;
    }

    default public boolean hasFillY() {
        return this.getAlignY() == 4;
    }

    default public void verifyAlignY(UIComp uIComp, PropVerification propVerification) {
        IntProp intProp = this.getAlignPropY();
        if (intProp != null) {
            int n2 = intProp.getInt(this.getDefaultAlignY());
            if (n2 == 4) {
                if (!uIComp.canFillY()) {
                    propVerification.add(new PropVerificationError("cant.fill.y", PropVerificationError.Severity.WARNING, "Vertical align", intProp, "Component cannot have vertical fill", new String[0]));
                }
            } else if (uIComp.hasImplicitAlignFillY()) {
                propVerification.add(new PropVerificationError("implicit.fill.y", PropVerificationError.Severity.WARNING, "Vertical align", intProp, "Component has implicit vertical fill", new String[0]));
            }
        }
    }
}

