/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.Utilities;
import com.iizix.prop.Atom;
import com.iizix.prop.ByteArrayProp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;

public class PKCS12IdentityProp
extends ByteArrayProp {
    private KeyManager[] a;

    protected PKCS12IdentityProp() {
    }

    public PKCS12IdentityProp(Atom atom) {
        super(atom);
    }

    @Override
    public PKCS12IdentityProp clone() {
        return (PKCS12IdentityProp)super.clone();
    }

    @Override
    public boolean setPropValue(byte[] byArray) {
        this.a = null;
        return super.setPropValue(byArray);
    }

    public boolean setIdentity(String string, char[] cArray) throws FileNotFoundException, IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        File file = new File(string);
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        byte[] byArray = null;
        String string2 = "File name '" + string + "'";
        Object object = null;
        Object var8_9 = null;
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            int n2 = fileInputStream.available();
            if ((long)n2 != file.length()) {
                throw new IOException("Different file size and data");
            }
            byArray = new byte[n2];
            if (fileInputStream.read(byArray) != n2) {
                throw new IOException("Different file size and data");
            }
            keyStore.load(new ByteArrayInputStream(byArray), cArray);
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                Serializable serializable;
                String string3 = enumeration.nextElement();
                Certificate certificate = keyStore.getCertificate(string3);
                if (certificate != null && certificate instanceof X509Certificate) {
                    serializable = (X509Certificate)certificate;
                    string2 = "Alias \"" + string3 + "\", " + ((X509Certificate)serializable).getSubjectX500Principal().getName();
                }
                if ((serializable = keyStore.getKey(string3, cArray)) != null) {
                    string2 = certificate == null ? "Alias \"" + string3 + "\": " : string2 + ", ";
                    string2 = string2 + serializable.getAlgorithm() + " Private Key, Creation Date " + String.valueOf(keyStore.getCreationDate(string3));
                } else {
                    if (certificate == null) continue;
                    string2 = string2 + ", Creation Date " + String.valueOf(keyStore.getCreationDate(string3));
                }
                break;
            }
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
        object = string2.getBytes(Utilities.UTF8);
        int n3 = ((Object)object).length;
        while (--n3 >= 0) {
            if (object[n3] != false) continue;
            object[n3] = 32;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write((byte[])object);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(byArray);
        boolean bl = this.setPropValue(byteArrayOutputStream.toByteArray());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, cArray);
        this.a = keyManagerFactory.getKeyManagers();
        return bl;
    }

    public KeyManager[] getKeyManagers(char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        KeyManager[] keyManagerArray = this.a;
        if (keyManagerArray == null) {
            KeyStore keyStore = this.getKeyStore(cArray);
            if (keyStore == null) {
                return null;
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, cArray);
            keyManagerArray = keyManagerFactory.getKeyManagers();
            this.a = keyManagerArray;
        }
        return keyManagerArray;
    }

    public String getIdentityDescription() {
        byte[] byArray = this.getByteArray();
        if (byArray != null) {
            int n2 = 0;
            while (true) {
                if (byArray[n2] == 0) {
                    return new String(byArray, 0, n2, Utilities.UTF8);
                }
                ++n2;
            }
        }
        return null;
    }

    public KeyStore getKeyStore(char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        int n2;
        byte[] byArray = this.getByteArray();
        if (byArray == null) {
            return null;
        }
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        while ((n2 = byteArrayInputStream.read()) > 0) {
        }
        keyStore.load(byteArrayInputStream, cArray);
        return keyStore;
    }

    public void setKeyStore(KeyStore keyStore, char[] cArray, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(string.getBytes(Utilities.UTF8));
        byteArrayOutputStream.write(0);
        keyStore.store(byteArrayOutputStream, cArray);
        this.setPropValue(byteArrayOutputStream.toByteArray());
    }
}

