/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.ILog;
import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.event.GEvent;
import com.iizix.event.ProjectNameEvent;
import com.iizix.event.ResolveReferencesEvent;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.IGProp;
import com.iizix.prop.IPropCnr;
import com.iizix.prop.IPropReference;
import com.iizix.prop.IReferencingGProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropError;
import com.iizix.prop.PropErrorItem;
import com.iizix.prop.PropException;
import com.iizix.prop.PropMgr;
import com.iizix.prop.PropReference;
import com.iizix.prop.PropTypeException;
import com.iizix.prop.PropValidateException;
import com.iizix.prop.ReferenceString;
import java.util.Set;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class AbstractReference<TARGET extends IPropCnr>
extends GProp<ReferenceString>
implements IPropReference,
IReferencingGProp {
    private static final Class<?>[] a = new Class[]{ReferenceString.class, String.class, StringBuilder.class, StringBuffer.class};
    public static final String ERROR_ID = "ref";
    public static final String QUICK_FIX_DELETE_PROP = "DeleteProperty";
    protected PropReference reference;
    protected boolean hasBeenValidated;
    private static volatile /* synthetic */ int[] a;

    protected AbstractReference() {
    }

    protected AbstractReference(Atom atom) {
        super(atom);
    }

    protected AbstractReference(Atom atom, String string) {
        super(atom);
        try {
            this.setPropValue(string);
        }
        catch (PropException propException) {
            throw new InternalError("Shouldn't be", propException);
        }
    }

    protected boolean doPostResolve() {
        return false;
    }

    protected TARGET getFixedTarget() {
        return null;
    }

    protected void clearFixedTarget() {
    }

    public final String getAbsoluteReference() {
        GProp<?> gProp;
        PropReference propReference = this.reference;
        if (propReference != null && (gProp = propReference.getProperty()) != null) {
            return gProp.isDisposed() ? "" : gProp.getReferencePropName();
        }
        return null;
    }

    public final boolean setPropValue(String string) throws PropTypeException, PropValidateException {
        try {
            return super.setPropValue(new ReferenceString(string));
        }
        catch (PropTypeException | PropValidateException propException) {
            throw propException;
        }
        catch (PropException propException) {
            throw new InternalError("Shouldn't be", propException);
        }
    }

    @Override
    public final void validatePropType(Object object) throws PropTypeException {
        if (!(object instanceof ReferenceString)) {
            throw new PropTypeException(this, "newValue not a ReferenceString");
        }
    }

    @Override
    public final void validatePropValue(Object object) throws PropException {
    }

    @Override
    protected final int modifyPropValue(Object object, Object object2, PropMgr propMgr) {
        return -1;
    }

    @Override
    public final Class<?>[] getValueClasses() {
        return a;
    }

    @Override
    protected void appendPropValue(PropMgr propMgr, SendTransaction sendTransaction, Object object) {
        ReferenceString referenceString = (ReferenceString)object;
        sendTransaction.appendString(referenceString != null ? referenceString.toString() : "");
    }

    @Override
    public boolean initializeValue(PropMgr propMgr, ReadTransaction readTransaction) throws PropException {
        return this.setPropValue((Object)new ReferenceString(readTransaction.readString()), propMgr);
    }

    public final String getReference() {
        ReferenceString referenceString = this.getReferenceString();
        return referenceString != null ? referenceString.toString() : null;
    }

    @Override
    protected final Object getPropValue0(Object object, int n2) throws Exception {
        ReferenceString referenceString = (ReferenceString)object;
        switch (n2) {
            case 1: {
                return referenceString.toString();
            }
            case 2: {
                return new StringBuilder(referenceString.toString());
            }
            case 3: {
                return new StringBuffer(referenceString.toString());
            }
        }
        throw new IllegalArgumentException("invalid index: " + n2);
    }

    @Override
    protected final Object toNativeValue0(Object object, int n2) throws Exception {
        switch (n2) {
            case 1: 
            case 2: 
            case 3: {
                return new ReferenceString(object.toString());
            }
        }
        throw new IllegalArgumentException("invalid index: " + n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void disposeReference() {
        PropReference propReference;
        AbstractReference abstractReference = this;
        synchronized (abstractReference) {
            if (this.reference == null) {
                return;
            }
            propReference = this.reference;
            this.reference = null;
            this.hasBeenValidated = false;
        }
        propReference.dispose();
        this.onReferenceDisposed();
        this.clearError();
    }

    protected void onReferenceDisposed() {
    }

    @Override
    protected final void onPropDispose() {
        this.disposeReference();
        super.onPropDispose();
        this.clearFixedTarget();
    }

    @Override
    public AbstractReference<TARGET> clone() {
        AbstractReference abstractReference;
        try {
            abstractReference = (AbstractReference)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
        abstractReference.clearFixedTarget();
        abstractReference.reference = null;
        abstractReference.hasBeenValidated = false;
        return abstractReference;
    }

    @Override
    protected final Object equalValues(GProp<?> abstractReference, ReferenceString referenceString, ReferenceString referenceString2, int n2) {
        if ((n2 & 0x16) != 22) {
            return super.equalValues(abstractReference, referenceString, referenceString2, n2);
        }
        return referenceString != null ? (referenceString.equalsOnlyReferenceString(referenceString2) ? null : this) : (referenceString2 == null ? null : abstractReference);
    }

    @Override
    protected final boolean equalsErrors(PropError propError, PropError propError2, int n2) {
        return (n2 & 3) != 0 || super.equalsErrors(propError, propError2, n2);
    }

    public abstract Class<?> getPropertyClass();

    @Override
    public void onEventSelf(GEvent gEvent) {
        switch (gEvent.getEventID()) {
            case 1: {
                this.clearFixedTarget();
                this.updateReference(gEvent);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                if (this.getFixedTarget() != null) break;
                this.checkCreateReference(gEvent);
                break;
            }
            case 15: {
                this.onProjectNameChanged((ProjectNameEvent)gEvent);
            }
        }
    }

    @Override
    protected void onReferenceEvent(ResolveReferencesEvent resolveReferencesEvent) {
        if (this.getFixedTarget() == null && resolveReferencesEvent.isPostResolving() == this.doPostResolve()) {
            this.createUpdateReference(this.reference, resolveReferencesEvent.doReCheck(), resolveReferencesEvent);
        }
    }

    protected final void onProjectNameChanged(ProjectNameEvent projectNameEvent) {
        String string = projectNameEvent.getOldName();
        String string2 = this.getReference();
        if (string2 != null && string2.startsWith(string + ":")) {
            String string3 = projectNameEvent.getNewName() + string2.substring(string.length());
            this.changeReference(string2, string3, this.reference);
        }
    }

    protected final void createUpdateReference(PropReference propReference, boolean bl, ResolveReferencesEvent resolveReferencesEvent) {
        if (propReference == null) {
            this.updateReference(resolveReferencesEvent);
        } else if (propReference.resolve(bl, resolveReferencesEvent) != 0) {
            this.clearError();
        } else if (this.getPropError(ERROR_ID) == null) {
            this.assignNotFoundError(propReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateReference(GEvent gEvent) {
        this.disposeReference();
        if (this.isPropReferenceTreeValid()) {
            PropReference propReference = this.reference;
            if (propReference == null) {
                AbstractReference abstractReference = this;
                synchronized (abstractReference) {
                    ReferenceString referenceString = this.getReferenceString();
                    if (referenceString == null) {
                        return;
                    }
                    propReference = this.reference = new PropReference(this, this.getLookupPropReference(referenceString), null, this);
                }
            }
            if (propReference.resolve(false, gEvent) != 0) {
                this.clearError();
            } else if (this.getPropError(ERROR_ID) == null) {
                this.assignNotFoundError(propReference);
            }
        }
    }

    protected String getLookupPropReference(ReferenceString referenceString) {
        return referenceString.toString();
    }

    protected String setLookedUpReference(String string) {
        return string;
    }

    protected void checkCreateReference(GEvent gEvent) {
        PropReference propReference = this.reference;
        if (propReference == null) {
            this.updateReference(gEvent);
        } else {
            this.a(propReference, false);
        }
    }

    @Override
    protected void onPropParentChanged(PropCnr propCnr, PropCnr propCnr2) {
        this.checkCreateReference(null);
    }

    protected void clearError() {
        if (!this.isDisposed() && this.getPropError(ERROR_ID) != null) {
            this.removePropError(ERROR_ID);
            this.informClearError();
        }
    }

    protected void assignNotFoundError(PropReference propReference) {
        this.hasBeenValidated = false;
        if (!this.isDisposed() && this.isPropReferenceTreeValid()) {
            this.addPropError(new PropErrorItem(ERROR_ID, "Reference '" + propReference.getName() + "' not found", 2, QUICK_FIX_DELETE_PROP));
            this.informError();
        }
    }

    protected void assignError(String string) {
        this.hasBeenValidated = false;
        if (!this.isDisposed() && this.isPropReferenceTreeValid()) {
            this.addPropError(new PropErrorItem(ERROR_ID, string, 2, QUICK_FIX_DELETE_PROP));
            this.informError();
        }
    }

    @Override
    public void onReferenceEvent(PropReference propReference, IPropReference.ReferenceChangeEvent referenceChangeEvent, GEvent gEvent) {
        if (!this.isDisposed()) {
            switch (AbstractReference.a()[referenceChangeEvent.ordinal()]) {
                case 1: {
                    this.a(propReference, true);
                    break;
                }
                case 2: {
                    this.assignError("Invalid reference '" + propReference.getName() + "' type, must be " + this.getReferenceType().getFallback());
                    break;
                }
                case 3: {
                    this.assignNotFoundError(propReference);
                    break;
                }
                case 4: 
                case 5: {
                    this.changeReference(this.getReference(), propReference.getName(), propReference);
                    break;
                }
                case 6: {
                    this.assignError("Reference '" + propReference.getName() + "' not found, it has been disposed of");
                }
            }
        }
    }

    protected void changeReference(String string, String string2, PropReference propReference) {
        try {
            this.hasBeenValidated = false;
            if (!this.isDisposed()) {
                this.setPropValue(this.setLookedUpReference(string2));
                this.onRefactored(string, string2);
                if (propReference != null) {
                    this.a(propReference, false);
                }
            }
        }
        catch (PropException propException) {
            ILog.SEVERE(this.getClass(), "onReferenceEvent.setPropValue(referenceName)", propException);
        }
    }

    protected void onRefactored(String string, String string2) {
    }

    private void a(PropReference propReference, boolean bl) {
        this.hasBeenValidated = false;
        if (propReference != null && !propReference.isDisposed() && !this.isDisposed()) {
            GProp<?> gProp = propReference.getProperty();
            if (gProp == null) {
                this.assignNotFoundError(propReference);
            } else {
                String string = this.validateReferenceScope((IPropCnr)((Object)gProp));
                if (string != null) {
                    this.assignError(string);
                } else {
                    this.hasBeenValidated = true;
                    this.clearError();
                    if (bl) {
                        this.informResolved();
                    }
                }
            }
        }
    }

    public boolean isValid() {
        PropReference propReference;
        TARGET TARGET = this.getFixedTarget();
        if (TARGET != null) {
            if (!TARGET.isDisposed()) {
                return true;
            }
            this.clearFixedTarget();
            this.updateReference(null);
        }
        if ((propReference = this.reference) == null || this.isDisposed()) {
            return false;
        }
        if (propReference.isResolved()) {
            if (!this.hasBeenValidated) {
                this.a(propReference, true);
            }
            return this.hasBeenValidated;
        }
        int n2 = propReference.resolve(true, null);
        if (n2 == 1) {
            if (!this.hasBeenValidated) {
                this.a(propReference, true);
            }
            return this.hasBeenValidated;
        }
        return false;
    }

    public String wouldValidate(GProp<?> gProp) {
        ReferenceString referenceString;
        TARGET TARGET = this.getFixedTarget();
        if (TARGET != null) {
            if (!TARGET.isDisposed()) {
                return null;
            }
            this.clearFixedTarget();
            this.updateReference(null);
        }
        if ((referenceString = this.getReferenceString()) == null) {
            return "Reference is undefined";
        }
        GProp<?> gProp2 = gProp.getPropFromReference(this.getLookupPropReference(referenceString));
        if (gProp2 == null) {
            return "Reference not found";
        }
        if (gProp2.isDisposed()) {
            return "Reference is disposed";
        }
        if (!this.isReferenceValid(gProp2)) {
            return "Reference is not of a valid class";
        }
        return this.validateReferenceScope((IPropCnr)((Object)gProp2));
    }

    public TARGET getTargetReference() {
        GProp<?> gProp;
        PropReference propReference;
        TARGET TARGET = this.getFixedTarget();
        if (TARGET != null) {
            if (!TARGET.isDisposed()) {
                return TARGET;
            }
            this.clearFixedTarget();
            this.updateReference(null);
        }
        if ((propReference = this.reference) != null && this.isValid() && (gProp = propReference.getProperty()) != null && !gProp.isDisposed()) {
            return (TARGET)((IPropCnr)((Object)gProp));
        }
        return null;
    }

    public TARGET getTargetReference(GProp<?> gProp) {
        ReferenceString referenceString;
        TARGET TARGET = this.getFixedTarget();
        if (TARGET != null) {
            if (!TARGET.isDisposed()) {
                return TARGET;
            }
            this.clearFixedTarget();
        }
        if ((referenceString = this.getReferenceString()) == null) {
            return null;
        }
        GProp<?> gProp2 = gProp.getPropFromReference(this.getLookupPropReference(referenceString));
        return (TARGET)(gProp2 != null && !gProp2.isDisposed() && this.isReferenceValid(gProp2) && this.validateReferenceScope((IPropCnr)((Object)gProp2)) == null ? (IPropCnr)((Object)gProp2) : null);
    }

    @Override
    public final boolean isReferencingMultipleTargets() {
        return false;
    }

    @Override
    public final IGProp<?> getDirectReferencedTarget() {
        return this.getTargetReference();
    }

    @Override
    public final Set<IGProp<?>> getDirectReferencedTargetSet() {
        return null;
    }

    protected ReferenceString getReferenceString() {
        return (ReferenceString)this.getPropValue();
    }

    @Override
    protected String paramString() {
        return super.paramString() + ",reference=" + PropReference.toString(this.reference) + ",hasBeenValidated=" + this.hasBeenValidated;
    }

    protected void informResolved() {
    }

    protected void informError() {
    }

    protected void informClearError() {
    }

    protected String validateReferenceScope(TARGET TARGET) {
        return null;
    }

    @Override
    public abstract IPropReference.IRefType getReferenceType();

    @Override
    public abstract boolean isReferenceValid(GProp<?> var1);

    static /* synthetic */ int[] a() {
        if (a != null) {
            return a;
        }
        int[] nArray = new int[IPropReference.ReferenceChangeEvent.values().length];
        try {
            nArray[IPropReference.ReferenceChangeEvent.BROKEN.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IPropReference.ReferenceChangeEvent.DISPOSED.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IPropReference.ReferenceChangeEvent.FOUND.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IPropReference.ReferenceChangeEvent.FOUND_WRONG_CLASS.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IPropReference.ReferenceChangeEvent.MOVED.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IPropReference.ReferenceChangeEvent.RENAMED.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        a = nArray;
        return nArray;
    }
}

