/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.os;

import com.iizix.Utilities;
import com.iizix.license.HardwareIdentication;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import oshi.SystemInfo;
import oshi.hardware.Baseboard;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.Firmware;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HWPartition;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.software.os.FileSystem;
import oshi.software.os.OperatingSystem;
import oshi.util.GlobalConfig;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class HardwareInfo {
    private static HardwareInfo a;
    private static final String[] a;
    final LinkedHashMap<String, String> a;
    final HashMap<HardwareIdentication, String> a;
    private SystemInfo a;
    private HardwareAbstractionLayer a;
    private List<NetworkIF> a;
    private final String a = new SystemInfo();
    private static volatile /* synthetic */ int[] a;

    static {
        a = new String[]{"ANDROID_*", "ANT_*", "GIT_*", "GRADLE_*", "MAVEN_*", "M2_*", "NODE_*", "NPM_*", "PATH", "PATHEXT", "PROCESSOR_*", "PSMODULEPATH", "PROMPT", "TEMP", "TMP", "OS"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HardwareInfo getInstance() {
        HardwareInfo hardwareInfo = a;
        if (hardwareInfo != null) return hardwareInfo;
        Class<HardwareInfo> clazz = HardwareInfo.class;
        synchronized (HardwareInfo.class) {
            hardwareInfo = a;
            if (hardwareInfo != null) return hardwareInfo;
            a = new HardwareInfo();
            return a;
        }
    }

    /*
     * WARNING - void declaration
     */
    HardwareInfo() {
        Object object;
        Object object2;
        void var28_28;
        Object object3;
        Object object4;
        Object object52;
        String string;
        GlobalConfig.set((String)"oshi.os.windows.perfdisk.disabled", (Object)true);
        HardwareAbstractionLayer hardwareAbstractionLayer = this.a(false);
        ComputerSystem computerSystem = hardwareAbstractionLayer.getComputerSystem();
        String string2 = computerSystem.getManufacturer();
        ((HashMap)((Object)this.a)).put("HW-manufacturer", string2);
        String string3 = computerSystem.getModel();
        ((HashMap)((Object)this.a)).put("HW-model", string3);
        String string4 = computerSystem.getSerialNumber();
        ((HashMap)((Object)this.a)).put("HW-serial", string4);
        Baseboard baseboard = computerSystem.getBaseboard();
        ((HashMap)((Object)this.a)).put("HW-baseboard-version", baseboard.getVersion());
        Firmware firmware = computerSystem.getFirmware();
        String string5 = firmware.getVersion();
        while (!(string = string5.replace("  ", " ")).equals(string5)) {
            string5 = string;
        }
        ((HashMap)((Object)this.a)).put("HW-firmware-version", string5);
        string = firmware.getReleaseDate();
        ((HashMap)((Object)this.a)).put("HW-firmware-version-date", string != null ? string.toString() + " (ISO date as YYYY-MM-DD)" : "n/a");
        ((HashMap)((Object)this.a)).put(HardwareIdentication.ComputerInfo, "Manufacturer:\t" + string2 + "\nModel:\t" + string3 + "\nSerial:\t" + string4);
        CentralProcessor centralProcessor = hardwareAbstractionLayer.getProcessor();
        CentralProcessor.ProcessorIdentifier processorIdentifier = centralProcessor.getProcessorIdentifier();
        string2 = centralProcessor.toString();
        ((HashMap)((Object)this.a)).put("CPU-info", string2);
        string3 = processorIdentifier.getIdentifier();
        ((HashMap)((Object)this.a)).put("CPU-identifier", string3);
        string4 = processorIdentifier.getProcessorID();
        ((HashMap)((Object)this.a)).put("CPU-processorID", string4);
        String string6 = processorIdentifier.getModel();
        ((HashMap)((Object)this.a)).put("CPU-model", string6);
        int n2 = centralProcessor.getPhysicalProcessorCount();
        ((HashMap)((Object)this.a)).put("CPU-physical-count", Integer.toString(n2));
        int n3 = centralProcessor.getLogicalProcessorCount();
        ((HashMap)((Object)this.a)).put("CPU-logical-count", Integer.toString(n3));
        ((HashMap)((Object)this.a)).put(HardwareIdentication.ProcessorInfo, "Information:\t" + string2 + "\nIdentifier:\t" + string3 + "\nProcessorID:\t" + string4 + "\nModel:\t" + string6 + "\nPhysical:\t" + n2 + "\nLogical:\t" + n3);
        GlobalMemory globalMemory = hardwareAbstractionLayer.getMemory();
        long l2 = globalMemory.getTotal();
        long l3 = globalMemory.getAvailable();
        long l4 = globalMemory.getPageSize();
        ((HashMap)((Object)this.a)).put("mem-total-size", Utilities.getEnglishSize(l2));
        ((HashMap)((Object)this.a)).put("mem-available-size", Utilities.getEnglishSize(l3));
        ((HashMap)((Object)this.a)).put("mem-page-size", Utilities.getEnglishSize(l4));
        ((HashMap)((Object)this.a)).put(HardwareIdentication.MemoryInfo, "Total:\t" + l2 + "\nPage:\t" + l4);
        OperatingSystem operatingSystem = this.a.getOperatingSystem();
        OperatingSystem.OSVersionInfo oSVersionInfo = operatingSystem.getVersionInfo();
        string2 = operatingSystem.getFamily();
        ((HashMap)((Object)this.a)).put("OS-family", string2);
        string3 = operatingSystem.getManufacturer();
        ((HashMap)((Object)this.a)).put("OS-manufacturer", string3);
        string4 = oSVersionInfo.getVersion();
        ((HashMap)((Object)this.a)).put("OS-version", string4);
        ((HashMap)((Object)this.a)).put(HardwareIdentication.OperatingSystem, "Family:\t" + string2 + "\nManufacturer:\t" + string3);
        ((HashMap)((Object)this.a)).put(HardwareIdentication.OperatingSystemWithVersion, "Family:\t" + string2 + "\nManufacturer:\t" + string3 + "\nVersion:\t" + string4);
        ((HashMap)((Object)this.a)).put("NWMacs-all", "");
        ((HashMap)((Object)this.a)).put("NWMacs-IPv4", "");
        ((HashMap)((Object)this.a)).put("NWMacs-IPv6", "");
        Object object7 = "";
        Object object8 = "";
        Object object9 = "";
        List<NetworkIF> list = this.a(false);
        for (NetworkIF object62 : list) {
            object52 = object62.getMacaddr();
            if (!((String)object7).isEmpty()) {
                object7 = (String)object7 + ",";
            }
            object7 = (String)object7 + (String)object52;
            long l5 = object62.getSpeed();
            if (l5 > 0L) {
                object4 = object62.getIPv4addr();
                if (((String[])object4).length > 0) {
                    if (!((String)object8).isEmpty()) {
                        object8 = (String)object8 + ",";
                    }
                    object8 = (String)object8 + (String)object52;
                }
                if (((String[])(object4 = object62.getIPv6addr())).length > 0) {
                    if (!((String)object9).isEmpty()) {
                        object9 = (String)object9 + ",";
                    }
                    object9 = (String)object9 + (String)object52;
                }
            }
            object4 = "NW_" + (String)object52;
            ((HashMap)((Object)this.a)).put((String)object4 + "-displayName", object62.getDisplayName());
            ((HashMap)((Object)this.a)).put((String)object4 + "-name", object62.getName());
            ((HashMap)((Object)this.a)).put((String)object4 + "-IPv4", Arrays.toString(object62.getIPv4addr()));
            ((HashMap)((Object)this.a)).put((String)object4 + "-IPv6", Arrays.toString(object62.getIPv6addr()));
            ((HashMap)((Object)this.a)).put((String)object4 + "-MTU", Long.toString(object62.getMTU()));
            ((HashMap)((Object)this.a)).put((String)object4 + "-speed-size", Utilities.getEnglishSize(l5));
            ((HashMap)((Object)this.a)).put((String)object4 + "-inPackets", Long.toString(object62.getPacketsRecv()));
            ((HashMap)((Object)this.a)).put((String)object4 + "-outPackets", Long.toString(object62.getPacketsSent()));
        }
        ((HashMap)((Object)this.a)).put("NWMacs-all", object7);
        ((HashMap)((Object)this.a)).put("NWMacs-IPv4", object8);
        ((HashMap)((Object)this.a)).put("NWMacs-IPv6", object9);
        ((HashMap)((Object)this.a)).put(HardwareIdentication.AllMacAddresses, object7);
        ((HashMap)((Object)this.a)).put(HardwareIdentication.IPv4MacAddresses, object8);
        ((HashMap)((Object)this.a)).put(HardwareIdentication.IPv6MacAddresses, object9);
        String string7 = "";
        ((HashMap)((Object)this.a)).put("FileStores-UUIDs", "");
        FileSystem fileSystem = operatingSystem.getFileSystem();
        for (Object object52 : fileSystem.getFileStores()) {
            void var28_30;
            object3 = object52.getUUID();
            if (!var28_28.isEmpty()) {
                String string8 = (String)var28_28 + ",";
            }
            String string9 = (String)var28_30 + (String)object3;
            ((HashMap)((Object)this.a)).put("FS_" + (String)object3 + "-name", object52.getName());
            ((HashMap)((Object)this.a)).put("FS_" + (String)object3 + "-volume", object52.getVolume());
            ((HashMap)((Object)this.a)).put("FS_" + (String)object3 + "-mount", object52.getMount());
            ((HashMap)((Object)this.a)).put("FS_" + (String)object3 + "-type", object52.getType());
            ((HashMap)((Object)this.a)).put("FS_" + (String)object3 + "-description", object52.getDescription());
            l2 = object52.getTotalSpace();
            ((HashMap)((Object)this.a)).put("FS_" + (String)object3 + "-total-size", Utilities.getEnglishSize(l2));
            l2 = object52.getUsableSpace();
            ((HashMap)((Object)this.a)).put("FS_" + (String)object3 + "-usable-size", Utilities.getEnglishSize(l2));
        }
        ((HashMap)((Object)this.a)).put("FileStores-UUIDs", var28_28);
        object52 = hardwareAbstractionLayer.getDiskStores();
        Object object6 = "";
        object3 = "";
        ((HashMap)((Object)this.a)).put("Disk-serials-all", "");
        ((HashMap)((Object)this.a)).put("Disk-serials-valid", "");
        Object object10 = object52.iterator();
        while (object10.hasNext()) {
            object4 = (HWDiskStore)object10.next();
            object2 = this.a(object4.getSerial());
            if (!((String)object6).isEmpty()) {
                object6 = (String)object6 + ",";
            }
            object6 = (String)object6 + (String)object2;
            l2 = object4.getSize();
            ((HashMap)((Object)this.a)).put("DS_" + (String)object2 + "-name", object4.getName());
            ((HashMap)((Object)this.a)).put("DS_" + (String)object2 + "-model", object4.getModel());
            ((HashMap)((Object)this.a)).put("DS_" + (String)object2 + "-size", Utilities.getEnglishSize(l2));
            boolean bl = false;
            int n4 = 0;
            for (Object object112 : object4.getPartitions()) {
                l2 = object112.getSize();
                object = object112.getMountPoint();
                ((HashMap)((Object)this.a)).put("Part_" + (String)object2 + "_" + ++n4 + "-name", object112.getName());
                ((HashMap)((Object)this.a)).put("Part_" + (String)object2 + "_" + n4 + "-mountPoint", object);
                ((HashMap)((Object)this.a)).put("Part_" + (String)object2 + "_" + n4 + "-identification", object112.getIdentification());
                ((HashMap)((Object)this.a)).put("Part_" + (String)object2 + "_" + n4 + "-type", object112.getType());
                ((HashMap)((Object)this.a)).put("Part_" + (String)object2 + "_" + n4 + "-UUID", object112.getUuid());
                ((HashMap)((Object)this.a)).put("Part_" + (String)object2 + "_" + n4 + "-size", Utilities.getEnglishSize(l2));
                if (bl || l2 <= 0L || ((String)object).isEmpty()) continue;
                bl = true;
                if (!((String)object3).isEmpty()) {
                    object3 = (String)object3 + ",";
                }
                object3 = (String)object3 + (String)object2;
            }
        }
        ((HashMap)((Object)this.a)).put("Disk-serials-all", object6);
        ((HashMap)((Object)this.a)).put("Disk-serials-valid", object3);
        ((HashMap)((Object)this.a)).put(HardwareIdentication.DiskSerials, object3);
        object4 = new StringBuilder();
        try {
            Object object12;
            Object object13;
            Object object112;
            object10 = new ArrayList();
            object2 = System.getenv();
            block7: for (Map.Entry entry : object2.entrySet()) {
                object112 = (String)entry.getKey();
                ((ArrayList)object10).add(object112);
                object13 = (String)entry.getValue();
                object = ((String)object112).toUpperCase();
                String[] stringArray = a;
                int n5 = a.length;
                int n6 = 0;
                while (n6 < n5) {
                    String string10 = stringArray[n6];
                    if (string10.endsWith("*") ? ((String)object).startsWith(string10.substring(0, string10.length() - 1)) : ((String)object).equals(string10)) continue block7;
                    ++n6;
                }
                if (((String)object13).length() > 80) {
                    object13 = ((String)object13).substring(0, 77) + "...";
                }
                if (((StringBuilder)object4).length() > 0) {
                    ((StringBuilder)object4).append('\n');
                }
                ((StringBuilder)object4).append((String)object112).append('=').append((String)object13);
            }
            Collator collator = Collator.getInstance(Locale.ENGLISH);
            ((ArrayList)object10).sort(collator);
            object112 = ((ArrayList)object10).iterator();
            while (object112.hasNext()) {
                object12 = (String)object112.next();
                ((HashMap)((Object)this.a)).put("Env-" + (String)object12, (String)object2.get(object12));
            }
            ((ArrayList)object10).clear();
            object12 = System.getProperties();
            for (Object object112 : ((Properties)object12).keySet()) {
                if (!(object112 instanceof String)) continue;
                ((ArrayList)object10).add((String)object112);
            }
            ((ArrayList)object10).sort(collator);
            object13 = ((ArrayList)object10).iterator();
            while (object13.hasNext()) {
                object112 = (String)object13.next();
                object = ((Properties)object12).get(object112);
                if (!(object instanceof String)) continue;
                ((HashMap)((Object)this.a)).put("SysProp-" + (String)object112, (String)object);
            }
        }
        catch (Throwable throwable) {
            ((StringBuilder)object4).append("NotAvailable=").append(throwable.toString());
        }
        this.a = ((StringBuilder)object4).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<String, String> getProperties() {
        HardwareInfo hardwareInfo = this.a;
        synchronized (hardwareInfo) {
            return (LinkedHashMap)((HashMap)((Object)this.a)).clone();
        }
    }

    private synchronized SystemInfo a() {
        return this.a;
    }

    private synchronized HardwareAbstractionLayer a(boolean bl) {
        if (this.a == null) {
            this.a = this.a().getHardware();
        }
        return this.a;
    }

    private synchronized List<NetworkIF> a(boolean bl) {
        if (bl || this.a == null) {
            this.a = this.a(bl).getNetworkIFs();
        }
        return this.a;
    }

    private String a(String string) {
        if ((string = string.trim()).endsWith(".")) {
            string = string.substring(0, string.length() - 1).trim();
        }
        return string;
    }

    public String toString() {
        String string2;
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getName()).append('[');
        int n2 = 0;
        for (String string2 : ((LinkedHashMap)((Object)this.a)).keySet()) {
            n2 = Math.max(n2, string2.length());
        }
        string2 = null;
        for (Map.Entry entry : ((LinkedHashMap)((Object)this.a)).entrySet()) {
            String string3 = (String)entry.getKey();
            if (string2 == null || !string3.startsWith(string2)) {
                if (string2 != null) {
                    stringBuilder.append("\n----------");
                }
                string2 = string3.substring(0, string3.indexOf(45) + 1);
            }
            stringBuilder.append('\n').append(string3);
            int n3 = n2 - string3.length();
            while (--n3 >= 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(": ").append((String)entry.getValue());
        }
        return stringBuilder.append("\n]").toString();
    }

    public String get(HardwareIdentication hardwareIdentication, boolean bl, boolean bl2, String ... stringArray) {
        if (hardwareIdentication.equals((Object)HardwareIdentication.SystemEnvironment)) {
            return this.a;
        }
        boolean bl3 = stringArray.length > 0 && hardwareIdentication.equals((Object)HardwareIdentication.HostAddressesIPv4) && hardwareIdentication.equals((Object)HardwareIdentication.HostNamesWithDomain) && hardwareIdentication.equals((Object)HardwareIdentication.HostNames);
        Object object = null;
        if (!bl3 && !bl && (object = (String)((HashMap)((Object)this.a)).get((Object)hardwareIdentication)) != null) {
            return object;
        }
        switch (HardwareInfo.a()[hardwareIdentication.ordinal()]) {
            case 1: {
                ComputerSystem computerSystem = this.a(false).getComputerSystem();
                object = "Manufacturer:\t" + computerSystem.getManufacturer() + "\nModel:\t" + computerSystem.getModel() + "\nSerial:\t" + computerSystem.getSerialNumber();
                break;
            }
            case 2: {
                CentralProcessor centralProcessor = this.a(bl).getProcessor();
                CentralProcessor.ProcessorIdentifier processorIdentifier = centralProcessor.getProcessorIdentifier();
                object = "Information:\t" + centralProcessor.toString() + "\nIdentifier:\t" + processorIdentifier.getIdentifier() + "\nProcessorID:\t" + processorIdentifier.getProcessorID() + "\nModel:\t" + processorIdentifier.getModel() + "\nPhysical:\t" + centralProcessor.getPhysicalProcessorCount() + "\nLogical:\t" + centralProcessor.getLogicalProcessorCount();
                break;
            }
            case 4: {
                OperatingSystem operatingSystem = this.a().getOperatingSystem();
                object = "Family:\t" + operatingSystem.getFamily() + "\nManufacturer:\t" + operatingSystem.getManufacturer();
                break;
            }
            case 3: {
                GlobalMemory globalMemory = this.a(bl).getMemory();
                object = "Total:\t" + globalMemory.getTotal() + "\nPage:\t" + globalMemory.getPageSize();
                break;
            }
            case 5: {
                OperatingSystem operatingSystem = this.a().getOperatingSystem();
                object = "Family:\t" + operatingSystem.getFamily() + "\nManufacturer:\t" + operatingSystem.getManufacturer() + "\nVersion:\t" + operatingSystem.getVersionInfo().getVersion();
                break;
            }
            case 6: {
                object = "";
                for (NetworkIF networkIF : this.a(bl)) {
                    if (!((String)object).isEmpty()) {
                        object = (String)object + ",";
                    }
                    object = (String)object + networkIF.getMacaddr();
                }
                break;
            }
            case 7: {
                object = "";
                for (NetworkIF networkIF : this.a(bl)) {
                    if (networkIF.getSpeed() <= 0L || networkIF.getIPv4addr().length <= 0) continue;
                    if (!((String)object).isEmpty()) {
                        object = (String)object + ",";
                    }
                    object = (String)object + networkIF.getMacaddr();
                }
                break;
            }
            case 8: {
                object = "";
                for (NetworkIF networkIF : this.a(bl)) {
                    if (networkIF.getSpeed() <= 0L || networkIF.getIPv6addr().length <= 0) continue;
                    if (!((String)object).isEmpty()) {
                        object = (String)object + ",";
                    }
                    object = (String)object + networkIF.getMacaddr();
                }
                break;
            }
            case 9: {
                object = this.a(this.a(bl, stringArray), false);
                break;
            }
            case 10: {
                object = this.a(this.a(bl, stringArray), true);
                break;
            }
            case 11: {
                object = String.join((CharSequence)",", this.a(bl, stringArray));
                break;
            }
            case 12: {
                object = "";
                block17: for (HWDiskStore hWDiskStore : this.a(bl).getDiskStores()) {
                    for (HWPartition hWPartition : hWDiskStore.getPartitions()) {
                        String string;
                        if (hWPartition.getSize() <= 0L || hWPartition.getMountPoint().isEmpty() || (string = this.a(hWDiskStore.getSerial())).isEmpty()) continue;
                        if (!((String)object).isEmpty()) {
                            object = (String)object + ",";
                        }
                        object = (String)object + string;
                        continue block17;
                    }
                }
                break;
            }
        }
        if (bl2 && !bl3) {
            ((HashMap)((Object)this.a)).put(hardwareIdentication, object);
        }
        return object;
    }

    private Set<String> a(boolean bl, String ... stringArray) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (NetworkIF networkIF : this.a(bl)) {
            if (networkIF.getSpeed() <= 0L) continue;
            String[] stringArray2 = networkIF.getIPv4addr();
            int n2 = stringArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                String string = stringArray2[n3];
                if (stringArray.length == 0) {
                    linkedHashSet.add(string);
                } else {
                    String[] stringArray3 = stringArray;
                    int n4 = stringArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        String string2 = stringArray3[n5];
                        if (string2.equals(string)) {
                            linkedHashSet.add(string);
                            break;
                        }
                        ++n5;
                    }
                }
                ++n3;
            }
        }
        return linkedHashSet;
    }

    private String a(Set<String> set, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : set) {
            String string2;
            try {
                int n2;
                InetAddress inetAddress = InetAddress.getByName(string);
                string2 = inetAddress.getHostName().toLowerCase(Locale.ENGLISH);
                if (bl && (n2 = string2.indexOf(46)) > 0) {
                    string2 = string2.substring(0, n2);
                }
            }
            catch (UnknownHostException unknownHostException) {
                string2 = string;
            }
            if (string2.equals("localhost") || arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        return String.join((CharSequence)",", arrayList);
    }

    static /* synthetic */ int[] a() {
        if (a != null) {
            return a;
        }
        int[] nArray = new int[HardwareIdentication.values().length];
        try {
            nArray[HardwareIdentication.AllMacAddresses.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HardwareIdentication.ComputerInfo.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HardwareIdentication.DiskSerials.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HardwareIdentication.HostAddressesIPv4.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HardwareIdentication.HostNames.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HardwareIdentication.HostNamesWithDomain.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HardwareIdentication.IPv4MacAddresses.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HardwareIdentication.IPv6MacAddresses.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HardwareIdentication.MemoryInfo.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HardwareIdentication.OperatingSystem.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HardwareIdentication.OperatingSystemWithVersion.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HardwareIdentication.ProcessorInfo.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HardwareIdentication.SystemEnvironment.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        a = nArray;
        return nArray;
    }
}

