/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.license;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.UUID;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DeveloperSignature {
    private final X509Certificate a;
    private final X500Principal a;
    public final UUID developerID;
    public final String developerName;
    public final String email;

    public DeveloperSignature(X509Certificate x509Certificate) {
        String string;
        Rdn rdn2;
        LdapName ldapName;
        this.a = x509Certificate;
        this.a = x509Certificate.getSubjectX500Principal();
        BigInteger bigInteger = x509Certificate.getSerialNumber();
        this.developerID = UUID.nameUUIDFromBytes(bigInteger.toByteArray());
        try {
            ldapName = new LdapName(this.a.getName());
        }
        catch (InvalidNameException invalidNameException) {
            throw new IllegalArgumentException("Failed parsing certificate subject for LDAP", invalidNameException);
        }
        String string2 = null;
        Object var5_6 = null;
        String string3 = null;
        System.err.println("RDN's for subject " + String.valueOf(this.a) + ":");
        for (Rdn rdn2 : ldapName.getRdns()) {
            string = rdn2.getType();
            String string4 = rdn2.getValue().toString();
            System.err.println(" - " + string + " = " + string4);
        }
        if (string3 == null) {
            throw new IllegalArgumentException("ASN1 Object Identifier for DeveloperID not found");
        }
        if (var5_6 == null) {
            throw new IllegalArgumentException("ASN1 Object Identifier for DeveloperName not found");
        }
        rdn2 = X500Name.getInstance((Object)this.a.getEncoded());
        RDN[] rDNArray = rdn2.getRDNs(BCStyle.EmailAddress);
        if (rDNArray.length > 0 && (string = rDNArray[0].getFirst()) != null) {
            string2 = IETFUtils.valueToString((ASN1Encodable)string.getValue());
        }
        if (string2 == null) {
            throw new IllegalArgumentException("ASN1 Object Identifier for EmailAddress not found");
        }
        this.developerName = var5_6;
        this.email = string2;
        if (!this.developerID.toString().equals(string3)) {
            throw new IllegalArgumentException("Mismatch of Developer ID: " + string3 + " != " + String.valueOf(this.developerID));
        }
        throw new InternalError("NOT YET COMPLETED!");
    }

    public DeveloperSignature(String string, String string2, byte[] byArray, String string3, String string4, String string5, String string6, String string7) throws Exception {
        this.a = null;
        this.a = null;
        this.developerID = null;
        this.developerName = null;
        this.email = string;
        throw new InternalError("Not yet");
    }

    public X509Certificate getCertificate() {
        return this.a;
    }
}

