/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.image;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import net.coobird.thumbnailator.Thumbnails;
import net.sf.image4j.codec.bmp.BMPDecoder;
import net.sf.image4j.codec.ico.ICOEncoder;

public class IcoUtilities {
    public static void createIco(File file, File ... fileArray) throws IOException {
        Serializable serializable;
        ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>();
        File[] fileArray2 = fileArray;
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            serializable = fileArray2[n3];
            String string = ((File)serializable).getName();
            int n4 = string.lastIndexOf(46);
            if (n4 < 0) {
                throw new FileNotFoundException(((File)serializable).getAbsolutePath() + ": file extension not found");
            }
            if (string.substring(n4 + 1).equalsIgnoreCase("bmp")) {
                arrayList.add(BMPDecoder.read((File)serializable));
            } else {
                arrayList.add(Thumbnails.of((File[])new File[]{serializable}).scale(1.0).asBufferedImage());
            }
            ++n3;
        }
        serializable = null;
        Object var4_7 = null;
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            ICOEncoder.write(arrayList, (OutputStream)fileOutputStream);
        }
        catch (Throwable throwable) {
            if (serializable == null) {
                serializable = throwable;
            } else if (serializable != throwable) {
                ((Throwable)serializable).addSuppressed(throwable);
            }
            throw serializable;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.err.println("IcoUtilities: syntax: IcoUtilities ico-destination-file ...list-of-input-files...");
            System.err.println("where the input files can be in JPEG/JPG, BMP or PNG formats.");
            System.err.println("The ico-destination-file is overwritten if present.");
            System.exit(9);
        }
        File file = new File(stringArray[0]);
        int n2 = stringArray.length;
        File[] fileArray = new File[n2 - 1];
        while (--n2 > 0) {
            fileArray[n2 - 1] = new File(stringArray[n2]);
        }
        try {
            IcoUtilities.createIco(file, fileArray);
        }
        catch (Throwable throwable) {
            System.err.println("Failed creating ICO file " + file.getAbsolutePath());
            throwable.printStackTrace(System.err);
        }
    }
}

