/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.geo;

public interface ILongitudeLatitude {
    public static final double EARTH_RADIUS = 6371000.0;

    public static double getDistance(double d2, double d3, double d4, double d5) {
        if (Double.isNaN(d2) || Double.isNaN(d3) || Double.isNaN(d4) || Double.isNaN(d5)) {
            return Double.NaN;
        }
        double d6 = Math.toRadians(d5 - d4);
        double d7 = Math.toRadians(d3 - d2);
        double d8 = Math.pow(Math.sin(d6 / 2.0), 2.0) + Math.cos(Math.toRadians(d4)) * Math.cos(Math.toRadians(d5)) * Math.pow(Math.sin(d7 / 2.0), 2.0);
        double d9 = 2.0 * Math.atan2(Math.sqrt(d8), Math.sqrt(1.0 - d8));
        return 6371000.0 * d9;
    }

    public double getLongitude();

    public double getLatitude();

    default public double getDistance(ILongitudeLatitude iLongitudeLatitude) {
        return ILongitudeLatitude.getDistance(this.getLongitude(), iLongitudeLatitude.getLongitude(), this.getLatitude(), iLongitudeLatitude.getLatitude());
    }
}

