/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.panel.prop;

import com.iizigo.editor.PropHelper;
import com.iizigo.panel.prop.EGridLayout;
import com.iizigo.panel.prop.IELayoutProp;
import com.iizigo.panel.prop.IEUICompCommon;
import com.iizigo.prop.editor.IDefaultGUnitProvider;
import com.iizigo.prop.group.LayoutDataFormatter;
import com.iizigo.prop.tooltip.TooltipItem;
import com.iizix.prop.Atom;
import com.iizix.prop.BoolProp;
import com.iizix.prop.GProp;
import com.iizix.prop.GRect;
import com.iizix.prop.GUnit;
import com.iizix.prop.IntProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.UnitProp;
import com.iizix.prop.ui.GridData;
import com.iizix.prop.ui.LayoutMgr;
import com.iizix.prop.ui.UIComp;
import com.iizix.prop.ui.UIContainer;
import java.util.List;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class EGridData
extends GridData
implements IELayoutProp,
IDefaultGUnitProvider {
    static final String[] a = new String[]{"spanX", "spanY", "alignX", "alignY", "cax=contX", "cay=contY", "grabX", "grabY", "grabOK", "cx=cxGrid", "cy=cyGrid", "cxMin", "cyMin", "cxMax", "cyMax", "assumeWidth", "assumeHeight"};
    private static final List<TooltipItem> a;

    static {
        a = List.of(TooltipItem.newNormal("Horizontal span", "spanX"), TooltipItem.newNormal("Vertical span", "spanY"), TooltipItem.newIntIndex("Horizontal align", "alignX", ALIGN_X), TooltipItem.newIntIndex("Vertical align", "alignY", ALIGN_Y), TooltipItem.newNormal("Horizontal align content", "cax", (propCnr, gProp, object) -> {
            if (object instanceof Integer) {
                Integer n2 = (Integer)object;
                return switch (n2) {
                    case 0 -> "inherit";
                    case 4 -> "left";
                    case 5 -> "center";
                    case 6 -> "right";
                    default -> "UNKNOWN (" + String.valueOf(n2) + ")";
                };
            }
            return null;
        }), TooltipItem.newNormal("Vertical align content", "cay", (propCnr, gProp, object) -> {
            if (object instanceof Integer) {
                Integer n2 = (Integer)object;
                return switch (n2) {
                    case 0 -> "inherit";
                    case 8 -> "top";
                    case 5 -> "center";
                    case 2 -> "bottom";
                    default -> "UNKNOWN (" + String.valueOf(n2) + ")";
                };
            }
            return null;
        }), TooltipItem.SPACER_4PX, TooltipItem.newNormal("Grab remaining vertical", "grabX"), TooltipItem.newNormal("Grab remaining horizontal", "grabY"), TooltipItem.newNormal("Assume valid grab", "grabOK"), TooltipItem.SPACER_4PX, TooltipItem.newNormal("Width", "cx"), TooltipItem.newNormal("Height", "cy"), TooltipItem.SPACER_4PX, TooltipItem.newNormal("Minimum width", "cxMin"), TooltipItem.newNormal("Minimum height", "cyMin"), TooltipItem.newNormal("Maximum width", "cxMax"), TooltipItem.newNormal("Maximum height", "cyMax"), TooltipItem.SPACER_4PX, TooltipItem.newBool("Assumed width", "assumeWidth"), TooltipItem.newBool("Assumed height", "assumeHeight"));
    }

    public EGridData() {
    }

    public EGridData(Atom atom) {
        super(atom);
    }

    public EGridData(UIComp uIComp) {
        super(Atom.LAYOUT);
    }

    public EGridData(Atom atom, GProp<?>[] gPropArray) throws PropException {
        super(atom, gPropArray);
    }

    @Override
    public String getCNDescriptionType() {
        return "Grid data";
    }

    @Override
    public Object[] getTransferProps() {
        return a;
    }

    public boolean verify(PropVerification propVerification) {
        LayoutMgr layoutMgr;
        if (!super.verify(propVerification)) {
            return false;
        }
        UIComp uIComp = (UIComp)this.getParent();
        this.verifyAlignX(uIComp, propVerification);
        this.verifyAlignY(uIComp, propVerification);
        UIContainer uIContainer = uIComp.getUIParent();
        if (uIContainer != null && (layoutMgr = uIContainer.getLayoutMgr()) instanceof EGridLayout) {
            IntProp intProp;
            IntProp intProp2;
            EGridLayout eGridLayout = (EGridLayout)layoutMgr;
            BoolProp boolProp = (BoolProp)this.getProp("grabX", BoolProp.class);
            boolean bl = layoutMgr.getBool("sameWidth", false);
            if (bl && boolProp != null && boolProp.getBool()) {
                propVerification.add(new PropVerificationError("gd.grabX", PropVerificationError.Severity.WARNING, "Grid data", (GProp)boolProp, "Grab remaining horizontal space used together with same column width", new String[0]));
            }
            boolProp = (BoolProp)this.getProp("grabY", BoolProp.class);
            bl = layoutMgr.getBool("sameHeight", false);
            if (bl && boolProp != null && boolProp.getBool()) {
                propVerification.add(new PropVerificationError("gd.grabY", PropVerificationError.Severity.WARNING, "Grid data", (GProp)boolProp, "Grab remaining vertical space used together with same column height", new String[0]));
            }
            int n2 = uIComp.getPropIndex() + 1;
            EGridLayout.Grid grid = eGridLayout.getGrid();
            block0: for (int[] nArray : grid.grid) {
                int n3 = 0;
                int[] nArray2 = nArray;
                int n4 = nArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    int n6 = nArray2[n5];
                    if (n6 == n2) {
                        int n7;
                        IntProp intProp3 = (IntProp)this.getProp("spanX", IntProp.class);
                        if (intProp3 == null || (n7 = intProp3.getInt()) + n3 <= grid.columnCount) break block0;
                        propVerification.add(new PropVerificationError("gd.spanX", PropVerificationError.Severity.ERROR, "Grid data", (GProp)intProp3, "Horizontal span value (" + n7 + ") is too large for grid", new String[0]));
                        break block0;
                    }
                    ++n3;
                    ++n5;
                }
            }
            if ((grid = (IntProp)this.getProp("cax", IntProp.class)) != null && grid.getInt() != 0 && this.getProp("cx", UnitProp.class) == null && (intProp2 = this.getAlignPropX()) != null && intProp2.getInt() == 4) {
                propVerification.add(new PropVerificationError("gd.contX", PropVerificationError.Severity.WARNING, "Grid data", (GProp)grid, "Content alignment is ignored when width is not set and horizontally filled. Width is implicit 100%.", new String[0]));
            }
            if ((grid = (IntProp)this.getProp("cay", IntProp.class)) != null && grid.getInt() != 0 && this.getProp("cy", UnitProp.class) == null && (intProp = this.getAlignPropY()) != null && intProp.getInt() == 4) {
                propVerification.add(new PropVerificationError("gd.contY", PropVerificationError.Severity.WARNING, "Grid data", (GProp)grid, "Content alignment is ignored when height is not set and horizontally filled. Height is implicit 100%.", new String[0]));
            }
        }
        this.verifySizeAndMinMax(propVerification);
        return true;
    }

    @Override
    public String getGroupText(PropCnr[] propCnrArray, StringBuilder stringBuilder, boolean[] blArray) {
        String string;
        Integer n2;
        Object object;
        Object object2 = PropHelper.getPropsValue(propCnrArray, Atom.get((String)"cx"));
        Object object3 = PropHelper.getPropsValue(propCnrArray, Atom.get((String)"cy"));
        Object object4 = PropHelper.getPropsValue(propCnrArray, Atom.get((String)"alignX"));
        Object object5 = PropHelper.getPropsValue(propCnrArray, Atom.get((String)"alignY"));
        Object object6 = PropHelper.getPropsValue(propCnrArray, Atom.get((String)"spanX"));
        Object object7 = PropHelper.getPropsValue(propCnrArray, Atom.get((String)"spanY"));
        blArray[0] = true;
        stringBuilder.append("<u><b>Grid layout:</b></u><br><table>");
        String string2 = LayoutDataFormatter.format(object2) + ", " + LayoutDataFormatter.format(object3);
        if (object2 != null) {
            stringBuilder.append("<tr><td>Width</td><td>").append(LayoutDataFormatter.format(object2)).append("</td></tr>");
        }
        if (object3 != null) {
            stringBuilder.append("<tr><td>Height</td><td>").append(LayoutDataFormatter.format(object3)).append("</td></tr>");
        }
        if (object6 != null) {
            string2 = string2 + ", H=" + LayoutDataFormatter.format(object6);
            stringBuilder.append("<tr><td>Horizontal span</td><td>").append(LayoutDataFormatter.format(object6)).append("</td></tr>");
        }
        if (object7 != null) {
            string2 = string2 + ", V=" + LayoutDataFormatter.format(object7);
            stringBuilder.append("<tr><td>Vertical span</td><td>").append(LayoutDataFormatter.format(object7)).append("</td></tr>");
        }
        if (object4 instanceof Integer && (object = this.getAlignXString(n2 = (Integer)object4)) != null) {
            string2 = string2 + ", " + (String)object;
            stringBuilder.append("<tr><td>Align horizontal</td><td>" + (String)object + "</td></tr>");
        }
        if (object5 instanceof Integer && (string = this.getAlignYString((Integer)(object = (Integer)object5))) != null) {
            string2 = string2 + ", " + string;
            stringBuilder.append("<tr><td>Align vertical</td><td>" + string + "</td></tr>");
        }
        stringBuilder.append("</table>");
        return string2;
    }

    @Override
    public GUnit getDefaultValue(Atom atom, GUnit gUnit) {
        String string;
        switch (string = atom.getAtomName()) {
            case "cx": 
            case "cy": {
                IEUICompCommon iEUICompCommon;
                GRect gRect;
                PropCnr propCnr = this.getParent();
                if (!(propCnr instanceof IEUICompCommon) || (gRect = (iEUICompCommon = (IEUICompCommon)propCnr).getBounds()) == null) break;
                int n2 = string.equals("cx") ? gRect.getCX() : gRect.getCY();
                gUnit = new GUnit(n2);
            }
        }
        return gUnit;
    }

    @Override
    public List<TooltipItem> getTooltipPropertyList() {
        return a;
    }
}

