/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.panel.prop;

import com.iizigo.Activator;
import com.iizigo.ApplicationUI;
import com.iizigo.editor.PropHelper;
import com.iizigo.editor.complex.ComplexOperation;
import com.iizigo.panel.DropInfo;
import com.iizigo.panel.prop.EAbsoluteData;
import com.iizigo.panel.prop.EAbsoluteLayout0;
import com.iizigo.panel.prop.EGridLayout;
import com.iizigo.panel.prop.IClearComponentArea;
import com.iizigo.panel.prop.IELayoutMgrDND;
import com.iizigo.panel.prop.IEUICompCommon;
import com.iizigo.panel.prop.IReplaceLayoutData;
import com.iizigo.panel.prop.IScrollbarsValidation;
import com.iizigo.panel.prop.UILayoutDesignerProp;
import com.iizigo.panel.wizards.AddUICompWizard;
import com.iizigo.prop.tooltip.TooltipItem;
import com.iizix.ILog;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.GRect;
import com.iizix.prop.GUnit;
import com.iizix.prop.IComplexOperation;
import com.iizix.prop.IGProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.Styles;
import com.iizix.prop.UnitProp;
import com.iizix.prop.ui.AbsoluteLayout;
import com.iizix.prop.ui.LayoutMgr;
import com.iizix.prop.ui.LayoutProp;
import com.iizix.prop.ui.UIComp;
import com.iizix.prop.ui.UIComps;
import com.iizix.prop.ui.UIContainer;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class EAbsoluteLayout
extends AbsoluteLayout
implements IELayoutMgrDND<EAbsoluteData>,
IReplaceLayoutData,
IScrollbarsValidation {
    private UILayoutDesignerProp a = new UILayoutDesignerProp((LayoutMgr<?>)this);
    private static final List<TooltipItem> a;

    static {
        a = List.of(TooltipItem.HEADER_IMAGE_DESCR_TYPE, TooltipItem.SEPARATOR, TooltipItem.newNormal("Trailing padding", "px"), TooltipItem.newNormal("Bottom padding", "py"), TooltipItem.newNormal("Minimum width", "mx"), TooltipItem.newNormal("Minimum height", "my"), TooltipItem.ATOM_HSCROLL, TooltipItem.ATOM_VSCROLL);
    }

    public EAbsoluteLayout() {
    }

    public EAbsoluteLayout(Atom atom) {
        super(atom);
    }

    @Override
    public Class<EAbsoluteData> getLayoutDataClass() {
        return EAbsoluteData.class;
    }

    @Override
    public boolean isCNVisible() {
        return true;
    }

    @Override
    public UILayoutDesignerProp getDesigner() {
        return this.a;
    }

    @Override
    public Object[] getPropertyEditorLayoutDataSetup() {
        return EAbsoluteData.a;
    }

    @Override
    public Image getCNImage(boolean bl) {
        return ApplicationUI.getInstance().imageUIAbsoluteLayout;
    }

    @Override
    public String getCNDescriptionType() {
        return "Absolute layout";
    }

    public EAbsoluteLayout clone() {
        EAbsoluteLayout eAbsoluteLayout = (EAbsoluteLayout)super.clone();
        eAbsoluteLayout.a = new UILayoutDesignerProp((LayoutMgr<?>)eAbsoluteLayout);
        return eAbsoluteLayout;
    }

    @Override
    public boolean isReplaceable() {
        return true;
    }

    @Override
    public EAbsoluteData createDefaultLayoutProp(UIComp uIComp) {
        return new EAbsoluteData(uIComp);
    }

    @Override
    public Object[] getTransferProps() {
        return EAbsoluteLayout0.setup;
    }

    public boolean verify(PropVerification propVerification) {
        if (!super.verify(propVerification)) {
            return false;
        }
        this.verifyScrollbars(propVerification);
        Styles styles = this.getUIContainer().getStyles();
        GProp gProp = styles.getProp("padding");
        if (gProp != null) {
            propVerification.add(new PropVerificationError("pad.abs", PropVerificationError.Severity.WARNING, "Padding", gProp, "Padding style is not supported for containers with absolute layout", new String[0]));
        }
        return true;
    }

    @Override
    public void checkReplaceLayoutData(ComplexOperation complexOperation, UIComp uIComp) {
        LayoutProp layoutProp = uIComp.getLayout();
        if (!(layoutProp instanceof EAbsoluteData)) {
            GUnit gUnit = layoutProp.getLayoutWidth();
            GUnit gUnit2 = layoutProp.getLayoutHeight();
            EAbsoluteData eAbsoluteData = new EAbsoluteData(Atom.LAYOUT);
            if (gUnit != null) {
                eAbsoluteData.addProp2((IGProp)new UnitProp(Atom.get((String)"cx"), gUnit));
            }
            if (gUnit2 != null) {
                eAbsoluteData.addProp2((IGProp)new UnitProp(Atom.get((String)"cy"), gUnit2));
            }
            int n2 = layoutProp.getInt("alignX");
            int n3 = layoutProp.getInt("alignY");
            if (n2 > 0) {
                eAbsoluteData.setInt("alignX", n2);
            }
            if (n3 > 0) {
                eAbsoluteData.setInt("alignY", n3);
            }
            if (complexOperation == null) {
                uIComp.removeProp2((IGProp)layoutProp);
                uIComp.addProp2((IGProp)eAbsoluteData);
            } else {
                complexOperation.removeProp((GProp<?>)layoutProp);
                complexOperation.addProp((PropCnr)uIComp, (GProp<?>)eAbsoluteData);
            }
        }
    }

    @Override
    public UIComp[] onDrop(DropInfo dropInfo) {
        Object object;
        GProp[] gPropArray;
        int n2;
        boolean bl = dropInfo.isCopy;
        GProp[] gPropArray2 = dropInfo.comps;
        int n3 = gPropArray2.length;
        Rectangle[] rectangleArray = new Rectangle[n3];
        int n4 = 0;
        while (n4 < n3) {
            rectangleArray[n4] = new Rectangle(dropInfo.trans.readSigned(), dropInfo.trans.readSigned(), dropInfo.trans.readSigned(), dropInfo.trans.readSigned());
            ++n4;
        }
        n4 = gPropArray2.length;
        String string = n4 > 1 ? "components" : "component";
        ComplexOperation complexOperation = new ComplexOperation(dropInfo.isCopy ? "Copy " + string : "Move " + string, dropInfo.panelEditor, dropInfo.panelEditor);
        UIComps uIComps = this.getCompsCnr();
        if (dropInfo.isWizardEditingRequested && !AddUICompWizard.doWizardBeforeDrop(gPropArray2[0], uIComps, complexOperation)) {
            return null;
        }
        Atom[] atomArray = PropHelper.getUniqueNames((PropCnr)uIComps, dropInfo.comps, dropInfo.isCopy ? " Copy" : " Moved", bl);
        if (bl) {
            int n5 = 0;
            while (n5 < n4) {
                UIComp uIComp = gPropArray2[n5];
                try {
                    uIComp = gPropArray2[n5] = uIComp.clone();
                    uIComp.renameProp(atomArray[n5]);
                    this.checkReplaceLayoutData(null, uIComp);
                }
                catch (PropException propException) {
                    ILog.SEVERE(EGridLayout.class, (String)"Failed clone", (Object[])new Object[]{"Component = " + String.valueOf(uIComp), propException});
                    return null;
                }
                ++n5;
            }
        } else {
            PropCnr propCnr = null;
            GProp[] gPropArray3 = gPropArray2;
            n2 = gPropArray2.length;
            int n6 = 0;
            while (n6 < n2) {
                UIComp uIComp = gPropArray3[n6];
                gPropArray = uIComp.getUIParent().getLayoutMgr();
                if (gPropArray instanceof IClearComponentArea) {
                    object = (IClearComponentArea)gPropArray;
                    if (propCnr == null) {
                        propCnr = new PropCnr(Atom.TRANSACTION);
                        complexOperation.addProp((PropCnr)this, (GProp<?>)propCnr);
                    }
                    PropCnr propCnr2 = new PropCnr(propCnr.createUniqueAtom(""));
                    complexOperation.addProp(propCnr, (GProp<?>)propCnr2);
                    complexOperation.moveProp((GProp<?>)uIComp, propCnr2, null, -1);
                    object.clearComponentArea(complexOperation, uIComp);
                }
                ++n6;
            }
            int n7 = 0;
            gPropArray = gPropArray2;
            int n8 = gPropArray2.length;
            n2 = 0;
            while (n2 < n8) {
                LayoutMgr layoutMgr = gPropArray[n2];
                if (layoutMgr.getParent() != uIComps) {
                    complexOperation.moveProp((GProp<?>)layoutMgr, (PropCnr)uIComps, atomArray[n7], -1);
                }
                ++n7;
                this.checkReplaceLayoutData(complexOperation, (UIComp)layoutMgr);
                ++n2;
            }
            if (propCnr != null) {
                gPropArray = propCnr.getProps();
                n8 = gPropArray.length;
                n2 = 0;
                while (n2 < n8) {
                    GProp gProp = gPropArray[n2];
                    object = (PropCnr)gProp;
                    assert (object.getPropCount() == 0) : "Temp-wrap-container not empty!";
                    complexOperation.removeProp(gProp);
                    ++n2;
                }
                complexOperation.removeProp((GProp<?>)propCnr);
            }
        }
        int n9 = 0;
        GProp[] gPropArray4 = gPropArray2;
        n2 = gPropArray2.length;
        int n10 = 0;
        while (n10 < n2) {
            LayoutMgr layoutMgr = gPropArray4[n10];
            gPropArray = rectangleArray[n9++];
            object = (EAbsoluteData)layoutMgr.getLayout();
            this.a(complexOperation, bl, (LayoutProp)object, "x", gPropArray.x);
            this.a(complexOperation, bl, (LayoutProp)object, "y", gPropArray.y);
            ++n10;
        }
        if (bl) {
            gPropArray4 = gPropArray2;
            n2 = gPropArray2.length;
            n10 = 0;
            while (n10 < n2) {
                GProp gProp = gPropArray4[n10];
                complexOperation.addProp((PropCnr)uIComps, gProp);
                ++n10;
            }
        }
        PropHelper.executeOperation(dropInfo.panelEditor.getShell(), complexOperation);
        return gPropArray2;
    }

    private void a(ComplexOperation complexOperation, boolean bl, LayoutProp layoutProp, String string, int n2) {
        GUnit gUnit = new GUnit(n2);
        Atom atom = Atom.get((String)string);
        UnitProp unitProp = (UnitProp)layoutProp.getProp(atom, UnitProp.class);
        if (unitProp != null) {
            if (bl) {
                unitProp.setPropValue(gUnit);
            } else {
                complexOperation.setPropValue((GProp<?>)unitProp, gUnit);
            }
        } else {
            unitProp = new UnitProp(atom, gUnit);
            if (bl) {
                try {
                    layoutProp.addProp((IGProp)unitProp);
                }
                catch (PropException propException) {
                    ILog.SEVERE(this.getClass(), (String)"Failed addProp", (Throwable)propException);
                }
            } else {
                complexOperation.addProp((PropCnr)layoutProp, (GProp<?>)unitProp);
            }
        }
    }

    @Override
    public void convertLayout(ComplexOperation complexOperation, UIContainer uIContainer, LayoutMgr<?> layoutMgr) {
        UIComp[] uICompArray = uIContainer.getCompsCnr().getUIComps();
        int n2 = uICompArray.length;
        int n3 = 0;
        while (n3 < n2) {
            UIComp uIComp = uICompArray[n3];
            this.checkReplaceLayoutData(complexOperation, uIComp);
            ++n3;
        }
    }

    public void onBeforeAdd(UIComp uIComp, LayoutProp layoutProp, int n2, IComplexOperation iComplexOperation) throws PropException {
        EAbsoluteData eAbsoluteData;
        int n3 = 5;
        int n4 = 0;
        UIComp[] uICompArray = this.getCompsCnr().getUIComps();
        int n5 = uICompArray.length;
        int n6 = 0;
        while (n6 < n5) {
            IEUICompCommon iEUICompCommon;
            GRect gRect;
            eAbsoluteData = uICompArray[n6];
            if (eAbsoluteData instanceof IEUICompCommon && (gRect = (iEUICompCommon = (IEUICompCommon)((Object)eAbsoluteData)).getBounds()) != null) {
                n4 = Math.max(gRect.getY() + gRect.getCY() + n3, n4);
            }
            ++n6;
        }
        eAbsoluteData = (EAbsoluteData)layoutProp;
        eAbsoluteData.setProp((IGProp)new UnitProp(Atom.get((String)"x"), new GUnit(0)));
        eAbsoluteData.setProp((IGProp)new UnitProp(Atom.get((String)"y"), new GUnit(n4)));
    }

    @Override
    public IStatus layoutNewComponents(List<UIComp> list, ComplexOperation complexOperation) {
        return Activator.createInfoStatus("Layed out " + list.size() + " components");
    }

    @Override
    public List<TooltipItem> getTooltipPropertyList() {
        return a;
    }
}

