/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.image.prop;

import com.iizigo.ApplicationUI;
import com.iizigo.image.ImageHelper;
import com.iizigo.image.LastVerified;
import com.iizigo.image.prop.EditorImagesDefinition;
import com.iizigo.image.prop.EditorImagesResolution;
import com.iizigo.image.prop.EditorImagesStyle;
import com.iizigo.image.prop.IEditorImage;
import com.iizigo.image.prop.ImageDesignerProp;
import com.iizigo.prop.IPropDesigner;
import com.iizix.Position;
import com.iizix.Size;
import com.iizix.prop.AssetReference;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.IntProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.image.ImageLocation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class EditorImageLocation
extends ImageLocation
implements IEditorImage,
IPropDesigner {
    private ImageDesignerProp a = new ImageDesignerProp((PropCnr)this);

    public EditorImageLocation() {
    }

    public EditorImageLocation(Atom atom) {
        super(atom);
    }

    @Override
    public ImageDesignerProp getDesigner() {
        return this.a;
    }

    public EditorImageLocation clone() throws CloneNotSupportedException {
        EditorImageLocation editorImageLocation = (EditorImageLocation)super.clone();
        editorImageLocation.a = new ImageDesignerProp((PropCnr)editorImageLocation);
        return editorImageLocation;
    }

    @Override
    public Image getCNImage() {
        return ApplicationUI.getInstance().imageImageLocation;
    }

    @Override
    public String getCNType() {
        return "Image Location";
    }

    @Override
    public String getCNText(int n2) {
        return n2 == 0 ? this.getPropName() : "";
    }

    @Override
    public Composite createTooltip(Composite composite) {
        AssetReference assetReference = null;
        Size size = null;
        PropCnr propCnr = this.getParent();
        if (propCnr instanceof EditorImagesStyle) {
            propCnr = propCnr.getParent();
        }
        if (propCnr instanceof EditorImagesDefinition) {
            EditorImagesDefinition editorImagesDefinition = (EditorImagesDefinition)propCnr;
            assetReference = editorImagesDefinition.getAssetReference();
            size = editorImagesDefinition.getImageSize();
        } else if (propCnr instanceof EditorImagesResolution) {
            EditorImagesResolution editorImagesResolution = (EditorImagesResolution)propCnr;
            assetReference = editorImagesResolution.getAssetReference();
            size = editorImagesResolution.getImageSize();
        }
        Rectangle rectangle = null;
        Position position = this.getLocation();
        if (size != null && position != null) {
            rectangle = new Rectangle(position.x, position.y, size.width, size.height);
        }
        return ImageHelper.createImageTooltip((PropCnr)this, composite, assetReference, this.getCNImage(), this.getCNType(), this.getCNText(0), rectangle);
    }

    public boolean verify(PropVerification propVerification) {
        IntProp intProp;
        if (!super.verify(propVerification)) {
            return false;
        }
        IntProp intProp2 = (IntProp)this.getProp("xo", IntProp.class);
        if (intProp2 == null) {
            propVerification.add(new PropVerificationError("xo.undef", PropVerificationError.Severity.ERROR, "X offset", (GProp)this, "X offset must be defined", new String[0]));
        }
        if ((intProp = (IntProp)this.getProp("yo", IntProp.class)) == null) {
            propVerification.add(new PropVerificationError("yo.undef", PropVerificationError.Severity.ERROR, "Y offset", (GProp)this, "Y offset must be defined", new String[0]));
        }
        Size size = null;
        LastVerified lastVerified = null;
        PropCnr propCnr = this.getParent();
        if (propCnr instanceof EditorImagesStyle) {
            propCnr = propCnr.getParent();
        }
        if (propCnr instanceof EditorImagesDefinition) {
            EditorImagesDefinition editorImagesDefinition = (EditorImagesDefinition)propCnr;
            lastVerified = editorImagesDefinition.getLastVerified();
            size = editorImagesDefinition.getImageSize();
        } else if (propCnr instanceof EditorImagesResolution) {
            EditorImagesResolution editorImagesResolution = (EditorImagesResolution)propCnr;
            lastVerified = editorImagesResolution.getLastVerified();
            size = editorImagesResolution.getImageSize();
        }
        if (size != null && lastVerified != null && lastVerified.success) {
            int n2;
            if (intProp2 != null && ((n2 = intProp2.getInt()) < 0 || n2 > lastVerified.width + size.width)) {
                propVerification.add(new PropVerificationError("xo.range", PropVerificationError.Severity.ERROR, "X offset", (GProp)intProp2, "X offset range is outside image horizontally", new String[0]));
            }
            if (intProp != null && ((n2 = intProp.getInt()) < 0 || n2 > lastVerified.height + size.height)) {
                propVerification.add(new PropVerificationError("yo.range", PropVerificationError.Severity.ERROR, "Y offset", (GProp)intProp, "Y offset range is outside image vertically", new String[0]));
            }
        }
        return true;
    }
}

