/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.editor;

import com.iizigo.Activator;
import com.iizigo.ApplicationUI;
import com.iizigo.editor.PropHelper;
import com.iizigo.prop.DesignerProp;
import com.iizigo.prop.IPropRenameable;
import com.iizigo.prop.PropUndoRedoAdapter;
import com.iizigo.swt.LineWidget;
import com.iizix.ILog;
import com.iizix.prop.Atom;
import com.iizix.prop.PropCnr;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class RenameDialog
extends Dialog
implements ModifyListener {
    private final String a;
    private final DesignerProp a;
    private final IUndoContext a;
    private Shell a;
    private Button a;
    private Text a;
    private CLabel a;
    private String b;

    public RenameDialog(Shell shell, DesignerProp designerProp, IUndoContext iUndoContext) {
        super(shell, 0);
        this.a = designerProp.getCNDescriptionType();
        this.setText("Rename " + this.a);
        this.a = designerProp;
        this.a = iUndoContext;
    }

    public void open() {
        this.a();
        this.a.open();
        this.a.layout();
        Display display = this.getParent().getDisplay();
        while (!this.a.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void a() {
        Label label;
        Object object;
        Composite composite;
        String string;
        ApplicationUI applicationUI = ApplicationUI.getInstance();
        this.a = new Shell(this.getParent(), 34928);
        this.a.setText(this.getText());
        this.a.setImage(applicationUI.getImage("rename.gif"));
        IResource iResource = this.a.getIResource();
        if (iResource == null) {
            this.b = this.a.getPropCnr().getPropName();
        } else {
            this.b = iResource.getName();
            string = this.a.getFolder().extension;
            if (this.b.endsWith(string)) {
                this.b = this.b.substring(0, this.b.length() - string.length());
            }
        }
        string = new GridLayout(1, true);
        ((GridLayout)string).marginTop = 0;
        ((GridLayout)string).horizontalSpacing = 0;
        ((GridLayout)string).verticalSpacing = 0;
        ((GridLayout)string).marginWidth = 0;
        ((GridLayout)string).marginHeight = 0;
        ((GridLayout)string).horizontalSpacing = 10;
        this.a.setLayout((Layout)string);
        Composite composite2 = new Composite((Composite)this.a, 0);
        string = new GridLayout(2, false);
        ((GridLayout)string).horizontalSpacing = 10;
        ((GridLayout)string).verticalSpacing = 5;
        ((GridLayout)string).marginWidth = 10;
        ((GridLayout)string).marginHeight = 10;
        composite2.setLayout((Layout)string);
        composite2.setLayoutData((Object)new GridData(4, 4, true, true));
        boolean bl = false;
        if (this.a.hasCNToolTip(null) && (composite = this.a.createCNToolTip(null, null, composite2)) != null) {
            composite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            bl = true;
            object = composite.getLayout();
            if (object instanceof GridLayout) {
                label = (GridLayout)object;
                string = label;
                ((GridLayout)string).marginWidth = 0;
                ((GridLayout)string).marginHeight = 0;
            }
        }
        if (!bl) {
            composite = new CLabel(composite2, 0);
            composite.setImage(this.a.getCNImage(0));
            composite.setText(this.a.getCNDescriptionType() + ":");
            composite.setFont(applicationUI.getBoldFont());
            composite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
            label = new Label(composite2, 258);
            label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            label = new Label(composite2, 0);
            label.setText("Reference:");
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            label = new Label(composite2, 0);
            label.setText(this.a.getPropCnr().getReferencePropName().replace("&", "&&"));
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        }
        composite = new GridData(16384, 0x1000000, false, false);
        composite.verticalIndent = 20;
        label = new Label(composite2, 0);
        label.setLayoutData((Object)composite);
        label.setText("New name:");
        composite = new GridData(4, 0x1000000, true, false);
        composite.verticalIndent = 20;
        composite.widthHint = 300;
        this.a = new Text(composite2, 2048);
        this.a.setLayoutData((Object)composite);
        this.a.setTextLimit(400);
        this.a.addModifyListener((ModifyListener)this);
        composite = new GridData(4, 128, true, true, 2, 1);
        composite.verticalIndent = 10;
        this.a = new CLabel(composite2, 0);
        this.a.setLayoutData((Object)composite);
        this.a.setImage(applicationUI.imageError);
        this.a.setVisible(false);
        composite = new GridData(4, 0x1000000, true, false);
        composite.verticalIndent = 10;
        object = new LineWidget((Composite)this.a, true, 0, 1);
        object.setLayoutData((Object)composite);
        Composite composite3 = new Composite((Composite)this.a, 0);
        composite3.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        string = new GridLayout(2, true);
        ((GridLayout)string).marginTop = 10;
        ((GridLayout)string).marginBottom = 10;
        ((GridLayout)string).marginHeight = 0;
        ((GridLayout)string).verticalSpacing = 0;
        ((GridLayout)string).marginRight = 5;
        composite3.setLayout((Layout)string);
        this.a = new Button(composite3, 8);
        this.a.setEnabled(false);
        this.a.setDefaultButton(this.a);
        composite = new GridData(4, 0x1000000, false, false);
        composite.widthHint = applicationUI.cx(80);
        this.a.setLayoutData((Object)composite);
        this.a.setText("OK");
        this.a.addListener(13, event -> {
            IResource iResource = this.a.getIResource();
            if (iResource == null) {
                IPropRenameable iPropRenameable;
                PropCnr propCnr = this.a.getPropCnr();
                if (!(propCnr instanceof IPropRenameable) || !(iPropRenameable = (IPropRenameable)propCnr).canRenameProperty()) {
                    ILog.SEVERE(RenameDialog.class, (String)"Property resource==null and not IPropRenameable with canRenameProperty()==true", (Object)propCnr);
                    this.a.dispose();
                    return;
                }
                try {
                    PropUndoRedoAdapter propUndoRedoAdapter = new PropUndoRedoAdapter(this.a, this.a);
                    PropHelper.doRename(propCnr, Atom.get((String)this.a.getText()), propUndoRedoAdapter);
                }
                catch (Exception exception) {
                    Activator.openError(this.a, "Rename Error", "Failed renaming element.", exception);
                    return;
                }
            } else {
                String string = this.a.getText() + this.a.getFolder().extension;
                PropHelper.doRename(this.a, iResource, string, this.a);
            }
            this.a.dispose();
        });
        Button button = new Button(composite3, 8);
        button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        button.setText("Cancel");
        button.addListener(13, event -> this.a.dispose());
        String string2 = this.a.hasNamingError() ? this.a.getIResource().getName() : this.a.getPropCnr().getPropName();
        this.a.setText(string2);
        this.a.setFocus();
        this.a.setSelection(0, string2.length());
        this.a.pack();
        Activator.centerDialog(this.a);
    }

    public void modifyText(ModifyEvent modifyEvent) {
        String string = this.a();
        this.a.setText(string);
        this.a.setVisible(string != null);
        this.a.setEnabled(string == null && !this.a.getText().equals(this.a.getPropCnr().getPropName()));
    }

    private String a() {
        String string = this.a.getText();
        if (string.isEmpty()) {
            return "Specify a new name";
        }
        String string2 = Atom.validateName((String)string);
        if (string2 != null) {
            return "Name " + string2;
        }
        if (string.charAt(0) == '$') {
            return "Name cannot start with \"$\"";
        }
        if (!string.equals(this.b)) {
            IResource iResource = this.a.getIResource();
            if (iResource == null) {
                PropCnr propCnr = this.a.getPropCnr().getParent();
                if (propCnr != null && propCnr.containsProp(string)) {
                    return "Name is in use";
                }
            } else {
                IContainer iContainer = iResource.getParent();
                if (iContainer instanceof IFolder) {
                    IFolder iFolder = (IFolder)iContainer;
                    try {
                        IFile iFile = iFolder.getFile(string + this.a.getFolder().extension);
                        if (iFile.getLocation().toFile().exists()) {
                            IFileSystem iFileSystem = EFS.getLocalFileSystem();
                            if (!iFileSystem.isCaseSensitive() && string.equalsIgnoreCase(this.b)) {
                                return null;
                            }
                            return "Name is in use";
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }
}

