/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.editor;

import com.iizigo.Activator;
import com.iizigo.ApplicationUI;
import com.iizigo.ImageRegistry;
import com.iizigo.Startup;
import com.iizigo.editor.CommonViewerEx;
import com.iizigo.editor.EndNodeTextFilter;
import com.iizigo.editor.FilteredCommonViewer;
import com.iizigo.editor.IActivationListener;
import com.iizigo.editor.IClipboardSelection;
import com.iizigo.editor.IContextMenuContributor;
import com.iizigo.editor.IContextMenuContributorFormControl;
import com.iizigo.editor.IDraggingFix;
import com.iizigo.editor.IWorkbenchPartIZ;
import com.iizigo.editor.MultiSelectionProvider;
import com.iizigo.editor.PartExtensionIZ;
import com.iizigo.editor.PropHelper;
import com.iizigo.editor.Q;
import com.iizigo.editor.b;
import com.iizigo.editor.l;
import com.iizigo.editor.q;
import com.iizigo.editor.r;
import com.iizigo.editor.s;
import com.iizigo.editor.t;
import com.iizigo.editor.u;
import com.iizigo.handler.ISelectionEnablerHandler;
import com.iizigo.handler.Link;
import com.iizigo.handler.PasteAfter;
import com.iizigo.handler.PasteBefore;
import com.iizigo.handler.PasteLink;
import com.iizigo.handler.SelectionEnabler;
import com.iizigo.jface.PartAction;
import com.iizigo.project.ModuleModel;
import com.iizigo.project.ProjectManager;
import com.iizigo.prop.DesignerProp;
import com.iizigo.prop.FilePropCnr;
import com.iizigo.prop.FilePropSaveable;
import com.iizigo.prop.FolderPropCnr;
import com.iizigo.prop.IPropDesigner;
import com.iizigo.prop.IPropUndoContext;
import com.iizigo.prop.IPropertyEditorController;
import com.iizigo.prop.ISaveableEditor;
import com.iizigo.prop.MultiPropCnr;
import com.iizigo.prop.PropertyEditor;
import com.iizigo.prop.ResourceDesignerProp;
import com.iizigo.swt.IzFilter;
import com.iizigo.swt.LineWidget;
import com.iizix.GenericListener;
import com.iizix.ILog;
import com.iizix.event.EventListener;
import com.iizix.event.GEvent;
import com.iizix.license.ILicenseSystemError;
import com.iizix.license.LicenseException;
import com.iizix.prop.GProp;
import com.iizix.prop.IGProp;
import com.iizix.prop.IPropCnr;
import com.iizix.prop.IPropErrorItem;
import com.iizix.prop.IPropUndoRedo;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.swt.DropdownSelectionListener;
import com.iizix.swt.IzMenu;
import com.iizix.swt.SWTHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.NavigationLocation;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class PropEditorPart
extends EditorPart
implements IActivationListener,
IDraggingFix,
IWorkbenchPartIZ,
IPropUndoContext,
IPropertyEditorController,
IPropUndoRedo,
ISelectionChangedListener,
ISelectionProvider,
INavigationLocationProvider,
IPersistableEditor,
ISaveablesSource,
IGotoMarker {
    public static final PropEditorPart[] EMPTY = new PropEditorPart[0];
    private static final HashSet<PropEditorPart> a = new HashSet();
    private static final ArrayList<PropEditorPart> a;
    private static LicenseException a;
    private static GenericListener<ILicenseSystemError> a;
    private PartExtensionIZ a;
    private IUndoContext a;
    protected PropCnr rootPropCnr;
    protected IFile fileResource;
    protected FilePropCnr filePropCnr;
    protected PropCnr editedPropCnr;
    private boolean b;
    private boolean c;
    private boolean d;
    private final MultiSelectionProvider a;
    protected ToolBar toolBar;
    protected ToolBar toolBar2;
    protected IStructuredSelection partSelection;
    protected SelectionEnabler selectionEnabler;
    protected PartAction cutAction;
    protected PartAction copyAction;
    protected PartAction pasteAction;
    protected PartAction pasteBeforeAction;
    protected PartAction pasteAfterAction;
    protected PartAction pasteLinkAction;
    protected PartAction deleteAction;
    protected PartAction selectAllAction;
    protected PartAction revertAction;
    protected PartAction saveAction;
    protected PartAction renameAction;
    protected PartAction moveAction;
    protected PartAction linkAction;
    protected PartAction printAction;
    protected PartAction copyReferenceAction;
    protected PartAction copyFullPathAction;
    protected UndoActionHandler undoAction;
    protected RedoActionHandler redoAction;
    protected ToolItem tiPaste;
    protected DropdownSelectionListener dslPaste;
    protected IActionBars globalActionBars;
    private final Class<? extends PropCnr> a;
    private Composite a;
    protected final ImageRegistry ir;
    protected ApplicationUI appUI;
    private boolean e = true;
    protected IMemento restoreMemento;
    private final LinkedHashSet<FilePropCnr> a;
    private HashSet<Object> b;
    private String a;
    protected final EventListener propEventListener;
    private final EventListener a;
    public final Runnable updateSelectionAndStatesRunner;
    private boolean f;
    private final Runnable a;
    private final EventListener b;
    private l a;
    private int a;
    private StructuredViewer a;
    private HashMap<StructuredViewer, Integer> a = new MultiSelectionProvider();
    private int b;

    static {
        a = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropEditorPart[] getEditors() {
        HashSet<PropEditorPart> hashSet = a;
        synchronized (hashSet) {
            return a.isEmpty() ? EMPTY : a.toArray(new PropEditorPart[a.size()]);
        }
    }

    public static void updateAllStates() {
        PropEditorPart[] propEditorPartArray = PropEditorPart.getEditors();
        int n2 = propEditorPartArray.length;
        int n3 = 0;
        while (n3 < n2) {
            PropEditorPart propEditorPart = propEditorPartArray[n3];
            propEditorPart.updateStates();
            ++n3;
        }
    }

    public static PropEditorPart getActiveEditor() {
        IEditorPart iEditorPart;
        IWorkbenchPage iWorkbenchPage;
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null && (iEditorPart = iWorkbenchPage.getActiveEditor()) instanceof PropEditorPart) {
            PropEditorPart propEditorPart = (PropEditorPart)iEditorPart;
            return propEditorPart;
        }
        return null;
    }

    public static PropEditorPart getActiveEditor(GProp<?> propCnr) {
        while (propCnr != null) {
            if (propCnr instanceof FilePropCnr) {
                FilePropCnr filePropCnr = (FilePropCnr)propCnr;
                return filePropCnr.getActiveEditor();
            }
            propCnr = propCnr.getParent();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropEditorPart getTopmostEditor(PropEditorPart[] propEditorPartArray) {
        int n2 = propEditorPartArray.length;
        if (n2 == 0) {
            return null;
        }
        Object object = a;
        synchronized (object) {
            int n3 = ((ArrayList)((Object)a)).size();
            while (--n3 >= 0) {
                PropEditorPart propEditorPart = (PropEditorPart)((ArrayList)((Object)a)).get(n3);
                PropEditorPart[] propEditorPartArray2 = propEditorPartArray;
                int n4 = propEditorPartArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    PropEditorPart propEditorPart2 = propEditorPartArray2[n5];
                    if (propEditorPart2 == propEditorPart) {
                        return propEditorPart;
                    }
                    ++n5;
                }
            }
        }
        object = propEditorPartArray[n2 - 1];
        ILog.WARNING(object.getClass(), (String)"PropEditorPart.getTopmostEditor didn't find an editor in the MRU");
        return object;
    }

    public static PropEditorPart getActivePart() {
        IWorkbenchPart iWorkbenchPart;
        IWorkbenchPage iWorkbenchPage;
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null && (iWorkbenchPart = iWorkbenchPage.getActivePart()) instanceof PropEditorPart) {
            PropEditorPart propEditorPart = (PropEditorPart)iWorkbenchPart;
            return propEditorPart;
        }
        return null;
    }

    public static void onCloseProject(IProject iProject) {
        Runnable runnable = () -> {
            PropEditorPart[] propEditorPartArray = PropEditorPart.getEditors();
            int n2 = propEditorPartArray.length;
            int n3 = 0;
            while (n3 < n2) {
                FilePropCnr filePropCnr;
                PropEditorPart propEditorPart = propEditorPartArray[n3];
                boolean bl = false;
                IWorkbenchPage iWorkbenchPage = propEditorPart.a.iterator();
                while (iWorkbenchPage.hasNext()) {
                    filePropCnr = (FilePropCnr)((Object)iWorkbenchPage.next());
                    if (!filePropCnr.getDesigner().getProject().equals((Object)iProject)) continue;
                    bl = true;
                    break;
                }
                if (bl && (filePropCnr = propEditorPart.getSite()) != null && (iWorkbenchPage = filePropCnr.getPage()) != null) {
                    try {
                        iWorkbenchPage.closeEditor((IEditorPart)propEditorPart, false);
                    }
                    catch (Throwable throwable) {
                        ILog.SEVERE(PropEditorPart.class, (String)"Failed closing an editor part", (Throwable)throwable);
                    }
                }
                ++n3;
            }
        };
        Display display = Display.getDefault();
        if (display.getThread() == Thread.currentThread()) {
            runnable.run();
        } else {
            display.asyncExec(runnable);
        }
    }

    public static synchronized boolean addListener(ILicenseSystemError iLicenseSystemError) {
        if (a == null) {
            a = new GenericListener(ILicenseSystemError.class);
        }
        return a.addListener(iLicenseSystemError);
    }

    public static synchronized boolean removeListener(ILicenseSystemError iLicenseSystemError) {
        if (a != null) {
            a.removeListener(iLicenseSystemError);
            if (!a.hasListeners()) {
                a = null;
            }
        }
        return false;
    }

    public static void invalidLicense(LicenseException licenseException) {
        a = licenseException;
        Display.getDefault().syncExec(() -> {
            HashSet<PropEditorPart> hashSet = a;
            if (hashSet != null) {
                hashSet.forEach(iLicenseSystemError -> iLicenseSystemError.onError(licenseException));
            }
            PropEditorPart[] propEditorPartArray = PropEditorPart.getEditors();
            int n2 = propEditorPartArray.length;
            int n3 = 0;
            while (n3 < n2) {
                PropEditorPart propEditorPart = propEditorPartArray[n3];
                propEditorPart.a(licenseException);
                ++n3;
            }
        });
    }

    public static LicenseException getLicenseException() {
        return a;
    }

    public static Composite createLicenseExceptionComposite(Composite composite, String string) {
        LicenseException licenseException = a;
        if (licenseException == null && string != null) {
            licenseException = new LicenseException(string);
        }
        return licenseException != null ? new b(composite, (Throwable)licenseException) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropEditorPart(Class<? extends PropCnr> clazz) {
        this.partSelection = StructuredSelection.EMPTY;
        this.a = new LinkedHashSet<PropEditorPart>();
        this.b = new HashSet();
        this.propEventListener = new q(this);
        this.a = new r(this);
        this.updateSelectionAndStatesRunner = () -> this.fireSelectionAndStates();
        this.a = () -> {
            PropEditorPart propEditorPart = this;
            synchronized (propEditorPart) {
                this.f = false;
            }
            if (!this.isDisposed()) {
                this.updateStates();
            }
        };
        this.b = gEvent -> {
            if (!this.isDisposed() && this.a != null) {
                switch (gEvent.getEventID()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 10: 
                    case 11: 
                    case 15: {
                        this.postAsyncUpdateStates();
                        this.onEditedPropertyChangedForVerify(gEvent);
                    }
                }
            }
        };
        this.a = new HashMap();
        this.a.setDraggingFix(this);
        this.a.addSelectionChangedListener(this);
        this.a = clazz;
        HashSet<PropEditorPart> hashSet = a;
        synchronized (hashSet) {
            a.add(this);
        }
        this.ir = ImageRegistry.getInstance();
    }

    protected void addForDisposalAtDispose(Object object) {
        this.b.add(object);
    }

    @Override
    public final MultiSelectionProvider getMultiSelectionProvider() {
        return this.a;
    }

    @Override
    public PartExtensionIZ getExtension() {
        return this.a;
    }

    @Override
    public SelectionEnabler getSelectionEnabler() {
        return this.selectionEnabler;
    }

    protected void onEditorActivated(boolean bl) {
    }

    protected void addOpenFile(FilePropCnr filePropCnr) {
        if (filePropCnr != null && this.a.add((PropEditorPart)((Object)filePropCnr))) {
            filePropCnr.attachEditor(this);
            this.updateTitle();
            this.verifyDirtyStateChanged();
        }
    }

    protected void closeFile(FilePropCnr filePropCnr) {
        if (this.a.remove(filePropCnr)) {
            filePropCnr.detachEditor(this);
            if (!this.isDisposed()) {
                this.updateTitle();
                this.verifyDirtyStateChanged();
            }
        }
    }

    public final void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        block8: {
            ISelectionEnablerHandler iSelectionEnablerHandler;
            this.setSite((IWorkbenchPartSite)iEditorSite);
            this.a = new PartExtensionIZ(this);
            PropEditorPart propEditorPart = this;
            this.selectionEnabler = new SelectionEnabler(null, this, propEditorPart instanceof ISelectionEnablerHandler ? (iSelectionEnablerHandler = (ISelectionEnablerHandler)((Object)propEditorPart)) : null, this, this.a, (IStructuredSelection)StructuredSelection.EMPTY);
            this.globalActionBars = iEditorSite.getActionBars();
            this.fileResource = (IFile)iEditorInput.getAdapter(IFile.class);
            if (this.fileResource == null) {
                this.d = true;
                throw new PartInitException("Editor input is not set (IEditorInput: IFile == null)");
            }
            if (!this.fileResource.exists()) {
                this.d = true;
                throw new PartInitException("File does not exist: " + String.valueOf(this.fileResource.getFullPath()));
            }
            if (!this.fileResource.isAccessible()) {
                throw new PartInitException("File '" + String.valueOf(this.fileResource.getFullPath()) + "' is not accessible");
            }
            this.setInput((IEditorInput)new FileEditorInput(this.fileResource));
            this.updateTitle();
            LicenseException licenseException = a;
            if (licenseException != null) {
                this.d = true;
                this.e = false;
                throw new PartInitException(licenseException.getMessage());
            }
            if (!Startup.isStartingUp(() -> this.b())) {
                this.e = false;
                try {
                    this.d();
                }
                catch (Throwable throwable) {
                    PartInitException partInitException;
                    if (this.isDisposed()) break block8;
                    this.d = true;
                    IProject iProject = this.fileResource.getProject();
                    if (iProject != null && iProject.isAccessible() && this.fileResource.exists()) {
                        ILog.SEVERE(this.getClass(), (String)"Failed initialization", (Throwable)throwable);
                    }
                    PartInitException partInitException2 = throwable instanceof PartInitException ? (partInitException = (PartInitException)throwable) : new PartInitException("Failed initialization", throwable);
                    throw partInitException2;
                }
            }
        }
    }

    private void a(LicenseException licenseException) {
        if (this.e && !this.d) {
            this.a((Throwable)licenseException);
        }
    }

    public boolean hasInitError() {
        return this.d;
    }

    private void a(Throwable throwable) {
        this.d = true;
        if (this.a == null || this.a.isDisposed()) {
            ILog.SEVERE(this.getClass(), (String)"Failed initializing the Editor at postponed creation after loading projects", (Throwable)throwable);
        } else {
            if (!(throwable instanceof LicenseException)) {
                ILog.SEVERE(this.getClass(), (String)"Failed initialization", (Throwable)throwable);
            }
            Control[] controlArray = this.a.getChildren();
            int n2 = controlArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Control control = controlArray[n3];
                control.dispose();
                ++n3;
            }
            this.a.setLayout((Layout)new FillLayout());
            new b(this.a, throwable);
            this.a.layout(true, true);
        }
    }

    private void b() {
        if (this.isDisposed()) {
            return;
        }
        this.e = false;
        try {
            this.d();
        }
        catch (Throwable throwable) {
            this.a(throwable);
            return;
        }
        if (this.a == null || this.a.isDisposed()) {
            return;
        }
        Control[] controlArray = this.a.getChildren();
        int n2 = controlArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Control control = controlArray[n3];
            control.dispose();
            ++n3;
        }
        this.restoreMemento();
        this.f();
        this.a.layout();
        this.c();
    }

    private void c() {
        this.onEditorReady();
        this.addOpenFile(this.filePropCnr);
        this.a.onInitializedUI();
    }

    protected void onEditorReady() {
    }

    private void d() throws PartInitException {
        this.e = false;
        this.proceedInit();
        this.firePropertyChange(258);
        PartExtensionIZ.updateActionBars(this.globalActionBars);
    }

    protected void proceedInit() throws PartInitException {
        if (!this.fileResource.isAccessible()) {
            throw new PartInitException("File '" + String.valueOf(this.fileResource.getFullPath()) + "' is not accessible");
        }
        ResourceDesignerProp resourceDesignerProp = DesignerProp.getInstance((IResource)this.fileResource);
        if (resourceDesignerProp == null) {
            if (ProjectManager.getInstance().isStartingUp()) {
                throw new PartInitException("Project has not completed loading, please reopen the file '" + String.valueOf(this.fileResource.getFullPath()) + "' later");
            }
            throw new PartInitException("Editor input is not set, DesignerProp == null, file = " + String.valueOf(this.fileResource.getFullPath()));
        }
        FilePropCnr filePropCnr = resourceDesignerProp.getFilePropCnr();
        if (filePropCnr == null) {
            return;
        }
        if (filePropCnr.isDisposed()) {
            throw new PartInitException("Property is disposed of: file '" + String.valueOf(this.fileResource.getFullPath()) + "'");
        }
        Throwable throwable = resourceDesignerProp.getException();
        if (throwable != null) {
            throw new PartInitException("Failed loading file '" + String.valueOf(this.fileResource.getFullPath()) + "'", throwable);
        }
        PropCnr propCnr = filePropCnr.getDataContainer();
        if (propCnr == null) {
            throw new PartInitException("Editor input not correct, data container is null, file '" + String.valueOf(this.fileResource.getFullPath()) + "'");
        }
        if (propCnr.isDisposed()) {
            throw new PartInitException("Editor input not correct, data container is disposed of");
        }
        if (!((Class)((Object)this.a)).isInstance(propCnr)) {
            throw new PartInitException("Editor input (" + this.getClass().getName() + ") not correct, data container has wrong class, " + propCnr.getClass().getName() + " instead of " + ((Class)((Object)this.a)).getName());
        }
        try {
            FolderPropCnr folderPropCnr = (FolderPropCnr)filePropCnr.getParent();
            if (folderPropCnr == null) {
                throw new PartInitException("Folder of file '" + String.valueOf(this.fileResource.getFullPath()) + "' is not accessible");
            }
            this.rootPropCnr = folderPropCnr.getDesigner().getRoot();
            this.rootPropCnr.addPropListener(this.propEventListener);
        }
        catch (Exception exception) {
            throw new PartInitException("Failed getting parent folder", (Throwable)exception);
        }
        this.filePropCnr = filePropCnr;
        this.addOpenFile(this.filePropCnr);
        this.proceedInitProperty(propCnr);
    }

    protected void proceedInitProperty(PropCnr propCnr) throws PartInitException {
        IPropDesigner iPropDesigner;
        block3: {
            block2: {
                if (!(propCnr instanceof IPropDesigner)) break block2;
                iPropDesigner = (IPropDesigner)propCnr;
                if (propCnr instanceof IPropUndoContext) break block3;
            }
            throw new PartInitException("Editor input not correct (property container not IPropDesigner and IPropUndoContext instance)");
        }
        IPropUndoContext iPropUndoContext = (IPropUndoContext)propCnr;
        this.editedPropCnr = propCnr;
        this.a = iPropUndoContext.getUndoContext();
        this.selectionEnabler.setUndoContext(this.a);
        this.setTitleImage(iPropDesigner.getDesigner().getCNImage(0));
        this.initEditor(this.editedPropCnr);
        this.a.createActivationListener(null, this, this.a);
    }

    public Composite getPartComposite() {
        return this.a;
    }

    /*
     * WARNING - void declaration
     */
    protected void updateTitle() {
        String string;
        Object object2 = "";
        Object object3 = "";
        for (FilePropCnr object4 : this.a) {
            if (!((String)object2).isEmpty()) {
                object2 = (String)object2 + "+";
                object3 = (String)object3 + "\n";
            }
            object2 = (String)object2 + object4.getPropName();
            object3 = (String)object3 + object4.getIFile().getFullPath().toString().substring(1);
        }
        if (((String)object2).isEmpty()) {
            void var3_8;
            String string2 = this.fileResource.getName();
            int n2 = string2.lastIndexOf(46);
            if (n2 >= 0) {
                String string3 = string2.substring(0, n2);
            }
            object2 = var3_8;
            object3 = this.fileResource.getFullPath().toString().substring(1);
        }
        this.setPartName(this.getPartName((String)object2));
        this.a = string = this.getTitleToolTip((String)object3);
        this.setTitleToolTip(string);
    }

    public String getTitleToolTip() {
        return this.a;
    }

    public Image getTitleImage() {
        Image image;
        PropCnr propCnr = this.editedPropCnr;
        if (propCnr instanceof IPropDesigner) {
            IPropDesigner iPropDesigner = (IPropDesigner)propCnr;
            image = iPropDesigner.getDesigner().getCNImage(0);
        } else {
            image = super.getTitleImage();
        }
        return image;
    }

    protected String getPartName(String string) {
        return string;
    }

    protected String getTitleToolTip(String string) {
        return string;
    }

    @Override
    public ModuleModel getModuleModel() {
        FilePropCnr filePropCnr = this.filePropCnr;
        return filePropCnr != null ? filePropCnr.getDesigner().getModel() : null;
    }

    protected void onFileClosed(FilePropCnr filePropCnr) {
    }

    protected void onPartRenamed(GEvent gEvent) {
    }

    protected void initEditor(PropCnr propCnr) throws PartInitException {
    }

    void a() {
        this.e();
    }

    @Override
    public void onClose() {
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isDisposed() || this.fileResource != null && !this.fileResource.isAccessible() || this.filePropCnr != null && this.filePropCnr.isDisposed() ? false : this.isDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void e() {
        HashSet<PropEditorPart> hashSet = a;
        synchronized (hashSet) {
            a.remove(this);
        }
        hashSet = a;
        synchronized (hashSet) {
            ((ArrayList)((Object)a)).remove(this);
        }
    }

    public void dispose() {
        this.c = true;
        if (this.editedPropCnr != null) {
            this.editedPropCnr.removePropListener(this.b);
        }
        if (this.rootPropCnr != null && !this.rootPropCnr.isDisposed()) {
            this.rootPropCnr.removePropListener(this.propEventListener);
        }
        FilePropCnr[] filePropCnrArray = this.a.toArray(new FilePropCnr[this.a.size()]);
        int n2 = filePropCnrArray.length;
        while (--n2 >= 0) {
            this.closeFile(filePropCnrArray[n2]);
        }
        if (this.a != null) {
            this.a.dispose();
        }
        this.e();
        Composite composite = this.a;
        if (composite != null && !composite.isDisposed()) {
            Control[] controlArray = composite.getChildren();
            int n3 = controlArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Object object = controlArray[n4];
                object.dispose();
                ++n4;
            }
        }
        for (Object object : this.b) {
            try {
                object.getClass().getMethod("dispose", new Class[0]).invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                ILog.SEVERE(this.getClass(), (String)"Failed to dispose of object", object);
            }
        }
        super.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.c || this.a != null && this.a.isDisposed();
    }

    public final void restoreState(IMemento iMemento) {
        this.restoreMemento = iMemento;
    }

    protected void restoreMemento() {
    }

    public final void saveState(IMemento iMemento) {
        if (!this.e) {
            this.saveStateImpl(iMemento);
        }
    }

    protected void saveStateImpl(IMemento iMemento) {
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.a.addSelectionChangedListener(iSelectionChangedListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.a.removeSelectionChangedListener(iSelectionChangedListener);
    }

    public ISelection getSelection() {
        return this.a.getSelection();
    }

    public void setSelection(ISelection iSelection) {
        this.a.setSelection(iSelection);
    }

    public static ToolItem addToolbarPushButton(ToolBar toolBar, String string, Image image, int n2, Listener listener) {
        ToolItem toolItem = new ToolItem(toolBar, n2);
        toolItem.setToolTipText(string);
        toolItem.setImage(image);
        toolItem.addListener(13, listener);
        return toolItem;
    }

    public static ToolItem addToolbarPushButton(ToolBar toolBar, String string, Image image, Listener listener) {
        ToolItem toolItem = new ToolItem(toolBar, 8);
        toolItem.setToolTipText(string);
        toolItem.setImage(image);
        toolItem.addListener(13, listener);
        return toolItem;
    }

    public static ToolItem addToolbarPushButton(ToolBar toolBar, String string, String string2, Listener listener) {
        ToolItem toolItem = new ToolItem(toolBar, 8);
        toolItem.setToolTipText(string);
        ApplicationUI.getInstance().loadWorkBenchImages(toolItem, string2);
        toolItem.addListener(13, listener);
        return toolItem;
    }

    protected ToolItem addToolbarPushButton(String string, Image image, Listener listener) {
        return PropEditorPart.addToolbarPushButton(this.toolBar, string, image, listener);
    }

    protected ToolItem addToolbarPushButton(String string, String string2, Listener listener) {
        return PropEditorPart.addToolbarPushButton(this.toolBar, string, string2, listener);
    }

    public void addToolbarPushButton(ToolBar toolBar, IAction iAction) {
        ActionContributionItem actionContributionItem = new ActionContributionItem(iAction);
        actionContributionItem.fill(toolBar, -1);
        this.addForDisposalAtDispose(actionContributionItem);
    }

    protected void addToolbarPushButton(IAction iAction) {
        this.addToolbarPushButton(this.toolBar, iAction);
    }

    protected void addToolbar2PushButton(IAction iAction) {
        this.addToolbarPushButton(this.toolBar2, iAction);
    }

    protected ToolItem addToolbar2PushButton(String string, Image image, Listener listener) {
        return PropEditorPart.addToolbarPushButton(this.toolBar2, string, image, listener);
    }

    public static void addToolbarSeparator(ToolBar toolBar) {
        ToolItem toolItem = new ToolItem(toolBar, 2);
    }

    protected void addToolbarSeparator() {
        PropEditorPart.addToolbarSeparator(this.toolBar);
    }

    protected void addToolbar2Separator() {
        PropEditorPart.addToolbarSeparator(this.toolBar2);
    }

    public final void createPartControl(Composite composite) {
        this.a.createActivationListener(composite, this, this.a);
        this.appUI = ApplicationUI.getInstance();
        this.a = composite;
        if (this.e) {
            composite.setLayout((Layout)new FillLayout());
            Q q2 = new Q(composite);
        } else {
            this.f();
            this.c();
        }
    }

    private void f() {
        Composite composite = new Composite(this.a, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 1;
        gridLayout.marginWidth = 1;
        composite.setLayout((Layout)gridLayout);
        composite.setBackground(this.appUI.border);
        composite = new Composite(composite, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setBackground(this.appUI.widgetBackground);
        this.h();
        Composite composite2 = new Composite(composite, 0);
        gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 1;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.toolBar = new ToolBar(composite2, 0x800000);
        this.toolBar.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.addToolbarPushButton((IAction)this.undoAction);
        this.addToolbarPushButton((IAction)this.redoAction);
        this.addToolbarSeparator();
        this.addToolbarPushButton((IAction)this.cutAction);
        this.g();
        this.addToolbarPushButton((IAction)this.pasteLinkAction);
        this.addToolbarSeparator();
        this.addToolbarPushButton((IAction)this.deleteAction);
        this.toolBar2 = new ToolBar(composite2, 0x800000);
        this.toolBar2.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        new LineWidget(composite, true, 0, -1).setLayoutData(new GridData(4, 0x1000000, true, false));
        Composite composite3 = new Composite(composite, 0);
        composite3.setBackground(this.appUI.widgetBackground);
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createEditorComposite(composite3);
        this.a.setInitialized();
        this.fireSelectionAndStates();
        this.updateStates();
        PartExtensionIZ.updateActionBars(this.globalActionBars);
        PropHelper.doVerify(this.editedPropCnr);
        this.editedPropCnr.addPropListener(this.b);
        this.verifyDirtyStateChanged();
    }

    protected boolean supportsCopyReference() {
        return false;
    }

    protected boolean supportsCopyFullPath() {
        return false;
    }

    protected boolean usePasteBeforeAfter() {
        return false;
    }

    private void g() {
        if (!this.usePasteBeforeAfter()) {
            this.addToolbarPushButton((IAction)this.pasteAction);
        } else {
            this.pasteAction.setText("&Paste into");
            this.tiPaste = new ToolItem(this.toolBar, 4);
            this.tiPaste.setToolTipText("Paste actions");
            this.tiPaste.setImage(this.appUI.getImage(ImageRegistry.getInstance().idPaste));
            this.dslPaste = new DropdownSelectionListener(this.tiPaste, false);
            this.dslPaste.add((IAction)this.pasteBeforeAction);
            this.dslPaste.add((IAction)this.pasteAction);
            this.dslPaste.add((IAction)this.pasteAfterAction);
        }
    }

    protected abstract void createEditorComposite(Composite var1);

    private void h() {
        this.printAction = this.a(0, 0, "org.eclipse.ui.file.print", "Print", "Print", this.ir.idPrint, this.ir.idPrintDisabled);
        this.cutAction = this.a(1, SWT.MOD1 | 0x58, "org.eclipse.ui.edit.cut", "Cu&t", "Cut", this.ir.idCut, this.ir.idCutDisabled);
        this.copyAction = this.a(2, SWT.MOD1 | 0x43, "org.eclipse.ui.edit.copy", "&Copy", "Copy", this.ir.idCopy, this.ir.idCopyDisabled);
        if (this.supportsCopyReference()) {
            this.copyReferenceAction = new PartAction(this, "copyReference", "Copy reference", "Copies the reference of the selected item(s)", this.ir.idCopyReference, this.ir.idCopyReferenceDisabled).with(() -> {
                boolean bl = this.performCopyReference(true);
            });
            this.addForDisposalAtDispose((Object)this.copyReferenceAction);
        }
        if (this.supportsCopyFullPath()) {
            this.copyFullPathAction = new PartAction(this, "copyFullPath", "Copy full path", "Copies the full path of the selected item(s)", this.ir.idCopyFullPath, this.ir.idCopyDisabled).with(() -> {
                boolean bl = this.performCopyFullPath(true);
            });
            this.addForDisposalAtDispose((Object)this.copyFullPathAction);
        }
        this.pasteAction = this.a(3, SWT.MOD1 | 0x56, "org.eclipse.ui.edit.paste", "&Paste", "Paste", this.ir.idPaste, this.ir.idPasteDisabled);
        this.pasteBeforeAction = this.a(13, 0, PasteBefore.ID, "Paste before", "Paste before", this.ir.idPasteBefore, this.ir.idPasteBeforeDisabled);
        this.pasteAfterAction = this.a(14, 0, PasteAfter.ID, "Paste after", "Paste after", this.ir.idPasteAfter, this.ir.idPasteAfterDisabled);
        this.pasteLinkAction = this.a(15, SWT.MOD1 | SWT.MOD2 | 0x56, PasteLink.ID, "&Paste-link", "Paste-link", this.ir.idPasteLink, this.ir.idPasteLinkDisabled);
        this.deleteAction = this.a(4, 127, "org.eclipse.ui.edit.delete", "&Delete", "Delete", this.ir.idDelete, this.ir.idDeleteDisabled);
        this.selectAllAction = this.a(5, SWT.MOD1 | 0x41, "org.eclipse.ui.edit.selectAll", "Select &All", "Select All", this.ir.idSelectAll, this.ir.idSelectAllDisabled);
        this.revertAction = this.a(6, 0, "org.eclipse.ui.file.revert", "Revert file", "Revert file", null, null);
        this.saveAction = this.a(9, SWT.MOD1 | 0x53, null, "Save", "Save", this.ir.idSave, this.ir.idSaveDisabled);
        this.renameAction = this.a(10, 0x100000B, "org.eclipse.ui.edit.rename", "Rename...", "Rename", this.ir.idRename, this.ir.idRenameDisabled);
        this.moveAction = this.a(11, 0, "org.eclipse.ui.edit.move", "&Move...", "Move", this.ir.idMove, this.ir.idMoveDisabled);
        this.linkAction = this.a(12, 0, Link.ID, "&Link...", "Link", this.ir.idLink, this.ir.idLinkDisabled);
        this.undoAction = new UndoActionHandler(this.getSite(), this.a);
        this.undoAction.setPruneHistory(true);
        this.globalActionBars.setGlobalActionHandler("org.eclipse.ui.edit.undo", (IAction)this.undoAction);
        this.redoAction = new RedoActionHandler(this.getSite(), this.a);
        this.redoAction.setPruneHistory(true);
        this.globalActionBars.setGlobalActionHandler("org.eclipse.ui.edit.redo", (IAction)this.redoAction);
        this.addForDisposalAtDispose(this.undoAction);
        this.addForDisposalAtDispose(this.redoAction);
    }

    protected boolean performCopyReference(boolean bl) {
        return false;
    }

    protected boolean performCopyFullPath(boolean bl) {
        return false;
    }

    public void setActionsUndoContext(IUndoContext iUndoContext) {
        if (iUndoContext == null) {
            iUndoContext = this.a;
        }
        this.undoAction.setContext(iUndoContext);
        this.redoAction.setContext(iUndoContext);
    }

    private PartAction a(int n2, int n3, String string, String string2, String string3, ImageDescriptor imageDescriptor, ImageDescriptor imageDescriptor2) {
        PartAction partAction = new PartAction(this, string, string2, string3, imageDescriptor, imageDescriptor2);
        partAction.with(() -> {
            if (partAction.isEnabled()) {
                switch (n2) {
                    case 0: {
                        this.performPrint();
                        break;
                    }
                    case 1: {
                        this.performCut();
                        break;
                    }
                    case 2: {
                        this.performCopy();
                        break;
                    }
                    case 3: {
                        this.performPaste();
                        break;
                    }
                    case 4: {
                        this.performDelete();
                        break;
                    }
                    case 5: {
                        this.performSelectAll();
                        break;
                    }
                    case 6: {
                        this.performRevert();
                        break;
                    }
                    case 9: {
                        this.performSave();
                        break;
                    }
                    case 10: {
                        this.performRename();
                        break;
                    }
                    case 11: {
                        this.performMove();
                        break;
                    }
                    case 12: {
                        this.performLink();
                        break;
                    }
                    case 13: {
                        this.performPasteBefore();
                        break;
                    }
                    case 14: {
                        this.performPasteAfter();
                        break;
                    }
                    case 15: {
                        this.performPasteLink();
                    }
                }
            }
        });
        if (n3 != 0) {
            partAction.setAccelerator(n3);
        }
        this.addForDisposalAtDispose((Object)partAction);
        return partAction;
    }

    private void a(IzMenu izMenu) {
        if (this.undoAction.isEnabled() || this.redoAction.isEnabled()) {
            if (izMenu.getItemCount() > 0) {
                izMenu.addSeparator();
            }
            if (this.undoAction.isEnabled()) {
                izMenu.add((IAction)this.undoAction);
            }
            if (this.redoAction.isEnabled()) {
                izMenu.add((IAction)this.redoAction);
            }
        }
        if (this.saveAction.isEnabled() || this.revertAction.isEnabled()) {
            if (izMenu.getItemCount() > 0) {
                izMenu.addSeparator();
            }
            if (this.saveAction.isEnabled()) {
                izMenu.add((IAction)this.saveAction);
            }
            if (this.revertAction.isEnabled()) {
                izMenu.add((IAction)this.revertAction);
            }
        }
        if (this.cutAction.isEnabled() || this.copyAction.isEnabled() || this.pasteAction.isEnabled() || this.pasteBeforeAction.isEnabled() || this.pasteAfterAction.isEnabled() || this.pasteLinkAction.isEnabled()) {
            if (izMenu.getItemCount() > 0) {
                izMenu.addSeparator();
            }
            boolean bl = this.usePasteBeforeAfter();
            if (this.cutAction.isEnabled()) {
                izMenu.add((IAction)this.cutAction);
            }
            if (this.copyAction.isEnabled()) {
                izMenu.add((IAction)this.copyAction);
            }
            if (this.copyReferenceAction != null && this.copyReferenceAction.isEnabled()) {
                izMenu.add((IAction)this.copyReferenceAction);
            }
            if (this.copyFullPathAction != null && this.copyFullPathAction.isEnabled()) {
                izMenu.add((IAction)this.copyFullPathAction);
            }
            if (bl && this.pasteBeforeAction.isEnabled()) {
                izMenu.add((IAction)this.pasteBeforeAction);
            }
            if (this.pasteAction.isEnabled()) {
                izMenu.add((IAction)this.pasteAction);
            }
            if (bl && this.pasteAfterAction.isEnabled()) {
                izMenu.add((IAction)this.pasteAfterAction);
            }
            if (this.pasteLinkAction.isEnabled()) {
                izMenu.add((IAction)this.pasteLinkAction);
            }
        }
        if (this.deleteAction.isEnabled()) {
            if (izMenu.getItemCount() > 0) {
                izMenu.addSeparator();
            }
            izMenu.add((IAction)this.deleteAction);
        }
        if (this.renameAction.isEnabled() || this.moveAction.isEnabled() || this.linkAction.isEnabled()) {
            if (izMenu.getItemCount() > 0) {
                izMenu.addSeparator();
            }
            if (this.renameAction.isEnabled()) {
                izMenu.add((IAction)this.renameAction);
            }
            if (this.moveAction.isEnabled()) {
                izMenu.add((IAction)this.moveAction);
            }
            if (this.linkAction.isEnabled()) {
                izMenu.add((IAction)this.linkAction);
            }
        }
    }

    public UndoActionHandler getUndoAction() {
        return this.undoAction;
    }

    public RedoActionHandler getRedoAction() {
        return this.redoAction;
    }

    public void registerFormControl(Control control) {
        this.a.addControl(control);
    }

    public final Shell getShell() {
        return this.getSite().getShell();
    }

    @Override
    public final IUndoContext getUndoContext() {
        return this.a;
    }

    @Override
    public final IPropUndoRedo getUndoRedo() {
        return this;
    }

    public boolean isDirty() {
        ISaveableEditor iSaveableEditor;
        if (this.isDisposed()) {
            return false;
        }
        boolean bl = false;
        PropEditorPart propEditorPart = this;
        if (propEditorPart instanceof ISaveableEditor && (iSaveableEditor = (ISaveableEditor)((Object)propEditorPart)).isAdditionalDataDirty()) {
            bl = true;
        } else {
            for (FilePropCnr filePropCnr : this.a) {
                if (!filePropCnr.getSaveable().isDirty()) continue;
                bl = true;
                break;
            }
        }
        if (this.b != bl) {
            this.b = bl;
            Display.getDefault().syncExec(() -> {
                if (!this.isDisposed()) {
                    for (FilePropCnr filePropCnr : this.a) {
                        filePropCnr.getSaveable().onDirtyChanged();
                    }
                    this.firePropertyChange(257);
                    this.updateStates();
                    this.getEditorSite().getActionBars().updateActionBars();
                }
            });
        }
        return bl;
    }

    public void verifyDirtyStateChanged() {
        this.isDirty();
    }

    public void refreshViewers() {
        for (StructuredViewer structuredViewer : ((HashMap)((Object)this.a)).keySet()) {
            structuredViewer.refresh();
        }
        this.updateStates();
    }

    public boolean doOpen(GProp<?>[] gPropArray) {
        System.err.println("Not overridden: PropEditorPart.doOpen(Property " + Arrays.toString(gPropArray) + ")");
        return false;
    }

    public boolean doOpen(GProp<?> gProp, int n2, String string) {
        System.err.println("Not overridden: PropEditorPart.doOpen(Property " + String.valueOf(gProp) + "," + n2 + ")");
        return false;
    }

    public void doSave(IProgressMonitor iProgressMonitor2) {
        if (this.isDisposed()) {
            return;
        }
        FilePropCnr[] filePropCnrArray = new FilePropCnr[1];
        try {
            ResourcesPlugin.getWorkspace().run(iProgressMonitor -> {
                for (FilePropCnr filePropCnr : this.a) {
                    if (!filePropCnr.getSaveable().isDirty()) continue;
                    filePropCnrArray[0] = filePropCnr;
                    filePropCnr.saveFile(iProgressMonitor);
                }
            }, null, 1, iProgressMonitor2);
        }
        catch (CoreException coreException) {
            FilePropCnr filePropCnr = filePropCnrArray[0] != null ? filePropCnrArray[0] : this.filePropCnr;
            ErrorDialog.openError((Shell)this.getShell(), (String)"Save File", (String)("Error saving file '" + filePropCnr.getFileName() + "'."), (IStatus)coreException.getStatus());
        }
    }

    public final void doSaveAs() {
        assert (false) : "Editor is called with doSaveAs(), and this is not supported";
    }

    public final boolean isSaveAsAllowed() {
        return false;
    }

    public void performUndo() {
        if (this.undoAction.isEnabled()) {
            this.undoAction.run();
        }
    }

    public void performRedo() {
        if (this.redoAction.isEnabled()) {
            this.redoAction.run();
        }
    }

    public IClipboardSelection getSyntClipboardSelection() {
        return this.a.getClipboardSelectionProvider();
    }

    public void performCopy() {
        if (!this.isDisposed() && this.copyAction.isEnabled()) {
            IClipboardSelection iClipboardSelection = this.getSyntClipboardSelection();
            if (iClipboardSelection != null) {
                iClipboardSelection.copy();
            } else if (this.partSelection != null) {
                PropHelper.doCopy(this.getSite().getShell(), (ISelection)this.partSelection, this.updateSelectionAndStatesRunner);
                this.updateStates();
            }
        }
    }

    public void performCut() {
        if (!this.isDisposed() && this.cutAction.isEnabled()) {
            IClipboardSelection iClipboardSelection = this.getSyntClipboardSelection();
            if (iClipboardSelection != null) {
                iClipboardSelection.cut();
            } else if (this.partSelection != null) {
                PropHelper.doCut((ISelection)this.partSelection, this, this.updateSelectionAndStatesRunner);
                this.updateStates();
            }
        }
    }

    public void performPaste() {
        if (this.pasteAction.isEnabled()) {
            IClipboardSelection iClipboardSelection = this.getSyntClipboardSelection();
            if (iClipboardSelection != null) {
                iClipboardSelection.paste();
            } else if (this.partSelection != null) {
                PropHelper.doPaste((ISelection)this.partSelection, 0, (IPropUndoRedo)this);
                this.updateStates();
            }
        } else if (this.usePasteBeforeAfter()) {
            this.updateStatesPasteBeforeAfter();
            boolean bl = this.pasteBeforeAction.isEnabled();
            boolean bl2 = this.pasteAfterAction.isEnabled();
            if (bl && bl2) {
                this.dslPaste.showMenu();
            } else if (bl) {
                this.performPasteBefore();
            } else if (bl2) {
                this.performPasteAfter();
            }
        }
    }

    public void performPasteBefore() {
        if (this.pasteBeforeAction.isEnabled() && this.partSelection != null) {
            PropHelper.doPaste((ISelection)this.partSelection, -1, (IPropUndoRedo)this);
            this.updateStates();
        }
    }

    public void performPasteAfter() {
        if (this.pasteAfterAction.isEnabled() && this.partSelection != null) {
            PropHelper.doPaste((ISelection)this.partSelection, 1, (IPropUndoRedo)this);
            this.updateStates();
        }
    }

    public void performPasteLink() {
        if (this.pasteLinkAction.isEnabled() && this.partSelection != null) {
            PropHelper.doPasteLink((ISelection)this.partSelection, (IPropUndoRedo)this);
            this.updateStates();
        }
    }

    public void performDelete() {
        if (this.deleteAction.isEnabled()) {
            IClipboardSelection iClipboardSelection = this.getSyntClipboardSelection();
            if (iClipboardSelection != null) {
                iClipboardSelection.delete();
            } else if (this.partSelection != null) {
                PropHelper.doDelete((ISelection)this.partSelection, this, this.updateSelectionAndStatesRunner);
                this.updateStates();
            }
        }
    }

    public final void performSelectAll() {
        IClipboardSelection iClipboardSelection = this.getSyntClipboardSelection();
        if (iClipboardSelection != null) {
            iClipboardSelection.selectAll();
        } else if (this.a != null) {
            Control control = this.a.getControl();
            if (control instanceof Tree) {
                Tree tree = (Tree)control;
                tree.selectAll();
            } else if (control instanceof Table) {
                Table table = (Table)control;
                table.selectAll();
            }
        }
        this.updateStates();
    }

    public void performMove() {
        if (this.moveAction.isEnabled() && this.partSelection != null) {
            DesignerProp designerProp;
            PropCnr propCnr = this.editedPropCnr;
            if (propCnr instanceof IPropDesigner) {
                IPropDesigner iPropDesigner = (IPropDesigner)propCnr;
                designerProp = iPropDesigner.getDesigner();
            } else {
                designerProp = this.filePropCnr != null ? this.filePropCnr.getDesigner() : null;
            }
            DesignerProp designerProp2 = designerProp;
            PropHelper.doMove(Activator.fileToData(designerProp2), (ISelection)this.partSelection, this);
            this.updateStates();
        }
    }

    public void performLink() {
        if (this.linkAction.isEnabled() && this.partSelection != null) {
            DesignerProp designerProp;
            PropCnr propCnr = this.editedPropCnr;
            if (propCnr instanceof IPropDesigner) {
                IPropDesigner iPropDesigner = (IPropDesigner)propCnr;
                designerProp = iPropDesigner.getDesigner();
            } else {
                designerProp = this.filePropCnr != null ? this.filePropCnr.getDesigner() : null;
            }
            DesignerProp designerProp2 = designerProp;
            PropHelper.doLink(this.getShell(), Activator.fileToData(designerProp2), (ISelection)this.partSelection);
            this.updateStates();
        }
    }

    protected abstract void performPrint();

    protected void performRevert() {
        this.updateStates();
    }

    protected void performSave() {
        if (this.saveAction.isEnabled()) {
            try {
                this.getSite().getWorkbenchWindow().run(false, true, iProgressMonitor -> this.doSave(iProgressMonitor));
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
        }
    }

    protected void performRename() {
        DesignerProp designerProp = Activator.getFirstSelectedProperty((ISelection)this.partSelection);
        if (designerProp != null) {
            PropHelper.doRename((ISelection)this.partSelection, this);
        }
        this.updateStates();
    }

    protected TreeViewer getCurrentTreeViewer() {
        StructuredViewer structuredViewer = this.a;
        if (structuredViewer instanceof TreeViewer) {
            TreeViewer treeViewer = (TreeViewer)structuredViewer;
            return treeViewer;
        }
        for (StructuredViewer structuredViewer2 : ((HashMap)((Object)this.a)).keySet()) {
            if (!(structuredViewer2 instanceof TreeViewer)) continue;
            TreeViewer treeViewer = (TreeViewer)structuredViewer2;
            return treeViewer;
        }
        return null;
    }

    protected void performCollapseAll() {
        TreeViewer treeViewer = this.getCurrentTreeViewer();
        if (treeViewer != null) {
            treeViewer.collapseAll();
        }
    }

    protected void performExpandAll() {
        TreeViewer treeViewer = this.getCurrentTreeViewer();
        if (treeViewer != null) {
            SWTHelper.expandAll(treeViewer);
        }
    }

    public final void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        StructuredSelection structuredSelection;
        if (this.isDisposed()) {
            return;
        }
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            structuredSelection = iStructuredSelection;
        } else {
            structuredSelection = StructuredSelection.EMPTY;
        }
        this.partSelection = structuredSelection;
        this.selectionChangedEx(selectionChangedEvent);
        this.updateStates();
    }

    public void fireSelectionAndStates() {
        this.a.fireCurrentSelection();
    }

    protected void selectionChangedEx(SelectionChangedEvent selectionChangedEvent) {
    }

    @Override
    public final void updateStates() {
        boolean bl;
        if (this.isDisposed() || this.toolBar == null || this.e) {
            return;
        }
        if (this.e || this.a == null) {
            return;
        }
        this.onUpdateStates();
        this.selectionEnabler.update(this.partSelection);
        if (this.copyReferenceAction != null) {
            this.copyReferenceAction.setEnabled(this.performCopyReference(false));
        }
        if (this.copyFullPathAction != null) {
            this.copyFullPathAction.setEnabled(this.performCopyFullPath(false));
        }
        this.updateStatesEx();
        IClipboardSelection iClipboardSelection = this.getSyntClipboardSelection();
        if (iClipboardSelection != null) {
            this.copyAction.setEnabled(iClipboardSelection.canCopy());
            this.cutAction.setEnabled(iClipboardSelection.canCut());
            this.pasteAction.setEnabled(iClipboardSelection.canPaste());
            this.deleteAction.setEnabled(iClipboardSelection.canDelete());
            this.renameAction.setEnabled(false);
            this.moveAction.setEnabled(false);
            this.linkAction.setEnabled(false);
            this.pasteBeforeAction.setEnabled(false);
            this.pasteAfterAction.setEnabled(false);
            this.pasteLinkAction.setEnabled(false);
        } else {
            this.copyAction.setEnabled(this.selectionEnabler.canCopy);
            this.cutAction.setEnabled(this.selectionEnabler.canCut);
            this.pasteAction.setEnabled(this.selectionEnabler.canPaste);
            this.pasteLinkAction.setEnabled(this.selectionEnabler.canPasteLink);
            this.deleteAction.setEnabled(this.selectionEnabler.canDelete);
            this.renameAction.setEnabled(this.selectionEnabler.canRename);
            this.moveAction.setEnabled(this.selectionEnabler.canMove);
            this.linkAction.setEnabled(this.selectionEnabler.canLink);
            this.updateStatesPasteBeforeAfter();
        }
        if (this.tiPaste != null) {
            bl = this.pasteAction.isEnabled() || this.pasteBeforeAction != null && this.pasteBeforeAction.isEnabled() || this.pasteAfterAction != null && this.pasteAfterAction.isEnabled();
            this.tiPaste.setEnabled(bl);
        }
        bl = this.b;
        this.saveAction.setEnabled(bl);
        this.revertAction.setEnabled(bl);
    }

    protected void onUpdateStates() {
    }

    protected void updateStatesPasteBeforeAfter() {
        this.pasteBeforeAction.setEnabled(this.selectionEnabler.canPasteBefore);
        this.pasteAfterAction.setEnabled(this.selectionEnabler.canPasteAfter);
    }

    protected final synchronized void postAsyncUpdateStates() {
        if (this.f || this.e || this.isDisposed()) {
            return;
        }
        this.f = true;
        Display.getDefault().asyncExec(this.a);
    }

    protected void onEditedPropertyChangedForVerify(GEvent gEvent) {
    }

    protected void updateStatesEx() {
    }

    @Override
    public void setPropertyValue(PropCnr propCnr, GProp<?> gProp, Object object) {
        block10: {
            if (propCnr instanceof MultiPropCnr) {
                try {
                    if (propCnr.containsProp(gProp.getPropAtom())) {
                        gProp.setPropValue(object);
                        break block10;
                    }
                    propCnr.addProp(gProp);
                }
                catch (PropException propException) {
                    ILog.SEVERE(this.getClass(), (String)("setPropertyValue " + String.valueOf(gProp) + " in parent " + String.valueOf(propCnr) + " failed"), (Throwable)propException);
                }
            } else {
                GProp gProp2 = propCnr.getProp(gProp.getPropAtom());
                if (gProp2 != null) {
                    if (gProp2 == gProp) {
                        if (gProp2.isPropExtended()) {
                            ILog.SEVERE(this.getClass(), (String)("setPropertyValue " + String.valueOf(gProp) + " is extended!"));
                        } else {
                            PropHelper.setValue("Edit property", new GProp[]{gProp}, new Object[]{object}, (IPropUndoRedo)this);
                            this.updateStates();
                        }
                        return;
                    }
                    if (!gProp2.isPropExtended()) {
                        ILog.SEVERE(this.getClass(), (String)("Property " + String.valueOf(gProp) + " found in parent " + String.valueOf(propCnr) + " in another instance: " + String.valueOf(gProp2)));
                        return;
                    }
                }
                PropHelper.doAdd("Define property", propCnr, gProp, (IPropUndoRedo)this, false);
            }
        }
        this.updateStates();
    }

    @Override
    public void setPropertyError(GProp<?> gProp, String string, IPropErrorItem iPropErrorItem) {
        if (gProp.getParent() instanceof MultiPropCnr) {
            if (iPropErrorItem == null) {
                gProp.removePropError(string);
            } else {
                gProp.addPropError(iPropErrorItem);
            }
        } else {
            PropHelper.setError(gProp, string, iPropErrorItem, this);
        }
        this.updateStates();
    }

    @Override
    public void setPropertyAttrFlag(GProp<?> gProp, int n2, boolean bl) {
        PropHelper.setAttribute(gProp, n2, bl, this);
        this.updateStates();
    }

    @Override
    public void removePropertyValue(GProp<?> gProp) {
        if (gProp.getParent() instanceof MultiPropCnr) {
            try {
                gProp.getParent().removeProp(gProp);
            }
            catch (PropException propException) {
                ILog.SEVERE(this.getClass(), (String)("removePropertyValue " + String.valueOf(gProp) + " failed"), (Throwable)propException);
            }
            this.updateStates();
        } else if (gProp.isPropChildOf((IPropCnr)this.editedPropCnr)) {
            assert (!gProp.isPropExtended()) : "Property " + String.valueOf(gProp) + " is extended and should not be removed using \"removePropertyValue()\"";
            PropHelper.doDelete("Un-defined property", new GProp[]{gProp}, this, () -> this.updateStates());
        }
    }

    public <T> T getAdapter(Class<T> clazz) {
        if (clazz.equals(Saveable.class)) {
            Saveable[] saveableArray = this.getSaveables();
            return saveableArray.length > 0 ? (T)clazz.cast(saveableArray[0]) : null;
        }
        if (clazz.equals(ISaveablesSource.class)) {
            return clazz.cast(this);
        }
        if (clazz.equals(IResource.class)) {
            return this.filePropCnr != null ? (T)clazz.cast(this.filePropCnr.getDesigner().getIResource()) : null;
        }
        if (clazz.equals(IFile.class)) {
            return this.filePropCnr != null ? (T)clazz.cast(this.filePropCnr.getIFile()) : null;
        }
        if (clazz.equals(IContentOutlinePage.class)) {
            PropCnr propCnr;
            if (this.a == null && (propCnr = this.editedPropCnr) instanceof IPropDesigner) {
                IPropDesigner iPropDesigner = (IPropDesigner)propCnr;
                this.a = new l(this, iPropDesigner.getDesigner());
            }
            return clazz.cast((Object)this.a);
        }
        if (clazz.equals(IShowInSource.class) && this.editedPropCnr != null) {
            return clazz.cast(new s(this));
        }
        return (T)super.getAdapter(clazz);
    }

    public Saveable[] getSaveables() {
        int n2 = this.a.size();
        if (this.filePropCnr == null || n2 == 0) {
            return FilePropSaveable.EMPTY;
        }
        Saveable[] saveableArray = new Saveable[n2];
        n2 = 0;
        for (FilePropCnr filePropCnr : this.a) {
            saveableArray[n2++] = filePropCnr.getSaveable();
        }
        return saveableArray;
    }

    public Saveable[] getActiveSaveables() {
        return this.getSaveables();
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return this.getEditorInput() != null ? new a() : null;
    }

    public INavigationLocation createNavigationLocation() {
        return this.getEditorInput() != null ? new a() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onActivated(boolean bl) {
        HashSet<PropEditorPart> hashSet = a;
        synchronized (hashSet) {
            ((ArrayList)((Object)a)).remove(this);
            ((ArrayList)((Object)a)).add(this);
        }
        this.onEditorActivated(bl);
    }

    public final CommonViewerEx createCommonViewer(Composite composite) {
        return new t(this, composite, 2, 32);
    }

    public final FilteredCommonViewer createFilteredCommonViewer(Composite composite, IzFilter izFilter) {
        return this.createFilteredCommonViewer(composite, 2, izFilter);
    }

    public final FilteredCommonViewer createFilteredCommonViewer(Composite composite, int n2, IzFilter izFilter) {
        return new u(this, composite, n2, izFilter, 32);
    }

    protected void onDragBegin() {
        ++this.a;
    }

    protected void onDragEnd() {
        if (--this.a == 0) {
            this.a.onDragEnd();
        }
    }

    @Override
    public boolean isDragging() {
        return this.a > 0;
    }

    protected void createMenu(Viewer viewer, IContextMenuContributor iContextMenuContributor) {
        Control control = viewer.getControl();
        IzMenu izMenu = new IzMenu(control);
        izMenu.setMenu(control, false).omitDisabled();
        izMenu.addMenuListener(() -> {
            PropCnr propCnr;
            izMenu.clear();
            if (this.redoAction == null) {
                return;
            }
            Object object = this.getTargetViewer();
            if (viewer != object) {
                this.setTargetViewer(viewer);
            }
            this.a.fireCurrentSelection();
            this.updateStates();
            DesignerProp designerProp = Activator.getFirstSelectedProperty(viewer.getSelection());
            if (designerProp == null && iContextMenuContributor != null) {
                designerProp = iContextMenuContributor.getTarget();
            }
            if (designerProp == null && (propCnr = this.editedPropCnr) instanceof IPropDesigner) {
                IPropDesigner iPropDesigner = (IPropDesigner)propCnr;
                designerProp = iPropDesigner.getDesigner();
            }
            if (iContextMenuContributor != null) {
                iContextMenuContributor.prependMenuItems(viewer, izMenu, designerProp);
            }
            this.a(izMenu);
            if (designerProp != null) {
                designerProp.addContextMenuItems(viewer, izMenu, this);
            }
            if (iContextMenuContributor != null) {
                iContextMenuContributor.appendMenuItems(viewer, izMenu, designerProp);
            }
        });
    }

    protected void createMenu(Control control, IContextMenuContributorFormControl<Control> iContextMenuContributorFormControl) {
        IzMenu izMenu = new IzMenu(control);
        izMenu.setMenu(control, false).omitDisabled();
        izMenu.addMenuListener(() -> {
            PropCnr propCnr;
            int n2 = izMenu.getItemCount();
            while (--n2 >= 0) {
                izMenu.getItem(n2).dispose();
            }
            if (control != this.a.getCurrentControl()) {
                System.err.println("Wrong control active when activating the pop-up!");
            }
            this.a.fireCurrentSelection();
            this.updateStates();
            DesignerProp designerProp = Activator.getFirstSelectedProperty(this.a.getSelection());
            if (designerProp == null && iContextMenuContributorFormControl != null) {
                designerProp = iContextMenuContributorFormControl.getTarget();
            }
            if (designerProp == null && (propCnr = this.editedPropCnr) instanceof IPropDesigner) {
                IPropDesigner iPropDesigner = (IPropDesigner)propCnr;
                designerProp = iPropDesigner.getDesigner();
            }
            if (iContextMenuContributorFormControl != null) {
                iContextMenuContributorFormControl.prependMenuItems(control, izMenu, designerProp);
            }
            this.a(izMenu);
            if (designerProp != null) {
                designerProp.addContextMenuItems(control, izMenu, this, designerProp);
            }
            if (iContextMenuContributorFormControl != null) {
                iContextMenuContributorFormControl.appendMenuItems(control, izMenu, designerProp);
            }
        });
    }

    public final void setFocus() {
        if (!(this.d || this.a != null && this.a.restoreLastFocus())) {
            this.onSetFocus();
        } else {
            this.updateStates();
        }
    }

    protected void onSetFocus() {
        if (!((HashMap)((Object)this.a)).isEmpty()) {
            ((StructuredViewer)((HashMap)((Object)this.a)).keySet().iterator().next()).getControl().setFocus();
        }
        this.updateStates();
    }

    protected void registerViewer(StructuredViewer structuredViewer, int n2) {
        this.registerViewer(structuredViewer, n2, null);
    }

    public void registerViewer(StructuredViewer structuredViewer, int n2, IContextMenuContributor iContextMenuContributor) {
        if (!((HashMap)((Object)this.a)).containsKey(structuredViewer)) {
            Control control = structuredViewer.getControl();
            control.addListener(12, event -> {
                ((HashMap)((Object)this.a)).remove(structuredViewer);
                if (this.a == structuredViewer) {
                    this.a = null;
                }
            });
            this.a.addControl(control, (ISelectionProvider)structuredViewer);
            ((HashMap)((Object)this.a)).put(structuredViewer, n2);
            this.createMenu((Viewer)structuredViewer, iContextMenuContributor);
        }
    }

    public final void setTargetViewer(Object object) {
        this.a = (StructuredViewer)object;
    }

    public Object getTargetViewer() {
        return this.b > 0 ? null : this.a;
    }

    @Override
    public void setBlockViewerFocus(boolean bl) {
        this.b = bl ? ++this.b : --this.b;
    }

    public void onComponentFocus(Control control) {
        this.updateStates();
        for (StructuredViewer structuredViewer : ((HashMap)((Object)this.a)).keySet()) {
            if (structuredViewer.getControl() != control) continue;
            this.setTargetViewer(structuredViewer);
            break;
        }
    }

    public void gotoMarker(IMarker iMarker) {
        try {
            String string;
            switch (string = iMarker.getType()) {
                case "com.iizigo.moduleproblem.property": {
                    Object object = iMarker.getAttribute("com.iizigo.propref");
                    if (object instanceof String) {
                        String string2;
                        String string3 = (String)object;
                        GProp gProp = this.editedPropCnr.getPropFromReference(string3);
                        if (gProp == null) {
                            string2 = "Reference property not found";
                        } else if (!this.editedPropCnr.isChild((IGProp)gProp)) {
                            string2 = "Not child property of edited container";
                        } else if (this.isDisposed()) {
                            string2 = "Editor part is disposed of";
                        } else {
                            String string4;
                            Object object2;
                            this.getEditorSite().getPage().activate((IWorkbenchPart)this);
                            this.refreshViewers();
                            int n2 = -1;
                            object = iMarker.getAttribute("com.iizigo.propref.index");
                            if (object instanceof Integer) {
                                n2 = (Integer)object;
                            }
                            String string5 = (object2 = iMarker.getAttribute("com.iizigo.childName")) instanceof String && !(string4 = (String)object2).isEmpty() ? string4 : null;
                            this.doOpen(gProp, n2, string5);
                            break;
                        }
                        ILog.INFO(this.getClass(), (String)("Marker type '" + iMarker.getType() + "' in gotoMarker failed: " + string2), (Object[])new Object[]{"Resource = " + String.valueOf(iMarker.getResource()), "Reference = " + string3, "Property = " + String.valueOf(gProp)});
                        break;
                    }
                    ILog.WARNING(this.getClass(), (String)("Marker type '" + string + "' in gotoMarker has missing reference attribute"), (Object[])new Object[]{"Resource = " + String.valueOf(iMarker.getResource()), "Reference = " + String.valueOf(object)});
                    break;
                }
                default: {
                    IResource iResource = iMarker.getResource();
                    if (iResource instanceof IFile) {
                        IFile iFile = (IFile)iResource;
                        ResourceDesignerProp resourceDesignerProp = DesignerProp.getInstance(iResource);
                        if (resourceDesignerProp != null) {
                            PropHelper.doOpen(iFile);
                            break;
                        }
                    }
                    ILog.WARNING(this.getClass(), (String)("Unknown marker type '" + string + "' in gotoMarker"), (Object)("Resource = " + String.valueOf(iResource.getFullPath())));
                    break;
                }
            }
        }
        catch (CoreException coreException) {
            ILog.WARNING(this.getClass(), (String)("gotoMarker failed: " + coreException.getMessage()));
        }
    }

    protected int setFocus(PropCnr propCnr, StructuredViewer structuredViewer, IzFilter izFilter, PropertyEditor propertyEditor, GProp<?> propCnrArray, int n2, String string) {
        if (!propCnr.isChild(propCnrArray) && propCnrArray != propCnr) {
            return -1;
        }
        TreePath treePath = null;
        PropCnr[] propCnrArray2 = null;
        DesignerProp designerProp = null;
        PropCnr[] propCnrArray3 = propCnrArray;
        do {
            if (!(propCnrArray3 instanceof IPropDesigner)) continue;
            IPropDesigner iPropDesigner = (IPropDesigner)propCnrArray3;
            designerProp = iPropDesigner.getDesigner();
            ViewerFilter[] viewerFilterArray = structuredViewer.getFilters();
            boolean bl = true;
            if (viewerFilterArray != null) {
                ViewerFilter[] viewerFilterArray2 = viewerFilterArray;
                int n3 = viewerFilterArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ViewerFilter viewerFilter = viewerFilterArray2[n4];
                    if (!viewerFilter.select((Viewer)structuredViewer, designerProp.getCNParent(0), (Object)designerProp)) {
                        if (izFilter != null && viewerFilter instanceof EndNodeTextFilter) {
                            String string2 = izFilter.getText();
                            if (string2 != null && !string2.isEmpty()) {
                                izFilter.clearNotify();
                            }
                        } else {
                            bl = false;
                            break;
                        }
                    }
                    ++n4;
                }
            }
            if (!bl || (treePath = PropHelper.getSelectionPath(structuredViewer, designerProp)) == null) continue;
            propCnrArray2 = propCnrArray3;
            break;
        } while (propCnrArray3 != propCnr && (propCnrArray3 = propCnrArray3.getParent()) != null);
        if (propCnrArray2 == null) {
            return -1;
        }
        structuredViewer.getControl().setFocus();
        PropHelper.expandAllInPath(structuredViewer, treePath);
        structuredViewer.setSelection((ISelection)new TreeSelection(treePath), true);
        if (designerProp != null && Activator.getFirstSelectedProperty(structuredViewer.getSelection()) != designerProp) {
            PropHelper.setSelection(structuredViewer, designerProp);
        }
        if ((propCnrArray3 = propertyEditor.getEditedProperties()) == null || propCnrArray3.length != 1) {
            return 0;
        }
        return propertyEditor.setFocus((GProp<?>)propCnrArray, n2, string) ? 1 : 0;
    }

    static /* synthetic */ void a(PropEditorPart propEditorPart, IEditorInput iEditorInput) {
        propEditorPart.setInputWithNotify(iEditorInput);
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    protected final class DragSourceDelegator
    implements DragSourceListener {
        private final DragSourceListener a;

        protected DragSourceDelegator(DragSourceListener dragSourceListener) {
            this.a = dragSourceListener;
        }

        public void dragStart(DragSourceEvent dragSourceEvent) {
            PropEditorPart.this.onDragBegin();
            this.a.dragStart(dragSourceEvent);
        }

        public void dragSetData(DragSourceEvent dragSourceEvent) {
            this.a.dragSetData(dragSourceEvent);
        }

        public void dragFinished(DragSourceEvent dragSourceEvent) {
            this.a.dragFinished(dragSourceEvent);
            PropEditorPart.this.onDragEnd();
        }
    }

    private class a
    extends NavigationLocation {
        private a() {
            super((IEditorPart)PropEditorPart.this);
        }

        public void saveState(IMemento iMemento) {
        }

        public void restoreState(IMemento iMemento) {
        }

        public void restoreLocation() {
        }

        public boolean mergeInto(INavigationLocation iNavigationLocation) {
            return true;
        }

        public void update() {
        }
    }
}

