/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.oauth;

import com.iizix.ILog;
import com.iizix.SessionInfo;
import com.iizix.comm.oauth.IOAuthCallbackProvider;
import com.iizix.comm.oauth.IOAuthListener;
import com.iizix.comm.oauth.IOAuthService;
import com.iizix.comm.session.SessionID;
import com.iizix.gyro.IAppSessionGyro;
import com.iizix.gyro.IClientSessionGyro;
import com.iizix.server.client.ClientParams;
import com.iizix.server.gyro.AppSessionGyro;
import com.iizix.server.oauth.OAuthSession;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class OAuthEngine {
    private static OAuthEngine a;
    private static String b;
    private HashMap<String, OAuthSession> a;
    final String a = new HashMap();

    static {
        b = "/oauth_cb";
    }

    public static OAuthEngine initializeNewInstance(String string) {
        a = new OAuthEngine(string);
        return a;
    }

    public static OAuthEngine getCurrentInstance() {
        OAuthEngine oAuthEngine = a;
        if (oAuthEngine == null) {
            throw new IllegalStateException("Authentication Engine is not initialized");
        }
        return oAuthEngine;
    }

    private OAuthEngine(String string) {
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        this.a = string + b;
        a = this;
    }

    String a(IAppSessionGyro iAppSessionGyro) {
        SessionID sessionID;
        Object object = this.a;
        IClientSessionGyro[] iClientSessionGyroArray = iAppSessionGyro.getClientSessionGyros();
        SessionInfo sessionInfo = iClientSessionGyroArray.length == 1 ? iClientSessionGyroArray[0].getClientSessionInfo() : iAppSessionGyro.getAppSessionInfo();
        String string = sessionInfo.getDomain();
        if (string != null && !string.isEmpty()) {
            boolean bl = sessionInfo.isSecure();
            int n = sessionInfo.getPort();
            Object object2 = "";
            if (n != 0 && (bl && n != 443 || !bl && n != 80)) {
                object2 = ":" + n;
            }
            object = (bl ? "https://" : "http://") + string + (String)object2 + b;
        }
        System.err.println("Callback URL = " + (String)object + " --> " + ((sessionID = sessionInfo.getSessionID()) != null ? sessionID.getFullLogInfo() : sessionInfo.toString()));
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(OAuthSession oAuthSession, String string, IOAuthCallbackProvider iOAuthCallbackProvider) {
        Object object;
        if (oAuthSession.isOAuth2()) {
            var4_4 = this.a;
            synchronized (var4_4) {
                object = oAuthSession.getState();
                if (((HashMap)((Object)this.a)).putIfAbsent(object, oAuthSession) != null) {
                    ILog.SEVERE(this.getClass(), (String)("OAuth 2.0 session already exists in callbacks: state = " + (String)object));
                }
            }
        } else {
            var4_4 = oAuthSession.getOAuth1Token();
            if (((HashMap)((Object)this.a)).putIfAbsent(var4_4, oAuthSession) != null) {
                ILog.SEVERE(this.getClass(), (String)("OAuth 1.0a session already exists in callbacks: oauth_token = " + (String)var4_4));
            }
        }
        boolean bl = false;
        try {
            object = oAuthSession.getAppSessionGyro();
            if (object != null) {
                bl = ((AppSessionGyro)object).getAppSessionInfo().assignThread();
            }
            iOAuthCallbackProvider.display((IOAuthService)oAuthSession.getService(), string);
        }
        finally {
            if (bl) {
                SessionInfo.unassignThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(OAuthSession oAuthSession) {
        OAuthEngine oAuthEngine = this.a;
        synchronized (oAuthEngine) {
            IOAuthListener.Code code;
            String string = oAuthSession.getState();
            if (((HashMap)((Object)this.a)).remove(string) == null && ((code = oAuthSession.getCompletionCode()) == IOAuthListener.Code.SUCCESS || code == IOAuthListener.Code.INCOMPLETE)) {
                ILog.WARNING(this.getClass(), (String)("Authentication session has already been removed from callbacks: state = " + string));
            }
        }
    }

    public static boolean isAuthenticationCallbackURL(String string) {
        int n = string.indexOf(63);
        if (n < 0) {
            return false;
        }
        return string.substring(0, n).equals(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processAuthenticationCallbackURL(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Object object;
        Object object2;
        if (!OAuthEngine.isAuthenticationCallbackURL(string)) {
            return false;
        }
        String string2 = "<unknown>";
        OAuthSession oAuthSession = null;
        ClientParams clientParams = new ClientParams(null, httpServletRequest.getQueryString(), false);
        String string3 = clientParams.getParameterValue("state");
        if (string3 != null) {
            string2 = "OAuth 2.0";
            object2 = this.a;
            synchronized (object2) {
                oAuthSession = (OAuthSession)((HashMap)((Object)this.a)).remove(string3);
            }
        }
        object2 = clientParams.getParameterValue("oauth_token");
        if (object2 != null) {
            string2 = "OAuth 1.0x";
            object = this.a;
            synchronized (object) {
                oAuthSession = (OAuthSession)((HashMap)((Object)this.a)).remove(object2);
            }
        }
        if (oAuthSession != null) {
            boolean bl = false;
            try {
                object = oAuthSession.getAppSessionGyro();
                if (object != null) {
                    bl = ((AppSessionGyro)object).getAppSessionInfo().assignThread();
                }
                oAuthSession.a(clientParams, httpServletRequest);
            }
            finally {
                if (bl) {
                    SessionInfo.unassignThread();
                }
            }
            return true;
        }
        object2 = "Authentication (" + string2 + ") failed looking up session instance: query = " + httpServletRequest.getQueryString();
        ILog.SEVERE(this.getClass(), (String)object2);
        httpServletResponse.sendError(404, (String)object2);
        return true;
    }
}

