/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.mail.MailSender;
import com.iizix.prop.Atom;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.StringProp;
import jakarta.mail.NoSuchProviderException;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.InvalidPathException;
import java.util.concurrent.ExecutorService;

public class MailProps
extends PropCnr {
    public static final String COMPRESS = "compress";
    public static final String DEBUG = "debug";
    public static final String QUEUED_MAIL_DIRECTORY = "directory";
    public static final String DEFAULT_SENDER = "defaultSender";
    public static final String DEFAULT_REPLYTO = "defaultReplyTo";
    public static final String DEFAULT_CCS = "defaultCCs";
    public static final String DEFAULT_BCCS = "defaultBCCs";
    public static final String MAIL_HOST = "host";
    public static final String PORT = "port";
    public static final String BIND_ADDRESS = "bindAddress";
    public static final String SMTPS_PROTOCOL = "smtps";
    public static final String USE_SSL = "ssl";
    public static final String USE_STARTTLS = "STARTTLS";
    public static final String SERVER_IDENTITY_CHECK = "serverIDCheck";
    public static final String TIMEOUT = "timeout";
    public static final String USER_NAME = "userName";
    public static final String PASSWORD = "password";
    private MailSender a;

    public MailProps() {
    }

    public MailProps(Atom atom) {
        super(atom);
    }

    @Override
    public MailProps clone() {
        try {
            MailProps mailProps = (MailProps)super.clone();
            mailProps.a = null;
            return mailProps;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    public File getMailQueueDirectory(File file) {
        File file2 = null;
        String string = this.getString(QUEUED_MAIL_DIRECTORY);
        if (string != null && !string.isEmpty() && file != null && file.isDirectory()) {
            try {
                file2 = file.toPath().resolve(string).toFile();
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
        }
        return file2;
    }

    public boolean isDefaultSender() {
        return this.getBool(DEFAULT_SENDER);
    }

    public MailSender getMailSender() {
        return this.a;
    }

    public InternetAddress getDefaultSender() throws AddressException {
        String string = this.getString(DEFAULT_SENDER);
        try {
            return string != null && !string.isEmpty() ? new InternetAddress(string) : null;
        }
        catch (Throwable throwable) {
            throw new AddressException("Invalid address: " + string);
        }
    }

    public InternetAddress getDefaultReplyTo() throws AddressException {
        String string = this.getString(DEFAULT_REPLYTO);
        try {
            return string != null && !string.isEmpty() ? new InternetAddress(string) : null;
        }
        catch (Throwable throwable) {
            throw new AddressException("Invalid address: " + string);
        }
    }

    public InternetAddress[] getDefaultCCs() throws AddressException {
        String string = this.getString(DEFAULT_CCS);
        if (string == null || string.isEmpty()) {
            return null;
        }
        try {
            InternetAddress[] internetAddressArray = InternetAddress.parse((String)string, (boolean)true);
            return internetAddressArray.length > 0 ? internetAddressArray : null;
        }
        catch (Throwable throwable) {
            throw new AddressException("Invalid address: " + string);
        }
    }

    public InternetAddress[] getDefaultBCCs() throws AddressException {
        String string = this.getString(DEFAULT_BCCS);
        if (string == null || string.isEmpty()) {
            return null;
        }
        try {
            InternetAddress[] internetAddressArray = InternetAddress.parse((String)string, (boolean)true);
            return internetAddressArray.length > 0 ? internetAddressArray : null;
        }
        catch (Throwable throwable) {
            throw new AddressException("Invalid address: " + string);
        }
    }

    public synchronized MailSender createInstance(ExecutorService executorService, File file) throws IOException, NoSuchProviderException, AddressException {
        if (this.a == null) {
            File file2 = this.getMailQueueDirectory(file);
            if (file2 == null) {
                throw new IOException("Mail send queue directory cannot be located");
            }
            this.a = new MailSender(this, executorService, file2);
        }
        return this.a;
    }

    @Override
    public boolean verify(PropVerification propVerification) {
        Object object;
        String string;
        if (!super.verify(propVerification)) {
            return false;
        }
        StringProp stringProp = this.getProp(DEFAULT_SENDER, StringProp.class);
        if (stringProp == null) {
            propVerification.add(new PropVerificationError((PropCnr)this, DEFAULT_SENDER, PropVerificationError.Severity.WARNING, "Default Sender", "Default Sender must be specified", new String[0]));
        } else {
            string = stringProp.getString();
            if (string == null || string.isEmpty()) {
                propVerification.add(new PropVerificationError("sender", PropVerificationError.Severity.WARNING, "Default Sender", stringProp, "Default Sender must be specified", new String[0]));
            } else {
                try {
                    object = new InternetAddress(string);
                }
                catch (Throwable throwable) {
                    propVerification.add(new PropVerificationError("sender", PropVerificationError.Severity.ERROR, "Default Sender", stringProp, "Default Sender is invalid: " + throwable.getMessage(), new String[0]));
                }
            }
        }
        string = this.getString(DEFAULT_REPLYTO);
        if (string != null && !string.isEmpty()) {
            try {
                object = new InternetAddress(string);
            }
            catch (Throwable throwable) {
                propVerification.add(new PropVerificationError("replyTo", PropVerificationError.Severity.ERROR, "Default Reply To", stringProp, "Default Reply To is invalid: " + throwable.getMessage(), new String[0]));
            }
        }
        if ((string = this.getString(DEFAULT_CCS)) != null && !string.isEmpty()) {
            try {
                object = InternetAddress.parse((String)string);
            }
            catch (Throwable throwable) {
                propVerification.add(new PropVerificationError("CCs", PropVerificationError.Severity.ERROR, "Default CCs", stringProp, "Default CCs \"" + string + "\"invalid: " + throwable.getMessage(), new String[0]));
            }
        }
        if ((string = this.getString(DEFAULT_BCCS)) != null && !string.isBlank()) {
            try {
                object = InternetAddress.parse((String)string.trim());
            }
            catch (Throwable throwable) {
                propVerification.add(new PropVerificationError("BCCs", PropVerificationError.Severity.ERROR, "Default BCCs", stringProp, "Default BCCs \"" + string + "\"invalid: " + throwable.getMessage(), new String[0]));
            }
        }
        if ((stringProp = this.getProp(MAIL_HOST, StringProp.class)) == null) {
            propVerification.add(new PropVerificationError((PropCnr)this, MAIL_HOST, PropVerificationError.Severity.WARNING, "Mail host", "Mail host must be specified", new String[0]));
        } else {
            object = null;
            Object object2 = null;
            String string2 = stringProp.getString();
            if (string2 == null || string2.isEmpty()) {
                object2 = "Mail host must be specified";
                object = PropVerificationError.Severity.WARNING;
            }
            try {
                InetAddress inetAddress = InetAddress.getByName(string2);
                if (!inetAddress.isReachable(5000)) {
                    object2 = "Mail host is not reachable within 5 seconds";
                    object = PropVerificationError.Severity.WARNING;
                }
            }
            catch (Throwable throwable) {
                object2 = "Mail host error: " + throwable.getMessage();
                object = PropVerificationError.Severity.ERROR;
            }
            if (object2 != null) {
                propVerification.add(new PropVerificationError("def", (PropVerificationError.Severity)((Object)object), "Mail host", stringProp, (String)object2, new String[0]));
            }
        }
        stringProp = this.getProp(QUEUED_MAIL_DIRECTORY, StringProp.class);
        if (stringProp == null) {
            propVerification.add(new PropVerificationError((PropCnr)this, QUEUED_MAIL_DIRECTORY, PropVerificationError.Severity.WARNING, "Directory", "Mail directory must be specified", new String[0]));
        } else {
            string = stringProp.getString();
            if (string == null || string.isEmpty()) {
                propVerification.add(new PropVerificationError("dir", PropVerificationError.Severity.WARNING, "Directory", stringProp, "Mail directory must be specified", new String[0]));
            }
        }
        stringProp = this.getProp(BIND_ADDRESS, StringProp.class);
        if (stringProp != null && (string = stringProp.getString()) != null && !string.isEmpty()) {
            try {
                InetAddress.getByName(string);
            }
            catch (Throwable throwable) {
                propVerification.add(new PropVerificationError("bind", PropVerificationError.Severity.ERROR, "Bind address", stringProp, "Mail bind address is invalid: " + throwable.getMessage(), new String[0]));
            }
        }
        return true;
    }
}

