/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.Utilities;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.PropException;
import com.iizix.prop.PropMgr;
import com.iizix.prop.PropTypeException;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;

public class ByteArrayProp
extends GProp<byte[]> {
    private static final Class<?>[] a = new Class[]{byte[].class, String.class};

    protected ByteArrayProp() {
    }

    public ByteArrayProp(Atom atom) {
        super(atom);
    }

    public ByteArrayProp(Atom atom, byte[] byArray) {
        super(atom);
        this.setPropValue(byArray);
    }

    @Override
    public Class<?>[] getValueClasses() {
        return a;
    }

    @Override
    public ByteArrayProp clone() {
        try {
            return (ByteArrayProp)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    public boolean setPropValue(byte[] byArray) {
        try {
            return super.setPropValue(byArray);
        }
        catch (PropException propException) {
            throw new InternalError(propException.getMessage(), propException);
        }
    }

    public byte[] getByteArray() {
        return (byte[])this.getPropValue();
    }

    @Override
    public void validatePropType(Object object) throws PropTypeException {
        if (!(object instanceof byte[])) {
            throw new PropTypeException(this, "newValue not byte[]");
        }
    }

    @Override
    protected int modifyPropValue(Object object, Object object2, PropMgr propMgr) throws PropException {
        return Arrays.equals((byte[])object, (byte[])object2) ? 0 : 1;
    }

    @Override
    protected void appendPropValue(PropMgr propMgr, SendTransaction sendTransaction, Object object) {
        byte[] byArray = (byte[])object;
        sendTransaction.appendUnsigned(byArray.length);
        sendTransaction.append(byArray);
    }

    @Override
    public boolean initializeValue(PropMgr propMgr, ReadTransaction readTransaction) throws PropException {
        return this.setPropValue((Object)readTransaction.readBytes(readTransaction.readUnsigned()), propMgr);
    }

    @Override
    public Object fromElementString(String string) throws PropException {
        byte[] byArray = Utilities.fromHex(string);
        if (byArray == null) {
            String string2 = "0123456789ABCDEF";
            int n2 = string.length();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2 / 2);
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                char c2;
                if (Character.isWhitespace(c2 = string.charAt(n3++))) continue;
                int n5 = string2.indexOf(Character.toUpperCase(c2));
                if (n5 < 0 || n3 == n2) {
                    throw new PropException(this, "Invalid hexadecimal character");
                }
                if ((n4 = string2.indexOf(Character.toUpperCase(c2 = string.charAt(n3++)))) < 0) {
                    throw new PropException(this, "Invalid hexadecimal character");
                }
                byteArrayOutputStream.write(n4 | n5 << 4);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    @Override
    public String toElementString(Object object) {
        return Utilities.toHex((byte[])this.getPropValue());
    }

    @Override
    protected Object getPropValue0(Object object, int n2) throws Exception {
        switch (n2) {
            case 1: {
                return this.toElementString(object);
            }
        }
        throw new IllegalArgumentException("invalid index: " + n2);
    }

    @Override
    protected Object toNativeValue0(Object object, int n2) throws Exception {
        switch (n2) {
            case 1: {
                return this.fromElementString((String)object);
            }
        }
        throw new IllegalArgumentException("invalid index: " + n2);
    }
}

