/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.selector;

import com.ibm.icu.text.Collator;
import com.iizix.ILog;
import com.iizix.Size;
import com.iizix.prop.Atom;
import com.iizix.prop.EnvProps;
import com.iizix.prop.PropTypeException;
import com.iizix.selector.IInfoProvider;
import com.iizix.selector.IMatchDescription;
import com.iizix.selector.a;
import com.iizix.selector.b;
import com.iizix.selector.c;
import com.iizix.selector.d;
import com.iizix.selector.e;
import com.iizix.selector.f;
import io.github.mngsk.devicedetector.Detection;
import io.github.mngsk.devicedetector.DeviceDetector;
import io.github.mngsk.devicedetector.device.Device;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import ua_parser.CachingParser;
import ua_parser.Client;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DeviceMatch {
    private static final Map<String, IMatchDescription> a = new HashMap<String, IMatchDescription>();
    private static final DeviceDetector a = new DeviceDetector.DeviceDetectorBuilder().disableBots().disableCameras().disableConsoles().disableMediaPlayers().disablePortableMediaPlayers().disableFeedReaders().disableLibraries().build();
    private static final CachingParser a = new CachingParser();

    static {
        a.put("cap-battery", new a(EnvProps.ClientCapability.Battery));
        a.put("cap-contacts", new a(EnvProps.ClientCapability.Contacts));
        a.put("cap-compass", new a(EnvProps.ClientCapability.Compass));
        a.put("cap-camera", new a(EnvProps.ClientCapability.Camera));
        a.put("cap-GPS", new a(EnvProps.ClientCapability.GPS));
        a.put("cap-touch", new a(EnvProps.ClientCapability.Touch));
        a.put("cap-mouse", new a(EnvProps.ClientCapability.Mouse));
        a.put("cap-pen", new a(EnvProps.ClientCapability.Pen));
        a.put("cap-motion", new a(EnvProps.ClientCapability.Motion));
        a.put("cap-microphone", new a(EnvProps.ClientCapability.Microphone));
        a.put("cap-videocapture", new a(EnvProps.ClientCapability.VideoCapture));
        a.put("cap-sound", new a(EnvProps.ClientCapability.Sound));
        a.put("cap-speechRecognition", new a(EnvProps.ClientCapability.SpeechRecognition));
        a.put("cap-speechSynthesis", new a(EnvProps.ClientCapability.SpeechSynthesis));
        a.put("cap-vibration", new a(EnvProps.ClientCapability.Vibration));
        a.put("cap-phone", new a(EnvProps.ClientCapability.Phone));
        a.put("orient-landscape", new f("Landscape orientation", envProps -> {
            Size size = DeviceMatch.a(envProps);
            return size.width >= size.height;
        }));
        a.put("orient-portrait", new f("Portrait orientation", envProps -> {
            Size size = DeviceMatch.a(envProps);
            return size.width < size.height;
        }));
        DeviceMatch.a("size-generic-small", "\"Small\" display (smaller than tabloid, typically phones, apect ratio > 16:10)");
        DeviceMatch.a("size-generic-tabloid", "Tablet displays (500 x 800 in portrait/landscape or better, aspect ratio <= 16:10)");
        DeviceMatch.a("size-micro", "Watch display");
        for (IMatchDescription iMatchDescription : a.values()) {
            if (iMatchDescription.isValid()) continue;
            ILog.SEVERE(DeviceMatch.class, "DeviceMatch \"" + iMatchDescription.getDescription() + "\" is not valid, the \"DeviceMatcher.xml\" file is not synchronized with the DeviceMatch code");
        }
        DeviceMatch.a("dev-isBrowser", new b("Browser based device", detection -> detection.isBrowser()));
        DeviceMatch.a("dev-isCarBrowser", new b("Car based Browser device", detection -> detection.isCarBrowser()));
        DeviceMatch.a("dev-isDesktop", new b("Desktop system device", detection -> detection.isDesktop()));
        DeviceMatch.a("dev-isFeaturePhone", new b("Feature Phone device", detection -> detection.isFeaturePhone()));
        DeviceMatch.a("dev-isMobile", new b("Mobile device", detection -> detection.isMobile()));
        DeviceMatch.a("dev-isMobileApp", new b("Mobile App device", detection -> detection.isMobileApp()));
        DeviceMatch.a("dev-isNotebook", new b("Notebook device", detection -> detection.isNotebook()));
        DeviceMatch.a("dev-isPhablet", new b("Phablet device (phone/tablet device)", detection -> detection.isPhablet()));
        DeviceMatch.a("dev-isPIM", new b("PIM device (Personal Information Manager device)", detection -> detection.isPIM()));
        DeviceMatch.a("dev-isSmartDisplay", new b("Smart Display device", detection -> detection.isSmartDisplay()));
        DeviceMatch.a("dev-isSmartphone", new b("Smartphone device", detection -> detection.isSmartphone()));
        DeviceMatch.a("dev-isSmartSpeaker", new b("Smart Speaker device", detection -> detection.isSmartSpeaker()));
        DeviceMatch.a("dev-isTablet", new b("Tablet device", detection -> detection.isTablet()));
        DeviceMatch.a("dev-isTouchEnabled", new b("Touch Enabled device", detection -> detection.isTouchEnabled()));
        DeviceMatch.a("dev-isTV", new b("TV device", detection -> detection.isTV()));
        DeviceMatch.a("dev-usesMobileBrowser", new b("Device uses a mobile browser", detection -> detection.usesMobileBrowser()));
        DeviceMatch.a("os-iOS", new c("iOS device (iPhone or iPad)", string -> string.startsWith("iOS")));
        DeviceMatch.a("os-Android", new c("Android device (phone or tablet)", string -> string.startsWith("Android")));
        DeviceMatch.a("os-Windows", new c("Windows", string -> string.startsWith("Windows")));
        DeviceMatch.a("os-macOS", new c("macOS", string -> string.toLowerCase(Locale.ENGLISH).startsWith("mac")));
    }

    private static void a(String string, String string2) {
        a.put(string, new e(string2, string));
    }

    private static void a(String string, b b2) {
        a.put(string, b2);
    }

    private static void a(String string, c c2) {
        a.put(string, c2);
    }

    public static boolean match(EnvProps envProps, String string) {
        Object object;
        try {
            IMatchDescription iMatchDescription = a.get(string);
            if (iMatchDescription != null) {
                return iMatchDescription.matches(envProps);
            }
            object = "Device match string \"" + string + "\" not found";
        }
        catch (Exception exception) {
            object = exception.getMessage();
        }
        ILog.WARNING(DeviceMatch.class, (String)object);
        return false;
    }

    public static String getDescription(String string) {
        IMatchDescription iMatchDescription = a.get(string);
        return iMatchDescription != null ? iMatchDescription.getDescription() : null;
    }

    public static boolean exists(String string) {
        return a.containsKey(string);
    }

    public static Map<String, String> getMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, IMatchDescription> entry : a.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().getDescription());
        }
        return hashMap;
    }

    private static Size a(EnvProps envProps) throws Exception {
        return envProps.getScreenSize();
    }

    private static String a(EnvProps envProps) throws Exception {
        try {
            String string = envProps.getClientEnv().getValue("navigator.platform");
            if (string != null) {
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new Exception("Failed retrieving 'navigator.platform' string");
    }

    public static String getUserAgent(EnvProps envProps) throws Exception {
        try {
            String string = envProps.getClientEnv().getValue("navigator.userAgent");
            if (string != null) {
                return string;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new Exception("Failed retrieving 'navigator.userAgent' string");
    }

    public static Client getParsedUserAgent(EnvProps envProps) throws Exception {
        Client client = envProps.getCachedValue("pua", Client.class);
        if (client == null) {
            String string = DeviceMatch.getUserAgent(envProps);
            client = a.parse(string);
            envProps.setCachedValue("pua", client);
        }
        return client;
    }

    public static Detection getDeviceDetectionFromUserAgent(EnvProps envProps) throws Exception {
        Detection detection = envProps.getCachedValue("dua", Detection.class);
        if (detection == null) {
            String string = DeviceMatch.getUserAgent(envProps);
            detection = a.detect(string);
            envProps.setCachedValue("dua", detection);
        }
        return detection;
    }

    public static String getDeviceDetectionOperatingSystemFromUserAgent(EnvProps envProps) throws Exception {
        String string = envProps.getCachedValue("dos", String.class);
        if (string == null) {
            Detection detection = DeviceMatch.getDeviceDetectionFromUserAgent(envProps);
            string = detection.getOperatingSystem().map(operatingSystem -> operatingSystem.toString()).orElse("unknown");
            envProps.setCachedValue("dos", string);
        }
        return string;
    }

    static IInfoProvider a(EnvProps envProps) {
        IInfoProvider iInfoProvider = envProps.getCachedValue("info", IInfoProvider.class);
        if (iInfoProvider == null) {
            iInfoProvider = new d(envProps);
            envProps.setCachedValue("info", iInfoProvider);
        }
        return iInfoProvider;
    }

    public static boolean isiOS(EnvProps envProps) throws Exception {
        String string = DeviceMatch.a(envProps).toLowerCase();
        return string.contains("ipad") || string.contains("iphone");
    }

    public static boolean isAndroid(EnvProps envProps) throws Exception {
        Client client = a.parse(DeviceMatch.getUserAgent(envProps));
        if ("Android".equalsIgnoreCase(client.os.family)) {
            return true;
        }
        String string = DeviceMatch.a(envProps).toLowerCase();
        return string.contains("android");
    }

    public static boolean isWinPhone(EnvProps envProps) throws Exception {
        Client client = a.parse(DeviceMatch.getUserAgent(envProps));
        return "Windows Phone".equalsIgnoreCase(client.os.family) || "Windows RT".equalsIgnoreCase(client.os.family);
    }

    public static boolean isMac(EnvProps envProps) throws Exception {
        return DeviceMatch.a(envProps).toLowerCase().contains("mac");
    }

    @Deprecated
    public static boolean isDesktop(EnvProps envProps) throws Exception {
        String string = DeviceMatch.a(envProps).toLowerCase();
        String string2 = DeviceMatch.getUserAgent(envProps).toLowerCase();
        return !string.contains("ipad") && !string.contains("iphone") && !string.contains("android") && !string2.contains("android") && !string2.contains("arm") && !DeviceMatch.isWinPhone(envProps);
    }

    public static String getSelectorMatch(String string) {
        Map.Entry<String, IMatchDescription> entry22;
        EnvProps envProps = new EnvProps(Atom.CLIENT);
        try {
            envProps.getClientEnv().put("navigator.userAgent", string);
        }
        catch (PropTypeException propTypeException) {
            ILog.SEVERE(DeviceMatch.class, "Failed creating 'navigator.userAgent' entry", propTypeException);
        }
        StringBuilder stringBuilder = new StringBuilder("User Agent = ").append(string).append("\n\n");
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        for (Map.Entry<String, IMatchDescription> entry22 : a.entrySet()) {
            String string22 = (String)entry22.getKey();
            if (string22.startsWith("size-") || string22.startsWith("orient-")) continue;
            IMatchDescription iMatchDescription = (IMatchDescription)entry22.getValue();
            if (iMatchDescription.isValid()) {
                try {
                    if (iMatchDescription.matches(envProps)) {
                        arrayList3.add(string22);
                        continue;
                    }
                    arrayList4.add(string22);
                }
                catch (Exception exception) {
                    arrayList.add((CallSite)((Object)(string22 + ": " + String.valueOf(exception))));
                    ILog.WARNING(DeviceMatch.class, "Matcher \"" + string22 + "\" failed", exception);
                }
                continue;
            }
            arrayList2.add(string22);
        }
        entry22 = "\n\u00a0-\u00a0";
        Object object = "";
        if (!arrayList3.isEmpty()) {
            object = "\n\n";
            arrayList3.sort((Comparator<String>)Collator.getInstance());
            stringBuilder.append("Matching:");
            for (String string2 : arrayList3) {
                stringBuilder.append((String)((Object)entry22)).append(string2);
            }
        }
        if (!arrayList4.isEmpty()) {
            stringBuilder.append((String)object).append("Not matching:");
            arrayList4.sort((Comparator<String>)Collator.getInstance());
            object = "\n\n";
            for (String string3 : arrayList4) {
                stringBuilder.append((String)((Object)entry22)).append(string3);
            }
        }
        if (!arrayList2.isEmpty()) {
            stringBuilder.append((String)object).append("Invalid:");
            arrayList2.sort((Comparator<String>)Collator.getInstance());
            object = "\n\n";
            for (String string4 : arrayList2) {
                stringBuilder.append((String)((Object)entry22)).append(string4);
            }
        }
        if (!arrayList.isEmpty()) {
            stringBuilder.append((String)object).append("Failed:");
            arrayList.sort((Comparator<CallSite>)Collator.getInstance());
            for (String string5 : arrayList) {
                stringBuilder.append((String)((Object)entry22)).append(string5);
            }
        }
        Detection detection = a.detect(string);
        stringBuilder.append("\n\nDevice: ").append(detection.getDevice().map(device -> device.toString()).orElse("unknown")).append("\nOS: ").append(detection.getOperatingSystem().map(operatingSystem -> operatingSystem.toString()).orElse("unknown")).append("\nClient: ").append(detection.getClient().map(client -> client.toString()).orElse("unknown"));
        if (detection.getDevice().isPresent()) {
            stringBuilder.append("\nType: ").append(((Device)detection.getDevice().get()).getType()).append("\nBrand: ").append(((Device)detection.getDevice().get()).getBrand().orElse("unknown")).append("\nModel: ").append(((Device)detection.getDevice().get()).getModel().orElse("unknown"));
        }
        return stringBuilder.toString();
    }
}

