/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.vs;

import com.iizix.ILog;
import com.iizix.event.GEvent;
import com.iizix.event.ResolveReferencesEvent;
import com.iizix.gyro.IAppSessionGyro;
import com.iizix.gyro.IClientSessionGyro;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.IPropReference;
import com.iizix.prop.IReferencingGProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropError;
import com.iizix.prop.PropErrorItem;
import com.iizix.prop.PropException;
import com.iizix.prop.PropReference;
import com.iizix.prop.PropValidateException;
import com.iizix.prop.StringProp;
import com.iizix.prop.vs.VSComponent;
import com.iizix.prop.vs.VSReference;
import com.iizix.prop.vs.VirtualSpace;

public abstract class VSRelativeReference<TARGET extends VSComponent>
extends StringProp
implements IPropReference,
IReferencingGProp {
    protected PropReference reference;
    protected String vsRefBase;
    protected TARGET currentTarget;
    protected TARGET fixedTarget;
    private static volatile /* synthetic */ int[] a;

    public VSRelativeReference() {
    }

    public VSRelativeReference(Atom atom) {
        super(atom);
    }

    public VSRelativeReference(Atom atom, String string) {
        super(atom);
        try {
            this.setPropValue(string);
        }
        catch (PropException propException) {
            throw new InternalError("Can't be!", propException);
        }
    }

    @Override
    protected boolean isPropPrivateAtCreation() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeReference() {
        PropReference propReference;
        VSRelativeReference vSRelativeReference = this;
        synchronized (vSRelativeReference) {
            propReference = this.reference;
            this.reference = null;
        }
        if (propReference != null) {
            propReference.dispose();
        }
        this.targetChanged(null);
    }

    @Override
    protected void onPropDispose() {
        this.disposeReference();
        super.onPropDispose();
        this.currentTarget = null;
        this.fixedTarget = null;
    }

    @Override
    public VSRelativeReference<TARGET> clone() {
        VSRelativeReference vSRelativeReference = (VSRelativeReference)super.clone();
        vSRelativeReference.reference = null;
        vSRelativeReference.vsRefBase = null;
        vSRelativeReference.currentTarget = null;
        vSRelativeReference.fixedTarget = null;
        return vSRelativeReference;
    }

    @Override
    protected VSRelativeReference<TARGET> virtualize(IAppSessionGyro iAppSessionGyro, IClientSessionGyro iClientSessionGyro, VirtualSpace virtualSpace) throws CloneNotSupportedException, PropException {
        TARGET TARGET = this.currentTarget;
        VSRelativeReference vSRelativeReference = (VSRelativeReference)super.virtualize(iAppSessionGyro, iClientSessionGyro, virtualSpace);
        if (TARGET != null) {
            assert (virtualSpace.isPropVirtualized()) : "VirtualSpace is not virtualized, expected virtualized instance";
            VirtualSpace virtualSpace2 = ((VSComponent)TARGET).getVirtualSpace();
            if (virtualSpace2 == virtualSpace.getNonVirtualized()) {
                Atom[] atomArray = ((GProp)TARGET).getAtomPath(virtualSpace2);
                GProp<?> gProp = virtualSpace.getProp(atomArray);
                assert (gProp != null) : "VS Component not found from path: " + String.valueOf(atomArray);
                if (TARGET.getClass().isInstance(gProp)) {
                    vSRelativeReference.fixedTarget = (VSComponent)gProp;
                    vSRelativeReference.currentTarget = vSRelativeReference.fixedTarget;
                } else {
                    vSRelativeReference.addError("Virtualized relative VS reference '" + ((GProp)TARGET).getReferencePropName() + "' not found");
                }
            }
        }
        return vSRelativeReference;
    }

    @Override
    protected boolean equalsErrors(PropError propError, PropError propError2, int n2) {
        return (n2 & 3) != 0 || super.equalsErrors(propError, propError2, n2);
    }

    @Override
    public final void onEventSelf(GEvent gEvent) {
        switch (gEvent.getEventID()) {
            case 1: {
                if (gEvent.getSource() != this) break;
                this.fixedTarget = null;
                this.targetChanged(null);
                this.disposeReference();
                this.createReference(gEvent);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                if (this.fixedTarget != null) break;
                this.onVSReferenceChanged(gEvent);
                break;
            }
            case 18: {
                if (this.fixedTarget != null || gEvent.getSource() == this) break;
                this.onVSReferenceChanged(gEvent);
            }
        }
    }

    @Override
    protected void onReferenceEvent(ResolveReferencesEvent resolveReferencesEvent) {
        if (resolveReferencesEvent.isPostResolving()) {
            this.resolve(resolveReferencesEvent.doReCheck(), resolveReferencesEvent);
        }
    }

    @Override
    protected final void onPropParentChanged(PropCnr propCnr, PropCnr propCnr2) {
        if (this.fixedTarget != null) {
            if (propCnr == null && propCnr2 != null && this.currentTarget != this.fixedTarget) {
                this.currentTarget = this.fixedTarget;
                this.a(this.currentTarget);
            }
        } else if (propCnr2 != null) {
            this.resolve(true, null);
        }
    }

    public void resolve(boolean bl, GEvent gEvent) {
        if (this.fixedTarget == null) {
            PropReference propReference = this.reference;
            if (propReference == null) {
                this.createReference(gEvent);
            } else {
                VSReference vSReference;
                if (!(!bl && this.vsRefBase != null || (vSReference = this.getVSReference(this.getPropAtom())) != null && vSReference.isValid())) {
                    this.setInvalid();
                    return;
                }
                this.resolve(propReference, bl, gEvent);
            }
        }
    }

    public String getReference() {
        String string;
        VSReference vSReference;
        Object object = this.getString();
        if (object == null) {
            return null;
        }
        PropReference propReference = this.reference;
        if (propReference != null) {
            return propReference.getName();
        }
        String string2 = "???";
        PropCnr propCnr = this.getParent();
        if (propCnr != null && (vSReference = propCnr.getVSReference(this.getPropAtom())) != null && (string = vSReference.getReference()) != null && !string.isEmpty()) {
            string2 = string;
        }
        if (!((String)object).isEmpty()) {
            object = "/" + (String)object;
        }
        return string2 + (String)object;
    }

    protected void onVSReferenceChanged(GEvent gEvent) {
        PropCnr propCnr = this.getParent();
        if (propCnr == null || !this.isPropReferenceTreeValid()) {
            this.targetChanged(null);
            this.clearError();
            return;
        }
        VSReference vSReference = propCnr.getVSReference(this.getPropAtom());
        if (vSReference == null) {
            this.setInvalid();
            return;
        }
        String string = vSReference.getReference();
        if (string == null || string.isEmpty()) {
            this.clearError();
            return;
        }
        String string2 = this.getString();
        if (string2 == null) {
            this.vsRefBase = null;
            this.clearError();
            return;
        }
        boolean bl = this.vsRefBase != string;
        this.vsRefBase = string;
        PropReference propReference = this.reference;
        if (propReference == null) {
            this.createReference(gEvent);
        } else {
            Object object = string2.isEmpty() ? "" : "/" + string2;
            this.resolve(propReference, bl |= propReference.setName(string + (String)object), gEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInvalid() {
        String string;
        VSRelativeReference vSRelativeReference = this;
        synchronized (vSRelativeReference) {
            this.vsRefBase = null;
            string = this.getString();
        }
        if (string == null) {
            this.clearError();
        } else {
            this.addError("Invalid main reference to VirtualSpace");
        }
        this.targetChanged(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createReference(GEvent gEvent) {
        String string = this.getString();
        if (string == null) {
            this.vsRefBase = null;
            this.clearError();
            this.targetChanged(null);
        } else if (this.isPropReferenceTreeValid()) {
            VSReference vSReference = this.getVSReference(this.getPropAtom());
            if (vSReference == null || !vSReference.isValid()) {
                this.setInvalid();
                return;
            }
            String string2 = vSReference.getReference();
            if (string2 != null && !string2.isEmpty()) {
                PropReference propReference;
                VSRelativeReference vSRelativeReference = this;
                synchronized (vSRelativeReference) {
                    this.vsRefBase = string2;
                    propReference = this.reference;
                    if (propReference == null) {
                        Object object = string.isEmpty() ? string : "/" + string;
                        propReference = this.reference = new PropReference(this, string2 + (String)object, null, this);
                    }
                }
                this.resolve(propReference, false, gEvent);
            }
        }
    }

    protected final void resolve(PropReference propReference, boolean bl, GEvent gEvent) {
        if (!this.isPropReferenceTreeValid()) {
            this.clearError();
            this.targetChanged(null);
        } else if (propReference.resolve(bl, gEvent) != 0) {
            this.clearError();
            this.targetChanged(propReference.getProperty());
        } else {
            if (this.getPropError("ref") == null) {
                this.addError("Reference '" + propReference.getName() + "' not found");
            }
            this.targetChanged(null);
        }
    }

    @Override
    public void onReferenceEvent(PropReference propReference, IPropReference.ReferenceChangeEvent referenceChangeEvent, GEvent gEvent) {
        String string = propReference.getName();
        switch (VSRelativeReference.a()[referenceChangeEvent.ordinal()]) {
            case 1: {
                this.clearError();
                this.targetChanged(propReference.getProperty());
                break;
            }
            case 2: {
                this.addError("Invalid reference '" + string + "' type: must be " + this.getReferenceType().getFallback());
                this.targetChanged(null);
                break;
            }
            case 3: {
                this.addError("Reference '" + string + "' not found");
                this.targetChanged(null);
                break;
            }
            case 4: 
            case 5: {
                try {
                    String string2 = this.vsRefBase;
                    assert (string2 != null) : "Base reference not set";
                    if (!string.startsWith(string2)) {
                        this.addError("Reference '" + string + "' not child of main reference '" + string2 + "'");
                        this.targetChanged(null);
                        break;
                    }
                    this.clearError();
                    int n2 = string2.length();
                    this.setPropValue(string.length() > n2 && string.charAt(n2) == '/' ? string.substring(n2 + 1) : "");
                }
                catch (PropValidateException propValidateException) {
                    ILog.SEVERE(this.getClass(), "onReferenceEvent.setPropValue(referenceName)", propValidateException);
                }
                break;
            }
            case 6: {
                this.addError("Reference '" + string + "' not found, disposed");
                this.targetChanged(null);
            }
        }
    }

    protected final void clearError() {
        this.removePropError("ref");
    }

    protected final void addError(String string) {
        if (this.isPropReferenceTreeValid()) {
            this.addPropError(new PropErrorItem("ref", string, 2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void targetChanged(GProp<?> gProp) {
        TARGET TARGET;
        VSComponent vSComponent = gProp != null && !gProp.isDisposed() && this.isReferenceValid(gProp) ? (VSComponent)gProp : null;
        VSRelativeReference vSRelativeReference = this;
        synchronized (vSRelativeReference) {
            if (vSComponent == this.currentTarget) {
                return;
            }
            TARGET = this.currentTarget;
            this.currentTarget = vSComponent;
        }
        if (TARGET != null) {
            this.onRemoved(TARGET);
        }
        if (vSComponent != null) {
            this.a(vSComponent);
        }
    }

    public final TARGET getVSTarget() {
        GProp<?> gProp;
        if (this.fixedTarget != null) {
            return this.fixedTarget;
        }
        PropReference propReference = this.reference;
        if (propReference != null && (gProp = propReference.getProperty()) != null && !gProp.isDisposed() && this.isReferenceValid(gProp)) {
            return (TARGET)((VSComponent)gProp);
        }
        return null;
    }

    @Override
    public boolean isReferenceValid(GProp<?> gProp) {
        return this.getPropertyClass().isInstance(gProp);
    }

    private void a(TARGET TARGET) {
        if (!this.isPropVirtualizing()) {
            this.onResolved(TARGET);
        }
    }

    @Override
    protected void onVirtualizationCompleted(IAppSessionGyro iAppSessionGyro, IClientSessionGyro iClientSessionGyro, VirtualSpace virtualSpace, boolean bl) {
        TARGET TARGET;
        if (bl && (TARGET = this.currentTarget) != null) {
            this.onResolved(TARGET);
        }
    }

    @Override
    protected String paramString() {
        return super.paramString() + ",reference=" + PropReference.toString(this.reference) + ",vsRefBase=" + this.vsRefBase + ",currentTarget=" + String.valueOf(this.currentTarget) + ",fixedTarget=" + String.valueOf(this.fixedTarget);
    }

    public abstract Class<? extends GProp<?>> getPropertyClass();

    @Override
    public abstract IPropReference.IRefType getReferenceType();

    protected abstract void onResolved(TARGET var1);

    protected abstract void onRemoved(TARGET var1);

    static /* synthetic */ int[] a() {
        if (a != null) {
            return a;
        }
        int[] nArray = new int[IPropReference.ReferenceChangeEvent.values().length];
        try {
            nArray[IPropReference.ReferenceChangeEvent.BROKEN.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IPropReference.ReferenceChangeEvent.DISPOSED.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IPropReference.ReferenceChangeEvent.FOUND.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IPropReference.ReferenceChangeEvent.FOUND_WRONG_CLASS.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IPropReference.ReferenceChangeEvent.MOVED.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IPropReference.ReferenceChangeEvent.RENAMED.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        a = nArray;
        return nArray;
    }
}

