/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.ui.value;

import com.iizix.ILog;
import com.iizix.prop.Atom;
import com.iizix.prop.DateTimeProp;
import com.iizix.prop.GDateTime;
import com.iizix.prop.PropException;
import com.iizix.prop.ui.value.IUIDateTimeComponent;
import java.time.LocalDate;
import java.util.Date;

public interface IUIDateValueComponent
extends IUIDateTimeComponent {
    @Override
    default public boolean isDateValueSupported() {
        return true;
    }

    @Override
    default public boolean isDateValueRequired() {
        return true;
    }

    @Override
    default public boolean isTimeValueSupported() {
        return false;
    }

    @Override
    default public boolean isTimeValueRequired() {
        return false;
    }

    @Override
    default public boolean setValue(GDateTime gDateTime) throws IllegalArgumentException {
        try {
            gDateTime = gDateTime.toDateValue();
            DateTimeProp dateTimeProp = this.getProp(Atom.VALUE, DateTimeProp.class);
            if (dateTimeProp != null) {
                return dateTimeProp.setPropValue(gDateTime);
            }
            dateTimeProp = this.createValueProp();
            dateTimeProp.setPropValue(gDateTime);
            return this.setProp(dateTimeProp);
        }
        catch (PropException propException) {
            ILog.SEVERE(this.getClass(), "Failed setting value: " + String.valueOf(gDateTime), propException);
            return false;
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException("Value has no date component: " + String.valueOf(gDateTime), illegalStateException);
        }
    }

    default public boolean setValue(LocalDate localDate) throws IllegalArgumentException {
        return this.setValue(new GDateTime(localDate));
    }

    default public boolean setValue(Date date) throws IllegalArgumentException {
        return this.setValue(GDateTime.fromDate(date));
    }

    default public LocalDate getLocalDate() {
        return this.getValue().toLocalDate();
    }
}

