/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.ui.selection;

import com.iizix.IntArrayList;
import com.iizix.prop.ui.selection.IUIIndexedSelection;
import com.iizix.prop.ui.selection.IUISelectionComp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public interface IUIIndexedSelectionComp
extends IUISelectionComp {
    public String clearSelection();

    public int getFirstSelectedIndex();

    public int[] getSelectedIndicies();

    public String setSelection(int var1);

    public String setSelection(int[] var1);

    default public String setSelection(IntArrayList intArrayList) {
        return intArrayList.isEmpty() ? this.setSelection(IUIIndexedSelection.EMPTY) : this.setSelection(intArrayList.toArray());
    }

    default public String setSelection(List<Integer> list) {
        int n2 = list.size();
        if (n2 == 0) {
            return this.setSelection(IUIIndexedSelection.EMPTY);
        }
        int[] nArray = new int[n2];
        while (--n2 >= 0) {
            nArray[n2] = list.get(n2);
        }
        return this.setSelection(nArray);
    }

    default public String setSelection(Collection<Integer> collection) {
        int n2 = collection.size();
        if (n2 == 0) {
            return this.setSelection(IUIIndexedSelection.EMPTY);
        }
        int[] nArray = new int[n2];
        try {
            Iterator<Integer> iterator = collection.iterator();
            int n3 = 0;
            while (n3 < n2) {
                nArray[n3++] = iterator.next();
            }
            if (iterator.hasNext()) {
                return "Concurrent modification: indiciesCollection modified during call to setSelection (elements were added)";
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return "Concurrent modification: indiciesCollection modified during call to setSelection (fewer elements)";
        }
        return this.setSelection(nArray);
    }

    default public String setSelection(Iterable<Integer> iterable) {
        return this.setSelection(iterable.iterator());
    }

    default public String setSelection(Iterator<Integer> iterator) {
        if (!iterator.hasNext()) {
            return this.setSelection(IUIIndexedSelection.EMPTY);
        }
        IntArrayList intArrayList = new IntArrayList();
        try {
            do {
                intArrayList.add(iterator.next());
            } while (iterator.hasNext());
        }
        catch (NoSuchElementException noSuchElementException) {
            return "Concurrent modification: indiciesIterator collection modified during call to setSelection (element removed)";
        }
        return this.setSelection(intArrayList.toArray());
    }

    @Override
    default public boolean isSelectionIndexBased() {
        return true;
    }
}

