/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.license;

import com.iizix.ILog;
import com.iizix.Utilities;
import com.iizix.user.IBasicUserInfoDetailNames;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.zip.CRC32;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ProfilePicture
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 861913089086797397L;
    private static final String[] a = new String[]{"IZS-UploadImage", "IZS-LargeImage", "IZS-ThumbnailImage"};
    private int a;
    private String a;
    private byte[] a;
    private transient Path a;
    private transient File a;
    private transient int b;

    private static int a(String string) {
        if (string == null) {
            return 0;
        }
        int n2 = 0;
        while (n2 < 3) {
            if (string.equals(a[n2])) {
                return n2;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Invalid profile picture type: " + string);
    }

    public ProfilePicture(File file) throws IOException {
        this(file, "IZS-UploadImage");
    }

    public ProfilePicture(File file, String string) throws IOException {
        if (!file.isFile()) {
            throw new FileNotFoundException("File not found: " + file.getPath());
        }
        this.a = ProfilePicture.a(string);
        this.a = file.getName();
        String string2 = this.a.toLowerCase();
        if (!(string2.endsWith(".jpg") || string2.endsWith(".jpeg") || string2.endsWith(".png"))) {
            throw new IOException("File extension for \"" + file.getPath() + "\" must be either .png, .jpg or .jpeg");
        }
        long l2 = file.length();
        if (l2 > 0x100000L) {
            throw new IOException("Profile picture file \"" + file.getPath() + "\" is larger than 1 MB");
        }
        try {
            this.a = Files.readAllBytes(file.toPath());
        }
        catch (InvalidPathException invalidPathException) {
            throw new IOException("Invalid path: " + file.getAbsolutePath(), invalidPathException);
        }
    }

    public ProfilePicture(String string, String string2, byte[] byArray) {
        this.a = ProfilePicture.a(string);
        this.a = string2;
        this.a = byArray;
    }

    public ProfilePicture clone() {
        try {
            ProfilePicture profilePicture = (ProfilePicture)super.clone();
            profilePicture.a = null;
            profilePicture.a = null;
            return profilePicture;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    public String getType() {
        return a[this.a];
    }

    public String getName() {
        return this.a;
    }

    public ByteArrayInputStream getImageInputStream() {
        return new ByteArrayInputStream(this.a);
    }

    public int getImageDataSize() {
        return this.a.length;
    }

    public String getImageExtension() {
        return this.a.toLowerCase().endsWith(".png") ? "png" : "jpg";
    }

    public synchronized boolean deleteTemporaries() {
        if (this.a != null) {
            try {
                Files.deleteIfExists(this.a.toPath());
            }
            catch (IOException | InvalidPathException exception) {
                ILog.WARNING(this.getClass(), "Failed deleting temporary profile picture file " + this.a.getPath() + ": " + exception.getMessage());
            }
            this.a = null;
        }
        if (this.a != null) {
            try {
                Utilities.deleteDirectoryRecursive(this.a, null);
            }
            catch (IOException iOException) {
                ILog.WARNING(this.getClass(), "Failed deleting temporary profile picture directory " + String.valueOf(this.a) + ": " + iOException.getMessage());
            }
            this.a = null;
        }
        return true;
    }

    public synchronized File getFile(File file, boolean bl) throws IOException {
        if (!bl) {
            this.deleteTemporaries();
        }
        if (file != null && !bl) {
            if (!file.isDirectory()) {
                throw new IOException("'dir' parameter is not a directory");
            }
            file = Utilities.getCanonicalFile(file);
        } else {
            bl = true;
            this.a = Files.createTempDirectory("izProfilePicure", new FileAttribute[0]);
            file = this.a.toFile();
        }
        File file2 = new File(file, this.a);
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
            fileOutputStream.write(this.a);
            fileOutputStream.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (bl) {
            this.a = file2;
        }
        return file2;
    }

    public synchronized File getFile() throws IOException {
        this.deleteTemporaries();
        int n2 = this.a.lastIndexOf(46);
        String string = n2 < 0 ? this.a : this.a.substring(0, n2);
        String string2 = "." + this.getImageExtension();
        if (string.length() < 3) {
            string = (string + "---").substring(0, 3);
        }
        this.a = File.createTempFile(string, string2);
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.a);){
            fileOutputStream.write(this.a);
            fileOutputStream.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return this.a;
    }

    public String toString() {
        return this.getClass().getName() + "[fileName=" + this.a + ",size=" + this.a.length + ",type=" + a[this.a] + "]";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ProfilePicture) {
            ProfilePicture profilePicture = (ProfilePicture)object;
            return this.a == profilePicture.a && this.a.equals(profilePicture.a) && Arrays.equals(this.a, profilePicture.a);
        }
        return false;
    }

    public int hashCode() {
        if (this.b == 0) {
            CRC32 cRC32 = new CRC32();
            cRC32.update(this.a);
            this.b = this.a.hashCode() ^ this.a * 11 ^ (int)cRC32.getValue();
        }
        return this.b;
    }

    protected void finalize() throws Throwable {
        try {
            this.deleteTemporaries();
        }
        catch (Throwable throwable) {
            ILog.SEVERE(this.getClass(), "Failed finalize", throwable);
        }
        super.finalize();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(this.a);
        byte[] byArray = this.a.getBytes(Utilities.UTF8);
        objectOutputStream.writeShort(byArray.length);
        objectOutputStream.write(byArray);
        objectOutputStream.writeInt(this.a.length);
        objectOutputStream.write(this.a);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.a = objectInputStream.readByte();
        if (this.a < 0 || this.a >= IBasicUserInfoDetailNames.profilePictureDetailsList.size()) {
            throw new IOException("Invalid type: " + this.a);
        }
        int n2 = objectInputStream.readShort();
        byte[] byArray = new byte[n2];
        objectInputStream.readFully(byArray);
        this.a = new String(byArray, Utilities.UTF8);
        n2 = objectInputStream.readInt();
        this.a = new byte[n2];
        objectInputStream.readFully(this.a);
    }
}

