/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.region;

import com.iizix.ILog;
import com.iizix.IWebServiceEngine;
import com.iizix.Utilities;
import com.iizix.geo.RegionLocation;
import com.iizix.geo.RegionLocationService;
import com.iizix.server.prop.ServerSettings;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class IPStack
extends RegionLocationService {
    private final String a;
    private final Proxy a;
    private String b = "f60e6d2e793061a70b505b267fd01d07";

    public IPStack(IWebServiceEngine iWebServiceEngine, ServerSettings serverSettings) {
        super("IPStack", 20000L);
        String string = serverSettings.getRegionLocationAPIKey("IPStack.com");
        if (string != null && !(string = string.trim()).isEmpty()) {
            this.b = string;
        }
        this.a = "http://api.ipstack.com/";
        try {
            this.a = iWebServiceEngine.getProxy(new URI(this.a).toURL());
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new InternalError("Shouldn't be", exception);
        }
    }

    protected boolean isAvailable() {
        return this.b != null;
    }

    protected RegionLocation request(String string) throws IOException, InterruptedIOException, InterruptedException {
        URL uRL;
        String string2 = this.a + Utilities.encodeURIComponent((String)string) + "?access_key=" + Utilities.encodeURIComponent((String)this.b);
        try {
            uRL = new URI(string2).toURL();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new IOException("IPStack URL " + string2 + " is invalid", exception);
        }
        JSONObject jSONObject = this.parse(uRL.openConnection(this.a));
        try {
            Object object;
            String string3;
            JSONArray jSONArray;
            if (jSONObject.isNull("type") || jSONObject.isNull("country_code") || !jSONObject.optBoolean("success", true)) {
                return new RegionLocation(string, (String)(jSONObject.has("message") ? "IPStack: " + String.valueOf(jSONObject.get("message")) : "IPStack: not found"));
            }
            String string4 = null;
            RegionLocation.Language[] languageArray = null;
            JSONObject jSONObject2 = jSONObject.optJSONObject("location");
            if (jSONObject2 != null) {
                string4 = jSONObject2.optString("geoname_id", null);
                jSONArray = jSONObject2.optJSONArray("languages");
                if (jSONArray != null) {
                    int n = jSONArray.length();
                    languageArray = new RegionLocation.Language[n];
                    while (--n >= 0) {
                        string3 = jSONArray.optJSONObject(n);
                        if (string3 == null || (object = string3.optString("code", null)) == null) {
                            ILog.WARNING(((Object)((Object)this)).getClass(), (String)("Failed parsing languages for IP address " + string + ", JSON:\n" + jSONArray.toString(2)));
                            languageArray = null;
                            break;
                        }
                        languageArray[n] = RegionLocation.languageFrom((String)object, (String)string3.optString("name"), (String)string3.optString("native"));
                    }
                }
            }
            jSONArray = null;
            jSONObject2 = jSONObject.optJSONObject("time_zone");
            if (jSONObject2 != null) {
                String string5 = jSONObject2.optString("id");
                string3 = jSONObject2.optString("code", null);
                object = jSONObject2.has("gmt_offset") ? Integer.valueOf(jSONObject2.optInt("gmt_offset", 0)) : null;
                jSONArray = RegionLocation.timezoneFrom((String)string5, (String)string3, (Integer)object);
            }
            RegionLocation.Currency currency = null;
            jSONObject2 = jSONObject.optJSONObject("currency");
            if (jSONObject2 != null) {
                currency = RegionLocation.currencyFrom((String)jSONObject2.optString("code"), (String)jSONObject2.optString("name"), (String)jSONObject2.optString("plural"), (String)jSONObject2.optString("symbol"), (String)jSONObject2.optString("symbol_native"));
            }
            string3 = null;
            jSONObject2 = jSONObject.optJSONObject("connection");
            if (jSONObject2 != null) {
                string3 = RegionLocation.connectionFrom((String)jSONObject2.optString("asn"), (String)jSONObject2.optString("isp"));
            }
            object = null;
            jSONObject2 = jSONObject.optJSONObject("security");
            if (jSONObject2 != null) {
                String[] stringArray;
                Boolean bl = jSONObject2.has("is_proxy") ? Boolean.valueOf(jSONObject2.optBoolean("is_proxy")) : null;
                String string6 = jSONObject2.optString("proxy_type");
                Boolean bl2 = jSONObject2.has("is_crawler") ? Boolean.valueOf(jSONObject2.optBoolean("is_crawler")) : null;
                String string7 = jSONObject2.optString("crawler_name");
                String string8 = jSONObject2.optString("crawler_type");
                Boolean bl3 = jSONObject2.has("is_tor") ? Boolean.valueOf(jSONObject2.optBoolean("is_tor")) : null;
                int n = RegionLocation.securityThreadLevelFrom((String)jSONObject.optString("threat_level"));
                JSONArray jSONArray2 = jSONObject2.optJSONArray("threat_types");
                if (jSONArray2 == null) {
                    stringArray = new String[]{};
                } else {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    int n2 = 0;
                    int n3 = jSONArray2.length();
                    while (n2 < n3) {
                        String string9;
                        if ((string9 = jSONArray2.optString(n2++, null)) == null) continue;
                        arrayList.add(string9);
                    }
                    stringArray = arrayList.toArray(new String[arrayList.size()]);
                }
                object = new RegionLocation.Security(bl, string6, bl2, string7, string8, bl3, n, stringArray);
            }
            return new RegionLocation(string, jSONObject.optString("continent_name", null), jSONObject.optString("continent_code", null), jSONObject.optString("country_name", null), jSONObject.optString("country_code", null), -1, jSONObject.optString("region_name", null), jSONObject.optString("region_code", null), jSONObject.optString("city", null), null, -1, jSONObject.optString("zip", null), -1, jSONObject.optDouble("longitude"), jSONObject.optDouble("latitude"), -1.0, string4, (RegionLocation.Timezone)jSONArray, currency, languageArray, (RegionLocation.Connection)string3, (RegionLocation.Security)object);
        }
        catch (JSONException jSONException) {
            ILog.SEVERE(((Object)((Object)this)).getClass(), (String)("Failed extracting values from JSON for IP address " + string + ": " + jSONException.getMessage() + "\n" + jSONObject.toString(2)));
            return new RegionLocation(string, "Failed parsing JSON reply: " + jSONException.getMessage());
        }
    }
}

