/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.project;

import com.iizigo.Activator;
import com.iizigo.project.NewWizard;
import com.iizigo.project.NewWizardPage;
import com.iizigo.prop.DesignerProp;
import com.iizigo.prop.IPropDesigner;
import com.iizigo.prop.ResourceDesignerProp;
import com.iizix.ILog;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateFolderOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

public class NewFolderWizard
extends NewWizard {
    public static final String WIZARD_ID = NewFolderWizard.class.getName();
    private NewWizardPage a;

    public NewFolderWizard() {
        super("New Folder", "new_folder.png");
    }

    public void addPages() {
        this.a = new NewWizardPage(this, WIZARD_ID + ".page1", "New Folder", "Enter folder name and select location.", this.model, this.model.getRootContainer(), false);
        this.addPage((IWizardPage)this.a);
    }

    @Override
    public boolean performFinish() {
        IPropDesigner iPropDesigner = this.a.getItemContainer();
        IFolder iFolder = ((IFolder)iPropDesigner.getDesigner().getIResource()).getFolder(this.a.getItemNameAndExtension());
        if ((iFolder = this.a(iFolder)) == null) {
            return false;
        }
        ResourceDesignerProp resourceDesignerProp = DesignerProp.getInstance((IResource)iFolder);
        if (resourceDesignerProp == null) {
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)"Internal Error", (String)"The background workspace listener did not create an iiziGo Designer instance of the file!");
            return false;
        }
        if (this.lastViewer != null) {
            this.lastViewer.setSelection((ISelection)new StructuredSelection((Object)resourceDesignerProp), true);
        }
        return true;
    }

    private IFolder a(IFolder iFolder) {
        Shell shell = this.getShell();
        try {
            ResourcesPlugin.getWorkspace().run(iProgressMonitor -> {
                CreateFolderOperation createFolderOperation = new CreateFolderOperation(iFolder, null, "Create Folder");
                try {
                    IStatus iStatus = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)createFolderOperation, iProgressMonitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)shell));
                    if (!iStatus.isOK()) {
                        ILog.SEVERE(((Object)((Object)this)).getClass(), (String)"performOperations failed", (Object)iStatus);
                        throw new CoreException(iStatus);
                    }
                }
                catch (ExecutionException executionException) {
                    ILog.SEVERE(((Object)((Object)this)).getClass(), (String)"performOperations", (Throwable)executionException);
                    Throwable throwable = executionException.getCause();
                    if (throwable instanceof CoreException) {
                        CoreException coreException = (CoreException)throwable;
                        throw coreException;
                    }
                    throw new CoreException((IStatus)Activator.createErrorStatus("Failed creating folder", executionException));
                }
            }, null, 1, null);
            return iFolder;
        }
        catch (CoreException coreException) {
            String string = "Failed creating folder: " + coreException.getStatus().getMessage();
            ILog.SEVERE(((Object)((Object)this)).getClass(), (String)string, (Throwable)coreException);
            MessageDialog.openError((Shell)shell, (String)"Folder Creation Error", (String)string);
            return null;
        }
    }
}

