/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.translate.google;

import com.iizix.ILog;
import com.iizix.text.KString;
import com.iizix.translate.ITranslator;
import com.iizix.translate.RequestException;
import com.iizix.translate.Translation;
import com.iizix.translate.TranslationEngine;
import com.iizix.translate.TranslationException;
import com.iizix.translate.google.DetectedLanguage;
import com.iizix.translate.google.Language;
import com.iizix.translate.google.LanguageInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class GoogleTranslate
implements ITranslator {
    protected String serverLockedIP_API_Key;
    private HashMap<String, LanguageInfo> a;

    public static String[] getLanguages(String string) throws RequestException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("key", string);
        try {
            JSONObject jSONObject = TranslationEngine.getInstance().requestJSON("https://www.googleapis.com/language/translate/v2/languages", hashMap, null, 1, 5120);
            JSONObject jSONObject2 = jSONObject.getJSONObject("data");
            JSONArray jSONArray = jSONObject2.getJSONArray("languages");
            int n2 = jSONArray.length();
            String[] stringArray = new String[n2];
            int n3 = 0;
            while (n3 < n2) {
                JSONObject jSONObject3 = jSONArray.getJSONObject(n3);
                stringArray[n3] = jSONObject3.getString("language");
                ++n3;
            }
            return stringArray;
        }
        catch (RequestException requestException) {
            throw requestException;
        }
        catch (IOException iOException) {
            throw new RequestException("Google Translate connection error", iOException);
        }
        catch (JSONException jSONException) {
            throw new RequestException("Google Translate reply format error", jSONException);
        }
    }

    public static LanguageInfo[] getLanguages(String string, Language language) throws RequestException {
        if (language.equals((Object)Language.Auto_detect)) {
            throw new RequestException("Cannot use Auto_detect");
        }
        return GoogleTranslate.getLanguages(string, language.langID);
    }

    public static LanguageInfo[] getLanguages(String string, String string2) throws RequestException {
        if (string2 == null || string2.isEmpty()) {
            throw new RequestException("Target language not specified");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("key", string);
        hashMap.put("target", string2);
        try {
            JSONObject jSONObject = TranslationEngine.getInstance().requestJSON("https://www.googleapis.com/language/translate/v2/languages", hashMap, null, 1, 5120);
            JSONObject jSONObject2 = jSONObject.getJSONObject("data");
            JSONArray jSONArray = jSONObject2.getJSONArray("languages");
            int n2 = jSONArray.length();
            LanguageInfo[] languageInfoArray = new LanguageInfo[n2];
            int n3 = 0;
            while (n3 < n2) {
                JSONObject jSONObject3 = jSONArray.getJSONObject(n3);
                languageInfoArray[n3] = new LanguageInfo(jSONObject3.getString("language"), jSONObject3.getString("name"));
                ++n3;
            }
            return languageInfoArray;
        }
        catch (RequestException requestException) {
            throw requestException;
        }
        catch (IOException iOException) {
            throw new RequestException("Google Translate connection error", iOException);
        }
        catch (JSONException jSONException) {
            throw new RequestException("Google Translate reply format error", jSONException);
        }
    }

    public static DetectedLanguage[] detectLanguages(String string, String string2) throws RequestException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("key", string);
        hashMap.put("q", string2);
        try {
            JSONObject jSONObject = TranslationEngine.getInstance().requestJSON("https://www.googleapis.com/language/translate/v2/detect", hashMap, null, 1, 5120);
            JSONObject jSONObject2 = jSONObject.getJSONObject("data");
            JSONArray jSONArray = jSONObject2.getJSONArray("detections");
            ArrayList<DetectedLanguage> arrayList = new ArrayList<DetectedLanguage>();
            int n2 = jSONArray.length();
            int n3 = 0;
            while (n3 < n2) {
                JSONArray jSONArray2 = jSONArray.getJSONArray(n3);
                int n4 = 0;
                int n5 = jSONArray2.length();
                while (n4 < n5) {
                    JSONObject jSONObject3 = jSONArray2.getJSONObject(n4);
                    arrayList.add(new DetectedLanguage(jSONObject3.getString("language"), jSONObject3.getBoolean("isReliable"), jSONObject3.getDouble("confidence")));
                    ++n4;
                }
                ++n3;
            }
            return arrayList.toArray(new DetectedLanguage[arrayList.size()]);
        }
        catch (RequestException requestException) {
            throw requestException;
        }
        catch (IOException iOException) {
            throw new RequestException("Google Translate connection error", iOException);
        }
        catch (JSONException jSONException) {
            throw new RequestException("Google Translate reply format error", jSONException);
        }
    }

    public static Translation translate(ITranslator iTranslator, String string, KString kString, String string2, String string3) throws TranslationException, RequestException {
        if (string3 == null || string3.isEmpty()) {
            throw new TranslationException("Target language not specified");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("key", string);
        hashMap.put("target", string3);
        if (!kString.isHTML()) {
            hashMap.put("format", "text");
        }
        if (string2 != null && !string2.isEmpty()) {
            hashMap.put("source", string2);
        }
        String string4 = kString.getRawString();
        hashMap.put("q", string4);
        JSONObject jSONObject = null;
        try {
            jSONObject = TranslationEngine.getInstance().requestJSON("https://www.googleapis.com/language/translate/v2", hashMap, null, 1, 5120);
            JSONObject jSONObject2 = jSONObject.getJSONObject("data");
            JSONArray jSONArray = jSONObject2.getJSONArray("translations");
            int n2 = jSONArray.length();
            if (n2 != 1) {
                throw new JSONException("One translation expected, found " + n2);
            }
            JSONObject jSONObject3 = jSONArray.getJSONObject(0);
            if (string2 == null || string2.isEmpty()) {
                try {
                    string2 = jSONObject3.getString("detectedSourceLanguage");
                }
                catch (JSONException jSONException) {
                    string2 = "";
                }
            }
            return new Translation(iTranslator, kString, string4, string2, jSONObject3.getString("translatedText"), string3);
        }
        catch (RequestException requestException) {
            throw requestException;
        }
        catch (IOException iOException) {
            throw new RequestException("Google Translate connection error", iOException);
        }
        catch (JSONException jSONException) {
            throw new RequestException("Google Translate reply format error: JSON reply = " + String.valueOf(jSONObject), jSONException);
        }
    }

    @Override
    public String getReadyState() {
        return this.serverLockedIP_API_Key != null ? null : "Missing API key, please configure Google Translate";
    }

    @Override
    public void updateSupportedLanguages() {
        if (this.serverLockedIP_API_Key == null) {
            return;
        }
        try {
            LanguageInfo[] languageInfoArray = GoogleTranslate.getLanguages(this.serverLockedIP_API_Key, "en");
            int n2 = languageInfoArray.length;
            CharSequence[] charSequenceArray = new String[n2];
            HashMap<String, LanguageInfo> hashMap = new HashMap<String, LanguageInfo>();
            while (--n2 >= 0) {
                charSequenceArray[n2] = languageInfoArray[n2].langID;
                hashMap.put(((String)charSequenceArray[n2]).toLowerCase(), languageInfoArray[n2]);
            }
            this.a = hashMap;
            ILog.INFO(this.getClass(), "Google Translate supported languages: " + String.join((CharSequence)", ", charSequenceArray));
        }
        catch (Exception exception) {
            ILog.WARNING(this.getClass(), "Failed retrieving the Google Translate supported languages: " + exception.getMessage());
        }
    }

    @Override
    public String getLanguageCode(String string) {
        Object object;
        HashMap<String, LanguageInfo> hashMap = this.a;
        if (hashMap != null && (object = hashMap.get(string.toLowerCase())) != null) {
            return ((LanguageInfo)object).langID;
        }
        object = Language.get(string);
        return object != null ? object.langID : null;
    }

    @Override
    public void deconfigure() {
        this.serverLockedIP_API_Key = null;
    }

    @Override
    public String getName() {
        return "Google Translate";
    }

    @Override
    public boolean isLanguageHandled(String string) {
        if (Language.get(string) != null) {
            return true;
        }
        HashMap<String, LanguageInfo> hashMap = this.a;
        return hashMap != null && hashMap.containsKey(string.toLowerCase());
    }

    @Override
    public String getLanguageDescription(String string) {
        Object object;
        if (string == null) {
            return "<auto-detect>";
        }
        HashMap<String, LanguageInfo> hashMap = this.a;
        if (hashMap != null && (object = hashMap.get(string.toLowerCase())) != null) {
            return ((LanguageInfo)object).name;
        }
        object = Language.get(string);
        if (object != null) {
            return object.toString();
        }
        return "<unsupported language code " + string + ">";
    }

    @Override
    public boolean canTranslate(String string, String string2) {
        HashMap<String, LanguageInfo> hashMap = this.a;
        return (string == null || Language.get(string) != null || hashMap != null && hashMap.containsKey(string.toLowerCase())) && (Language.get(string2) != null || hashMap != null && hashMap.containsKey(string2.toLowerCase()));
    }

    @Override
    public Translation translate(KString kString, String string, String string2) throws TranslationException, RequestException {
        String string3 = this.serverLockedIP_API_Key;
        if (string3 == null) {
            throw new TranslationException("Google Translate is not configured with Server IP locked key");
        }
        String string4 = this.getLanguageCode(string2);
        if (string4 != null) {
            string2 = string4;
        }
        if (string != null && (string4 = this.getLanguageCode(string)) != null) {
            string = string4;
        }
        return GoogleTranslate.translate(this, string3, kString, string, string2);
    }
}

