/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.knn.KnnSearchStrategy;

public class HnswQueueSaturationCollector
extends KnnCollector.Decorator {
    private final KnnCollector delegate;
    private final double saturationThreshold;
    private final int patience;
    private boolean patienceFinished;
    private int countSaturated;
    private int previousQueueSize;
    private int currentQueueSize;

    HnswQueueSaturationCollector(KnnCollector delegate, double saturationThreshold, int patience) {
        super(delegate);
        this.delegate = delegate;
        this.previousQueueSize = 0;
        this.currentQueueSize = 0;
        this.countSaturated = 0;
        this.patienceFinished = false;
        this.saturationThreshold = saturationThreshold;
        this.patience = patience;
    }

    @Override
    public boolean earlyTerminated() {
        return this.delegate.earlyTerminated() || this.patienceFinished;
    }

    @Override
    public boolean collect(int docId, float similarity) {
        boolean collect = this.delegate.collect(docId, similarity);
        if (collect) {
            ++this.currentQueueSize;
        }
        return collect;
    }

    @Override
    public TopDocs topDocs() {
        TopDocs topDocs;
        if (this.patienceFinished && !this.delegate.earlyTerminated()) {
            TopDocs delegateDocs = this.delegate.topDocs();
            TotalHits totalHits = new TotalHits(delegateDocs.totalHits.value(), TotalHits.Relation.EQUAL_TO);
            topDocs = new TopDocs(totalHits, delegateDocs.scoreDocs);
        } else {
            topDocs = this.delegate.topDocs();
        }
        return topDocs;
    }

    public void nextCandidate() {
        double queueSaturation = (double)Math.min(this.currentQueueSize, this.previousQueueSize) / (double)this.currentQueueSize;
        this.previousQueueSize = this.currentQueueSize;
        this.countSaturated = queueSaturation >= this.saturationThreshold ? ++this.countSaturated : 0;
        if (this.countSaturated > this.patience) {
            this.patienceFinished = true;
        }
    }

    @Override
    public KnnSearchStrategy getSearchStrategy() {
        KnnSearchStrategy delegateStrategy = this.delegate.getSearchStrategy();
        assert (delegateStrategy instanceof KnnSearchStrategy.Hnsw);
        return new KnnSearchStrategy.Patience(this, ((KnnSearchStrategy.Hnsw)delegateStrategy).filteredSearchThreshold());
    }
}

