/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.apache.derby.iapi.jdbc.EmbeddedDataSourceInterface;
import org.apache.derby.iapi.jdbc.EngineConnection;
import org.apache.derby.iapi.jdbc.ResourceAdapter;
import org.apache.derby.impl.jdbc.EmbedPooledConnection;
import org.apache.derby.impl.jdbc.EmbedXAResource;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.jdbc.XAStatementControl;

public class EmbedXAConnection
extends EmbedPooledConnection
implements XAConnection {
    private EmbedXAResource xaRes;

    public EmbedXAConnection(EmbeddedDataSourceInterface embeddedDataSourceInterface, ResourceAdapter resourceAdapter, String string, String string2, boolean bl) throws SQLException {
        super(embeddedDataSourceInterface, string, string2, bl);
        this.xaRes = new EmbedXAResource(this, resourceAdapter);
    }

    @Override
    public boolean isInGlobalTransaction() {
        return this.isGlobal();
    }

    private boolean isGlobal() {
        return this.xaRes.getCurrentXid() != null;
    }

    @Override
    public final synchronized XAResource getXAResource() throws SQLException {
        this.checkActive();
        return this.xaRes;
    }

    @Override
    public void checkAutoCommit(boolean bl) throws SQLException {
        if (bl && this.isGlobal()) {
            throw Util.generateCsSQLException("XJ056.S", new Object[0]);
        }
        super.checkAutoCommit(bl);
    }

    @Override
    public int checkHoldCursors(int n, boolean bl) throws SQLException {
        if (n == 1 && this.isGlobal()) {
            if (!bl) {
                throw Util.generateCsSQLException("XJ05C.S", new Object[0]);
            }
            n = 2;
        }
        return super.checkHoldCursors(n, bl);
    }

    @Override
    public void checkSavepoint() throws SQLException {
        if (this.isGlobal()) {
            throw Util.generateCsSQLException("XJ058.S", new Object[0]);
        }
        super.checkSavepoint();
    }

    @Override
    public void checkRollback() throws SQLException {
        if (this.isGlobal()) {
            throw Util.generateCsSQLException("XJ058.S", new Object[0]);
        }
        super.checkRollback();
    }

    @Override
    public void checkCommit() throws SQLException {
        if (this.isGlobal()) {
            throw Util.generateCsSQLException("XJ057.S", new Object[0]);
        }
        super.checkCommit();
    }

    @Override
    public void checkClose() throws SQLException {
        if (!this.isGlobal()) {
            super.checkClose();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection connection;
        if (!this.isGlobal()) {
            connection = super.getConnection();
        } else {
            if (this.currentConnectionHandle != null) {
                throw Util.generateCsSQLException("XJ059.S", new Object[0]);
            }
            connection = this.getNewCurrentConnectionHandle();
        }
        this.currentConnectionHandle.syncState();
        return connection;
    }

    @Override
    public Statement wrapStatement(Statement statement) throws SQLException {
        XAStatementControl xAStatementControl = new XAStatementControl(this, statement);
        return xAStatementControl.applicationStatement;
    }

    @Override
    public PreparedStatement wrapStatement(PreparedStatement preparedStatement, String string, Object object) throws SQLException {
        preparedStatement = super.wrapStatement(preparedStatement, string, object);
        XAStatementControl xAStatementControl = new XAStatementControl(this, preparedStatement, string, object);
        return (PreparedStatement)((Object)xAStatementControl.applicationStatement);
    }

    @Override
    public CallableStatement wrapStatement(CallableStatement callableStatement, String string) throws SQLException {
        callableStatement = super.wrapStatement(callableStatement, string);
        XAStatementControl xAStatementControl = new XAStatementControl(this, callableStatement, string);
        return (CallableStatement)((Object)xAStatementControl.applicationStatement);
    }

    @Override
    public EngineConnection getRealConnection() throws SQLException {
        EngineConnection engineConnection = super.getRealConnection();
        if (engineConnection != null) {
            return engineConnection;
        }
        this.openRealConnection();
        this.currentConnectionHandle.setState(true);
        return this.realConnection;
    }
}

