/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.license.history;

import com.iizix.Utilities;
import com.iizix.license.history.LicensingHistoryEvent;
import java.io.Serializable;

public final class LicensingHistoryEntry
implements Serializable {
    private static final long serialVersionUID = 44405006908339203L;
    protected long dateTime;
    protected LicensingHistoryEvent event;
    protected String text;

    public LicensingHistoryEntry(LicensingHistoryEvent licensingHistoryEvent, String string) {
        this(System.currentTimeMillis(), licensingHistoryEvent, string);
    }

    public LicensingHistoryEntry(long l2, LicensingHistoryEvent licensingHistoryEvent, String string) {
        if (licensingHistoryEvent == null) {
            throw new NullPointerException("event is null");
        }
        if (string == null) {
            throw new NullPointerException("text is null");
        }
        if (string.length() > 1000) {
            throw new IllegalArgumentException("text length (max 1000): " + string.length());
        }
        this.dateTime = l2;
        this.event = licensingHistoryEvent;
        this.text = string;
    }

    public long getDateTime() {
        return this.dateTime;
    }

    public LicensingHistoryEvent getEvent() {
        return this.event;
    }

    public String getText() {
        return this.text;
    }

    public boolean equals(Object object) {
        if (object instanceof LicensingHistoryEntry) {
            LicensingHistoryEntry licensingHistoryEntry = (LicensingHistoryEntry)object;
            return licensingHistoryEntry.dateTime == this.dateTime && licensingHistoryEntry.event.equals((Object)this.event) && licensingHistoryEntry.text.equals(this.text);
        }
        return false;
    }

    public int hashCode() {
        return (int)this.dateTime ^ this.event.hashCode() ^ this.text.hashCode();
    }

    public String toString() {
        return Utilities.formatDate(this.dateTime) + "  " + String.valueOf((Object)this.event) + ": " + this.text;
    }
}

