/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.barcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Writer;
import com.google.zxing.WriterException;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.iizix.barcode.BarcodeBuilder;
import com.iizix.barcode.BarcodeException;
import com.iizix.barcode.BarcodeURN;
import com.iizix.barcode.a;
import com.iizix.barcode.b;
import com.iizix.barcode.c;
import com.iizix.barcode.d;
import com.iizix.barcode.e;
import com.iizix.barcode.f;
import com.iizix.barcode.g;
import com.iizix.barcode.h;
import com.iizix.barcode.i;
import com.iizix.barcode.j;
import com.iizix.barcode.k;
import com.iizix.barcode.l;
import com.iizix.barcode.m;
import java.util.HashMap;
import java.util.Locale;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract sealed class BarcodeType
extends Enum<BarcodeType>
permits c, a, b, j, f, g, h, i, l, m, d, e, k {
    public static final /* enum */ BarcodeType AZTEC = new a(BarcodeFormat.AZTEC, true);
    public static final /* enum */ BarcodeType CODABAR = new f(BarcodeFormat.CODABAR, false);
    public static final /* enum */ BarcodeType CODE_39 = new g(BarcodeFormat.CODE_39, false);
    public static final /* enum */ BarcodeType CODE_93 = new h(BarcodeFormat.CODE_93, false);
    public static final /* enum */ BarcodeType CODE_128 = new i(BarcodeFormat.CODE_128, false);
    public static final /* enum */ BarcodeType DATA_MATRIX = new j(BarcodeFormat.DATA_MATRIX, true);
    public static final /* enum */ BarcodeType EAN_8 = new k(BarcodeFormat.EAN_8, false);
    public static final /* enum */ BarcodeType EAN_13 = new l(BarcodeFormat.EAN_13, false);
    public static final /* enum */ BarcodeType ITF = new m(BarcodeFormat.ITF, false);
    public static final /* enum */ BarcodeType PDF_417 = new b(BarcodeFormat.PDF_417, true);
    public static final /* enum */ BarcodeType QR_CODE = new c(BarcodeFormat.QR_CODE, true);
    public static final /* enum */ BarcodeType UPC_A = new d(BarcodeFormat.UPC_A, false);
    public static final /* enum */ BarcodeType UPC_E = new e(BarcodeFormat.UPC_E, false);
    public final BarcodeFormat format;
    public final String lowerCase;
    public final boolean isTwoDimensional;
    private Writer a;
    private static final HashMap<BarcodeFormat, BarcodeType> a;
    private static final HashMap<String, BarcodeType> b;
    public static final String TEXT_IS_NULL_ERROR = "Barcode text is null";
    private static final /* synthetic */ BarcodeType[] a;

    static {
        a = new BarcodeType[]{AZTEC, CODABAR, CODE_39, CODE_93, CODE_128, DATA_MATRIX, EAN_8, EAN_13, ITF, PDF_417, QR_CODE, UPC_A, UPC_E};
        BarcodeType[] barcodeTypeArray = BarcodeType.values();
        a = new HashMap(barcodeTypeArray.length);
        b = new HashMap(barcodeTypeArray.length);
        BarcodeType[] barcodeTypeArray2 = barcodeTypeArray;
        int n = barcodeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BarcodeType barcodeType = barcodeTypeArray2[n2];
            a.put(barcodeType.format, barcodeType);
            b.put(barcodeType.lowerCase, barcodeType);
            ++n2;
        }
    }

    private BarcodeType(BarcodeFormat barcodeFormat, boolean bl) {
        this.format = barcodeFormat;
        this.isTwoDimensional = bl;
        this.lowerCase = this.name().toLowerCase(Locale.ENGLISH);
    }

    public static BarcodeType from(String string) {
        return b.get(string);
    }

    public static BarcodeType from(BarcodeFormat barcodeFormat) {
        return (BarcodeType)((Object)a.get(barcodeFormat));
    }

    public BarcodeBuilder createBuilder() {
        return new BarcodeBuilder(this);
    }

    protected abstract Writer _createWriter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writer getWriter() {
        Writer writer = this.a;
        if (writer == null) {
            BarcodeType barcodeType = this;
            synchronized (barcodeType) {
                writer = this.a;
                if (writer == null) {
                    writer = this.a = this._createWriter();
                }
            }
        }
        return writer;
    }

    public String getSVG(String string, int n, int n2) throws BarcodeException {
        return this.createBuilder().text(string).size(n, n2).asSVG();
    }

    public String getSVG(String string, int n, int n2, ErrorCorrectionLevel errorCorrectionLevel) throws BarcodeException {
        return this.createBuilder().text(string).size(n, n2).errorCorrection(errorCorrectionLevel).asSVG();
    }

    public String validate(String string) {
        if (string == null) {
            return TEXT_IS_NULL_ERROR;
        }
        try {
            this.getWriter().encode(string, this.format, 0, 0);
            return null;
        }
        catch (WriterException writerException) {
            return writerException.getMessage();
        }
    }

    public boolean isValid(String string) {
        return this.validate(string) == null;
    }

    public BarcodeURN createBarcodeURN(String string, int n, int n2) throws BarcodeException {
        return this.createBuilder().text(string).size(n, n2).asURN();
    }

    public BarcodeURN createBarcodeURN(String string, int n, int n2, ErrorCorrectionLevel errorCorrectionLevel) throws BarcodeException {
        return this.createBuilder().text(string).size(n, n2).errorCorrection(errorCorrectionLevel).asURN();
    }

    public static BarcodeType[] values() {
        BarcodeType[] barcodeTypeArray = a;
        int n = barcodeTypeArray.length;
        BarcodeType[] barcodeTypeArray2 = new BarcodeType[n];
        System.arraycopy(a, 0, barcodeTypeArray2, 0, n);
        return barcodeTypeArray2;
    }

    public static BarcodeType valueOf(String string) {
        return Enum.valueOf(BarcodeType.class, string);
    }
}

