/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.LocaleInfo;
import com.iizix.Value;
import com.iizix.value.TermporalAccessorValue;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.XMLGregorianCalendar;

public class LocalDateTimeValue
extends TermporalAccessorValue<LocalDateTime> {
    @Override
    public final Value.Type getValueType() {
        return Value.Type.LocalDateTime;
    }

    @Override
    public Class<LocalDateTime> getValueClass() {
        return LocalDateTime.class;
    }

    @Override
    public String getDescription() {
        return "Date-time without a time-zone in the ISO-8601 calendar system, such as 2007-12-03T10:15:30";
    }

    @Override
    public LocalDateTime createDefault() {
        return LocalDateTime.of(1970, 1, 1, 0, 0);
    }

    @Override
    public LocalDateTime parse(String string) throws ParseException, Exception {
        try {
            return LocalDateTime.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public LocalDateTime parse(String string, DateTimeFormatter dateTimeFormatter) throws ParseException, Exception {
        try {
            return LocalDateTime.parse(string, dateTimeFormatter);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public LocalDateTime convert(Object object, Value.Type type, LocaleInfo localeInfo) throws Exception {
        long l2;
        if (object instanceof LocalDateTime) {
            return (LocalDateTime)object;
        }
        if (object instanceof Number) {
            Instant instant = Instant.ofEpochMilli(((Number)object).longValue());
            return LocalDateTime.ofInstant(instant, LocaleInfo.getNonNull(localeInfo, false).getZoneId());
        }
        if (object instanceof OffsetDateTime) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)object;
            return offsetDateTime.toLocalDateTime();
        }
        if (object instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)object;
            return zonedDateTime.toLocalDateTime();
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return timestamp.toLocalDateTime();
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            Instant instant = Instant.ofEpochMilli(date.getTime());
            return LocalDateTime.ofInstant(instant, LocaleInfo.getNonNull(localeInfo, false).getZoneId());
        }
        if (object instanceof XMLGregorianCalendar) {
            object = ((XMLGregorianCalendar)object).toGregorianCalendar();
        }
        if (object instanceof GregorianCalendar) {
            return ((GregorianCalendar)object).toZonedDateTime().toLocalDateTime();
        }
        if (type != null && (l2 = type.valueObject.asLongCast(object, localeInfo)) != Long.MIN_VALUE) {
            Instant instant = Instant.ofEpochMilli(l2);
            return LocalDateTime.ofInstant(instant, LocaleInfo.getNonNull(localeInfo, false).getZoneId());
        }
        String string = type != null ? type.valueObject.toStringForced(object) : String.valueOf(object);
        try {
            return LocalDateTime.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public long asLong(LocalDateTime localDateTime, LocaleInfo localeInfo) {
        return localDateTime.toInstant(LocaleInfo.getNonNull(localeInfo, false).getZoneOffset()).toEpochMilli();
    }

    @Override
    public String toString(LocalDateTime localDateTime, String string, LocaleInfo localeInfo) {
        if (string == null) {
            return String.valueOf(localDateTime);
        }
        if (localeInfo == null) {
            localeInfo = LocaleInfo.getCurrent(true);
        }
        DateTimeFormatter dateTimeFormatter = this.a(string, localeInfo, false);
        try {
            return dateTimeFormatter.format(localDateTime);
        }
        catch (UnsupportedTemporalTypeException unsupportedTemporalTypeException) {
            OffsetDateTime offsetDateTime = localDateTime.atOffset(localeInfo.getZoneOffset());
            return dateTimeFormatter.format(offsetDateTime);
        }
    }
}

