/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit4.runner;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.jdt.internal.junit.runner.ITestLoader;
import org.eclipse.jdt.internal.junit.runner.ITestReference;
import org.eclipse.jdt.internal.junit.runner.RemoteTestRunner;
import org.eclipse.jdt.internal.junit.runner.junit3.JUnit3TestLoader;
import org.eclipse.jdt.internal.junit.runner.junit3.JUnit3TestReference;
import org.eclipse.jdt.internal.junit4.runner.DescriptionMatcher;
import org.eclipse.jdt.internal.junit4.runner.FailuresFirstSorter;
import org.eclipse.jdt.internal.junit4.runner.JUnit4TestReference;
import org.eclipse.jdt.internal.junit4.runner.SubForestFilter;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;

public class JUnit4TestLoader
implements ITestLoader {
    public ITestReference[] loadTests(Class<?>[] testClasses, String testName, String[] failureNames, String[] packages, String[][] includeExcludeTags, String uniqueId, RemoteTestRunner listener) {
        ITestReference[] refs = new ITestReference[testClasses.length];
        int i = 0;
        while (i < testClasses.length) {
            ITestReference ref;
            Class<?> clazz = testClasses[i];
            refs[i] = ref = this.createTest(clazz, testName, failureNames, listener);
            ++i;
        }
        return refs;
    }

    private Description getRootDescription(Runner runner, DescriptionMatcher matcher) {
        Description current = runner.getDescription();
        ArrayList children;
        while ((children = current.getChildren()).size() == 1 && !matcher.matches(current)) {
            current = (Description)children.get(0);
        }
        return current;
    }

    private ITestReference createTest(Class<?> clazz, String testName, String[] failureNames, RemoteTestRunner listener) {
        if (clazz == null) {
            return null;
        }
        if (testName != null && this.isJUnit3SetUpTest(clazz, testName)) {
            JUnit3TestLoader jUnit3TestLoader = new JUnit3TestLoader();
            junit.framework.Test test = jUnit3TestLoader.getTest(clazz, testName, listener);
            return new JUnit3TestReference(test);
        }
        if (testName != null) {
            return this.createFilteredTest(clazz, testName, failureNames);
        }
        return this.createUnfilteredTest(clazz, failureNames);
    }

    private ITestReference createFilteredTest(Class<?> clazz, String testName, String[] failureNames) {
        DescriptionMatcher matcher = DescriptionMatcher.create(clazz, testName);
        SubForestFilter filter = new SubForestFilter(matcher);
        Request request = this.sortByFailures(Request.classWithoutSuiteMethod(clazz).filterWith((Filter)filter), failureNames);
        Runner runner = request.getRunner();
        Description description = this.getRootDescription(runner, matcher);
        return new JUnit4TestReference(runner, description);
    }

    private ITestReference createUnfilteredTest(Class<?> clazz, String[] failureNames) {
        Request request = this.sortByFailures(Request.aClass(clazz), failureNames);
        Runner runner = request.getRunner();
        Description description = runner.getDescription();
        return new JUnit4TestReference(runner, description);
    }

    private Request sortByFailures(Request request, String[] failureNames) {
        if (failureNames != null) {
            return request.sortWith((Comparator)new FailuresFirstSorter(failureNames));
        }
        return request;
    }

    private boolean isJUnit3SetUpTest(Class<?> clazz, String testName) {
        block6: {
            if (!junit.framework.Test.class.isAssignableFrom(clazz)) {
                return false;
            }
            Method testMethod = clazz.getMethod(testName, new Class[0]);
            if (testMethod.getAnnotation(Test.class) == null) break block6;
            return false;
        }
        try {
            Method setup = clazz.getMethod("setUpTest", junit.framework.Test.class);
            int modifiers = setup.getModifiers();
            if (setup.getReturnType() == junit.framework.Test.class && Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers)) {
                return true;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }
}

