/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.webthumbs;

import com.iizix.GenericListener;
import com.iizix.ILog;
import com.iizix.NotFoundException;
import com.iizix.Utilities;
import com.iizix.server.ServerShell;
import com.iizix.server.webthumbs.IWebThumbnailListener;
import com.iizix.server.webthumbs.WebThumbnailState;
import com.iizix.server.webthumbs.WebThumbs;
import com.iizix.server.wsfile.WSFileProvider;
import com.iizix.wsfile.IWSFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.StandardCopyOption;
import javax.net.ssl.HttpsURLConnection;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WebThumbnail {
    private final Object a;
    private final String a;
    private final File a;
    private IWSFile a;
    WebThumbnailState a;
    private Throwable a;
    private GenericListener<IWebThumbnailListener> a = WebThumbnailState.INITIALIZING;
    private static volatile /* synthetic */ int[] a;

    WebThumbnail(String string, File file, IWSFile iWSFile) {
        this.a = string;
        this.a = Utilities.getCanonicalFile((File)file);
        this.a = iWSFile;
        if (iWSFile != null) {
            this.a = WebThumbnailState.SUCCESS;
        }
    }

    public boolean isDisposed() {
        return this.a == WebThumbnailState.DISPOSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a() {
        Object object;
        WebThumbnailState webThumbnailState;
        Object object2 = this.a;
        synchronized (object2) {
            webThumbnailState = this.a = WebThumbnailState.DISPOSED;
            this.a.notifyAll();
            object = this.a;
            this.a = null;
        }
        if (object != null) {
            object.forEach(iWebThumbnailListener -> iWebThumbnailListener.onCompleted(this, webThumbnailState, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Runnable a(ServerShell serverShell, WSFileProvider wSFileProvider) {
        Object object = this.a;
        synchronized (object) {
            if (this.a != WebThumbnailState.INITIALIZING) {
                return null;
            }
            this.a = WebThumbnailState.PENDING;
            this.a.notifyAll();
        }
        return () -> {
            Object object;
            Object object2;
            WebThumbnailState webThumbnailState = WebThumbnailState.SUCCESS;
            IOException iOException = null;
            IWSFile iWSFile = null;
            if (wSFileProvider.isDisposed() || this.isDisposed()) {
                webThumbnailState = WebThumbnailState.DISPOSED;
                object2 = this.a;
                synchronized (object2) {
                    object = this.a;
                }
            }
            object2 = this.a;
            synchronized (object2) {
                this.a = WebThumbnailState.RETRIEVING;
                this.a.notifyAll();
            }
            try {
                this.a(serverShell, this.a, this.a);
                iWSFile = wSFileProvider.reserveFile(this.a, this.a, null);
                ILog.INFO(this.getClass(), (String)("Generated Website " + this.a + " thumbnail, size = " + Utilities.getEnglishSize((long)this.a.length()) + ", file " + this.a.getPath()));
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                webThumbnailState = WebThumbnailState.ERROR;
                ILog.WARNING(this.getClass(), (String)("Failed loading thumbnail for Website " + this.a + ": " + iOException2.getMessage()));
            }
            catch (NotFoundException | InvalidPathException throwable) {
                ILog.WARNING(this.getClass(), (String)("Unexpected error loading thumbnail for Website " + this.a));
            }
            object2 = this.a;
            synchronized (object2) {
                if (this.a == WebThumbnailState.DISPOSED) {
                    webThumbnailState = WebThumbnailState.DISPOSED;
                    iOException = null;
                } else {
                    this.a = webThumbnailState;
                }
                this.a = iWSFile;
                this.a = iOException;
                this.a.notifyAll();
                object = this.a;
                this.a = null;
            }
            if (object != null) {
                object2 = webThumbnailState;
                IOException iOException3 = iOException;
                object.forEach(arg_0 -> this.a((WebThumbnailState)((Object)((Object)object2)), iOException3, arg_0));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebThumbnailState waitForCompletion(Runnable runnable) {
        try {
            Object object = this.a;
            synchronized (object) {
                block11: while (true) {
                    switch (WebThumbnail.a()[this.a.ordinal()]) {
                        case 1: 
                        case 2: 
                        case 5: 
                        case 6: {
                            return this.a;
                        }
                        case 3: 
                        case 4: {
                            break block11;
                        }
                        default: {
                            continue block11;
                        }
                    }
                    break;
                }
                try {
                    this.a.wait(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            runnable.run();
        }
        catch (Throwable throwable) {
            ILog.SEVERE(this.getClass(), (String)"The \"runnable\" callback failed", (Throwable)throwable);
        }
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebThumbnailState addCompletionListener(Runnable runnable) {
        try {
            Object object = this.a;
            synchronized (object) {
                block11: while (true) {
                    switch (WebThumbnail.a()[this.a.ordinal()]) {
                        case 1: 
                        case 2: 
                        case 5: 
                        case 6: {
                            return this.a;
                        }
                        case 3: 
                        case 4: {
                            break block11;
                        }
                        default: {
                            continue block11;
                        }
                    }
                    break;
                }
                try {
                    this.a.wait(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            runnable.run();
        }
        catch (Throwable throwable) {
            ILog.SEVERE(this.getClass(), (String)"The \"runnable\" callback failed", (Throwable)throwable);
        }
        return this.a;
    }

    public File getFile() {
        return this.a;
    }

    public IWSFile getWSFile() {
        return this.a;
    }

    public WebThumbnailState getState() {
        return this.a;
    }

    public Throwable getException() {
        return this.a;
    }

    public String getSite() {
        return this.a;
    }

    private void a(ServerShell serverShell, String string, String object) throws IOException, InvalidPathException {
        block20: {
            int n = -1;
            try {
                URL uRL;
                String string2 = "https://api.urlbox.io/v1/" + WebThumbs.a + "/png?retina=true&block_ads=true&bg_color=white&width=1280&height=1024&url=" + URLEncoder.encode((String)object, StandardCharsets.UTF_8) + "&download=" + URLEncoder.encode(this.a.getName(), StandardCharsets.UTF_8);
                try {
                    uRL = new URI(string2).toURL();
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    throw new IOException("The request " + string2 + " is an invalid", exception);
                }
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
                serverShell.configureProxy(httpsURLConnection);
                n = httpsURLConnection.getResponseCode();
                Throwable throwable = null;
                Object var9_16 = null;
                try (InputStream inputStream = httpsURLConnection.getInputStream();){
                    if (n == 200) {
                        Files.copy(inputStream, this.a.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                if (((String)object).startsWith("www.") || n >= 0 && (n < 400 || n >= 500)) break block20;
                object = "www." + (String)object;
                ILog.INFO(this.getClass(), (String)("Failed loading thumbnail for Website '" + string + "', attempting '" + (String)object + "': " + iOException.getMessage()));
                try {
                    this.a(serverShell, string, (String)object);
                    String string3 = this.a.getName();
                    if (string3.startsWith("website-")) {
                        String string4 = "website-www." + string3.substring(8);
                        File file = new File(this.a.getParentFile(), string4);
                        if (!file.exists() && file.length() > 0L) {
                            try {
                                Files.copy(this.a.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                            }
                            catch (IOException iOException2) {
                                ILog.WARNING(this.getClass(), (String)("As the thumbnail for the Website \"" + this.a + "\" was found for \"www." + this.a + "\" the thumbnail file \"" + this.a.getPath() + "\" was copied to \"" + file.getPath() + "\", but failed: " + iOException.getMessage()));
                            }
                        }
                    }
                }
                catch (IOException iOException3) {
                    throw iOException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(IWebThumbnailListener iWebThumbnailListener) {
        Object object = this.a;
        synchronized (object) {
            block5: {
                if (this.a == WebThumbnailState.PENDING || this.a == WebThumbnailState.RETRIEVING) break block5;
                return false;
            }
            if (this.a == null) {
                this.a = new GenericListener(IWebThumbnailListener.class);
            }
            return this.a.addListener((Object)iWebThumbnailListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(IWebThumbnailListener iWebThumbnailListener) {
        Object object = this.a;
        synchronized (object) {
            return this.a != null ? this.a.removeListener((Object)iWebThumbnailListener) : false;
        }
    }

    static /* synthetic */ int[] a() {
        if (a != null) {
            return a;
        }
        int[] nArray = new int[WebThumbnailState.values().length];
        try {
            nArray[WebThumbnailState.DISPOSED.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WebThumbnailState.ERROR.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WebThumbnailState.INITIALIZING.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WebThumbnailState.PENDING.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WebThumbnailState.RETRIEVING.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WebThumbnailState.SUCCESS.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        a = nArray;
        return nArray;
    }

    private /* synthetic */ void a(WebThumbnailState webThumbnailState, Throwable throwable, IWebThumbnailListener iWebThumbnailListener) {
        iWebThumbnailListener.onCompleted(this, webThumbnailState, throwable);
    }
}

