/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.ui;

import com.iizix.GenericListener;
import com.iizix.Size;
import com.iizix.api.ui.IUIMediaListener;
import com.iizix.api.ui.UIMediaEvent;
import com.iizix.event.RemoteEvent;
import com.iizix.prop.AssetReference;
import com.iizix.prop.Atom;
import com.iizix.prop.FileURIPropCnr;
import com.iizix.prop.GProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.prop.ui.IUIContextMenuOwner;
import com.iizix.prop.ui.UIComp;
import com.iizix.prop.ui.a;
import java.util.Objects;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class UIMedia
extends UIComp
implements IUIContextMenuOwner {
    private GenericListener<IUIMediaListener> a;
    private int a;

    public UIMedia() {
    }

    public UIMedia(Atom atom) {
        super(atom);
    }

    public UIMedia(Atom atom, GProp<?>[] gPropArray) throws PropException {
        super(atom, gPropArray);
    }

    public String getAssetReferenceString() {
        AssetReference assetReference = this.getAssetReference();
        return assetReference != null ? assetReference.getReference() : null;
    }

    public AssetReference getAssetReference() {
        return this.getProp("source", AssetReference.class);
    }

    public boolean setAssetReference(String string) throws PropException {
        AssetReference assetReference = this.getAssetReference();
        if (assetReference == null) {
            if (!this.setProp(new AssetReference(Atom.get("source"), string))) {
                return false;
            }
            assetReference = this.getProp("source", AssetReference.class);
        } else if (!assetReference.setPropValue(string)) {
            return false;
        }
        FileURIPropCnr fileURIPropCnr = (FileURIPropCnr)assetReference.getTargetReference();
        return fileURIPropCnr != null && fileURIPropCnr.getURL() != null;
    }

    public boolean requestMediaInfo(IUIMediaListener iUIMediaListener) {
        return this.a(0, new PropCnr(Atom.SYSTEM), Objects.requireNonNull(iUIMediaListener, "callback is null"));
    }

    public boolean play() {
        return this.play(null);
    }

    public boolean play(IUIMediaListener iUIMediaListener) {
        PropCnr propCnr = new PropCnr(Atom.SYSTEM);
        propCnr.setInt("s", 0);
        return this.a(1, propCnr, iUIMediaListener);
    }

    public boolean pause() {
        return this.pause(null);
    }

    public boolean pause(IUIMediaListener iUIMediaListener) {
        PropCnr propCnr = new PropCnr(Atom.SYSTEM);
        propCnr.setInt("s", 1);
        return this.a(1, propCnr, iUIMediaListener);
    }

    public boolean load() {
        return this.load(null);
    }

    public boolean load(IUIMediaListener iUIMediaListener) {
        PropCnr propCnr = new PropCnr(Atom.SYSTEM);
        propCnr.setInt("s", 2);
        return this.a(1, propCnr, iUIMediaListener);
    }

    public boolean setMuted(boolean bl) {
        return this.setMuted(bl, null);
    }

    public boolean setMuted(boolean bl, IUIMediaListener iUIMediaListener) {
        PropCnr propCnr = new PropCnr(Atom.SYSTEM);
        propCnr.setBool("m", bl);
        return this.a(2, propCnr, iUIMediaListener);
    }

    public boolean setVolume(int n2) {
        return this.setVolume(n2, null);
    }

    public boolean setVolume(int n2, IUIMediaListener iUIMediaListener) {
        if (n2 < 0 || n2 > 100) {
            throw new IllegalArgumentException("Invalid volume range (0-100): " + n2);
        }
        PropCnr propCnr = new PropCnr(Atom.SYSTEM);
        propCnr.setInt("v", n2);
        return this.a(3, propCnr, iUIMediaListener);
    }

    public boolean increaseVolume() {
        return this.increaseVolume(null);
    }

    public boolean increaseVolume(IUIMediaListener iUIMediaListener) {
        PropCnr propCnr = new PropCnr(Atom.SYSTEM);
        propCnr.setInt("v", -2);
        return this.a(3, propCnr, iUIMediaListener);
    }

    public boolean decreaseVolume() {
        return this.decreaseVolume(null);
    }

    public boolean decreaseVolume(IUIMediaListener iUIMediaListener) {
        PropCnr propCnr = new PropCnr(Atom.SYSTEM);
        propCnr.setInt("v", -3);
        return this.a(3, propCnr, iUIMediaListener);
    }

    public boolean setPosition(double d2) {
        return this.setPosition(d2, null);
    }

    public boolean setPosition(double d2, IUIMediaListener iUIMediaListener) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("position is negative");
        }
        PropCnr propCnr = new PropCnr(Atom.SYSTEM);
        propCnr.setNumber("p", d2);
        return this.a(4, propCnr, iUIMediaListener);
    }

    public boolean skip(double d2) {
        return this.skip(d2, null);
    }

    public boolean skip(double d2, IUIMediaListener iUIMediaListener) {
        if (d2 < 1.0 || d2 > 500.0) {
            throw new IllegalArgumentException("Invalid seconds range (1-500): " + d2);
        }
        PropCnr propCnr = new PropCnr(Atom.SYSTEM);
        propCnr.setNumber("p", d2 - 501.0);
        return this.a(4, propCnr, iUIMediaListener);
    }

    public boolean rewind(double d2) {
        return this.rewind(d2);
    }

    public boolean rewind(double d2, IUIMediaListener iUIMediaListener) {
        if (d2 < 1.0 || d2 > 500.0) {
            throw new IllegalArgumentException("Invalid seconds range (1-500): " + d2);
        }
        PropCnr propCnr = new PropCnr(Atom.SYSTEM);
        propCnr.setNumber("p", 501.0 - d2);
        return this.a(4, propCnr, iUIMediaListener);
    }

    public boolean setPlaybackRate(double d2) {
        return this.setPlaybackRate(d2, null);
    }

    public boolean setPlaybackRate(double d2, IUIMediaListener iUIMediaListener) {
        if (d2 < 0.0 || d2 > 20.0) {
            throw new IllegalArgumentException("Invalid rate range (0-100): " + d2);
        }
        PropCnr propCnr = new PropCnr(Atom.SYSTEM);
        propCnr.setNumber("r", d2);
        return this.a(5, propCnr, iUIMediaListener);
    }

    public boolean increasePlaybackRate() {
        return this.increasePlaybackRate(null);
    }

    public boolean increasePlaybackRate(IUIMediaListener iUIMediaListener) {
        PropCnr propCnr = new PropCnr(Atom.SYSTEM);
        propCnr.setNumber("r", -2.0);
        return this.a(5, propCnr, iUIMediaListener);
    }

    public boolean decreasePlaybackRate() {
        return this.decreasePlaybackRate(null);
    }

    public boolean decreasePlaybackRate(IUIMediaListener iUIMediaListener) {
        PropCnr propCnr = new PropCnr(Atom.SYSTEM);
        propCnr.setNumber("r", -3.0);
        return this.a(5, propCnr, iUIMediaListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(int n2, PropCnr propCnr, IUIMediaListener iUIMediaListener) {
        if (this.isDisposed()) {
            return false;
        }
        int n3 = 0;
        if (iUIMediaListener != null) {
            UIMedia uIMedia = this;
            synchronized (uIMedia) {
                if (++this.a == 0) {
                    ++this.a;
                }
                n3 = this.a;
            }
            propCnr.setLong("id", (long)n3);
        }
        this.triggerRemoteEvent(n2, propCnr);
        if (iUIMediaListener != null) {
            int n4 = n3;
            this.addPropListener(new a(this, n2, n4, iUIMediaListener));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(IUIMediaListener iUIMediaListener) {
        GenericListener<IUIMediaListener> genericListener = this.a;
        if (genericListener == null) {
            UIMedia uIMedia = this;
            synchronized (uIMedia) {
                genericListener = this.a;
                if (genericListener == null) {
                    genericListener = this.a = new GenericListener<IUIMediaListener>(IUIMediaListener.class);
                }
            }
        }
        boolean bl = genericListener.hasListeners();
        if (genericListener.addListener(iUIMediaListener)) {
            if (!bl) {
                this.triggerRemoteEvent(6);
            }
            return true;
        }
        return false;
    }

    public boolean removeListener(IUIMediaListener iUIMediaListener) {
        GenericListener<IUIMediaListener> genericListener = this.a;
        if (genericListener != null && genericListener.removeListener(iUIMediaListener)) {
            if (!genericListener.hasListeners()) {
                this.triggerRemoteEvent(7);
            }
            return true;
        }
        return false;
    }

    @Override
    public void onRemoteEvent(RemoteEvent remoteEvent) {
        int n2 = remoteEvent.getLocalID();
        if (n2 == 9) {
            GenericListener<IUIMediaListener> genericListener = this.a;
            if (genericListener != null) {
                UIMediaEvent uIMediaEvent = new UIMediaEvent(this, remoteEvent.getParameters());
                genericListener.forEach(iUIMediaListener -> iUIMediaListener.onMediaEvent(uIMediaEvent));
            }
        } else {
            if (n2 >= 0 && n2 < 9) {
                return;
            }
            super.onRemoteEvent(remoteEvent);
        }
    }

    @Override
    public final int getDeviceType() {
        return 0;
    }

    @Override
    public boolean isMobileContextMenuSupported() {
        return false;
    }

    @Override
    public boolean hasImplicitAlignFillX() {
        return true;
    }

    @Override
    public boolean hasImplicitAlignFillY() {
        return true;
    }

    @Override
    public UIMedia clone() {
        UIMedia uIMedia = (UIMedia)super.clone();
        uIMedia.a = null;
        uIMedia.a = 0;
        return uIMedia;
    }

    @Override
    public Size getApproximateSize() {
        return new Size(150, 100);
    }
}

