/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.ui;

import com.iizix.ILog;
import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.XMLUtilities;
import com.iizix.prop.PropMgr;
import com.iizix.text.KString;
import com.iizix.text.KStringException;
import org.w3c.dom.Element;

public class KTooltip
implements Cloneable {
    public static final int ABOVE = 8;
    public static final int BELOW = 2;
    public static final int BEFORE = 4;
    public static final int AFTER = 6;
    public static final int[] EMPTY = new int[0];
    private KString a;
    public final int category;
    public final int showDelay;
    public final int locations;

    KTooltip(ReadTransaction readTransaction) {
        KString kString;
        try {
            kString = new KString(KString.Type.HTML, readTransaction.readString());
        }
        catch (KStringException kStringException) {
            ILog.SEVERE(this.getClass(), "Failed creating KString from Transaction", kStringException);
            kString = KString.EMPTY;
        }
        this.a = kString;
        this.category = readTransaction.readByte() - 1;
        int n2 = readTransaction.readUnsigned() - 1;
        this.showDelay = n2 < 0 ? 400 : n2;
        this.locations = readTransaction.readUnsigned();
    }

    KTooltip(Element element) {
        KString kString;
        try {
            kString = KString.createKString(element);
        }
        catch (KStringException kStringException) {
            Object object;
            try {
                object = ": " + XMLUtilities.getNodeString(element);
            }
            catch (Exception exception) {
                object = "";
            }
            ILog.SEVERE(this.getClass(), "Failed creating KString from Element" + (String)object, kStringException);
            kString = KString.EMPTY;
        }
        this.a = kString;
        int n2 = -1;
        try {
            n2 = Integer.parseInt(element.getAttribute("category"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.category = n2;
        n2 = 400;
        try {
            n2 = Integer.parseInt(element.getAttribute("showDelay"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.showDelay = n2;
        n2 = 0;
        try {
            n2 = Integer.parseInt(element.getAttribute("locations"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.locations = n2;
    }

    void a(PropMgr propMgr, SendTransaction sendTransaction) {
        sendTransaction.appendString(this.a.getHTMLString(propMgr.getProvider()));
        sendTransaction.appendByte(this.category + 1);
        sendTransaction.appendUnsigned(this.showDelay == 400 ? 0 : this.showDelay + 1);
        sendTransaction.appendUnsigned(this.locations);
    }

    void a(Element element) {
        this.a.toElement(element);
        element.setAttribute("category", Integer.toString(this.category));
        if (this.locations != 0) {
            element.setAttribute("locations", Integer.toString(this.locations));
        }
        if (this.showDelay != 400) {
            element.setAttribute("showDelay", Integer.toString(this.showDelay));
        }
    }

    public KTooltip(KString kString) {
        if (kString == null) {
            throw new NullPointerException("text==null");
        }
        this.a = kString;
        this.locations = 0;
        this.category = -1;
        this.showDelay = 400;
    }

    public KTooltip(KString kString, KTooltip kTooltip) {
        if (kString == null) {
            throw new NullPointerException("text==null");
        }
        this.a = kString;
        this.locations = kTooltip.locations;
        this.category = kTooltip.category;
        this.showDelay = kTooltip.showDelay;
    }

    public KTooltip(KString kString, int n2, int ... nArray) {
        this(kString, n2, -1, nArray);
    }

    public KTooltip(KString kString, int n2) {
        if (kString == null) {
            throw new NullPointerException("text==null");
        }
        this.a = kString;
        this.category = n2;
        this.locations = 0;
        this.showDelay = 400;
    }

    public KTooltip(KString kString, int n2, int n3, int ... nArray) {
        if (kString == null) {
            throw new NullPointerException("text==null");
        }
        this.a = kString;
        this.showDelay = n2;
        this.category = n3;
        int n4 = 0;
        if (nArray != null && nArray.length > 4) {
            ILog.WARNING(this.getClass(), "Tooltip locations length invalid (=" + nArray.length + "), assuming none");
        } else if (nArray != null) {
            int n5;
            int[] nArray2 = nArray;
            int n6 = nArray.length;
            int n7 = 0;
            while (n7 < n6) {
                n5 = nArray2[n7];
                if (n5 != 2 && n5 != 4 && n5 != 6 && n5 != 8) {
                    ILog.WARNING(this.getClass(), "Tooltip location '" + n5 + "' invalid, assuming none");
                    nArray = null;
                    break;
                }
                ++n7;
            }
            if (nArray != null && (n5 = nArray.length) > 0) {
                while (--n5 >= 0) {
                    n4 = n4 << 3 | nArray[n5] / 2;
                }
            }
        }
        this.locations = n4;
    }

    public KString getText() {
        return this.a;
    }

    public KTooltip clone() {
        try {
            KTooltip kTooltip = (KTooltip)super.clone();
            kTooltip.a = kTooltip.a.clone();
            return kTooltip;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    public void dispose() {
        this.a.dispose();
    }

    protected void finalize() throws Throwable {
        try {
            this.a.dispose();
        }
        catch (Throwable throwable) {
            ILog.SEVERE(this.getClass(), "Failed finalize", throwable);
        }
        super.finalize();
    }

    public int[] getLocations() {
        int n2;
        if (this.locations < 0) {
            return EMPTY;
        }
        int n3 = 0;
        int n4 = n2 = this.locations;
        while (n4 != 0) {
            n4 >>>= 3;
            ++n3;
        }
        int[] nArray = new int[n3];
        int n5 = 0;
        while (n5 < n3) {
            nArray[n5] = (n2 & 7) * 2;
            n2 >>>= 3;
            ++n5;
        }
        return nArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof KTooltip) {
            KTooltip kTooltip = (KTooltip)object;
            return this.category == kTooltip.category && this.locations == kTooltip.locations && this.showDelay == kTooltip.showDelay && this.a.equals(kTooltip.a);
        }
        return false;
    }

    public boolean equalsOmitReferenceRefreshCheck(KTooltip kTooltip) {
        return kTooltip != null && this.category == kTooltip.category && this.locations == kTooltip.locations && this.showDelay == kTooltip.showDelay && kTooltip.a.equalsOmitReferenceRefreshCheck(this.a);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("tooltip[").append(this.a).append(",category=").append(this.category).append(",showDelay=").append(this.showDelay);
        if (this.locations == 0) {
            stringBuilder.append(",defaultLocation");
        } else {
            stringBuilder.append(",locations=");
            boolean bl = false;
            int n2 = this.locations;
            while (n2 != 0) {
                if (bl) {
                    stringBuilder.append(',');
                } else {
                    bl = true;
                }
                switch ((n2 & 7) * 2) {
                    case 8: {
                        stringBuilder.append("above");
                        break;
                    }
                    case 2: {
                        stringBuilder.append("below");
                        break;
                    }
                    case 4: {
                        stringBuilder.append("before");
                        break;
                    }
                    case 6: {
                        stringBuilder.append("after");
                        break;
                    }
                    default: {
                        stringBuilder.append("unknown[").append(n2).append(']');
                    }
                }
                n2 >>>= 3;
            }
        }
        return stringBuilder.append(']').toString();
    }
}

