/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.GUnit;
import com.iizix.prop.GUnitException;
import com.iizix.prop.PropException;
import com.iizix.prop.PropMgr;
import com.iizix.prop.PropTypeException;

public class UnitProp
extends GProp<GUnit> {
    private static final Class<?>[] a = new Class[]{GUnit.class, String.class};

    public UnitProp() {
    }

    public UnitProp(Atom atom) {
        super(atom);
    }

    public UnitProp(Atom atom, GUnit gUnit) {
        super(atom);
        this.setPropValue(gUnit);
    }

    @Override
    public Class<?>[] getValueClasses() {
        return a;
    }

    public boolean setPropValue(GUnit gUnit) {
        try {
            return super.setPropValue(gUnit);
        }
        catch (PropException propException) {
            throw new InternalError(propException.getMessage(), propException);
        }
    }

    @Override
    public void validatePropType(Object object) throws PropTypeException {
        if (!(object instanceof GUnit)) {
            throw new PropTypeException(this, "newValue not GUnit");
        }
    }

    public GUnit getUnit() {
        GUnit gUnit = (GUnit)this.getPropValue();
        if (gUnit == null) {
            gUnit = GUnit.NONE;
        }
        return gUnit;
    }

    public boolean setUnit(GUnit gUnit) {
        return this.setPropValue(gUnit);
    }

    @Override
    protected void appendPropValue(PropMgr propMgr, SendTransaction sendTransaction, Object object) {
        GUnit gUnit = (GUnit)object;
        if (gUnit == null) {
            gUnit = GUnit.NONE;
        }
        gUnit.append(sendTransaction);
    }

    @Override
    public boolean initializeValue(PropMgr propMgr, ReadTransaction readTransaction) throws PropException {
        GUnit gUnit = new GUnit(readTransaction);
        return this.setPropValue((Object)gUnit, propMgr);
    }

    @Override
    public Object fromElementString(String string) throws PropException {
        try {
            try {
                return GUnit.createGUnit(string, new String[0]);
            }
            catch (GUnitException gUnitException) {
                return GUnit.createGUnit(string, string.trim().toLowerCase());
            }
        }
        catch (Exception exception) {
            throw new PropException(this, "fromElementString error: " + String.valueOf(exception), exception);
        }
    }

    @Override
    public String toElementString(Object object) {
        return ((GUnit)object).getString();
    }

    @Override
    protected Object getPropValue0(Object object, int n2) throws Exception {
        switch (n2) {
            case 1: {
                return ((GUnit)object).getString();
            }
        }
        throw new IllegalArgumentException("invalid index: " + n2);
    }

    @Override
    protected Object toNativeValue0(Object object, int n2) throws Exception {
        switch (n2) {
            case 1: {
                return GUnit.createGUnit((String)object, new String[0]);
            }
        }
        throw new IllegalArgumentException("invalid index: " + n2);
    }

    public String getCSSValue() {
        GUnit gUnit = (GUnit)this.getPropValue();
        return gUnit != null ? gUnit.getCSSValue() : null;
    }
}

