/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.EnumeratorFromIterator;
import com.iizix.ILog;
import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.Utilities;
import com.iizix.event.PropValueEvent;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.PropException;
import com.iizix.prop.PropMgr;
import com.iizix.prop.PropTypeException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class StringArrayProp
extends GProp<List<String>> {
    private static final Class<?>[] a = new Class[]{ArrayList.class, List.class, Collection.class, Iterable.class, Vector.class, ListIterator.class, Iterator.class, Enumeration.class};
    private List<String> a;
    private List<String> b;

    public static StringArrayProp createUnmodifiableReadOnly(Atom atom, String[] stringArray) {
        return new StringArrayProp(atom, stringArray);
    }

    protected StringArrayProp() {
        this.a = new ArrayList();
        this.b = Collections.synchronizedList(this.a);
        this.setPropValueIncognito(this.b);
    }

    public StringArrayProp(Atom atom) {
        super(atom);
        this.a = new ArrayList();
        this.b = Collections.synchronizedList(this.a);
        this.setPropValueIncognito(this.b);
    }

    public StringArrayProp(Atom atom, List<String> list) throws PropTypeException {
        super(atom);
        this.a = new ArrayList();
        this.b = Collections.synchronizedList(this.a);
        this.setPropValueIncognito(this.b);
        this.addStrings(list);
    }

    private StringArrayProp(Atom atom, String[] stringArray) {
        super(atom);
        this.b = List.of(stringArray);
        this.a = this.b;
        this.setPropValueIncognito(this.b);
        this.setPropReadOnly(true);
    }

    @Override
    public Class<?>[] getValueClasses() {
        return a;
    }

    @Override
    public StringArrayProp clone() {
        try {
            StringArrayProp stringArrayProp = (StringArrayProp)super.clone();
            if (stringArrayProp.a instanceof ArrayList) {
                stringArrayProp.a = (List)((ArrayList)stringArrayProp.a).clone();
                stringArrayProp.b = Collections.synchronizedList(stringArrayProp.a);
                stringArrayProp.setPropValueIncognito(stringArrayProp.b);
            }
            return stringArrayProp;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    @Override
    public void validatePropType(Object object) throws PropTypeException {
        if (!(object instanceof List)) {
            throw new PropTypeException(this, "Not a List<?>");
        }
        for (Object e2 : (List)object) {
            if (e2 instanceof String) continue;
            throw new PropTypeException(this, "Not a List<String>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int modifyPropValue(Object object, Object object2, PropMgr propMgr) throws PropException {
        try {
            List list = (List)object2;
            Class<?>[] classArray = this.a;
            synchronized (this.a) {
                if (this.a.equals(list)) {
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                    return 0;
                }
                this.a.clear();
                this.a.addAll(list);
                // ** MonitorExit[var5_6] (shouldn't be in output)
                return 2;
            }
        }
        catch (Throwable throwable) {
            throw new PropException(this, "modifyPropertyValue error: " + String.valueOf(throwable), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void appendPropValue(PropMgr propMgr, SendTransaction sendTransaction, Object object) {
        Class<?>[] classArray = this.a;
        synchronized (this.a) {
            sendTransaction.appendUnsigned(this.a.size());
            for (String string : this.a) {
                sendTransaction.appendString(string);
            }
            // ** MonitorExit[classArray] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean initializeValue(PropMgr propMgr, ReadTransaction readTransaction) {
        int n2 = readTransaction.readUnsigned();
        UnsupportedOperationException unsupportedOperationException = null;
        Class<?>[] classArray = this.a;
        synchronized (this.a) {
            boolean bl = n2 > 0 || this.a.size() != n2;
            try {
                this.a.clear();
            }
            catch (UnsupportedOperationException unsupportedOperationException2) {
                unsupportedOperationException = unsupportedOperationException2;
            }
            while (n2-- > 0) {
                try {
                    this.a.add(readTransaction.readString());
                }
                catch (UnsupportedOperationException unsupportedOperationException3) {
                    unsupportedOperationException = unsupportedOperationException3;
                }
            }
            if (unsupportedOperationException != null) {
                ILog.SEVERE(this.getClass(), "Failed updating remote read-only list: " + String.valueOf(this), unsupportedOperationException);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return bl;
        }
    }

    @Override
    public void initializeProp(Element element) throws PropException {
        this.throwIfReadOnly();
        boolean bl = !this.b.isEmpty();
        this.b.clear();
        Node node = element.getFirstChild();
        while (node != null) {
            Attr attr;
            if (node instanceof Element && node.getNodeName().equals("string") && (attr = ((Element)node).getAttributeNode("value")) != null) {
                this.b.add(attr.getNodeValue());
                bl = true;
            }
            node = node.getNextSibling();
        }
        if (bl) {
            this.setChanged();
            this.d();
        }
    }

    public void sortList() throws PropTypeException {
        this.sortList(null, false);
    }

    public void sortList(boolean bl) throws PropTypeException {
        this.sortList(null, bl);
    }

    public void sortList(Locale locale) throws PropTypeException {
        this.sortList(locale, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sortList(Locale locale, boolean bl) throws PropTypeException {
        this.throwIfReadOnly();
        if (this.b.isEmpty()) return;
        Class<?>[] classArray = this.a;
        synchronized (this.a) {
            Collator collator = locale != null ? Collator.getInstance(locale) : Utilities.COLLATOR;
            this.a.sort((string, string2) -> {
                if (bl) {
                    string = string.toUpperCase(locale);
                    string2 = string2.toUpperCase(locale);
                }
                return collator.compare((String)string, (String)string2);
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.setChanged();
            this.d();
            return;
        }
    }

    @Override
    public void initializeElement(Element element) {
        while (element.hasChildNodes()) {
            element.removeChild(element.getLastChild());
        }
        Document document = element.getOwnerDocument();
        for (String string : this.b) {
            Element element2 = document.createElement("string");
            element2.setAttribute("value", string);
            element.appendChild(element2);
        }
    }

    private void d() {
        this.onEvent(new PropValueEvent(this, this.b, this.b));
    }

    public void addString(String string) throws PropTypeException {
        this.throwIfReadOnly();
        this.b.add(string);
        this.setChanged();
        this.d();
    }

    public void addString(String string, int n2) throws PropTypeException {
        this.throwIfReadOnly();
        this.b.add(n2, string);
        this.setChanged();
        this.d();
    }

    public void addStrings(List<String> list) throws PropTypeException {
        if (!list.isEmpty()) {
            this.throwIfReadOnly();
            this.b.addAll(list);
            this.setChanged();
            this.d();
        }
    }

    public void addStrings(String[] stringArray) throws PropTypeException {
        int n2 = stringArray.length;
        if (n2 > 0) {
            this.throwIfReadOnly();
            this.b.addAll(Arrays.asList(stringArray));
            this.setChanged();
            this.d();
        }
    }

    public int size() {
        return this.b.size();
    }

    public boolean clear() throws PropTypeException {
        if (this.b.isEmpty()) {
            return false;
        }
        this.throwIfReadOnly();
        this.b.clear();
        this.setChanged();
        this.d();
        return true;
    }

    public boolean removeString(String string) throws PropTypeException {
        this.throwIfReadOnly();
        boolean bl = this.b.remove(string);
        if (bl) {
            this.setChanged();
            this.d();
        }
        return bl;
    }

    public String removeString(int n2) throws PropTypeException {
        this.throwIfReadOnly();
        String string = this.b.remove(n2);
        this.setChanged();
        this.d();
        return string;
    }

    public String getString(int n2) {
        return this.b.get(n2);
    }

    public String setString(String string, int n2) throws PropTypeException {
        this.throwIfReadOnly();
        String string2 = this.b.set(n2, string);
        if (!string2.equals(string)) {
            this.setChanged();
            this.d();
        }
        return string2;
    }

    public List<String> getArrayList() {
        return this.isPropReadOnly() ? Collections.unmodifiableList(this.b) : this.b;
    }

    @Override
    protected Object getPropValue0(Object object, int n2) throws Exception {
        List list = (List)object;
        switch (n2) {
            case 1: {
                return list;
            }
            case 2: {
                return list;
            }
            case 3: {
                return list;
            }
            case 4: {
                return new Vector(list);
            }
            case 5: {
                return list.listIterator();
            }
            case 6: {
                return list.iterator();
            }
            case 7: {
                return EnumeratorFromIterator.createEnumerator(list.iterator());
            }
        }
        throw new IllegalArgumentException("invalid index: " + n2);
    }

    @Override
    protected Object toNativeValue0(Object object, int n2) throws Exception {
        ArrayList<String> arrayList;
        switch (n2) {
            case 1: {
                arrayList = new ArrayList((List)object);
                break;
            }
            case 2: {
                arrayList = new ArrayList((Collection)object);
                break;
            }
            case 3: {
                arrayList = new ArrayList<String>();
                for (String string : (Iterable)object) {
                    arrayList.add(string);
                }
                break;
            }
            case 4: {
                arrayList = new ArrayList((Vector)object);
                break;
            }
            case 5: {
                arrayList = new ArrayList();
                ListIterator listIterator = (ListIterator)object;
                while (listIterator.hasNext()) {
                    arrayList.add((String)listIterator.next());
                }
                break;
            }
            case 6: {
                arrayList = new ArrayList();
                Iterator iterator = (Iterator)object;
                while (iterator.hasNext()) {
                    arrayList.add((String)iterator.next());
                }
                break;
            }
            case 7: {
                arrayList = new ArrayList();
                Enumeration enumeration = (Enumeration)object;
                while (enumeration.hasMoreElements()) {
                    arrayList.add((String)enumeration.nextElement());
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid index: " + n2);
            }
        }
        return arrayList;
    }
}

