/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.ILog;
import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.Utilities;
import com.iizix.prop.Atom;
import com.iizix.prop.KStringProp;
import com.iizix.prop.PropException;
import com.iizix.prop.PropMgr;
import com.iizix.prop.PropTypeException;
import com.iizix.prop.PropValidateException;
import com.iizix.text.KString;
import com.iizix.text.KStringException;
import com.iizix.text.PlainKString;

public class PlainKStringProp
extends KStringProp {
    private static final Class<?>[] a = new Class[]{PlainKString.class, KString.class, String.class, StringBuilder.class, StringBuffer.class, char[].class, byte[].class, Long.class, Integer.class, Short.class, Byte.class, Double.class, Float.class, Character.class};

    protected PlainKStringProp() {
    }

    public PlainKStringProp(Atom atom) {
        super(atom);
    }

    public PlainKStringProp(Atom atom, KString kString) {
        super(atom);
        try {
            this.setPropValue(kString);
        }
        catch (PropException propException) {
            throw new InternalError("Shouldn't be", propException);
        }
    }

    public PlainKStringProp(Atom atom, String string) {
        super(atom);
        try {
            super.setPropValue(KString.newPlainKString(string));
        }
        catch (PropException propException) {
            throw new InternalError("Shouldn't be", propException);
        }
    }

    public PlainKString getPlainKString() {
        try {
            KString kString = (KString)this.getPropValue();
            return kString != null ? kString.toPlainKString() : null;
        }
        catch (KStringException kStringException) {
            throw new InternalError("Shouldn't be", kStringException);
        }
    }

    @Override
    public void validatePropType(Object object) throws PropTypeException {
        if (!(object instanceof KString)) {
            throw new PropTypeException(this, "newValue not a KString");
        }
        if (!((KString)object).isPLAIN()) {
            throw new PropTypeException(this, "newValue not a PLAIN KString");
        }
    }

    @Override
    public boolean setPropValue(KString kString) throws PropTypeException, PropValidateException {
        if (kString instanceof PlainKString) {
            return super.setPropValue(kString);
        }
        try {
            return super.setPropValue(kString.toPlainKString());
        }
        catch (KStringException kStringException) {
            throw new PropValidateException(this, "New value is not convertible to a PlainKString: " + String.valueOf(kString));
        }
    }

    public boolean setPropValue(PlainKString plainKString) throws PropTypeException, PropValidateException {
        return super.setPropValue(plainKString);
    }

    @Override
    protected void appendPropValue(PropMgr propMgr, SendTransaction sendTransaction, Object object) {
        KString kString = (KString)object;
        sendTransaction.appendString(kString == null ? "" : kString.getPLAINString(this));
    }

    @Override
    public boolean initializeValue(PropMgr propMgr, ReadTransaction readTransaction) throws PropException {
        KString kString;
        try {
            kString = new KString(KString.Type.PLAIN, readTransaction.readString());
        }
        catch (KStringException kStringException) {
            ILog.SEVERE(this.getClass(), "Failed creating KString from Transaction", kStringException);
            kString = KString.EMPTY;
        }
        return this.setPropValue((Object)kString, propMgr);
    }

    @Override
    public Class<?>[] getValueClasses() {
        return a;
    }

    @Override
    protected Object getPropValue0(Object object, int n2) throws Exception {
        if (n2 == 1) {
            return ((KString)object).toPlainKString();
        }
        String string = ((KString)object).getPLAINString(this);
        switch (n2) {
            case 2: {
                return string;
            }
            case 3: {
                return new StringBuilder(string);
            }
            case 4: {
                return new StringBuffer(string);
            }
            case 5: {
                return string.toCharArray();
            }
            case 6: {
                return Utilities.getBytes(string);
            }
            case 7: {
                return Long.valueOf(string);
            }
            case 8: {
                return Integer.valueOf(string);
            }
            case 9: {
                return Short.valueOf(string);
            }
            case 10: {
                return Byte.valueOf(string);
            }
            case 11: {
                return Double.valueOf(string);
            }
            case 12: {
                return Float.valueOf(string);
            }
            case 13: {
                int n3 = string.length();
                if (n3 != 1) {
                    throw new IllegalArgumentException("string length != 1: " + n3);
                }
                return Character.valueOf(string.charAt(0));
            }
        }
        throw new IllegalArgumentException("invalid index: " + n2);
    }

    @Override
    protected Object toNativeValue0(Object object, int n2) throws Exception {
        String string;
        switch (n2) {
            case 1: {
                return object;
            }
            case 2: {
                string = (String)object;
                break;
            }
            case 3: {
                string = ((StringBuilder)object).toString();
                break;
            }
            case 4: {
                string = ((StringBuffer)object).toString();
                break;
            }
            case 5: {
                string = new String((char[])object);
                break;
            }
            case 6: {
                string = Utilities.createString((byte[])object);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = object.toString();
                break;
            }
            case 13: {
                string = ((Character)object).toString();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid index: " + n2);
            }
        }
        return new PlainKString(string, false);
    }
}

