/*
 * Decompiled with CFR 0.152.
 */
package com.iizix;

import com.iizix.ILog;
import com.iizix.ITransaction;
import com.iizix.ReadTransaction;
import com.iizix.Utilities;
import com.iizix.WriteCache;
import java.nio.charset.StandardCharsets;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class SendTransaction
implements ITransaction {
    public static final int MAX_TRANSACTION_SIZE = 0x1FFFFFFF;
    private static boolean a;
    private static boolean b;
    private byte[] a;
    private int a;
    private boolean c;
    private WriteCache a;
    private boolean d;
    private Exception a;

    static {
        b = true;
    }

    public static boolean isDatatypeIncluded() {
        return b;
    }

    public static void setDatatypeIncluded(boolean bl) {
        if (a) {
            throw new IllegalStateException("Flag for datatype included in transactions has already been set");
        }
        b = bl;
        ReadTransaction.a = bl;
        a = true;
    }

    public static int setLongData(int n2, int n3, byte[] byArray) {
        byArray[n3++] = (byte)(n2 >>> 24);
        byArray[n3++] = (byte)(n2 >>> 16);
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3++] = (byte)n2;
        return n3;
    }

    public SendTransaction() {
        this(null);
    }

    public SendTransaction(WriteCache writeCache) {
        this.a = writeCache;
        if (writeCache != null) {
            writeCache.a(this);
        }
    }

    public boolean close() {
        boolean bl = this.d;
        this.d = true;
        WriteCache writeCache = this.a;
        this.a = null;
        if (writeCache != null) {
            writeCache.b(this);
        }
        this.a = null;
        return bl;
    }

    protected void finalize() throws Throwable {
        Exception exception = this.a;
        if (!this.close()) {
            if (exception != null) {
                ILog.SEVERE(this.getClass(), "Allocated SendTransaction not closed when garbage collected (finalize), see stack trace for origin", exception);
            } else {
                ILog.SEVERE(this.getClass(), "Allocated SendTransaction not closed during garbage collection (finalize)");
            }
        }
        super.finalize();
    }

    public int getTotalSendSize() {
        return this.a;
    }

    public boolean hasAppendedData() {
        return this.a != null;
    }

    public byte[] getData() {
        this.close();
        byte[] byArray = new byte[this.a];
        System.arraycopy(this.a, 0, byArray, 0, this.a);
        if (!this.c) {
            SendTransaction.setLongData(this.a, 0, byArray);
        }
        return byArray;
    }

    public byte[] getData(int n2) {
        byte[] byArray;
        if (n2 < 0) {
            return this.getData();
        }
        if (n2 > 65535) {
            throw new IllegalArgumentException("serial range is not 0x0000 to 0xFFFF: " + Utilities.toUnsignedHex(n2, 4));
        }
        this.close();
        if (this.a == null) {
            throw new IllegalStateException("No data available in transaction");
        }
        if (!this.c) {
            this.c = true;
            SendTransaction.setLongData(this.a, 0, this.a);
        }
        if (b) {
            byArray = new byte[this.a + 4];
            byArray[0] = 4;
            byArray[1] = (byte)(n2 >>> 8);
            byArray[2] = (byte)n2;
            byArray[3] = 14;
            System.arraycopy(this.a, 0, byArray, 4, this.a);
            this.a += 4;
        } else {
            byArray = new byte[this.a + 2];
            byArray[0] = (byte)(n2 >>> 8);
            byArray[1] = (byte)n2;
            System.arraycopy(this.a, 0, byArray, 2, this.a);
            this.a += 2;
        }
        return byArray;
    }

    public void appendByte(int n2) {
        if (b) {
            this.b(2);
            this.a[this.a++] = 1;
        } else {
            this.b(1);
        }
        this.a[this.a++] = (byte)n2;
    }

    public void appendChar(char c2) {
        int n2;
        if (b) {
            this.b(4);
            this.a[this.a++] = 3;
        }
        if ((n2 = c2 & 0xFFFF) >= 255) {
            this.b(3);
            this.a[this.a++] = -1;
            this.a[this.a++] = (byte)(n2 >>> 8);
        } else {
            this.b(1);
        }
        this.a[this.a++] = (byte)n2;
    }

    public void appendBoolean(boolean bl) {
        if (b) {
            this.b(2);
            this.a[this.a++] = 2;
        } else {
            this.b(1);
        }
        this.a[this.a++] = bl ? (byte)1 : 0;
    }

    public void appendShort(int n2) {
        if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
            throw new IllegalArgumentException("value range is not -0x8000 to 0x7FFF: " + Utilities.toSignedHex(n2, 4));
        }
        if (b) {
            this.b(3);
            this.a[this.a++] = 15;
        } else {
            this.b(2);
        }
        this.a[this.a++] = (byte)((n2 += 65536) >>> 8);
        this.a[this.a++] = (byte)n2;
    }

    public void appendUShort(int n2) {
        if (n2 < 0 || n2 > 65535) {
            throw new IllegalArgumentException("value range is not 0x0000 to 0xFFFF: " + Utilities.toUnsignedHex(n2, 4));
        }
        if (b) {
            this.b(3);
            this.a[this.a++] = 4;
        } else {
            this.b(2);
        }
        this.a[this.a++] = (byte)(n2 >>> 8);
        this.a[this.a++] = (byte)n2;
    }

    public int appendLong(int n2) {
        if (b) {
            this.b(5);
            this.a[this.a++] = 5;
        } else {
            this.b(4);
        }
        int n3 = this.a;
        this.a = SendTransaction.setLongData(n2, this.a, this.a);
        return n3;
    }

    public void setLong(int n2, int n3) {
        if (this.d) {
            throw new IllegalStateException("SendTransaction is closed");
        }
        SendTransaction.setLongData(n2, n3, this.a);
    }

    public void appendLong64(long l2) {
        if (b) {
            this.b(9);
            this.a[this.a++] = 6;
        } else {
            this.b(8);
        }
        this.a[this.a++] = (byte)(l2 >>> 56);
        this.a[this.a++] = (byte)(l2 >>> 48);
        this.a[this.a++] = (byte)(l2 >>> 40);
        this.a[this.a++] = (byte)(l2 >>> 32);
        this.a[this.a++] = (byte)(l2 >>> 24);
        this.a[this.a++] = (byte)(l2 >>> 16);
        this.a[this.a++] = (byte)(l2 >>> 8);
        this.a[this.a++] = (byte)l2;
    }

    public void appendSigned(int n2) {
        if (n2 < -536870911 || n2 > 0x1FFFFFFF) {
            throw new IllegalArgumentException("value range is not -0x1FFF_FFFF to 0x1FFF_FFFF: " + Utilities.toSignedHex(n2, 8));
        }
        if (b) {
            this.b(5);
            this.a[this.a++] = 7;
        } else {
            this.b(4);
        }
        int n3 = 0;
        if (n2 < 0) {
            n3 = 32;
            n2 = -n2;
        }
        if (n2 > 0x1FFFFF) {
            this.a[this.a++] = (byte)(0xC0 | n3 | n2 >>> 24);
            this.a[this.a++] = (byte)(n2 >>> 16);
            this.a[this.a++] = (byte)(n2 >>> 8);
        } else if (n2 > 8191) {
            this.a[this.a++] = (byte)(0x80 | n3 | n2 >>> 16);
            this.a[this.a++] = (byte)(n2 >>> 8);
        } else if (n2 > 31) {
            this.a[this.a++] = (byte)(0x40 | n3 | n2 >>> 8);
        } else {
            this.a[this.a++] = (byte)(n3 | n2);
            return;
        }
        this.a[this.a++] = (byte)n2;
    }

    public void appendUnsigned(int n2) {
        if (n2 < 0 || n2 > 0x3FFFFFFF) {
            throw new IllegalArgumentException("value range is not 0 to 0x3FFF_FFFF: " + Utilities.toUnsignedHex(n2, 8));
        }
        if (b) {
            this.b(5);
            this.a[this.a++] = 8;
        }
        this.a(n2);
    }

    private void a(int n2) {
        this.b(4);
        if (n2 > 0x3FFFFF) {
            this.a[this.a++] = (byte)(0xC0 | n2 >>> 24);
            this.a[this.a++] = (byte)(n2 >>> 16);
            this.a[this.a++] = (byte)(n2 >>> 8);
        } else if (n2 > 16383) {
            this.a[this.a++] = (byte)(0x80 | n2 >>> 16);
            this.a[this.a++] = (byte)(n2 >>> 8);
        } else if (n2 > 63) {
            this.a[this.a++] = (byte)(0x40 | n2 >>> 8);
        }
        this.a[this.a++] = (byte)n2;
    }

    public void appendFloat(float f2) {
        if (b) {
            this.b(5);
            this.a[this.a++] = 10;
        } else {
            this.b(4);
        }
        int n2 = Float.floatToIntBits(f2);
        this.a[this.a++] = (byte)(n2 >>> 24);
        this.a[this.a++] = (byte)(n2 >>> 16);
        this.a[this.a++] = (byte)(n2 >>> 8);
        this.a[this.a++] = (byte)n2;
    }

    public void appendDouble(double d2) {
        if (b) {
            this.b(9);
            this.a[this.a++] = 11;
        } else {
            this.b(8);
        }
        long l2 = Double.doubleToLongBits(d2);
        this.a[this.a++] = (byte)(l2 >>> 56);
        this.a[this.a++] = (byte)(l2 >>> 48);
        this.a[this.a++] = (byte)(l2 >>> 40);
        this.a[this.a++] = (byte)(l2 >>> 32);
        this.a[this.a++] = (byte)(l2 >>> 24);
        this.a[this.a++] = (byte)(l2 >>> 16);
        this.a[this.a++] = (byte)(l2 >>> 8);
        this.a[this.a++] = (byte)l2;
    }

    public void appendNumber(double d2) {
        long l2;
        String string = d2 < -9.007199254740991E15 || d2 > 9.007199254740991E15 ? Double.toString(d2) : (d2 == (double)(l2 = (long)d2) ? Long.toString(l2) : Double.toString(d2));
        byte[] byArray = string.getBytes(StandardCharsets.US_ASCII);
        int n2 = byArray.length;
        if (b) {
            this.b(n2 + 2);
            this.a[this.a++] = 9;
        } else {
            this.b(n2 + 1);
        }
        this.a[this.a++] = (byte)n2;
        System.arraycopy(byArray, 0, this.a, this.a, n2);
        this.a += n2;
    }

    public void appendString(String string) {
        this.appendString(string, true);
    }

    public void appendString(String string, boolean bl) {
        byte[] byArray;
        int n2;
        if (b) {
            this.b(64 + string.length());
            this.a[this.a++] = 13;
        }
        if (bl && this.a != null) {
            if (this.a.a(string)) {
                this.a(1 | this.a.a(string) << 1);
                return;
            }
            int n3 = string.length();
            if (this.a.a(n3)) {
                byte[] byArray2 = string.getBytes(StandardCharsets.UTF_8);
                n3 = byArray2.length;
                if (n3 > 0xFFFFFF) {
                    throw new IllegalArgumentException("Encoded string length > 0xFF_FFFF (268_435_455) bytes: " + n3);
                }
                this.a(2 | n3 << 2);
                this.a(this.a.a(string));
                this.a(byArray2, 0, n3, false, true);
                return;
            }
        }
        if ((n2 = (byArray = string.getBytes(StandardCharsets.UTF_8)).length) > 0xFFFFFF) {
            throw new IllegalArgumentException("Encoded string length > 0xFF_FFFF (268_435_455) bytes: " + n2);
        }
        this.a(n2 << 2);
        this.a(byArray, 0, n2, false, true);
    }

    public void append(SendTransaction sendTransaction) {
        if (sendTransaction.a == null) {
            throw new IllegalArgumentException("No data in appended transaction");
        }
        sendTransaction.close();
        if (!sendTransaction.c) {
            sendTransaction.c = true;
            SendTransaction.setLongData(sendTransaction.a, 0, sendTransaction.a);
        }
        if (this.a == null) {
            if (this.a.length > 0x1FFFFFFF) {
                throw new IllegalArgumentException("Transaction too large, maximum size = " + Utilities.toUnsignedHex(0x1FFFFFFF, 8));
            }
            this.a = sendTransaction.a;
            this.a = sendTransaction.a;
            this.c = true;
        } else {
            if (!this.c) {
                this.c = true;
                SendTransaction.setLongData(this.a, 0, this.a);
            }
            this.d = false;
            int n2 = sendTransaction.a;
            if (b) {
                this.c(1 + n2);
                this.a[this.a++] = 14;
            } else {
                this.c(n2);
            }
            this.a(sendTransaction.a, 0, n2, false, false);
        }
        this.close();
    }

    public void append(byte[] byArray) {
        this.append(byArray, 0, byArray.length);
    }

    public void append(byte[] byArray, int n2) {
        this.append(byArray, 0, n2);
    }

    public void append(byte[] byArray, int n2, int n3) {
        this.a(byArray, n2, n3, b, true);
    }

    private void a(byte[] byArray, int n2, int n3, boolean bl, boolean bl2) {
        if (bl) {
            this.b(n3 + 1);
            this.a[this.a++] = 12;
        }
        if (bl2) {
            this.b(n3);
        }
        System.arraycopy(byArray, n2, this.a, this.a, n3);
        this.a += n3;
    }

    private void b(int n2) {
        if (this.d) {
            throw new IllegalStateException("SendTransaction is closed");
        }
        if (this.c) {
            throw new IllegalStateException("SendTransaction is sealed for further append");
        }
        if (this.a == null) {
            if (n2 + 4 > 0x1FFFFFFF) {
                throw new IllegalArgumentException("Transaction too large, maximum size = " + Utilities.toUnsignedHex(0x1FFFFFFF, 8));
            }
            int n3 = n2 + 259 >>> 8 << 8;
            this.a = new byte[n3];
            this.a = 4;
        } else {
            int n4 = this.a.length;
            if (n2 + this.a > n4) {
                if (n2 + this.a > 0x1FFFFFFF) {
                    throw new IllegalArgumentException("Transaction too large, maximum size = " + Utilities.toUnsignedHex(0x1FFFFFFF, 8));
                }
                int n5 = (int)Math.min(((long)(n2 + this.a) + 256L) * 2L, 0x40000000L);
                int n6 = n5 - n5 % 512;
                byte[] byArray = new byte[n6];
                System.arraycopy(this.a, 0, byArray, 0, this.a);
                this.a = byArray;
            }
        }
    }

    private void c(int n2) {
        if (this.d) {
            throw new IllegalStateException("SendTransaction is closed");
        }
        if (this.a == null) {
            if (n2 > 0x1FFFFFFF) {
                throw new IllegalArgumentException("Transaction too large, maximum size = " + Utilities.toUnsignedHex(0x1FFFFFFF, 8));
            }
            int n3 = n2 * 2 + 259 >>> 8 << 8;
            this.a = new byte[n3];
            this.a = 4;
        } else {
            int n4 = this.a.length;
            if (n2 + this.a > n4) {
                if (n2 + this.a > 0x1FFFFFFF) {
                    throw new IllegalArgumentException("Transaction too large, maximum size = " + Utilities.toUnsignedHex(0x1FFFFFFF, 8));
                }
                int n5 = (int)Math.min(((long)(n2 + this.a) + 256L) * 2L, 0x40000000L);
                int n6 = n5 - n5 % 512;
                byte[] byArray = new byte[n6];
                System.arraycopy(this.a, 0, byArray, 0, this.a);
                this.a = byArray;
            }
        }
    }

    public String dumpWriteCache(String string) {
        return this.a != null ? this.a.toString() : "*** NO WRITE CACHE ***";
    }
}

