/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.prop.editor;

import com.iizigo.prop.BaseEditor;
import com.iizigo.swt.UpDownArrowSpinner;
import com.iizix.prop.NumberProp;

public class NumberPropEditor
extends BaseEditor<NumberProp, Double> {
    @Override
    protected void create() {
        this.createGridLayout(1, 0);
        this.createText();
        UpDownArrowSpinner.enable(this.text, true);
    }

    @Override
    protected String getToolTipText() {
        return "Enter a Number";
    }

    @Override
    public Double getDefaultValue() {
        try {
            return Double.valueOf(this.info.defaultPropertyValue);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    @Override
    protected Double getValue(String string) throws Exception {
        if (string.isEmpty()) {
            throw new Exception("Number must be specified");
        }
        String string2 = null;
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            string2 = "Invalid number: " + string;
            throw new Exception(string2);
        }
    }

    @Override
    public String formatValue(Double d2) {
        return (double)d2.longValue() == d2 ? Long.toString(d2.longValue()) : d2.toString();
    }
}

