/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.project;

import com.iizigo.prop.IPropertyEditorController;
import com.iizigo.prop.PropertyEditorInfo;
import com.iizigo.prop.editor.IEntryValidator;
import com.iizix.prop.PropCnr;

public class AppVersionValidator
implements IEntryValidator {
    @Override
    public String validate(IPropertyEditorController iPropertyEditorController, PropertyEditorInfo propertyEditorInfo, PropCnr[] propCnrArray, String string, String[] stringArray) {
        if (string != null) {
            int n2 = string.length();
            if (n2 > 64) {
                return "Version string is too long: maximum 64 characters";
            }
            char c2 = string.charAt(0);
            if (c2 < '0' || c2 > '9') {
                return "Version string must start with a number character";
            }
            int n3 = 0;
            while (n3 < n2) {
                c2 = string.charAt(n3);
                if (!(c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z' || c2 == '.' || c2 == '-' || c2 == '_')) {
                    return "Invalid character '" + c2 + "' in version string: only 0-9, '.-_' and a-z characters are allowed";
                }
                ++n3;
            }
        }
        return null;
    }

    @Override
    public String getDescription(IPropertyEditorController iPropertyEditorController, PropertyEditorInfo propertyEditorInfo, PropCnr[] propCnrArray, String[] stringArray) {
        return "Enter the app Version string as e.g. \"1.2.3.45678-type\" where \"45678\" is e.g. the build number\n\"-type\" is \"test\", \"acc\" or \"prod\" to specify that the app is in test, acceptance\nor production. The version must start with a number and valid characters are numbers,\n'.-_' and 'a' to 'z'.";
    }
}

