/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.prop.editor;

import com.iizigo.Activator;
import com.iizigo.editor.PropHelper;
import com.iizigo.prop.BaseEditor;
import com.iizigo.prop.IPropDesigner;
import com.iizigo.prop.editor.VSRelativeReferencePropEditor;
import com.iizigo.prop.editor.dialog.SelectPropDialog;
import com.iizigo.prop.editor.dialog.SelectPropViewerFilter;
import com.iizigo.swt.IzToolTip;
import com.iizigo.vs.prop.EditorVSTable;
import com.iizigo.vs.prop.EditorVirtualSpace;
import com.iizix.ILog;
import com.iizix.prop.GProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.vs.IVSTableColumnReferenceOwner;
import com.iizix.prop.vs.VSColumnHeader;
import com.iizix.prop.vs.VSReference;
import com.iizix.prop.vs.VSRelativeReference;
import com.iizix.prop.vs.VSTable;
import com.iizix.prop.vs.VSTableColumnReference;
import com.iizix.prop.vs.VirtualSpace;
import com.iizix.swt.IzMenu;
import com.iizix.swt.IzMenuItem;
import com.iizix.swt.SWTHelper;
import java.util.HashSet;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class VSTableColumnReferencePropEditor
extends BaseEditor<VSRelativeReference<?>, String> {
    private static final Class<?>[] a = new Class[]{VSColumnHeader.class};
    protected String title = "Select a VS Table Column";
    protected String moreText = "Selects a VS Table Column";
    protected String tooltipText = "Enter a name of a VS Table Column";
    protected String itemDefined = "VS Table Column";
    protected Image image;
    protected Class<?>[] classes = a;
    protected IzToolTip tip;
    protected IzMenu menu;
    protected IzMenuItem miSelect;
    protected IzMenuItem miGoto;

    protected void setup() {
    }

    @Override
    protected void create() {
        block25: {
            this.setup();
            if (this.options == null) break block25;
            HashSet hashSet = null;
            String[] stringArray = this.options;
            int n2 = this.options.length;
            int n3 = 0;
            while (n3 < n2) {
                block26: {
                    String string = stringArray[n3];
                    int n4 = string.indexOf(61);
                    if (n4 <= 0) break block26;
                    String string2 = string.substring(n4 + 1).trim();
                    switch (string.substring(0, n4).toLowerCase()) {
                        case "title": {
                            this.title = string2;
                            break;
                        }
                        case "more": {
                            this.moreText = string2;
                            break;
                        }
                        case "tooltip": {
                            this.tooltipText = string2;
                            break;
                        }
                        case "image": {
                            this.image = this.appUI.getImage(string2);
                            break;
                        }
                        case "class": {
                            try {
                                Class<?> clazz = Class.forName(string2);
                                if (hashSet == null) {
                                    hashSet = new HashSet();
                                }
                                hashSet.add(clazz);
                                break;
                            }
                            catch (Exception exception) {
                                ILog.SEVERE(this.getClass(), (String)("Failed loading class " + string2), (Throwable)exception);
                            }
                        }
                    }
                }
                ++n3;
            }
            if (hashSet != null) {
                this.classes = hashSet.toArray(new Class[hashSet.size()]);
            }
        }
        if (this.image == null) {
            this.image = this.appUI.imageVSColumn;
        }
        this.createGridLayout(2, 0);
        this.createMoreButton(this.moreText);
        this.createText();
        this.tip = new IzToolTip((Control)this.text);
        this.menu = this.createMoreIzMenu();
        this.menu.addMenuListener(() -> this.a());
    }

    private void a() {
        PropCnr propCnr;
        VSReference vSReference;
        this.menu.clear();
        this.onCreateMenu(this.menu, false);
        boolean bl = false;
        if (this.propController.getParents().length == 1 && ((vSReference = (propCnr = this.propController.getParents()[0]).getVSReference(this.info.atom)) != null || propCnr.createVSReference(this.info.atom, new PropCnr[1]) != null)) {
            VirtualSpace virtualSpace;
            VirtualSpace virtualSpace2 = virtualSpace = vSReference != null ? (VirtualSpace)vSReference.getTargetReference() : null;
            if (virtualSpace == null) {
                this.menu.add("&Connect to VirtualSpace...", this.appUI.imageVSField, event -> {
                    EditorVirtualSpace editorVirtualSpace = this.getVirtualSpace(0);
                }).add("Create &VirtualSpace and connect it...", this.appUI.getNewImage(this.appUI.imageVSField), event -> {
                    EditorVirtualSpace editorVirtualSpace = this.getVirtualSpace(1);
                }).addSeparator();
            }
            this.menu.add("Create VS &Table Column...", this.appUI.getNewImage(this.appUI.imageVSColumn), event -> {
                VSTableColumnReference vSTableColumnReference = new VSTableColumnReference(this.info.atom);
                VSRelativeReferencePropEditor.onCreateVSColumn(this.getVirtualSpace(-1), this.controller, this.propController, this.text, vSTableColumnReference);
            });
            bl = true;
        }
        if (bl) {
            this.menu.addSeparator();
        }
        this.miSelect = new IzMenuItem(this.menu, this.title + "...", this.image, event -> {
            boolean bl = this.onList(true);
        });
        this.menu.addSeparator();
        this.miGoto = new IzMenuItem(this.menu, "Show reference in Editor", this.appUI.imageShowInEditor, event -> {
            boolean bl = this.onGoto(true);
        });
        this.onCreateMenu(this.menu, true);
        this.miSelect.setEnabled(this.onList(false));
        this.miGoto.setEnabled(this.onGoto(false));
    }

    protected EditorVirtualSpace getVirtualSpace(int n2) {
        return VSRelativeReferencePropEditor.getVirtualSpace(this.shell, n2, this.controller, this.propController, this.info.atom);
    }

    protected void onCreateMenu(IzMenu izMenu, boolean bl) {
    }

    @Override
    protected void onDoubleClick(Event event) {
        event.doit = false;
        if (!this.onGoto(true)) {
            this.onList(true);
        }
    }

    @Override
    public void onMore() {
        this.a();
        SWTHelper.showPopupMenu(this.menu, (Control)this.more);
    }

    protected boolean onList(boolean bl) {
        PropCnr propCnr = this.propController.getParents()[0];
        Object object = null;
        if (!(propCnr instanceof IVSTableColumnReferenceOwner)) {
            object = "Parent property doesn't implement IVSTableColumnReferenceOwner!";
        } else {
            IVSTableColumnReferenceOwner iVSTableColumnReferenceOwner = (IVSTableColumnReferenceOwner)propCnr;
            EditorVSTable editorVSTable = (EditorVSTable)iVSTableColumnReferenceOwner.getVSTable(null);
            if (editorVSTable == null) {
                object = "Can only define the VS Table Column reference when the VS Table reference has been set.";
            } else if (bl) {
                SelectPropViewerFilter selectPropViewerFilter = new SelectPropViewerFilter(this.classes);
                Object[] objectArray = new Object[]{editorVSTable.getDesigner()};
                String string = new SelectPropDialog(this.shell, this.title, this.image, this.controller.getModuleModel(), objectArray, selectPropViewerFilter, this.classes, this.text.getText(), -1).open();
                if (string != null) {
                    GProp gProp = editorVSTable.getPropFromReference(string);
                    if (gProp == null) {
                        object = "Property reference \"" + string + "\" could not be found!";
                    } else {
                        string = gProp.getPropName();
                        this.setCurrentValue(string);
                    }
                }
                this.text.setFocus();
            }
        }
        if (object != null) {
            if (bl) {
                Activator.openError(this.shell, "Relative VirtualSpace Error", (String)object);
            }
            return false;
        }
        return true;
    }

    protected boolean onGoto(boolean bl) {
        VSColumnHeader vSColumnHeader = this.getCurrentReferenceTarget();
        if (vSColumnHeader == null) {
            return false;
        }
        return PropHelper.doOpenAndFocus(bl, vSColumnHeader, -1);
    }

    protected VSColumnHeader getCurrentReferenceTarget() {
        return this.getReferenceTarget((String)this.propController.getCurrentValue());
    }

    protected VSColumnHeader getReferenceTarget(String string) {
        PropCnr propCnr = this.propController.getParents()[0];
        if (!(propCnr instanceof IVSTableColumnReferenceOwner)) {
            return null;
        }
        IVSTableColumnReferenceOwner iVSTableColumnReferenceOwner = (IVSTableColumnReferenceOwner)propCnr;
        VSTable vSTable = iVSTableColumnReferenceOwner.getVSTable(null);
        if (string == null || vSTable == null) {
            return null;
        }
        return (VSColumnHeader)vSTable.getHeader().getProp(string, VSColumnHeader.class);
    }

    @Override
    protected String getToolTipText() {
        return this.tooltipText;
    }

    @Override
    protected void setToolTipText(String string) {
        if (string == null) {
            if (this.getSeverity() == 0) {
                VSColumnHeader vSColumnHeader = this.getCurrentReferenceTarget();
                while (vSColumnHeader != null && !(vSColumnHeader instanceof IPropDesigner)) {
                    vSColumnHeader = vSColumnHeader.getParent();
                }
                if (vSColumnHeader instanceof IPropDesigner) {
                    IPropDesigner iPropDesigner = (IPropDesigner)vSColumnHeader;
                    this.tip.setProperty(iPropDesigner.getDesigner());
                    return;
                }
            }
            string = this.getToolTipText2();
        }
        this.tip.setText(string, 0);
    }

    @Override
    public String getDefaultValue() {
        return "";
    }

    @Override
    protected String getValue(String string) {
        return string;
    }

    @Override
    public String formatValue(String string) {
        return string;
    }
}

