/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.image.prop;

import com.iizigo.ApplicationUI;
import com.iizigo.image.ImageHelper;
import com.iizigo.image.LastVerified;
import com.iizigo.image.prop.EditorImageStyle;
import com.iizigo.image.prop.IEditorImage;
import com.iizigo.image.prop.ILastVerified;
import com.iizigo.image.prop.ImageDesignerProp;
import com.iizigo.prop.IPropDesigner;
import com.iizix.prop.AssetReference;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.image.ImageResolution;
import java.util.HashSet;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class EditorImageResolution
extends ImageResolution
implements IEditorImage,
ILastVerified,
IPropDesigner {
    private ImageDesignerProp a;
    private final LastVerified a = new ImageDesignerProp((PropCnr)this);

    public EditorImageResolution() {
    }

    public EditorImageResolution(Atom atom) {
        super(atom);
    }

    @Override
    public LastVerified getLastVerified() {
        return this.a;
    }

    @Override
    public ImageDesignerProp getDesigner() {
        return this.a;
    }

    public EditorImageResolution clone() throws CloneNotSupportedException {
        EditorImageResolution editorImageResolution = (EditorImageResolution)super.clone();
        editorImageResolution.a = new ImageDesignerProp((PropCnr)editorImageResolution);
        return editorImageResolution;
    }

    @Override
    public Image getCNImage() {
        return ApplicationUI.getInstance().imageImageResolution;
    }

    @Override
    public String getCNType() {
        return "Resolution";
    }

    @Override
    public String getCNText(int n2) {
        return n2 == 0 ? "resolution, device pixel ratio = " + this.getDevicePixelRatio() : (n2 == 1 ? ImageHelper.getSize(this.a) : this.a.fileName);
    }

    @Override
    public Composite createTooltip(Composite composite) {
        Composite composite2 = ImageHelper.createImageTooltip((PropCnr)this, composite, this.getAssetReference(), this.getCNImage(), this.getCNType(), this.getCNText(0));
        double d2 = this.getDevicePixelRatio();
        if (d2 > 0.0) {
            Label label = new Label(composite2, 0);
            label.setText("Device pixel ratio:");
            label = new Label(composite2, 0);
            label.setText(Double.toString(d2));
        }
        return composite2;
    }

    public void onAssetReferenceChanged(AssetReference assetReference) {
        super.onAssetReferenceChanged(assetReference);
        ImageHelper.flagVerification((PropCnr)this);
    }

    public boolean verify(PropVerification propVerification) {
        if (!super.verify(propVerification)) {
            return false;
        }
        ImageHelper.verify((PropCnr)this, propVerification);
        HashSet<String> hashSet = new HashSet<String>();
        GProp[] gPropArray = this.getProps();
        int n2 = gPropArray.length;
        int n3 = 0;
        while (n3 < n2) {
            EditorImageStyle editorImageStyle;
            String string;
            GProp gProp = gPropArray[n3];
            if (gProp instanceof EditorImageStyle && !hashSet.add(string = (editorImageStyle = (EditorImageStyle)gProp).getStyleString())) {
                propVerification.add(new PropVerificationError("dup.style", PropVerificationError.Severity.ERROR, "Image style", (GProp)editorImageStyle, "Image Style is a duplicate", new String[]{"DeleteProperty", "OpenProp"}));
            }
            ++n3;
        }
        return true;
    }
}

