/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.weblogos;

import com.iizix.GenericListener;
import com.iizix.ILog;
import com.iizix.NotFoundException;
import com.iizix.Utilities;
import com.iizix.server.ServerShell;
import com.iizix.server.weblogos.IWebLogoListener;
import com.iizix.server.weblogos.WebLogoState;
import com.iizix.server.weblogos.WebLogos;
import com.iizix.server.wsfile.WSFileProvider;
import com.iizix.wsfile.IWSFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.StandardCopyOption;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WebLogo {
    private final Object a;
    private final String a;
    private File a;
    private IWSFile a;
    WebLogoState a;
    private Throwable a;
    private GenericListener<IWebLogoListener> a = WebLogoState.INITIALIZING;
    private static volatile /* synthetic */ int[] a;

    WebLogo(String string, File file, IWSFile iWSFile) {
        this.a = string;
        this.a = Utilities.getCanonicalFile((File)file);
        this.a = iWSFile;
        if (iWSFile != null) {
            this.a = WebLogoState.SUCCESS;
        }
    }

    public boolean isDisposed() {
        return this.a == WebLogoState.DISPOSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a() {
        Object object;
        WebLogoState webLogoState;
        Object object2 = this.a;
        synchronized (object2) {
            webLogoState = this.a = WebLogoState.DISPOSED;
            this.a.notifyAll();
            object = this.a;
            this.a = null;
        }
        if (object != null) {
            object.forEach(iWebLogoListener -> iWebLogoListener.onCompleted(this, webLogoState, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Runnable a(ServerShell serverShell, WSFileProvider wSFileProvider) {
        Object object = this.a;
        synchronized (object) {
            if (this.a != WebLogoState.INITIALIZING) {
                return null;
            }
            this.a = WebLogoState.PENDING;
            this.a.notifyAll();
        }
        return () -> {
            Object object;
            Object object2;
            WebLogoState webLogoState = WebLogoState.SUCCESS;
            IOException iOException = null;
            IWSFile iWSFile = null;
            if (wSFileProvider.isDisposed() || this.isDisposed()) {
                webLogoState = WebLogoState.DISPOSED;
                object2 = this.a;
                synchronized (object2) {
                    object = this.a;
                }
            }
            object2 = this.a;
            synchronized (object2) {
                this.a = WebLogoState.RETRIEVING;
                this.a.notifyAll();
            }
            try {
                object2 = this.a(serverShell, this.a, this.a);
                this.a = object2;
                iWSFile = wSFileProvider.reserveFile(this.a, this.a, null);
                ILog.INFO(this.getClass(), (String)("Generated website " + this.a + " logo, size = " + Utilities.getEnglishSize((long)this.a.length()) + ", file " + this.a.getPath()));
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                webLogoState = WebLogoState.ERROR;
                ILog.WARNING(this.getClass(), (String)("Failed loading logo for website " + this.a + ": " + iOException2.getMessage()));
            }
            catch (NotFoundException | InvalidPathException throwable) {
                ILog.WARNING(this.getClass(), (String)("Unexpected error loading logo for Website " + this.a));
            }
            object2 = this.a;
            synchronized (object2) {
                if (this.a == WebLogoState.DISPOSED) {
                    webLogoState = WebLogoState.DISPOSED;
                    iOException = null;
                } else {
                    this.a = webLogoState;
                }
                this.a = iWSFile;
                this.a = iOException;
                this.a.notifyAll();
                object = this.a;
                this.a = null;
            }
            if (object != null) {
                object2 = webLogoState;
                IOException iOException3 = iOException;
                object.forEach(arg_0 -> this.a((WebLogoState)((Object)((Object)object2)), iOException3, arg_0));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebLogoState waitForCompletion(Runnable runnable) {
        try {
            Object object = this.a;
            synchronized (object) {
                block11: while (true) {
                    switch (WebLogo.a()[this.a.ordinal()]) {
                        case 1: 
                        case 2: 
                        case 5: 
                        case 6: {
                            return this.a;
                        }
                        case 3: 
                        case 4: {
                            break block11;
                        }
                        default: {
                            continue block11;
                        }
                    }
                    break;
                }
                try {
                    this.a.wait(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            runnable.run();
        }
        catch (Throwable throwable) {
            ILog.SEVERE(this.getClass(), (String)"The \"runnable\" callback failed", (Throwable)throwable);
        }
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebLogoState addCompletionListener(Runnable runnable) {
        try {
            Object object = this.a;
            synchronized (object) {
                block11: while (true) {
                    switch (WebLogo.a()[this.a.ordinal()]) {
                        case 1: 
                        case 2: 
                        case 5: 
                        case 6: {
                            return this.a;
                        }
                        case 3: 
                        case 4: {
                            break block11;
                        }
                        default: {
                            continue block11;
                        }
                    }
                    break;
                }
                try {
                    this.a.wait(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            runnable.run();
        }
        catch (Throwable throwable) {
            ILog.SEVERE(this.getClass(), (String)"The \"runnable\" callback failed", (Throwable)throwable);
        }
        return this.a;
    }

    public File getFile() {
        return this.a;
    }

    public IWSFile getWSFile() {
        return this.a;
    }

    public WebLogoState getState() {
        return this.a;
    }

    public Throwable getException() {
        return this.a;
    }

    public String getSite() {
        return this.a;
    }

    private File a(ServerShell serverShell, String string, String object) throws IOException, InvalidPathException {
        block52: {
            File file = this.a.getParentFile();
            File file2 = WebLogos.siteToFileName(file, (String)object);
            if (file2 != null) {
                return file2;
            }
            boolean bl = false;
            int n = -1;
            String string2 = "http://logo.clearbit.com/" + URLEncoder.encode((String)object, StandardCharsets.UTF_8);
            try {
                URL uRL;
                try {
                    uRL = new URI(string2).toURL();
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new IOException("The request " + string2 + " has a syntax error", uRISyntaxException);
                }
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                serverShell.configureProxy(httpURLConnection);
                n = httpURLConnection.getResponseCode();
                Throwable throwable = null;
                Object var12_16 = null;
                try (InputStream inputStream = httpURLConnection.getInputStream();){
                    if (n != 200) break block52;
                    String string3 = httpURLConnection.getContentType();
                    if (string3 == null || string3.isEmpty()) {
                        throw new IOException("Content encoding not specified for logo for Website '" + this.a + "' at '" + String.valueOf(uRL) + "'");
                    }
                    String string4 = switch (string3 = string3.toLowerCase()) {
                        case "image/bmp" -> ".bmp";
                        case "image/png" -> ".png";
                        case "image/jpeg", "image/jpg" -> ".jpg";
                        case "image/gif" -> ".gif";
                        case "image/tiff", "image/webp", "image/svg", "image/svg+xml" -> throw new IOException("Website '" + this.a + "' logo is in " + string3 + " format: currently unsupported");
                        default -> throw new IOException("Content encoding '" + string3 + "' logo for Website '" + this.a + "' at '" + String.valueOf(uRL) + "' is either not supported");
                    };
                    String string5 = this.a.getName();
                    if (!string5.endsWith(string4)) {
                        Object object2;
                        int n2 = string5.lastIndexOf(46);
                        if (n2 < 0) {
                            throw new IOException("Website '" + (String)object + "' for file name is invalid: " + string5);
                        }
                        String string6 = string5.substring(n2).toLowerCase();
                        boolean bl2 = false;
                        boolean bl3 = false;
                        String[] stringArray = WebLogos.FILE_EXTS;
                        int n3 = WebLogos.FILE_EXTS.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            object2 = stringArray[n4];
                            if (((String)object2).equals(string4)) {
                                bl3 = true;
                                if (!string6.equals(object2)) {
                                    bl2 = true;
                                    break;
                                }
                            }
                            ++n4;
                        }
                        if (!bl3) {
                            object2 = "Website '" + this.a + "' logo format has a file that cannot be processed: " + string5;
                            throw new IOException((String)object2);
                        }
                        if (bl2 && this.a.isFile() && !this.a.delete()) {
                            ILog.WARNING(this.getClass(), (String)("Failed deleting the old Website '" + this.a + "' logo file: " + this.a.getPath()));
                        }
                        this.a = Utilities.getCanonicalFile((File)new File(file, string5.substring(0, n2) + string4));
                    }
                    Files.copy(inputStream, this.a.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                if (!bl && !((String)object).startsWith("www.") && (n < 0 || n >= 400 && n < 500)) {
                    object = "www." + (String)object;
                    ILog.INFO(this.getClass(), (String)("Failed loading logo for Website " + string + ", attempting " + (String)object + ": " + iOException.getMessage()));
                    try {
                        return this.a(serverShell, string, (String)object);
                    }
                    catch (IOException iOException2) {
                        iOException.addSuppressed(iOException2);
                    }
                }
                throw iOException;
            }
        }
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(IWebLogoListener iWebLogoListener) {
        Object object = this.a;
        synchronized (object) {
            block5: {
                if (this.a == WebLogoState.PENDING || this.a == WebLogoState.RETRIEVING) break block5;
                return false;
            }
            if (this.a == null) {
                this.a = new GenericListener(IWebLogoListener.class);
            }
            return this.a.addListener((Object)iWebLogoListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(IWebLogoListener iWebLogoListener) {
        Object object = this.a;
        synchronized (object) {
            return this.a != null ? this.a.removeListener((Object)iWebLogoListener) : false;
        }
    }

    static /* synthetic */ int[] a() {
        if (a != null) {
            return a;
        }
        int[] nArray = new int[WebLogoState.values().length];
        try {
            nArray[WebLogoState.DISPOSED.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WebLogoState.ERROR.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WebLogoState.INITIALIZING.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WebLogoState.PENDING.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WebLogoState.RETRIEVING.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WebLogoState.SUCCESS.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        a = nArray;
        return nArray;
    }

    private /* synthetic */ void a(WebLogoState webLogoState, Throwable throwable, IWebLogoListener iWebLogoListener) {
        iWebLogoListener.onCompleted(this, webLogoState, throwable);
    }
}

