/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.ui;

import com.iizix.prop.Atom;
import com.iizix.prop.ui.UIComp;
import com.iizix.prop.ui.UIContainer;
import com.iizix.prop.ui.selection.IUIBooleanSelectionComp;
import com.iizix.prop.ui.selection.IUIIndexedSelection;
import com.iizix.prop.ui.selection.IUISingleIndexedSelectionComp;
import com.iizix.prop.ui.selection.RadioSelection;

public interface IUIRadioComponent
extends IUIBooleanSelectionComp,
IUISingleIndexedSelectionComp {
    public static final String PN_GROUP_NAME = "rgrp";
    public static final String PN_SELECTED = "selected";
    public static final Atom SELECTED_ATOM = Atom.get("selected");
    public static final String PN_SELECTED_NO_MATCH = "selNoMatch";
    public static final String PN_SELECTED_VALUE = "selValue";

    default public String getGroupName() {
        return this.getString(PN_GROUP_NAME);
    }

    @Override
    default public boolean isSelected() {
        return this.getBool(PN_SELECTED);
    }

    @Override
    default public boolean isUnselected() {
        return !this.getBool(PN_SELECTED);
    }

    @Override
    default public boolean isON() {
        return this.getBool(PN_SELECTED);
    }

    @Override
    default public boolean isOFF() {
        return !this.getBool(PN_SELECTED);
    }

    @Override
    default public int getSelectedIndex() {
        UIComp uIComp = this.getSelectedRadioComponent();
        if (uIComp != null) {
            int n2 = 0;
            UIComp[] uICompArray = this.getRadioSelectionComponents();
            int n3 = uICompArray.length;
            int n4 = 0;
            while (n4 < n3) {
                UIComp uIComp2 = uICompArray[n4];
                if (uIComp == uIComp2) {
                    return n2;
                }
                ++n2;
                ++n4;
            }
        }
        return -1;
    }

    @Override
    default public int[] getSelectedIndicies() {
        int[] nArray;
        int n2 = this.getFirstSelectedIndex();
        if (n2 >= 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = n2;
        } else {
            nArray = IUIIndexedSelection.EMPTY;
        }
        return nArray;
    }

    @Override
    default public String setSelection(int n2) {
        if (n2 < 0) {
            return this.clearSelection();
        }
        UIContainer uIContainer = this.getUIParent();
        if (uIContainer == null) {
            return "Radio component does not have a parent container";
        }
        UIComp[] uICompArray = uIContainer.getRadioSelectionComponents(this.getGroupName());
        if (n2 >= uICompArray.length) {
            return "Selection index " + n2 + " is out of bounds (0-" + uICompArray.length + ")";
        }
        uIContainer.setRadioSelectionComponent((IUIRadioComponent)((Object)uICompArray[n2]), true);
        return null;
    }

    @Override
    default public String clearSelection() {
        this.setSelection(false);
        return null;
    }

    default public boolean isSelectedByDefault() {
        return this.getBool(PN_SELECTED_NO_MATCH);
    }

    @Override
    default public boolean setSelection(boolean bl) {
        UIContainer uIContainer;
        if (bl && (uIContainer = this.getUIParent()) != null) {
            return uIContainer.setRadioSelectionComponent(this, true);
        }
        return this.setBool(PN_SELECTED, bl);
    }

    default public UIComp[] getRadioSelectionComponents() {
        UIComp[] uICompArray;
        UIContainer uIContainer = this.getUIParent();
        if (uIContainer != null) {
            uICompArray = uIContainer.getRadioSelectionComponents(this.getGroupName());
        } else {
            UIComp[] uICompArray2 = new UIComp[1];
            uICompArray = uICompArray2;
            uICompArray2[0] = (UIComp)((Object)this);
        }
        return uICompArray;
    }

    default public UIComp getSelectedRadioComponent() {
        UIContainer uIContainer = this.getUIParent();
        return uIContainer != null ? uIContainer.getSelectedRadioComponent(this.getGroupName()) : (this.isSelected() ? (UIComp)((Object)this) : null);
    }

    @Override
    default public int getSelectionType() {
        return 1;
    }

    @Override
    default public RadioSelection getSelection() {
        return new RadioSelection(this, this.getBool(PN_SELECTED), this.getFirstSelectedIndex());
    }
}

