/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.ILog;
import com.iizix.IntArrayList;
import com.iizix.prop.Atom;
import com.iizix.prop.EnvProps;
import com.iizix.prop.GProp;
import com.iizix.prop.ISelectorExpression;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.Selector;
import com.iizix.prop.StringProp;
import com.iizix.selector.DeviceMatch;
import com.iizix.selector.LanguageMatch;
import com.iizix.util.WindowsLikeFilenameFilter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class SelectorExpression {
    public static final Reference[] EMPTY = new Reference[0];
    public final String expression;
    protected final ArrayList<TokenData> tokens = new ArrayList();
    private int a;
    private int b;
    private int c;
    private final StringBuilder a;
    private String a = new StringBuilder();
    private int d;
    private static volatile /* synthetic */ int[] a;

    public boolean isValidWordCharacter(int n2) {
        return ":/\\{}\"'?*^,;".indexOf(n2) < 0 && " -\t\r\n".indexOf(n2) < 0;
    }

    public SelectorExpression(String string) {
        this.expression = string;
        this.c = string.length();
    }

    public boolean parse() {
        if (this.c < 0) {
            return this.a == null;
        }
        try {
            this.a();
            int n2 = this.a;
            this.e();
            if (this.a < this.c) {
                if (this.expression.charAt(this.a) == ')') {
                    throw new ParseException("Unbalanced closing parenthesis", this.a);
                }
                throw new ParseException("Unexpected character: expected end of string", n2);
            }
            this.c = -1;
            return true;
        }
        catch (ParseException parseException) {
            this.d = parseException.getErrorOffset();
            this.a = parseException.getMessage();
            this.c = -1;
            return false;
        }
    }

    public int getErrorPosition() {
        return this.a != null ? this.d : -1;
    }

    public String getError() {
        return this.a;
    }

    private void a() throws ParseException {
        this.b();
        this.e();
        int n2 = this.a();
        switch (n2) {
            case -1: {
                return;
            }
            case 41: {
                this.tokens.add(new TokenData(Token.CLOSE, this.b));
                --this.a;
                return;
            }
            case 124: {
                if (this.a() != n2) {
                    throw new ParseException("Expected operator ||", this.b);
                }
                this.tokens.add(new TokenData(Token.OR, this.b));
                break;
            }
            case 38: {
                if (this.a() != n2) {
                    throw new ParseException("Expected operator &&", this.b);
                }
                this.tokens.add(new TokenData(Token.AND, this.b));
                break;
            }
            default: {
                throw new ParseException("Expected operator || or &&", this.b);
            }
        }
        this.a();
    }

    private void b() throws ParseException {
        this.c();
        switch (this.a()) {
            case 40: {
                this.tokens.add(new TokenData(Token.OPEN, this.b));
                this.a();
                int n2 = this.a;
                this.e();
                int n3 = this.a();
                if (n3 == 41) break;
                throw new ParseException("Unexpected end of string: expected closed parenthesis", n2);
            }
            case 41: {
                throw new ParseException("Unbalanced parenthesis", this.b);
            }
            case 123: {
                this.d();
                break;
            }
            default: {
                throw new ParseException("Unexpected character: expected {expression}", this.b);
            }
        }
    }

    private void c() throws ParseException {
        IntArrayList intArrayList = null;
        while (true) {
            this.e();
            int n2 = this.a();
            if (n2 < 0) {
                throw new ParseException("Unexpected end of string: expected {expression}", this.b);
            }
            if (n2 != 33) {
                --this.a;
                break;
            }
            if (intArrayList == null) {
                intArrayList = new IntArrayList();
            }
            intArrayList.add(this.b);
        }
        if (intArrayList != null) {
            int[] nArray = new int[intArrayList.size()];
            int n3 = 0;
            int[] nArray2 = intArrayList.toArray();
            int n4 = nArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                int n6 = nArray2[n5];
                nArray[n3++] = n6;
                ++n5;
            }
            this.tokens.add(new TokenData(Token.NOT, nArray));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void d() throws ParseException {
        var1_1 = new IntArrayList();
        var1_1.add(this.b);
        this.e();
        var1_1.add(this.b);
        var2_2 = this.a("built-in expression name");
        var4_3 = null;
        var5_4 = null;
        var7_5 = -1;
        var8_6 = var2_2.toLowerCase();
        tmp = -1;
        switch (var8_6.hashCode()) {
            case -934799095: {
                if (var8_6.equals("regexp")) {
                    tmp = 1;
                }
                break;
            }
            case 3788: {
                if (var8_6.equals("wc")) {
                    tmp = 2;
                }
                break;
            }
            case 99349: {
                if (var8_6.equals("dev")) {
                    tmp = 3;
                }
                break;
            }
            case 113754: {
                if (var8_6.equals("sel")) {
                    tmp = 4;
                }
                break;
            }
            case 3254818: {
                if (var8_6.equals("java")) {
                    tmp = 5;
                }
                break;
            }
            case 3314158: {
                if (var8_6.equals("lang")) {
                    tmp = 6;
                }
                break;
            }
        }
        switch (tmp) {
            case 3: {
                this.e();
                var1_1.add(this.b);
                this.f();
                this.e();
                var1_1.add(this.b);
                var7_5 = this.b;
                var3_8 = this.a();
                if (var3_8.isEmpty()) {
                    throw new ParseException("Device string is empty", this.b);
                }
                var7_5 = this.a - var7_5;
                var6_9 = Token.DEVICE;
                break;
            }
            case 6: {
                this.e();
                var1_1.add(this.b);
                this.f();
                this.e();
                var1_1.add(this.b);
                var7_5 = this.b;
                var3_8 = this.a();
                if (var3_8.isEmpty()) {
                    throw new ParseException("Language string is empty", this.b);
                }
                var7_5 = this.a - var7_5;
                var6_9 = Token.LANGUAGE;
                break;
            }
            case 4: {
                this.e();
                var1_1.add(this.b);
                this.f();
                this.e();
                var1_1.add(this.b);
                var7_5 = this.b;
                var3_8 = this.a();
                if (var3_8.isEmpty()) {
                    throw new ParseException("Selector reference is empty", this.b);
                }
                var7_5 = this.a - var7_5;
                var6_9 = Token.SELECTOR;
                break;
            }
            case 5: {
                this.e();
                var1_1.add(this.b);
                this.f();
                this.e();
                var1_1.add(this.b);
                var7_5 = this.b;
                var3_8 = this.a();
                if (var3_8.isEmpty()) {
                    throw new ParseException("Java class name is empty", this.b);
                }
                var7_5 = this.a - var7_5;
                var6_9 = Token.JAVA_CLASS;
                break;
            }
            case 2: {
                this.e();
                var1_1.add(this.b);
                this.f();
                this.e();
                var1_1.add(this.b);
                var3_8 = this.a("environment variable");
                this.e();
                var1_1.add(this.b);
                this.f();
                this.e();
                var1_1.add(this.b);
                var7_5 = this.b;
                var4_3 = this.a();
                var7_5 = this.a - var7_5;
                var6_9 = Token.WILD_CARD;
                break;
            }
            case 1: {
                this.e();
                var1_1.add(this.b);
                this.f();
                this.e();
                var1_1.add(this.b);
                var3_8 = this.a("environment variable");
                if (var3_8.isEmpty()) {
                    throw new ParseException("Environment variable is empty", this.b);
                }
                this.e();
                var1_1.add(this.b);
                this.f();
                this.e();
                var1_1.add(this.b);
                var9_10 = this.a();
                if (var9_10 < 0) {
                    throw new ParseException("Expected single or double quoted regular expression string", this.b);
                }
                var10_12 = this.a--;
                var7_5 = this.b;
                var4_3 = this.a();
                if (var4_3.isEmpty()) {
                    throw new ParseException("Quoted regular expression string cannot be empty", this.b);
                }
                var7_5 = this.a - var7_5;
                var6_9 = Token.REG_EXP;
                try {
                    var5_4 = Pattern.compile(var4_3);
                    break;
                }
                catch (PatternSyntaxException var11_13) {
                    var12_16 = var11_13.getIndex();
                    if (var12_16 >= var4_3.length()) {
                        var12_16 = var4_3.length() - 1;
                    }
                    var13_18 = var12_16;
                    ** while (var12_16 >= 0)
                }
lbl-1000:
                // 1 sources

                {
                    if (var4_3.charAt(var12_16--) != var9_10) continue;
                    ++var10_12;
                    continue;
                }
lbl150:
                // 1 sources

                throw new ParseException("Regular Expression error: " + var11_13.getDescription(), var10_12 + var13_18);
            }
            default: {
                throw new ParseException("Unknown built-in function: '" + var2_2 + "'", this.b);
            }
        }
        this.e();
        var8_7 = this.a();
        if (var8_7 != 125) {
            if (var8_7 >= 0) {
                --this.a;
            }
            throw new ParseException("Expected end of built-in expression: '}'", this.b);
        }
        var1_1.add(this.b);
        var9_11 = new int[var1_1.size()];
        var10_12 = 0;
        var14_20 = var1_1.toArray();
        var13_19 = var14_20.length;
        var12_17 = 0;
        while (var12_17 < var13_19) {
            var11_14 = var14_20[var12_17];
            var9_11[var10_12++] = var11_14;
            ++var12_17;
        }
        var11_15 = new TokenData(var6_9, var3_8, var4_3, var5_4, var9_11);
        if (var7_5 >= 0) {
            var11_15.a = var7_5;
        }
        this.tokens.add(var11_15);
    }

    private int a() {
        if (this.a >= this.c) {
            return -1;
        }
        return this.expression.charAt(this.a++);
    }

    private void e() {
        while (this.a < this.c) {
            char c2 = this.expression.charAt(this.a);
            if (c2 != ' ' && c2 != '\r' && c2 != '\n' && c2 != '\t') break;
            ++this.a;
        }
        this.b = this.a;
    }

    private void f() throws ParseException {
        int n2 = this.a();
        if (n2 != 58) {
            throw new ParseException("Expected ':'", this.b);
        }
    }

    String a(String string) throws ParseException {
        this.a.setLength(0);
        int n2 = this.a();
        if (n2 < 0) {
            throw new ParseException("Expected a word (" + string + ")", this.b);
        }
        if (!this.isValidWordCharacter(n2)) {
            throw new ParseException("Invalid first character in word", this.b);
        }
        do {
            this.a.append((char)n2);
            n2 = this.a();
            if (n2 >= 0) continue;
            return this.a.toString();
        } while (this.isValidWordCharacter(n2));
        --this.a;
        return this.a.toString();
    }

    private String a() throws ParseException {
        String string;
        this.a.setLength(0);
        int n2 = this.a();
        if (n2 < 0) {
            throw new ParseException("Expected quoted string", this.b);
        }
        if (n2 == 39) {
            string = "single quote";
        } else if (n2 == 34) {
            string = "double quote";
        } else {
            throw new ParseException("Invalid character for quoted string: must be a single or double quote character", this.b);
        }
        while (true) {
            int n3;
            if ((n3 = this.a()) < 0) {
                throw new ParseException("Unexpected end of string: expected ending " + string, this.b);
            }
            if (n3 == n2) {
                if (this.a < this.c && this.expression.charAt(this.a) == n2) {
                    this.a.append((char)n3);
                    ++this.a;
                    continue;
                }
                return this.a.toString();
            }
            this.a.append((char)n3);
        }
    }

    public String getExpression() {
        if (this.a != null) {
            return this.expression;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (TokenData tokenData : this.tokens) {
            stringBuilder.append(tokenData.getString());
        }
        return stringBuilder.toString();
    }

    public String getClassRefactoredExpression(String string, String string2) {
        if (this.a != null) {
            return this.expression;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (TokenData tokenData : this.tokens) {
            stringBuilder.append(tokenData.a(string, string2));
        }
        return stringBuilder.toString();
    }

    public String getSelectorRefactoredExpression(String string, String string2) {
        if (this.a != null) {
            return this.expression;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (TokenData tokenData : this.tokens) {
            stringBuilder.append(tokenData.b(string, string2));
        }
        return stringBuilder.toString();
    }

    public Reference[] getReferences() {
        ArrayList<Reference> arrayList = null;
        for (TokenData tokenData : this.tokens) {
            if (tokenData.token != Token.SELECTOR && tokenData.token != Token.JAVA_CLASS) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Reference>();
            }
            arrayList.add(new Reference(tokenData.token == Token.SELECTOR, tokenData.text, tokenData.pos[0]));
        }
        if (arrayList == null) {
            return EMPTY;
        }
        Collections.sort(arrayList, (reference, reference2) -> reference2.position - reference.position);
        return arrayList.toArray(new Reference[arrayList.size()]);
    }

    public void getReferences(HashSet<String> hashSet, HashSet<String> hashSet2) {
        for (TokenData tokenData : this.tokens) {
            if (tokenData.token == Token.SELECTOR) {
                hashSet.add(tokenData.text);
                continue;
            }
            if (tokenData.token != Token.JAVA_CLASS) continue;
            hashSet2.add(tokenData.text);
        }
    }

    public boolean isSelected(Selector selector, EnvProps envProps) {
        try {
            return this.eval(selector, envProps, new int[1], false);
        }
        catch (Throwable throwable) {
            ILog.SEVERE(this.getClass(), "Failed evaluting Selector expression", this.getExpression(), throwable);
            return false;
        }
    }

    protected boolean eval(Selector selector, EnvProps envProps, int[] nArray, boolean bl) {
        boolean bl2 = this.a(selector, envProps, nArray, bl);
        int n2 = nArray[0];
        nArray[0] = n2 + 1;
        if (n2 == this.tokens.size()) {
            return bl2;
        }
        TokenData tokenData = this.tokens.get(n2);
        switch (SelectorExpression.a()[tokenData.token.ordinal()]) {
            case 8: {
                break;
            }
            case 9: {
                boolean bl3 = this.eval(selector, envProps, nArray, bl);
                bl2 = bl2 || bl3;
                break;
            }
            case 10: {
                boolean bl4 = this.eval(selector, envProps, nArray, bl);
                bl2 = bl2 && bl4;
                break;
            }
            default: {
                throw new InternalError("Expected operator || or &&, got [" + tokenData.getString() + "] in expression [" + this.getExpression() + "]");
            }
        }
        return bl2;
    }

    private boolean a(Selector selector, EnvProps envProps, int[] nArray, boolean bl) {
        boolean bl2;
        boolean bl3 = false;
        int n2 = nArray[0];
        TokenData tokenData = this.tokens.get(n2);
        if (tokenData.token == Token.NOT) {
            if ((tokenData.pos.length & 1) != 0) {
                bl3 = true;
            }
            tokenData = this.tokens.get(++n2);
        }
        nArray[0] = n2 + 1;
        switch (SelectorExpression.a()[tokenData.token.ordinal()]) {
            case 7: {
                Token token;
                bl2 = this.eval(selector, envProps, nArray, bl);
                Token token2 = token = nArray[0] > 0 ? this.tokens.get((int)(nArray[0] - 1)).token : null;
                if (token == Token.CLOSE) break;
                throw new InternalError("Unexpected end of expression: expected CLOSE, found " + String.valueOf(token));
            }
            case 1: {
                bl2 = DeviceMatch.match(envProps, tokenData.text);
                break;
            }
            case 2: {
                bl2 = LanguageMatch.match(envProps, tokenData.text);
                break;
            }
            case 6: {
                if (bl) {
                    bl2 = true;
                    break;
                }
                ISelectorExpression iSelectorExpression = selector.getJavaClassInstance(tokenData.text);
                try {
                    bl2 = iSelectorExpression != null && iSelectorExpression.isSelected(envProps);
                }
                catch (Throwable throwable) {
                    ILog.SEVERE(this.getClass(), "Failed executing custom Java Selector Expression in class '" + tokenData.text + "'", throwable);
                    bl2 = false;
                }
                break;
            }
            case 3: {
                GProp<?> gProp = selector.getPropFromReference(tokenData.text);
                if (gProp == null) {
                    ILog.SEVERE(this.getClass(), "Selector '" + tokenData.text + "' not found: " + this.getExpression());
                    bl2 = false;
                    break;
                }
                if (gProp instanceof ISelectorExpression) {
                    bl2 = ((ISelectorExpression)((Object)gProp)).isSelected(envProps);
                    break;
                }
                ILog.SEVERE(this.getClass(), "Selector '" + tokenData.text + "' is not an instanceof ISelectorExpression", gProp);
                bl2 = false;
                break;
            }
            case 4: {
                String string = envProps.getClientEnv().getValue(tokenData.text);
                if (string != null) {
                    bl2 = WindowsLikeFilenameFilter.isMatching(string, tokenData.match, true, false);
                    break;
                }
                ILog.WARNING(this.getClass(), "Client environment did not contain the variable '" + tokenData.text + "'", this.getExpression(), envProps.getClientEnv().getStringMapAsStringArray("="));
                bl2 = false;
                break;
            }
            case 5: {
                String string = envProps.getClientEnv().getValue(tokenData.text);
                if (string != null) {
                    bl2 = tokenData.pattern.matcher(string).matches();
                    break;
                }
                ILog.WARNING(this.getClass(), "Client environment did not contain the variable '" + tokenData.text + "'", this.getExpression(), envProps.getClientEnv().getStringMapAsStringArray("="));
                bl2 = false;
                break;
            }
            default: {
                throw new InternalError("Unexpected token in subEval [" + tokenData.getString() + "] in expression [" + this.getExpression() + "]");
            }
        }
        return bl3 ? !bl2 : bl2;
    }

    void a(StringProp stringProp, PropVerification propVerification) {
        int n2 = 0;
        for (TokenData tokenData : this.tokens) {
            switch (SelectorExpression.a()[tokenData.token.ordinal()]) {
                case 1: {
                    if (DeviceMatch.exists(tokenData.text)) break;
                    propVerification.add(new PropVerificationError("exist" + ++n2, PropVerificationError.Severity.ERROR, "expression", stringProp, "Device '" + tokenData.text + "' is unknown", new String[0]));
                    break;
                }
                case 2: {
                    if (LanguageMatch.exists(tokenData.text)) break;
                    propVerification.add(new PropVerificationError("exist" + ++n2, PropVerificationError.Severity.ERROR, "expression", stringProp, "Language '" + tokenData.text + "' does not exist", new String[0]));
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        Object object2 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = object2[n3];
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append((String)object);
            ++n3;
        }
        object = stringBuilder.toString();
        SelectorExpression selectorExpression = new SelectorExpression((String)object);
        n2 = selectorExpression.parse() ? 1 : 0;
        System.out.println("Selector expression:\n[" + (String)object + "]\n\nis valid:\n\n" + selectorExpression.getExpression());
        System.out.println("\nReferences:");
        Reference[] referenceArray = selectorExpression.getReferences();
        int n4 = referenceArray.length;
        int n5 = 0;
        while (n5 < n4) {
            object2 = referenceArray[n5];
            System.out.println(" - " + String.valueOf(object2));
            ++n5;
        }
        if (n2 != 0) {
            object2 = new Selector(Atom.SYSTEM);
            selectorExpression.isSelected((Selector)object2, new EnvProps(Atom.CLIENT));
        } else {
            int n6;
            object = "Selector expression:\n[" + (String)object + "]\n\nis in error --> " + selectorExpression.getError() + "\n\n";
            n5 = n6 = selectorExpression.getErrorPosition();
            while (--n5 >= 0) {
                object = (String)object + "-";
            }
            object = (String)object + "!";
            System.out.println((String)object);
        }
    }

    static /* synthetic */ int[] a() {
        if (a != null) {
            return a;
        }
        int[] nArray = new int[Token.values().length];
        try {
            nArray[Token.AND.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.CLOSE.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.DEVICE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.JAVA_CLASS.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.LANGUAGE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.NOT.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.OPEN.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.OR.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.REG_EXP.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.SELECTOR.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Token.WILD_CARD.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        a = nArray;
        return nArray;
    }

    public static class Reference {
        public final boolean isSelectorReference;
        public final String reference;
        public final int position;

        private Reference(boolean bl, String string, int n2) {
            this.isSelectorReference = bl;
            this.reference = string;
            this.position = n2;
        }

        public String toString() {
            return (this.isSelectorReference ? "Selector \"" : "Class \"") + this.reference + "\" [" + this.position + "]";
        }
    }

    public static enum Token {
        DEVICE(3),
        LANGUAGE(4),
        SELECTOR(3),
        WILD_CARD(2),
        REG_EXP(6),
        JAVA_CLASS(4),
        OPEN(1),
        CLOSE(1),
        OR(2),
        AND(2),
        NOT(1);

        public final int length;

        private Token(int n3) {
            this.length = n3;
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static class TokenData {
        public final Token token;
        public final String text;
        public final String match;
        public final int[] pos;
        public final Pattern pattern;
        private int a;
        private static volatile /* synthetic */ int[] a;

        private TokenData(Token token, String string, String string2, Pattern pattern, int ... nArray) {
            this.token = token;
            this.text = string;
            this.match = string2;
            this.pattern = pattern;
            this.pos = nArray;
        }

        private TokenData(Token token, int ... nArray) {
            this.token = token;
            this.text = null;
            this.match = null;
            this.pattern = null;
            this.pos = nArray;
        }

        public int getQuotedStringLength() {
            return this.a;
        }

        public String getString() {
            switch (TokenData.a()[this.token.ordinal()]) {
                case 1: {
                    return "{ Dev: \"" + this.text.replace("\"", "\"\"") + "\" }";
                }
                case 2: {
                    return "{ Lang: \"" + this.text.replace("\"", "\"\"") + "\" }";
                }
                case 3: {
                    return "{ Sel: \"" + this.text.replace("\"", "\"\"") + "\" }";
                }
                case 4: {
                    return "{ WC: " + this.text + ": \"" + this.match.replace("\"", "\"\"") + "\" }";
                }
                case 5: {
                    return "{ RegExp: " + this.text + ": \"" + this.match.replace("\"", "\"\"") + "\" }";
                }
                case 6: {
                    return "{ Java: \"" + this.text.replace("\"", "\"\"") + "\" }";
                }
                case 7: {
                    return "( ";
                }
                case 8: {
                    return " )";
                }
                case 9: {
                    return " || ";
                }
                case 10: {
                    return " && ";
                }
                case 11: {
                    return "! ";
                }
            }
            return "<unknown>";
        }

        private String a(String string, String string2) {
            if (this.token == Token.JAVA_CLASS && this.text.equals(string)) {
                return "{ Java: \"" + string2.replace("\"", "\"\"") + "\" }";
            }
            return this.getString();
        }

        private String b(String string, String string2) {
            if (this.token == Token.SELECTOR && this.text.equals(string)) {
                return "{ Sel: \"" + string2.replace("\"", "\"\"") + "\" }";
            }
            return this.getString();
        }

        static /* synthetic */ int[] a() {
            if (a != null) {
                return a;
            }
            int[] nArray = new int[Token.values().length];
            try {
                nArray[Token.AND.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Token.CLOSE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Token.DEVICE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Token.JAVA_CLASS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Token.LANGUAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Token.NOT.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Token.OPEN.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Token.OR.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Token.REG_EXP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Token.SELECTOR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[Token.WILD_CARD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            a = nArray;
            return nArray;
        }
    }
}

