/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.os;

import com.iizix.ILog;
import com.iizix.Utilities;
import com.iizix.os.IAdditonalInformation;
import com.iizix.os.a;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class OSSystemInfo<INFO> {
    private static final Runtime a;
    private static final java.lang.management.OperatingSystemMXBean a;
    private static final OperatingSystemMXBean a;
    public static final long DEFAULT_INTERVAL = 5000L;
    private static final HistoryEntry<?>[] a;
    private final IAdditonalInformation<INFO> a;
    private Timer a;
    private final ArrayList<HistoryEntry<INFO>> a;
    private long a;
    private int a = 17280;

    static {
        java.lang.management.OperatingSystemMXBean operatingSystemMXBean;
        a = Runtime.getRuntime();
        try {
            operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        }
        catch (Throwable throwable) {
            operatingSystemMXBean = null;
            ILog.SEVERE(OSSystemInfo.class, "Failed retrieving java.lang.management.OperatingSystemMXBean bean", throwable);
        }
        a = operatingSystemMXBean;
        a = operatingSystemMXBean instanceof OperatingSystemMXBean ? (OperatingSystemMXBean)operatingSystemMXBean : null;
        a = new HistoryEntry[0];
    }

    public static Basic getBasic() {
        try {
            if (a != null) {
                return new Basic();
            }
        }
        catch (Throwable throwable) {
            ILog.WARNING(OSSystemInfo.class, "Security manager prohibits access to OS Java information", throwable);
        }
        return null;
    }

    public static double getSystemLoadAverage() {
        return a != null ? a.getSystemLoadAverage() : -1.0;
    }

    public static int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static Details getDetails() {
        try {
            if (a != null) {
                return new Details();
            }
        }
        catch (Throwable throwable) {
            ILog.WARNING(OSSystemInfo.class, "Security manager prohibits access to Oracle internal OS information", throwable);
        }
        return null;
    }

    public OSSystemInfo(IAdditonalInformation<INFO> iAdditonalInformation) {
        this.a = iAdditonalInformation;
    }

    public synchronized boolean startHistory(long l2) {
        if (this.a != null) {
            return false;
        }
        Details details = OSSystemInfo.getDetails();
        if (details == null) {
            ILog.WARNING(this.getClass(), "OS system information history is not available");
            return false;
        }
        Object INFO = this.a != null ? (Object)this.a.getAdditionalInformation() : null;
        HistoryEntry<Object> historyEntry = new HistoryEntry<Object>(details, INFO);
        ((ArrayList)((Object)this.a)).clear();
        ((ArrayList)((Object)this.a)).add(historyEntry);
        this.a = l2;
        ILog.INFO(this.getClass(), "OS system information history gathering every " + Utilities.formatEnglishDuration(l2));
        this.a = new Timer(true);
        this.a.scheduleAtFixedRate((TimerTask)new a(this), new Date(historyEntry.timestamp + l2), l2);
        return true;
    }

    public void setMaxHistorySize(int n2) {
        if (n2 < 100 || n2 >= 100000) {
            throw new IllegalArgumentException("Invalid range: 100-100_000): " + n2);
        }
        this.a = n2;
    }

    public long getHistoryInterval() {
        return this.a;
    }

    public boolean isGatheringHistory() {
        return this.a != null;
    }

    public synchronized boolean stopHistory() {
        if (this.a == null) {
            return false;
        }
        this.a.cancel();
        this.a = null;
        return true;
    }

    public synchronized HistoryEntry<INFO>[] getHistory(long l2) {
        int n2 = ((ArrayList)((Object)this.a)).size();
        if (l2 == 0L) {
            return ((ArrayList)((Object)this.a)).toArray(new HistoryEntry[n2]);
        }
        int n3 = 0;
        while (n3 < n2) {
            if (((HistoryEntry)((ArrayList)((Object)this.a)).get((int)n3)).timestamp >= l2) {
                HistoryEntry[] historyEntryArray = new HistoryEntry[n2 - n3];
                int n4 = 0;
                while (n3 < n2) {
                    historyEntryArray[n4++] = (HistoryEntry)((ArrayList)((Object)this.a)).get(n3++);
                }
                return historyEntryArray;
            }
            ++n3;
        }
        return a;
    }

    public static final class Basic {
        public final String osArchitecture = a.getArch();
        public final String osName = a.getName();
        public final String osVersion = a.getVersion();

        private Basic() {
        }
    }

    public static final class Details {
        public final long totalJVMMemorySize = a.totalMemory();
        public final long freeJVMMemorySize = a.freeMemory();
        private static boolean a;
        private static boolean b;
        private static boolean c;
        private static boolean d;
        public final long totalPhysicalMemorySize;
        public final long freePhysicalMemorySize;
        public final long committedVirtualMemorySize;
        private static boolean e;
        private static boolean f;
        public final long totalSwapSpaceSize;
        public final long freeSwapSpaceSize;
        private static boolean g;
        private static boolean h;
        private static boolean i;
        public final double systemCPULoad;
        public final double processCPULoad;
        public final long processCPUTime;

        Details() {
            if (a) {
                this.totalPhysicalMemorySize = b ? a.getTotalMemorySize() : -1L;
                this.freePhysicalMemorySize = c ? a.getFreeMemorySize() : -1L;
                this.committedVirtualMemorySize = d ? a.getCommittedVirtualMemorySize() : -1L;
                this.totalSwapSpaceSize = e ? a.getTotalSwapSpaceSize() : -1L;
                this.freeSwapSpaceSize = f ? a.getFreeSwapSpaceSize() : -1L;
                this.systemCPULoad = g ? a.getCpuLoad() : -1.0;
                this.processCPULoad = h ? a.getProcessCpuLoad() : -1.0;
                this.processCPUTime = i ? a.getProcessCpuTime() / 1000000L : -1L;
            } else {
                long l2 = -1L;
                try {
                    l2 = a.getTotalMemorySize();
                }
                catch (Throwable throwable) {
                    ILog.WARNING(OSSystemInfo.class, "Host system does not support OS information 'totalPhysicalMemorySize': " + String.valueOf(throwable));
                }
                b = l2 >= 0L;
                this.totalPhysicalMemorySize = l2;
                try {
                    l2 = a.getFreeMemorySize();
                }
                catch (Throwable throwable) {
                    l2 = -1L;
                    ILog.WARNING(OSSystemInfo.class, "Host system does not support OS information 'freePhysicalMemorySize': " + String.valueOf(throwable));
                }
                c = l2 >= 0L;
                this.freePhysicalMemorySize = l2;
                try {
                    l2 = a.getCommittedVirtualMemorySize();
                }
                catch (Throwable throwable) {
                    l2 = -1L;
                    ILog.WARNING(OSSystemInfo.class, "Host system does not support OS information 'committedVirtualMemorySize': " + String.valueOf(throwable));
                }
                d = l2 >= 0L;
                this.committedVirtualMemorySize = l2;
                try {
                    l2 = a.getTotalSwapSpaceSize();
                }
                catch (Throwable throwable) {
                    l2 = -1L;
                    ILog.WARNING(OSSystemInfo.class, "Host system does not support OS information 'totalSwapSpaceSize': " + String.valueOf(throwable));
                }
                e = l2 >= 0L;
                this.totalSwapSpaceSize = l2;
                try {
                    l2 = a.getFreeSwapSpaceSize();
                }
                catch (Throwable throwable) {
                    l2 = -1L;
                    ILog.WARNING(OSSystemInfo.class, "Host system does not support OS information 'freeSwapSpaceSize': " + String.valueOf(throwable));
                }
                f = l2 >= 0L;
                this.freeSwapSpaceSize = l2;
                double d2 = -1.0;
                try {
                    d2 = a.getCpuLoad();
                }
                catch (Throwable throwable) {
                    ILog.WARNING(OSSystemInfo.class, "Host system does not support OS information 'systemCPULoad': " + String.valueOf(throwable));
                }
                g = d2 >= 0.0;
                this.systemCPULoad = d2;
                try {
                    d2 = a.getProcessCpuLoad();
                }
                catch (Throwable throwable) {
                    d2 = -1.0;
                    ILog.WARNING(OSSystemInfo.class, "Host system does not support OS information 'processCPULoad': " + String.valueOf(throwable));
                }
                h = d2 >= 0.0;
                this.processCPULoad = d2;
                try {
                    l2 = a.getProcessCpuTime();
                }
                catch (Throwable throwable) {
                    l2 = -1L;
                    ILog.WARNING(OSSystemInfo.class, "Host system does not support OS information 'processCPUTime': " + String.valueOf(throwable));
                }
                i = l2 >= 0L;
                this.processCPUTime = l2 / 1000000L;
                a = true;
            }
        }
    }

    public static class HistoryEntry<INFO> {
        public final long timestamp = System.currentTimeMillis();
        public final Details details;
        public final INFO info;

        private HistoryEntry(Details details, INFO INFO) {
            this.details = details;
            this.info = INFO;
        }
    }
}

