/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.jetty;

import com.iizix.ILog;
import com.iizix.RunMode;
import com.iizix.Utilities;
import com.iizix.comm.State;
import com.iizix.comm.TransactionComm;
import com.iizix.jetty.WSHelper;
import com.iizix.jetty.k;
import com.iizix.nio.IWebSocketComm;
import com.iizix.nio.WebSocketCommListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Frame;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketFrame;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketOpen;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@WebSocket(autoDemand=true)
public class WebSocketClientEndPoint
implements IWebSocketComm,
Session.Listener.AutoDemanding {
    private static final Duration a = Duration.ofSeconds(60L);
    private final String a;
    private final int a;
    private final String b;
    private final boolean b;
    private final boolean c;
    private final String c;
    private final TransactionComm a;
    private WebSocketCommListener a;
    private HttpClient a;
    private WebSocketClient a;
    private CompletableFuture<Session> a;
    private Session a;
    private Object a;
    private boolean d;
    private boolean e;
    private Timer a;
    private static ByteBuffer a;
    private static volatile /* synthetic */ int[] a;

    WebSocketClientEndPoint(String string, int n, String string2, boolean bl, boolean bl2, TransactionComm transactionComm) {
        this.a = string;
        this.a = n;
        this.b = string2;
        this.b = bl;
        this.c = bl2;
        this.a = transactionComm;
        String string3 = "WebSocket " + (bl ? "wss" : "ws") + "://" + string;
        if (bl && n != 443) {
            string3 = string3 + ":" + n;
        } else if (bl && n != 443) {
            string3 = string3 + ":" + n;
        }
        this.c = string3 + string2 + ": ";
        if (bl2) {
            ILog.INFO(this.getClass(), (String)(this.c + "CREATED"));
        }
    }

    public boolean isCompressionSupported() {
        return true;
    }

    public void dispose() {
        if (!this.d) {
            this.close();
        } else if (!this.e) {
            this.close();
        } else {
            this.c();
        }
    }

    public void open() throws IOException {
        this.a(false);
    }

    void a(boolean bl) throws IOException {
        SslContextFactory.Client client;
        SocketAddress socketAddress;
        URL uRL;
        URI uRI;
        int n;
        Object object;
        Object object2;
        if (this.c) {
            ILog.INFO(this.getClass(), (String)(this.c + "OPEN"));
        }
        if (this.a != null) {
            if (this.c) {
                ILog.INFO(this.getClass(), (String)(this.c + "OPEN error: WebSocket client connection has already been opened once before"));
            }
            throw new IOException("WebSocket client connection has already been opened once before");
        }
        if (this.b) {
            object2 = "wss://";
            object = "https://";
            n = 443;
        } else {
            object2 = "ws://";
            object = "http://";
            n = 80;
        }
        String string = this.a != n ? ":" + this.a : "";
        String string2 = this.a + string + this.b;
        object2 = (String)object2 + string2;
        object = (String)object + string2;
        try {
            uRI = URI.create((String)object2);
            uRL = URI.create((String)object).toURL();
        }
        catch (Throwable throwable) {
            ILog.WARNING(this.getClass(), (String)(this.c + "OPEN error: Invalid destination URI: " + (String)object2), (Throwable)throwable);
            throw new IOException("Invalid destination URI: " + (String)object2, throwable);
        }
        this.a = new HttpClient();
        Proxy proxy = RunMode.getWebServiceConfigurator().getProxy(uRL);
        if (proxy != null && !proxy.equals(Proxy.NO_PROXY) && (socketAddress = proxy.address()) instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            if (this.c) {
                ILog.INFO(this.getClass(), (String)("Active proxy " + String.valueOf(proxy)));
            }
            client = new HttpProxy(inetSocketAddress.getHostString(), inetSocketAddress.getPort());
            ProxyConfiguration proxyConfiguration = this.a.getProxyConfiguration();
            if (!proxyConfiguration.getProxies().contains(client)) {
                proxyConfiguration.addProxy((ProxyConfiguration.Proxy)client);
            }
        }
        if (this.b) {
            client = new SslContextFactory.Client();
            this.a.setSslContextFactory(client);
        }
        this.a = new WebSocketClient(this.a);
        this.a.setAutoFragment(true);
        if (bl) {
            ILog.WARNING(this.getClass(), (String)(this.c + "Using NO TIMEOUT's"));
            this.a.setAddressResolutionTimeout(Long.MAX_VALUE);
            this.a.setConnectTimeout(Long.MAX_VALUE);
            this.a.setIdleTimeout(Long.MAX_VALUE);
            this.a.setDestinationIdleTimeout(Long.MAX_VALUE);
            this.a.setStopTimeout(Long.MAX_VALUE);
        } else {
            this.a.setIdleTimeout(a);
        }
        try {
            this.a.start();
        }
        catch (Exception exception) {
            ILog.WARNING(this.getClass(), (String)(this.c + "OPEN error: Failed webSocketClient.start()"), (Throwable)exception);
            throw new IOException("Failed webSocketClient.start(" + (String)object2 + ")", exception);
        }
        client = new ClientUpgradeRequest(uRI);
        client.setSubProtocols(new String[]{"iizi"});
        this.a = this.a.setWebSocket((IWebSocketComm)this, this.a);
        this.a = this.a.connect((Object)this, (ClientUpgradeRequest)client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        WebSocketClientEndPoint webSocketClientEndPoint = this;
        synchronized (webSocketClientEndPoint) {
            if (this.e) {
                return State.CLOSED;
            }
            if (this.d) {
                return State.CLOSING;
            }
        }
        if (this.isConnecting()) {
            return State.CONNECTING;
        }
        if (this.isConnected()) {
            return State.CONNECTING;
        }
        if (this.a == null) {
            return State.UNINITIALIZED;
        }
        return State.CONNECTING;
    }

    public boolean isConnecting() {
        Session session = this.a;
        return this.a != null && !this.d && !this.e && (session == null || !session.isOpen());
    }

    public boolean isConnected() {
        Session session = this.a;
        return session != null && !this.d && !this.e && session.isOpen();
    }

    public boolean isClosing() {
        return this.d;
    }

    public boolean isClosed() {
        return this.e;
    }

    private void a() {
        if (this.a == null) {
            if (this.c) {
                ILog.INFO(this.getClass(), (String)"Heartbeat timer started, interval @15000 ms");
            }
            this.a = new Timer(true);
            this.a.scheduleAtFixedRate((TimerTask)new k(this), 15000L, 15000L);
        }
    }

    private void b() {
        try {
            if (this.isConnected()) {
                this.sendHeartBeat();
            }
        }
        catch (Throwable throwable) {
            ILog.WARNING(this.getClass(), (String)(this.c + "Failed sending heartbeat"), (Throwable)throwable);
        }
    }

    private void c() {
        HttpClient httpClient;
        this.d();
        WebSocketClient webSocketClient = this.a;
        if (webSocketClient != null) {
            this.a = null;
            if (this.c) {
                ILog.INFO(this.getClass(), (String)"Cleanup webSocketClient");
            }
            try {
                webSocketClient.stop();
            }
            catch (Exception exception) {
                ILog.SEVERE(this.getClass(), (String)(this.c + "Failed WebSocketClient stop()"), (Throwable)exception);
            }
        }
        if ((httpClient = this.a) != null) {
            this.a = null;
            if (this.c) {
                ILog.INFO(this.getClass(), (String)"Cleanup httpClient");
            }
            try {
                httpClient.stop();
            }
            catch (Exception exception) {
                ILog.SEVERE(this.getClass(), (String)(this.c + "Failed HTTPClient stop()"), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void d() {
        Timer timer;
        WebSocketClientEndPoint webSocketClientEndPoint = this;
        synchronized (webSocketClientEndPoint) {
            timer = this.a;
            if (timer == null) {
                return;
            }
            this.a = null;
        }
        if (this.c) {
            ILog.INFO(this.getClass(), (String)"Heartbeat timer stopped");
        }
        timer.cancel();
        timer.purge();
    }

    public void close() {
        this.close(1000, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int n, String string) {
        if (this.c) {
            ILog.INFO(this.getClass(), (String)("close(" + n + "," + string + ")"));
        }
        this.d();
        Session session = this.a;
        if (session != null) {
            WebSocketClientEndPoint webSocketClientEndPoint = this;
            synchronized (webSocketClientEndPoint) {
                if (this.d) {
                    return;
                }
                this.d = true;
            }
            session.close(n, string, Callback.from(() -> {
                if (this.c) {
                    ILog.INFO(this.getClass(), (String)(this.c + "Connection closed successfully"));
                }
                this.d = true;
                if (!this.e) {
                    this.e = true;
                    this.a.onCommClosed((IWebSocketComm)this, n, string);
                }
                this.c();
            }, throwable -> {
                if (this.c) {
                    if (WSHelper.a(throwable)) {
                        ILog.INFO(this.getClass(), (String)(this.c + "Connection closed with error: " + String.valueOf(throwable)));
                    } else {
                        ILog.WARNING(this.getClass(), (String)(this.c + "Connection closed with error"), (Throwable)throwable);
                    }
                }
                if (!this.e) {
                    this.a.onCommError((IWebSocketComm)this, throwable);
                }
                if (!this.e) {
                    this.a.onCommClosed((IWebSocketComm)this, n, string);
                }
                this.c();
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean close(boolean bl) {
        Session session;
        if (this.c) {
            ILog.INFO(this.getClass(), (String)("close(" + bl + ")"));
        }
        if ((session = this.a) == null) return false;
        WebSocketClientEndPoint webSocketClientEndPoint = this;
        synchronized (webSocketClientEndPoint) {
            if (this.e) {
                return false;
            }
            if (bl) {
                this.d = true;
                this.e = true;
            } else {
                if (this.d) return false;
                this.d = true;
            }
        }
        if (bl) {
            session.disconnect();
            return false;
        }
        session.close();
        return false;
    }

    public void setSubProtocol(String string) throws IllegalStateException {
        if (!string.equals("iizi")) {
            throw new IllegalStateException("Cannot set subprotocol: it is fixed to 'iizi'");
        }
    }

    public String getSubProtocol() {
        return this.a != null ? "iizi" : null;
    }

    public boolean areBinaryDataFramesSupported() {
        return true;
    }

    public void send(byte[] byArray) throws IOException {
        Session session = this.a;
        if (session == null) {
            throw new IOException("Not connected");
        }
        if (this.e) {
            throw new IOException("Connection closed");
        }
        if (this.d) {
            throw new IOException("Connection closing");
        }
        if (!session.isOpen()) {
            throw new IOException("Connection is not open");
        }
        if (this.c) {
            ILog.INFO(this.getClass(), (String)(this.c + "send binary data, size = " + byArray.length));
        }
        session.sendBinary(ByteBuffer.wrap(byArray), Callback.from(() -> {
            if (this.c) {
                ILog.INFO(this.getClass(), (String)(this.c + "binary data sent successfully, size = " + byArray.length));
            }
        }, throwable -> {
            if (WSHelper.a(throwable)) {
                ILog.WARNING(this.getClass(), (String)(this.c + "SEND BINARY DATA ERROR, size = " + byArray.length + ": " + String.valueOf(throwable)));
            } else {
                ILog.SEVERE(this.getClass(), (String)(this.c + "SEND BINARY DATA ERROR, size = " + byArray.length), (Throwable)throwable);
            }
            this.onWebSocketError((Throwable)throwable);
        }));
    }

    public void send(String string) throws IOException {
        Session session = this.a;
        if (session == null) {
            throw new IOException("Not connected");
        }
        if (this.e) {
            throw new IOException("Connection closed");
        }
        if (this.d) {
            throw new IOException("Connection closing");
        }
        if (!session.isOpen()) {
            throw new IOException("Connection is not open");
        }
        if (this.c) {
            ILog.INFO(this.getClass(), (String)(this.c + "send String data, size = " + string.length()));
        }
        session.sendText(string, Callback.from(() -> {
            if (this.c) {
                ILog.INFO(this.getClass(), (String)(this.c + "String data sent successfully, size = " + string.length()));
            }
        }, throwable -> {
            if (WSHelper.a(throwable)) {
                ILog.WARNING(this.getClass(), (String)(this.c + "SEND STRING ERROR, size = " + string.length() + ": " + String.valueOf(throwable)));
            } else {
                ILog.SEVERE(this.getClass(), (String)(this.c + "SEND STRING ERROR, size = " + string.length()), (Throwable)throwable);
            }
            this.onWebSocketError((Throwable)throwable);
        }));
    }

    public boolean sendHeartBeat() throws IOException {
        Session session = this.a;
        if (session == null) {
            throw new IOException("Not connected");
        }
        if (this.e) {
            throw new IOException("Connection closed");
        }
        if (this.d) {
            throw new IOException("Connection closing");
        }
        if (!session.isOpen()) {
            throw new IOException("Connection is not open");
        }
        ByteBuffer byteBuffer = a;
        if (byteBuffer == null) {
            byteBuffer = a = ByteBuffer.wrap(new byte[0]);
        }
        if (this.c) {
            ILog.INFO(this.getClass(), (String)(this.c + "Send heartbeat"));
        }
        session.sendPing(ByteBuffer.allocate(8).putLong(NanoTime.now()).flip(), Callback.from(() -> {
            if (this.c) {
                ILog.INFO(this.getClass(), (String)(this.c + "PING sent successfully"));
            }
        }, throwable -> {
            if (WSHelper.a(throwable)) {
                ILog.WARNING(this.getClass(), (String)(this.c + "PING send error: " + String.valueOf(throwable)));
            } else {
                ILog.SEVERE(this.getClass(), (String)(this.c + "PING send error"), (Throwable)throwable);
            }
            this.onWebSocketError((Throwable)throwable);
        }));
        return true;
    }

    public String getDomain() {
        return this.a;
    }

    public int getPort() {
        return this.a;
    }

    public boolean isSecure() {
        return this.b;
    }

    public String getRemoteAddr() {
        SocketAddress socketAddress;
        Session session = this.a;
        if (session != null && (socketAddress = session.getRemoteSocketAddress()) instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            return inetSocketAddress.getAddress().getHostAddress();
        }
        return this.a;
    }

    public String getRemoteHost() {
        SocketAddress socketAddress;
        Session session = this.a;
        if (session != null && (socketAddress = session.getRemoteSocketAddress()) instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            return inetSocketAddress.getAddress().getHostName();
        }
        return this.a;
    }

    public SocketAddress getSocketAddress() {
        Session session = this.a;
        return session != null ? session.getRemoteSocketAddress() : null;
    }

    public Object getAttachment() {
        return this.a;
    }

    public void setAttachment(Object object) {
        this.a = object;
    }

    @OnWebSocketOpen
    public void onWebSocketOpen(Session session) {
        if (this.c) {
            ILog.SEVERE(this.getClass(), (String)(this.c + "onOpen, session = " + String.valueOf(session)));
        }
        assert (this.a == null) : "Session is already set";
        this.a = session;
        this.a.onCommConnected((IWebSocketComm)this);
        this.a();
    }

    @OnWebSocketError
    public void onWebSocketError(Throwable throwable) {
        if (WSHelper.a(throwable)) {
            if (this.c) {
                ILog.WARNING(this.getClass(), (String)(this.c + "connection closed - " + String.valueOf(throwable)));
            }
        } else {
            ILog.WARNING(this.getClass(), (String)(this.c + "onError"), (Throwable)throwable);
        }
        this.a.onCommError((IWebSocketComm)this, throwable);
        if (!this.d && !this.e) {
            this.d = true;
            this.a.onCommClosing((IWebSocketComm)this);
        }
        if (!this.e) {
            this.e = true;
            this.a.onCommClosed((IWebSocketComm)this, 1006, "Error: " + throwable.getMessage());
            Session session = this.a;
            if (session != null && session.isOpen()) {
                session.close(1006, null, Callback.NOOP);
            }
        }
        this.d();
        this.c();
    }

    @OnWebSocketClose
    public void onWebSocketClose(int n, String string) {
        if (this.c) {
            ILog.INFO(this.getClass(), (String)(this.c + "onClose, code = " + n + ", reason = " + string));
        }
        if (!this.d && !this.e) {
            this.a.onCommClosing((IWebSocketComm)this);
        }
        if (!this.e) {
            this.a.onCommClosed((IWebSocketComm)this, n, string);
        }
        this.d = true;
        this.e = true;
        this.close();
    }

    public void onWebSocketPong(ByteBuffer byteBuffer) {
        long l = byteBuffer.getLong();
        long l2 = NanoTime.since((long)l);
        if (this.c) {
            ILog.INFO(this.getClass(), (String)(this.c + "onPong, heartbeat duration = " + l2));
        }
        this.a.onCommHeartBeat((IWebSocketComm)this, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnWebSocketFrame
    public void onWebSocketFrame(Frame frame) {
        if (this.c) {
            ILog.INFO(this.getClass(), (String)("onWebSocketFrame @" + Utilities.formatCurrentDate() + " --> " + String.valueOf(frame)));
        }
        switch (WebSocketClientEndPoint.a()[frame.getType().ordinal()]) {
            case 6: {
                int n = 0;
                if (frame.hasPayload()) {
                    ByteBuffer byteBuffer = frame.getPayload();
                    n = frame.getPayloadLength();
                    if (n > 0 && n < 32) {
                        byte[] byArray = new byte[n];
                        byteBuffer.get(byArray);
                        try {
                            this.a.onCommHeartBeat((IWebSocketComm)this, (System.nanoTime() - Long.parseLong(new String(byArray, StandardCharsets.ISO_8859_1), 16)) / 1000000L);
                            return;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                ILog.WARNING(this.getClass(), (String)"Unexcepted format encountered in Pong Frame");
                this.onWebSocketError(new IOException("Unexcepted format encountered in Pong Frame: no or invalid data payload size = " + n));
                break;
            }
            case 4: {
                WebSocketClientEndPoint webSocketClientEndPoint = this;
                synchronized (webSocketClientEndPoint) {
                    if (this.d) {
                        return;
                    }
                    this.d = true;
                }
                this.a.onCommClosing((IWebSocketComm)this);
                break;
            }
        }
    }

    @OnWebSocketMessage
    public void onWebSocketText(String string) {
        if (this.c) {
            ILog.INFO(this.getClass(), (String)(this.c + "onWebSocketMessage: length = " + string.length() + ", string = " + string));
        }
        this.a.onCommData((IWebSocketComm)this, string);
    }

    @OnWebSocketMessage
    public void onWebSocketBinary(ByteBuffer byteBuffer, Callback callback) {
        int n = byteBuffer.remaining();
        try {
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray, 0, n);
            if (this.c) {
                ILog.INFO(this.getClass(), (String)(this.c + "onWebSocketMessage: binary message length = " + n));
            }
            this.a.onCommData((IWebSocketComm)this, byArray, 0, n);
            callback.succeed();
        }
        catch (Throwable throwable) {
            if (WSHelper.a(throwable)) {
                ILog.WARNING(this.getClass(), (String)(this.c + "onWebSocketMessage: binary message failed: " + String.valueOf(throwable)));
            } else {
                ILog.SEVERE(this.getClass(), (String)(this.c + "onWebSocketMessage: binary message failed"), (Throwable)throwable);
            }
            callback.fail(throwable);
        }
    }

    static /* synthetic */ int[] a() {
        if (a != null) {
            return a;
        }
        int[] nArray = new int[Frame.Type.values().length];
        try {
            nArray[Frame.Type.BINARY.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Frame.Type.CLOSE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Frame.Type.CONTINUATION.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Frame.Type.PING.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Frame.Type.PONG.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Frame.Type.TEXT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        a = nArray;
        return nArray;
    }
}

